#include <stdlib.h>
#include <string.h>
 
#include "defs.h"
#include "bitOut.h"

#include "chacodec.h"

#include "codec.h"
#include "galois.h"
#include "chacodec.p"


/***************************************************************************** 
 *
 * function: Channel Receiver & Decoder
 *
 * Return: 
 *
 *****************************************************************************/
void ChaRecDec(FILE *fp, InterleaverStack *ilStack_p)
{
  int  iln;
  int  l;


  while ((iln = readPckRTP(ilStack_p, fp)) >= 0)
    if (ilStack_p->pckMode == 0) { /* Separate layer packetization */
      if (ilStack_p->nRecPck[iln] == 1) { /* 1st packet: Set everything */
	for (l = 0; l < NUM_LAYERS; l++)
	  ilStack_p->kIl[iln][l] = 1;
	memset(ilStack_p->bytesPerLayerPck + iln, 0, NUM_LAYERS * sizeof(int));
	memset(ilStack_p->layerStartOffset + iln, 0, NUM_LAYERS * sizeof(int));
	l = (int)(ilStack_p->il[iln][0]);
	ilStack_p->kIl[iln][l] = (int)(ilStack_p->il[iln][1]);
	ilStack_p->end_f[iln] = (int)(ilStack_p->il[iln][2]);
	ilStack_p->bytesPerPckILInfo[iln] = HEADER_BYTES_PCK_MODE_0;
	ilStack_p->bytesPerLayerPck[iln][l] =
	  ilStack_p->bytesPerPck[iln] - HEADER_BYTES_PCK_MODE_0;
	ilStack_p->layerStartOffset[iln][l] = HEADER_BYTES_PCK_MODE_0;
	/* Set status bits */
	ilStack_p->status[iln] = (1 << ilStack_p->numLayer[iln]) - 1;
      }
    } else
      if (ilStack_p->nRecPck[iln] == ilStack_p->k_il_info) {
	/* Interpolate Interleaver Info */
	InterpolateLayerIlpackets(iln, -1, ilStack_p);

	/* Extract info (k's, P's, etc.) */
	DecodeIlInfo(ilStack_p->il[iln], ilStack_p->bytesPerPck[iln],
		     ilStack_p->bytesPerPckILInfo[iln], ilStack_p->k_il_info,
		     ilStack_p->numLayer[iln],
		     ilStack_p->end_f+iln, ilStack_p->kIl[iln],
		     ilStack_p->bytesPerLayerPck[iln],
		     ilStack_p->layerStartOffset[iln]);

	/* Set status bits */
	ilStack_p->status[iln] = (1 << ilStack_p->numLayer[iln]) - 1;
      }
}


void DecodeIlInfo(Byte *il, int bytesPerPck, int bytesPerPckILInfo,
		  int kIlInfo, int numLayer, int *end_f_p, int *kIl,
		  int *bytesPerLayerPck, int *layerStartOffset)
{
  int k, l, i;
  int tmp;
  int columnOffset;


  /* numLayer is already known from fileheader */
  *end_f_p = il[bytesPerPck];
  k = 2;
  for (l = numLayer - 1; l >= 0 ; l--) {
    if (k >= kIlInfo) {
      k = 0;
      il++;
    }
    kIl[l] = il[k * bytesPerPck];
    k++;
  }
  columnOffset = bytesPerPckILInfo;
  for (l = numLayer - 1; l >= 0 ; l--) {
    tmp = 0;
    for (i = 8; i >= 0; i -= 8) {
      if (k >= kIlInfo) {
	k = 0;
	il++;
      }
      tmp |= il[k * bytesPerPck];
      tmp = (tmp << i);
      k++;
    }
    layerStartOffset[l] = columnOffset;
    columnOffset += tmp;
    bytesPerLayerPck[l] = tmp;
  }
}


int GetNextInterleaverData(int nl, InterleaverStack *ilStack_p,
			   Byte **next_p, Byte **end_p, int *end_f)
{
  int iln = ilStack_p->videoDecIL[nl];
  int iln_old;


  if (ilStack_p->status[iln] & (1 << nl)) /* Remove this if in real networks */
    ilStack_p->videoDecLayerPck[nl]++;
  else {
    /* The header of the next interleaver is not decoded yet */
    *end_p = *next_p;
    return 1;
  }

  if (ilStack_p->videoDecLayerPck[nl] >= ilStack_p->kIl[iln][nl]) {

    iln_old = iln;

    /* Reset status bit of this layer */
    ilStack_p->status[iln_old] &= ~(1 << nl);

    /* Reset interleaver if the status of all layer is set to 0 */
    if (ilStack_p->status[iln_old] == 0) {
      ilStack_p->nRecPck[iln_old] = 0;
      memset(ilStack_p->pckRec[iln_old], 0, ilStack_p->nIlmax * sizeof(int));
    }

    memset(ilStack_p->pckValid[iln_old][nl], 0, ilStack_p->nIlmax*sizeof(int));

    iln++;
    if (iln >= NUM_IL)
      iln = 0;
   
    /* Reset with highest layer; Part 2 */
    if (ilStack_p->status[iln_old] == 0) {
      ilStack_p->ilNumber[iln_old] += NUM_IL;
      ilStack_p->ilNumber[iln_old] %= 256;
    }

    ilStack_p->videoDecIL[nl] = iln;
    if ((ilStack_p->status[iln] & (1 << nl)) == 0) {
      /* The header of the next interleaver is not decoded yet */
      ilStack_p->videoDecLayerPck[nl] = -1;
      *end_p = *next_p;
      return 1;
    }
    ilStack_p->videoDecLayerPck[nl] = 0;
  }

  if (!ilStack_p->pckRec[iln][ilStack_p->videoDecLayerPck[nl]])
    if (!ilStack_p->pckValid[iln][nl][ilStack_p->videoDecLayerPck[nl]]) 
      if (!InterpolateLayerIlpackets(iln, nl, ilStack_p)){ 
	/* The requested packet is not valid (decoded) */
	*end_p = *next_p;
	return 0;
      }

  *next_p = ilStack_p->il[iln] + ilStack_p->layerStartOffset[iln][nl] +
    ilStack_p->videoDecLayerPck[nl] * ilStack_p->bytesPerPck[iln];

  *end_p = *next_p + ilStack_p->bytesPerLayerPck[iln][nl];

  if ((ilStack_p->videoDecLayerPck[nl] == ilStack_p->kIl[iln][nl] - 1) &&
      ilStack_p->end_f[iln])
    *end_f=1;                /* interleaverdata end reached */
  else
    *end_f=0;  /* not last packet of actual interleaver or end-flag not set */

  return 1;
}


/* Interpolate the missing packets for layer 'nl'.
   If nl < 0: Interpolate the missing packets for the interleaver info */
int InterpolateLayerIlpackets( int iln, int nl, InterleaverStack *ilStack_p)
{
  static unsigned long        *bytesPPvec;
  static SYMBOL               *recvec,*lostvec;
  static int                  virgin = 1, nIlmax, packetSize;
  int irec;
  int ilost;
  int i, k;
  int column, columnOffset, numColumns;


  if (virgin) {
    virgin = 0;
    packetSize = ilStack_p->bytesPerPck[iln];
    nIlmax = ilStack_p->nIlmax;
    recvec=(SYMBOL *)malloc(nIlmax * sizeof(SYMBOL));
    lostvec=(SYMBOL *)malloc(nIlmax * sizeof(SYMBOL));
    bytesPPvec = (unsigned long *)malloc(nIlmax * sizeof(unsigned long));
    for (i = 0; i < nIlmax; i++)
      bytesPPvec[i] = i * packetSize;
  } else if (nIlmax < ilStack_p-> nIlmax) {
    nIlmax = ilStack_p->nIlmax;
    packetSize = ilStack_p->bytesPerPck[iln];
    free(bytesPPvec);
    free(recvec);
    free(lostvec);
    recvec=(SYMBOL *)malloc(nIlmax * sizeof(SYMBOL));
    lostvec=(SYMBOL *)malloc(nIlmax * sizeof(SYMBOL));
    bytesPPvec = (unsigned long *)malloc(nIlmax * sizeof(unsigned long));
    for (i = 0; i < nIlmax; i++)
      bytesPPvec[i] = i * packetSize;
  } else {
    if (packetSize != ilStack_p->bytesPerPck[iln]) {
      packetSize = ilStack_p->bytesPerPck[iln];
      for (i = 0; i < nIlmax; i++)
	bytesPPvec[i] = i * packetSize;
    }
  }

  if (ilStack_p->nRecPck[iln]<ilStack_p->k_il_info)
    return 0;

  if (nl >= 0) {
    /* Interpolate layer 'nl' */
    if (ilStack_p->nRecPck[iln]<ilStack_p->kIl[iln][nl])
      return 0;
    k = ilStack_p->kIl[iln][nl];
    columnOffset = ilStack_p->layerStartOffset[iln][nl];
    numColumns = ilStack_p->bytesPerLayerPck[iln][nl];
    /* Set 'pckValid' */
    for (i=0;i<ilStack_p->kIl[iln][nl];i++)
      ilStack_p->pckValid[iln][nl][i] = 1;
  } else {
    /* Interpolate interleaver info */
    k = ilStack_p->k_il_info;
    columnOffset = 0;
    /* Interpolate only the first column at first since we need numLayer */
    numColumns = 1;
  }


  /* register lost packets */
  irec = 0;
  ilost = 0;
  for (i=0; i < k+ilost;i++) {
    if (ilStack_p->pckRec[iln][i]==1) {
      recvec[irec]=i;        /* position of received packets */
      irec++;
    }else{
      lostvec[ilost]=i;      /* position of lossed packets */
#if 0
       printf("Channel Decoder: ups, packet %d from interleaver %d is lost\n",
	      i,ilStack_p->ilNumber[iln]);
#endif
      ilost++;
    }
  }


  /* Decode layer */
#if 0
  printf("Channel Decoder: Decode layer %d\n", nl);
#endif
  for (column=0; column < numColumns ;column++)
    FastNewtonInterpolation(ilStack_p->il[iln]+columnOffset+column,
			    bytesPPvec, recvec, k, lostvec, ilost);

  if (nl < 0) {
    /* Decode the remaining columns of the interleaver info */
    ilStack_p->numLayer[iln] = ilStack_p->il[iln][0];
    ilStack_p->bytesPerPckILInfo[iln] =
      BYTES_PER_PACKET_IL_INFO(ilStack_p->numLayer[iln], ilStack_p->k_il_info);
#if 0
    printf("Channel Decoder: Decode %d .column (Il-info)\n",
	   ilStack_p->bytesPerPckILInfo[iln] - 1);
#endif

    numColumns = ilStack_p->bytesPerPckILInfo[iln];
    for (column=1; column<numColumns;column++)
      FastNewtonInterpolation(ilStack_p->il[iln]+column, bytesPPvec, recvec,
			      k, lostvec, ilost);
  }

  return 1 ;
}


/* Go to a new interleaver only if the other layers have catched
   up or are in front */
/* Return 1 if the layer is too far in front
   and 0 if we can go on */
int LayerTooFarInFront(int nl, InterleaverStack *ilStack_p)
{
#if 0
  int l, iln, ilnNumber, dIlNumber;


  iln = ilStack_p->videoDecIL[nl];

  /* If the status is ok, we can go on */
  if (ilStack_p->status[iln] & (1 << nl))
    return 0;

  /* Check if the upper layers have *all* catched up */
  ilnNumber = ilStack_p->ilNumber[iln];
  for (l = 0; l < nl; l++) {
    dIlNumber = ilnNumber - ilStack_p->ilNumber[ilStack_p->videoDecIL[l]];
    if (dIlNumber > 0)
      return 1;
  }

  /* If the layer is too far in front, we should wait and read the packet 0
     when it's the time, i.e. the other layers have catched up */
  /*ilStack_p->videoDecLayerPck[nl] = -1;*/

  return 0;
#else
  int i;


  for (i = 0; i < NUM_IL; i++)
    if (ilStack_p->status[i] & (1 << nl))
      return 0;

  return 1;
#endif
}
