/**********************************************************************************
 *
 *  Header file: Galois Field library
 *  
 *  Michael Link, 1997
 *
 ***********************************************************************************/

#ifndef GALOISH
#define GALOISH


#ifndef CODECH
#include "codec.h"
#endif

/* defines */

#define MAXBITSPERSYMBOL      8

#if MAXBITSPERSYMBOL == 8
#define SYMBOL            unsigned char    /* l <= 8,  STANDARD  */
#else
#define SYMBOL            unsigned short   /* l <= 16, UNKNOWN RESULT!!! */
#endif


/*#ifdef SIMULATION*/
#define STACKSIZE         100
/*#else
#ifdef ENCODER
#define STACKSIZE         5  */            /* 5 seems to be sufficient for the encoder */
/*#else
#ifdef DECODER
#define STACKSIZE         5   */          /* 5 seems to be sufficient for the decoder */
/*#endif
#endif
#endif*/





/* structures */

struct stack_struct
{
  unsigned char *free;  /* vector with the numbers of free lines in any order */ 
  unsigned char index;  /* index to vector free, points at the topmost free line */
                        /* this is the number of allocated lines ! */ 
  SYMBOL        **data; /* data block */
  
#ifdef CHECKSTACKMAX 
  unsigned char maxindex;
#endif

};




/* global variables */

unsigned short         N;                    /* 2^l-1 = Maximum number of symbols per codeword */

SYMBOL                 **GFMULTAB;           /* GF multiplication table */
SYMBOL                 **GFDIVTAB;           /* GF division table */

#define GFmul(a, b)    GFMULTAB[a][b]        /* Replace GFmul function call by table look-up */
#define GFdiv(a, b)    GFDIVTAB[a][b]        /* Replace GFdiv function call by table look-up */



/* prototypes */

void StackInit(void);
void StackCheck(void);
void StackFree(void);

void GFInit(short);
void GFFree(void);
SYMBOL mulGF(SYMBOL, SYMBOL);
SYMBOL divGF(SYMBOL, SYMBOL);
SYMBOL GFexp(SYMBOL, int);

void NewtonTransform(SYMBOL *, SYMBOL *, SYMBOL *, SYMBOL *);
void InverseNewtonTransform(SYMBOL *, SYMBOL *, SYMBOL *, SYMBOL *);
void NewtonInterpolation(SYMBOL *, SYMBOL *, SYMBOL, SYMBOL *, SYMBOL *, SYMBOL *);
void FastNewtonInterpolation(SYMBOL *, unsigned long *, SYMBOL *, SYMBOL, SYMBOL *, SYMBOL);

SYMBOL *MakeVector(void);
void FreeVector(SYMBOL *);
void PrintVector(char*, SYMBOL *);
void PrintVectorAll(char*, SYMBOL *, unsigned long);
void PrintVectorFormat(char*, char*, float*, unsigned long);


#endif

