/******************************************************/
/* Channel encoder: internals.h                       */
/*                                                    */
/******************************************************/

#ifndef _INTERNALS_H
#define _INTERNALS_H

#include "defs.h"


#define MAX_NAME_LENGTH 100

#define MAX_HEADER_SIZE 4
#define NGOBS          36



/*************************************************************************/
/*                        Defaults for info struct                       */
/*************************************************************************/


/* Paketizing configuration */
#define DEFAULT_RS_CODING_FLAG                                          OFF
#define DEFAULT_N_IL                                                     30
#define DEFAULT_BYTES_PER_PACKET                                        500
#define DEFAULT_K_IL                                                     30
#define DEFAULT_PCK_MODE                                                  0
#define DEFAULT_PACKET_FILENAME                                "pck_stream"


/* General configurations */
#define DEFAULT_QUIET_FLAG                                                0


/*************************************************************************/
/*                            Info struct                                */
/*************************************************************************/

typedef struct {

  /* Input streams */
  char *inStreams[NUM_LAYERS];

  /* Paketizing configuration */
  int prs;                       /* Flag to switch on the reed solomon pack. */
  int nIl;                       /* Number of lines of interleaver */
  int bytesPerPck;               /* Bytes per packet */
  int kIl[NUM_LAYERS];           /* Number of info symbols per layer */
  int pckMode;         /* Packetization mode */
  char *pckFilename;

  /* General configurations */
  int quiet;

} ChaEncInfo;



#endif /* _INTERNALS_H */
