 /*########## channel-encoder ############# 
 * main.c - 
 *
 * Klaus Stuhlmller
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <time.h>
#include <sys/fcntl.h>	/* for O_RDONLY */

#define DEFINE_GLOBALS


#include "internals.h"

#include "bitOut.h"
#include "chacodec.h"
#include "codec.h"
#include "h263decoder.h"


#include "openurl.h"	/* OpenUrl(), struct url_info */
#include <jittr/schedule.h>	/* sched_timerdiff */
extern FILE *fdopen();

/* Define mbuiltins for jittr library */
struct mbuiltin *mbuiltins = NULL;


/* Prototype files */
#include "common.h"

int ChopByteSync(dstring **d,FILE *fp,int max,unsigned char *pat,int nbits);

int  ExtractGOBSizes(Byte *buffer, Byte *end,
		     int *nGOBsPerGOP, int *maxGOBsPerGOP,
		     int **gobSize);



/* *************************************************************************/
/* *************************************************************************/
void PrintChaEncInfo(ChaEncInfo *cInfo) {
  int i;


  /* Paketizing configuration */
  printf("\t-prs    Flag to switch on the reed solomon pack. [%s]\n",
	 (cInfo->prs ? "ON" : "OFF"));
  printf("\t-nIl    Number of lines of interleaver [%d].\n", cInfo->nIl);
  printf("\t-bPP    Bytes per packet. [%d]\n", cInfo->bytesPerPck);
  printf("\t-kIl    Number of info symbols per layer\n");
  printf("\t   ");
  for (i = 0; i < NUM_LAYERS; i++)
    printf("[%d]   ", cInfo->kIl[i]);
  printf("\t-pM  Packetization mode [%d]\n", cInfo->pckMode);
  printf("\t-pckFile Filename for packed stream [%s]\n", cInfo->pckFilename);

  /* General */
  printf("\n\t-quiet run quietly (default: verbose)\n");
}


void Usage(char *argv[]) {
  printf("\nScalVico channel encoder (version 1.0)\n");
  printf("Copyright (c) 1998 LNT, Uni Erlangen, Germany\n");
  printf("Type <%s -H> for advanced help\n", argv[0]);
  printf("Usage: %s\n", argv[0]);
}


void VerboseUsage(int argc, char *argv[], ChaEncInfo *cInfo) {
  int i;

  for(i=0; *(argv+i) != NULL; ++i) {
    /* Help utilities */
    if((!strcmp(argv[i],"-help")) || (!strcmp(argv[i],"-H")) 
       || (!strcmp(argv[i],"-U"))) {
      Usage(argv);
      printf("Options:\n");
      PrintChaEncInfo(cInfo);
      printf("\n\tDefault options in square brackets are specified in "
	     "main.h\n");
      printf("\n\tFor the Options that need a number for each layer you "
	     "have to specify\n\t*exactly* >%d< numbers!\n", NUM_LAYERS);
      exit(0);
    }
    if((!strcmp(argv[i],"-h")) || (!strcmp(argv[i],"-u"))) {
      Usage(argv);
      exit(0);
    }
  }
}


ChaEncInfo *NewChaEncInfo()

{

  int         i;
  ChaEncInfo  *cInfo = (ChaEncInfo *)malloc(sizeof(ChaEncInfo));


  if(!cInfo)
    exit(-1);

  for (i = 0; i < NUM_LAYERS - 1; i++)
    cInfo->inStreams[i] = NULL;
 
  /* Paketizing configuration */
  cInfo->prs = DEFAULT_RS_CODING_FLAG;
  cInfo->nIl = DEFAULT_N_IL;
  cInfo->bytesPerPck = DEFAULT_BYTES_PER_PACKET;
  for (i = 0; i < NUM_LAYERS; i++)
    cInfo->kIl[i] = DEFAULT_K_IL;
  cInfo->pckMode = DEFAULT_PCK_MODE;

  cInfo->pckFilename = (char *)malloc(sizeof(char)*MAX_NAME_LENGTH);
  if(!cInfo->pckFilename) exit(-1);
  strcpy(cInfo->pckFilename, DEFAULT_PACKET_FILENAME);

  /* General configurations */
  cInfo->quiet = DEFAULT_QUIET_FLAG;


  return(cInfo);
}


void EvaluateArgumentsChaEncInfo(int argc, char *argv[], ChaEncInfo *cInfo)
{
  int i, j, l = 0;

  
  for(i=1;i<argc;++i) {
    /* Paketizing configuration */
    if(!strcmp(argv[i],"-prs")) {
      cInfo->prs = !(cInfo->prs);
      continue;
    }
    /* Frame width */
    if(!strcmp(argv[i],"-nIl")) {
      if(++i >= argc) {Usage(argv); printf("%d %d\n",i,argc); exit(0);}
      cInfo->nIl = atoi(argv[i]);
      continue;
    }
    /* Bytes per packet */
    if(!strcmp(argv[i],"-bPP")) {
      if(++i >= argc) {Usage(argv); printf("%d %d\n",i,argc); exit(0);}
      cInfo->bytesPerPck = atoi(argv[i]);
      continue;
    }
    /* Layer k's */
    if(!strcmp(argv[i],"-kIl")) {
      for (j = 0; j < NUM_LAYERS; j++) {
	if(++i >= argc) {Usage(argv); printf("%d %d\n",i,argc); exit(0);}
	cInfo->kIl[j] = atoi(argv[i]);
      }
      continue;
    }
    /* Packetization mode */
    if(!strcmp(argv[i],"-pM")) {
      if(++i >= argc) {Usage(argv); printf("%d %d\n",i,argc); exit(0);}
      cInfo->pckMode = atoi(argv[i]);
      continue;
    }
    /* Name of bitstream file */
    if(!strcmp(argv[i],"-pckFile")) {
      if(++i >= argc) {Usage(argv); printf("%d %d\n",i,argc); exit(0);}
      strcpy(cInfo->pckFilename,argv[i]);
      continue;
    }

    /* Switch quiet flag */
    if(!strcmp(*argv,"-quiet")) {
      argv++;
      cInfo->quiet = 1; 
      continue;
    }

    /* Input bitstreams */
    if (argv[i][0] != '-') {
      if (l >= NUM_LAYERS - 1) {
        fprintf(stderr, "The max. number of input streams is %d.\n",
                NUM_LAYERS - 1);
        fprintf(stderr, "Input streams by now:\n");
        for (; l > 0; l--)
          fprintf(stderr, "\t%s\n", cInfo->inStreams[l - 1]);
        fprintf(stderr, "%s is too much.\n", argv[i]);
        PrintChaEncInfo(cInfo);
        exit(0);
      }
      cInfo->inStreams[l] = (char *)malloc(strlen(argv[i]) + 1);
      strcpy(cInfo->inStreams[l],argv[i]);
      l++;
      continue;
    }
 
    printf("Unknown option '%s'\n", *argv);
    PrintChaEncInfo(cInfo);
    exit(1);
    break;
  }
}





/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- ChaEncoder -- Channel encoder for scalable pyramid streams (ScalVico)
 *
 * Author:      K.S.
 *	        
 * Created:     3-Mar-98
 *	        
 * Purpose:     -
 * 	        
 * Options:     -quiet run quietly
 *
 *	        Default options in square brackets are specified in internals.h
 *
 *
 * Description: Call:
 *                      ChaEncoder <options> bitstream0 bitstream1 ...
 *
 * See also:    -
 *
 * Modified:    -
 *
 *****************************************************************************/
void main(int argc, char *argv[])
/***********************************************************CommentEnd********/
{
  ChaEncInfo           *cInfo = NewChaEncInfo();
  static unsigned char *patH263 = (unsigned char *)"\0\0\200";  /* H.263 picture sync pattern */
  static unsigned char *patPyra = (unsigned char *)"\0\0\1\0";  /* pyra picture sync pattern */
  const int    	       pSyncBitsH263 = 8 + 8 + 6;
  const int    	       pSyncBitsPyra = 8 + 8 + 8 + 5;
  int                  pOffsetTRH263 = 4;
  int                  pOffsetTRPyra = 5;
  int  		       t;
  int  		       nLayers, nl;
  int  		       method[NUM_LAYERS];
  int  		       tr[NUM_LAYERS];
  unsigned char        *pat[NUM_LAYERS];
  int       	       pSyncBits[NUM_LAYERS];
  int                  pOffsetTR[NUM_LAYERS];
  FILE      	       *stream[NUM_LAYERS];
  Byte                 *end[NUM_LAYERS];  
  dstring   	       *d[NUM_LAYERS];   
  Bitstr               *bitstr[NUM_LAYERS];
  int       	       cont = 0;
 
  int            packNow = 0;
  int            maxGOBsPerGOP[NUM_LAYERS];
  int            *gobSize[NUM_LAYERS], nGOBsPerGOP[NUM_LAYERS];
 /*  int            nGOBsPerFrame[NUM_LAYERS]; */
 /*  int            nGOBsCoded[NUM_LAYERS]; */
 /*  int            maxFreqDiv = 0; */
  int            pckMode = 0;
  int            littleHelper;
  int            varBytesPerLayerPck_f;
  int            maxBytesPerPck, bytesPerPck;
  int            bytesPerPckILInfo;
  int            forceLayer[NUM_LAYERS];
  int            pck2Write;
  FILE           *fp_pack;
  Byte           *packStream;
  PackRSFileHeader fileheader;
  int            packAll_f;



  /* Evalute command line arguments and/or print usage */
  EvaluateArgumentsChaEncInfo(argc, argv, cInfo);
  VerboseUsage(argc, argv, cInfo);


  /* Print a short hello message */
  if (!cInfo->quiet) {
    printf("\n\n                  ScalVico\n\n");
    printf("Uwe Horn, Jrgen Weigert, Klaus Stuhlmller\n\n\n");
  }


  /* Open input files */

  for (nLayers = 0; nLayers < NUM_LAYERS; nLayers++)
    if (cInfo->inStreams[nLayers] != NULL) {
#ifdef WITHOUT_JLIB
      if (!(stream[nLayers]=fopen(cInfo->inStreams[nLayers],"r")))
	fprintf(stderr, "%s: ", *argv),perror("fopen"),exit(0);
#else
      struct url_info u;

      if (!(stream[nLayers] = fdopen(OpenUrl(cInfo->inStreams[nLayers],
					     &u, O_RDONLY), "r")))
	fprintf(stderr, "%s: ", *argv),perror("fdopen"),exit(0);
      if (!cInfo->quiet)
	fprintf(stderr, "mime/type: %s, length=%d, mtime='%s'\n",
	  u.mime->buf, u.len, u.modified ? u.modified->buf : "<>");
      FreeUrlInfo(&u);
#endif
    } else
      break;
 
  /*******************/
  /* Initializations */
  /*******************/
  
  for (nl = 0; nl < nLayers; nl++) {  /*# in nLayers steht die aktuelle Zahl an Layern #*/
    cont |= (1 << nl);
    d[nl] = NULL;
    /* Decide on method by looking at the first sync */
    if (ChopByteSync(d + nl, stream[nl], MAX_HEADER_SIZE + 1, patPyra,
		     pSyncBitsPyra)) {
      d[nl]->length = 0;
      rewind(stream[nl]);
      if (ChopByteSync(d + nl, stream[nl], MAX_HEADER_SIZE + 1, patH263,
		       pSyncBitsH263)) {
	method[nl] = NONE;
	fprintf(stderr, "Streamfile no. %d contains undecodable data\n", nl);
	return;
      } else {
	method[nl] = H263;
	pSyncBits[nl] = pSyncBitsH263;
	pat[nl] = patH263;
	pOffsetTR[nl] = pOffsetTRH263;
	tr[nl] = ShowH263TempRef((Byte *)d[nl]->buf/*+d[nl]->length-pOffsetTR[nl]*/);
      }
    } else {
      method[nl] = PYRA;
      pSyncBits[nl] = pSyncBitsPyra;
      pat[nl] = patPyra;
      pOffsetTR[nl] = pOffsetTRPyra;
      tr[nl] = ShowPyraTempRef((Byte *)d[nl]->buf/* + d[nl]->length-pOffsetTR[nl]*/);
    }
  }
  
  /************************/
  /* Init channel encoder */
  /************************/
  /* Create GF(2^l): initialize N, LOG, EXP, GFMULTAB and stack. */
  GFInit(8);   /* 8 == bits per byte */
  for (nl = 0; nl < nLayers; nl++) {
    if (cInfo->kIl[nl] > cInfo->nIl || cInfo->kIl[nl] < K_IL_INFO) {
      fprintf(stderr, "'kIl[.]' must be <= 'nIl' and >= %d for each layer\n",
	      K_IL_INFO);
      exit(1);
    }
  }
  bytesPerPck = cInfo->bytesPerPck;
  maxBytesPerPck = bytesPerPck;
  if (bytesPerPck > 0) {
    varBytesPerLayerPck_f = 1;
    packStream = (Byte *)malloc(bytesPerPck * cInfo->nIl * sizeof(Byte));
  }
  for (nl = 0; nl < nLayers; nl++) {
    maxGOBsPerGOP[nl] = NGOBS;
    gobSize[nl] = (int *)malloc(maxGOBsPerGOP[nl] * sizeof(int));
    bitstr[nl] = (Bitstr *)malloc(1 * sizeof(Bitstr));
  }
  /* Open and init packet file */
  fileheader.bytesPerPck = varBytesPerLayerPck_f ? bytesPerPck :littleHelper;
  fileheader.nIlmax = cInfo->nIl;
  fileheader.k_il_info = K_IL_INFO;
  fp_pack = OpenInitPrsFile(cInfo->pckFilename, bytesPerPck, cInfo->nIl,
			    cInfo->pckMode, nLayers, method);

  /*************/
  /* Film loop */
  /*************/
  for (t = 0; cont; t++) {
    t &= 0xff;   /* Count modulo 256 (8 bit) */
    if (!cInfo->quiet)
      printf("\rt: %4d", t);

    packNow = 1;

    /**********************/
    /* Picture Layer loop */
    /**********************/
    for (nl = 0; nl < nLayers; nl++) {
      if ((cont & (1 << nl)) && tr[nl] == t) {

	end[nl] = (Byte *)d[nl]->buf + d[nl]->length - pOffsetTR[nl];

	if (ChopByteSync(d + nl, stream[nl], 0, pat[nl], pSyncBits[nl])) {
	  /* No more picture sync words */
	  cont &= ~(1 << nl);
	} else {
	  /* Got next picture sync */

	  /* Get temporal reference */
	  ChopByteSync(d + nl, stream[nl], 1, pat[nl], pSyncBits[nl]);
	  switch (method[nl]) {
	  case H263:
	    tr[nl] = ShowH263TempRef((Byte *)d[nl]->buf/* +
				     d[nl]->length-pOffsetTR[nl]*/);
	    break;
	  case PYRA:
	    tr[nl] = ShowPyraTempRef((Byte *)d[nl]->buf/* +
				     d[nl]->length-pOffsetTR[nl]*/);
	    break;
	  }
	}
      }

      if (tr[nl] != (t + 1) & 0xff)
	packNow = 0;

    if (!cInfo->quiet)
      printf("\t %d", tr[nl]);
    }
    /*****************************/
    /* End of Picture Layer loop */
    /*****************************/

    if (packNow) {
      /* So let's pack now! */

      /******************/
      /* GOB Layer loop */
      /******************/
      for (nl = 0; nl < nLayers; nl++) {
	bitstr[nl]->b = (Byte *)d[nl]->buf;
	bitstr[nl]->ind = ((int)(end[nl] - (Byte *)d[nl]->buf) << 3);
	ExtractGOBSizes((Byte *)d[nl]->buf, end[nl],
			nGOBsPerGOP + nl, maxGOBsPerGOP + nl, gobSize + nl);
      }
      /*************************/
      /* End of GOB Layer loop */
      /*************************/

      /* Channel coding; Paketizing */
      while ((pck2Write = chaenco(nLayers, gobSize, nGOBsPerGOP, cInfo->kIl,
				  cInfo->nIl, pckMode, varBytesPerLayerPck_f,
				  maxBytesPerPck, &bytesPerPck,
				  forceLayer, forceLayer /*!Noch nicht gesetzt!*/,
				  bitstr, packStream, packAll_f)) > 0) {
	/* Write packBitstr to file/port */
	/*! writeRTP(packStream, bytesPerPck, pck2Write, fp_pack);! */
	writeInterleaverRTP(packStream, bytesPerPck, pck2Write, fp_pack);
      }

      /* Reset d's */
      for (nl = 0; nl < nLayers; nl++) {
	xbcopy(end[nl], d[nl]->buf, pOffsetTR[nl]);
	d[nl]->length = pOffsetTR[nl];
      }
    }

  }
  /********************/
  /* End of Film loop */
  /********************/

  
  /* Clean up */
  for (nl = 0; nl < nLayers; nl++) {
    fclose(stream[nl]);
  }

  if (!cInfo->quiet) {
    printf("\n\n                *************************\n");
    printf("                *        The End        *\n");
    printf("                *************************\n\n\n");
  }
  return;
}


#if 0
/*
 * ChopByteSync finds the first nbits bits of pat in the file referenced by fp.
 * Start of the sync pattern pat is expected to be byte aligned.
 * all material from the current file position up to and including the bytes
 * containing pat are appended to *d.
 * to read an unlimited amount of bytes use 0 for max.
 *
 * returns nonzero at EOF.
 */
int ChopByteSync(dstring **d, FILE *fp, int max, unsigned char *pat, int nbits)
{
  unsigned char *s, *p = pat;
  int c, need = nbits;
  int nbytes = (nbits + 7) >> 3;

  if (!*d) dstring_append(d, 0, NULL, 8192);

  if (max) max++;

  for (;;)
    {
      if (((c = getc(fp)) == EOF) || !--max)
	{
	  (*d)->buf[(*d)->length] = '\0';
	  return -1;
	}
      if ((*d)->allocated <= (*d)->length) dstring_append(d, -1, NULL, 8192);
      *(s = (*d)->buf + (*d)->length++) = c;

      if ((*d)->length < nbytes)
        continue;
	
      s += 1-nbytes;
      
      while (need >= 8)
        {
	  if (*s == *p)
	    {
	      s++; p++;
	      need -= 8;
	    }
	  else
	    break;
	}
      if (!need || ((need < 8) && ((*s >> (8-need)) == (*p >> (8-need)))))
        break;
      p = pat;
      need = nbits; 
    }
  (*d)->buf[(*d)->length] = '\0';
  return 0;
}
#endif

int  ExtractGOBSizes(Byte *buffer, Byte *end,
		     int *nGOBsPerGOP, int *maxGOBsPerGOP,
		     int **gobSize)
{
  printf("Geht noch nicht!\n");
  return 0;
}

