#include <stdio.h>
#include <stdlib.h>

#include "defs.h"
#include "bitOut.h"
#include "chacodec.h"


void ReadPrsFileHeader(FILE *fp, int *bytesPerPck_p, int *nIlmax_p,
		       int *kIlInfo_p, int *pckMode_p, int *maxLayers_p,
		       int *method)
{
  int              l;
  unsigned char    tmpChar;
  PackRSFileHeader fileheader;


  fread(&fileheader, sizeof(PackRSFileHeader), 1, fp);
  *bytesPerPck_p = fileheader.bytesPerPck;  /* max. bytes p. pck in stream */
  *nIlmax_p = fileheader.nIlmax;
  *kIlInfo_p = fileheader.k_il_info;
  *pckMode_p = fileheader.pckMode;
  *maxLayers_p = fileheader.maxLayers;
  for (l = 0; l < *maxLayers_p; l++) {
    fread(&tmpChar, sizeof(unsigned char), 1, fp);
    method[l] = (int)(tmpChar);
  }
}


/* Returns the interleaver number if a packet was successfully read;
   Returns -1 if no packet could be read */
int readPckRTP(InterleaverStack *ilStack_p, FILE *fp)
{
  int  i;
  static int rtpHeader_f = 0;
  static RSPacketHeader *rsPckHeader = NULL;


  if (!rsPckHeader)
    rsPckHeader = (RSPacketHeader *)calloc(1, sizeof(RSPacketHeader));


  if (feof(fp) != 0)
    return -1;    

  /* RTP header */
  if (!rtpHeader_f) {
    if (fread(rsPckHeader, sizeof(RSPacketHeader), 1, fp) != 1)
      return -1;
    rtpHeader_f = 1;
  }

  /* Data */
  for (i = 0; i < NUM_IL; i++)
    if (ilStack_p->ilNumber[i] == rsPckHeader->ilNumber) {
      ilStack_p->bytesPerPck[i] = rsPckHeader->bytesPerPck;
      if (fread(ilStack_p->il[i] +
		rsPckHeader->packetNumber * ilStack_p->bytesPerPck[i],
		ilStack_p->bytesPerPck[i], 1, fp) != 1)
	return -1;
      ilStack_p->pckRec[i][rsPckHeader->packetNumber] = 1;
      ilStack_p->nRecPck[i]++;
      rtpHeader_f = 0;
      return i;
    }

  /* Could not place the packet */
  return -1;
}

