#include <stdio.h>
#include <stdlib.h>

#include "defs.h"
#include "bitOut.h"
#include "chacodec.h"


FILE *OpenInitPrsFile(char *name, int bytesPerPck, int nIlmax, int pckMode,
		      int maxLayers, int *method)
{
  int              l;
  unsigned char    tmpChar;
  FILE             *fp;
  PackRSFileHeader fileheader;


  if ((fp = fopen(name, "w")) == NULL) {
    fprintf(stderr,"OpenInitPrsFile: Can't open file %s for writing.\n",name);
    return NULL;
  }

  fileheader.bytesPerPck = bytesPerPck;
  fileheader.nIlmax = nIlmax;
  fileheader.k_il_info = K_IL_INFO;
  fileheader.pckMode = pckMode;
  fileheader.maxLayers = maxLayers;
  fwrite(&fileheader, sizeof(PackRSFileHeader), 1, fp);
  for (l = 0; l < maxLayers; l++) {
    tmpChar = (unsigned char)(method[l]);
    fwrite(&tmpChar, sizeof(unsigned char), 1, fp);
  }

  return fp;
}



void writeInterleaverRTP(Byte *packStream, int bytesPerPck, int pck2Write,
			 FILE *fp)
{
  static RSPacketHeader *rsPckHeader = NULL;


  if (!rsPckHeader)
    rsPckHeader = (RSPacketHeader *)calloc(1, sizeof(RSPacketHeader));

  rsPckHeader->bytesPerPck = (unsigned short)bytesPerPck;

  for (rsPckHeader->packetNumber = 0; rsPckHeader->packetNumber < pck2Write;
       rsPckHeader->packetNumber++) {
    fwrite(rsPckHeader, sizeof(RSPacketHeader), 1, fp);
    fwrite(packStream, bytesPerPck, 1, fp);
    packStream += bytesPerPck;
  }

  rsPckHeader->ilNumber++;
}
