/******************************************************************************
 *
 *  Header file: Basic parameters for all functions
 *  
 *  Michael Link, 1997
 *
 *****************************************************************************/

#ifndef CODECH
#define CODECH


/* #define SIMULATION   */

#define ENCODER    

/* #define DECODER    */


#if 0
#define CHECKSTACKMAX     /* compilation flag: check and report number of used vectors */

#define PRINTRESULTS      /* compilation flag: print results */ 
#endif



#ifndef GALOISH
#include "galois.h"
#endif

#ifndef RSH
#include "rs.h"
#endif


/* Channel flags */

#define AWGN                  0
#define GE                    1

/* Decoding mode flags */

#define COUNT_ERRORS          0
#define RSDECODE              1

/* Erasure mode flags */

#define HAGENAUER             0
#define MIN_REDUNDANCY        1
#define MAX_ERASURES          2

/* Reliability mode */

#define NO_REL                0
#define PR_AWGN_SYMBOL        1
#define PR_AWGN_BIT_MIN       2
#define ICE_NR_BITERRORS      3
#define ICE_NR_CORRECT_BITS   4


/* GMD criterion flags */

#define NO_GMD                0
#define SQUARED_DISTANCE      1
#define NR_OF_BITERRORS       2

/* Channel states */

#define GOOD                  0
#define BAD                   1


/* Defaults */

#define MAXPACKETSIZE         2000         /* should be < 8192 = 65536/8 */     
#define MAXNUMBEROFERRORS     100  
#define INTERMEDIATE          1000  
#define BITSPERSYMBOL         4



/* Error numbers */

#define MEMORY_ALLOCATION_ERROR  1
#define STACK_FULL               2
#define FREE_VECTOR_ERROR        3
#define FILE_ERROR               4
#define PARAMETER_ERROR          5
#define ARGUMENT_ERROR           6



/* Structures */

#if 0 /*MS*/
struct fileheader_struct
{
  unsigned short   bitspersymbol;      /* ( short => highbyte lowbyte ) */
  unsigned short   nrofcodesymbols;     
  unsigned short   nrofinfosymbols;  
  unsigned short   bytesperpacket;
};
#endif



struct packetheader_struct
{
#if 0 /*MS*/
  unsigned short   packetnumber;
  unsigned short   bytesinpacket;
#endif
  unsigned long    bytesinpacket; /*MS*/
};




#endif





