/* Compare Files
 *
 * compile with: gcc -o compdec compdec.c
 *
 * M. Link, LNT II, 1998
 *
 */



#include <stdio.h>

main(int argc, char *argv[])
{
  int i, j=0, c1, c2;

  char filename1[80];
  char filename2[80];    
  FILE *file1, *file2;


  if ( argc != 3 ) {
	fprintf(stderr, "\nUsage: %s file1 file2\n\n", argv[0]);
	fprintf(stderr, "Compare files file1 and file2: write bytewise XOR to stdout.\n\n");
	exit(1);
  }

  sprintf(filename1, "%s", argv[1]);  
  sprintf(filename2, "%s", argv[2]);  

  if ( (file1 = fopen(filename1, "r")) == NULL ) {
	fprintf(stderr,"\nError in %s: can't open %s for reading.\n", argv[0], filename1);
	exit(1);
  }

  if ( (file2 = fopen(filename2, "r")) == NULL ) {
	fprintf(stderr,"\nError in %s: can't open %s for reading.\n", argv[0], filename2);
	exit(1);
  }


  i = 9;

  while ( (c1 = fgetc(file1)) != EOF ) {

	if ( (c2 = fgetc(file2)) != EOF ) {

	  if (++i==10) {
		i = 0;
		fprintf(stdout,"\n%5i>", j++);
	  }
	  fprintf(stdout,"%4i",c1^c2);

	} else {

	  fprintf(stdout, "\nFile %s finished.\n\n", filename2);
	  exit(0);

	}

  }

  if ( (c2 = fgetc(file2)) != EOF ) {

	fprintf(stdout, "\nFile %s finished.\n\n", filename1);
	exit(0);

  } else {

	fprintf(stdout, "\nBoth files finished.\n\n");

  }
}
