/**********************************************************************************
 *
 *  Header file: for RS Encoder & Decoder, Interleaver
 *  
 *  Michael Link, 1997
 *
 ***********************************************************************************/

#ifndef RSH
#define RSH

#ifndef GALOISH
#include "galois.h"
#endif

#define RELIABILITYTYPE unsigned char     /* SYMBOL */

#define MAXNUMBEROFLEVELS     4            /* max. number of protection levels */



/* structures */

struct interleaver_struct {
  unsigned short   nrofrows;                     /* number of SYMBOLSs per codeword */
  unsigned short   nrofcolumns;                  /* number of codewords = packet size */
  unsigned char    nroflevels;                   /* UEP parameters */
  unsigned char    nrofsegments;
  unsigned short   columnsoflevel[MAXNUMBEROFLEVELS];
  SYMBOL           koflevel[MAXNUMBEROFLEVELS];      /* number of info symbols per codeword */ 
  unsigned long    totalinfosymbols;                 /* total number of info symbols per IL block */
  unsigned short   bytesperpacket;                   /* number of bytes for one row (packet) */
  SYMBOL           *data;                            /* data block */
  SYMBOL           *pnr;                             /* packet numbers of received packets */
  SYMBOL           *pnl;                             /* packet numbers of lost packets */
  SYMBOL           *samplepoints;                    /* samplepoints of samples in data rows */
  unsigned long    *ri;                              /* row index vector */
  SYMBOL           nrofpackets;                      /* number of columns filled with packets */
  RELIABILITYTYPE  *reliability;                     /* reliability vector for ICE */
};


/* prototypes */

void RSEncode(SYMBOL *, SYMBOL *);
void IndexSort(unsigned short, RELIABILITYTYPE *, SYMBOL *);
char RSDecode(SYMBOL *, SYMBOL *, RELIABILITYTYPE *, SYMBOL, SYMBOL, SYMBOL, unsigned char, SYMBOL *, SYMBOL **);
void RSCalculate(SYMBOL *, SYMBOL *, RELIABILITYTYPE *, SYMBOL, SYMBOL, SYMBOL *);

void InterleaverDesign(unsigned char, unsigned char, unsigned char, SYMBOL *, unsigned short *, unsigned short , struct interleaver_struct *);
void InterleaverInit(struct interleaver_struct *);
void InterleaverFree(struct interleaver_struct);



#endif

