#include <stdio.h>
#include <stdlib.h>

char *ReadPGMFile(char *name, int *width, int *height) {

  FILE *in;
  char *data;
  char s[80];
  int j;

  in = fopen(name,"rb");

  if (in==NULL) {
    fprintf(stderr,"Error opening file %s\n", name);
    exit(1);
  }

  fscanf(in,"%s",s);

  if ((s[0] != 'P') && (s[1] != '5')) {
    fprintf(stderr,"Unknown file format\n");
    exit(1);
  }

  fscanf(in," %s",s);
  *width = atoi(s);

  fscanf(in," %s",s);
  *height = atoi(s);

  fscanf(in," %s ",s); /* ignore */

  data = (char *) malloc( *width * *height * sizeof(char));

  if (data == NULL) {
    fprintf(stderr,"Error allocating image memory\n");
    exit(1);
  }

  for (j=0; j < *height; j++) {
    fread(data+(j* *width), 1, *width, in);
  }

  fclose(in);

  return(data);
}


int WritePGMFile(char *name, int width, int height, char *data) {

  FILE *out;
  int j;

  out = fopen(name,"wb");

  if (out==NULL) {
    fprintf(stderr,"Error opening file %s\n", name);
    exit(1);
  }

  fprintf(out,"P5\n");
  fprintf(out,"%d\n",width);
  fprintf(out,"%d\n",height);
  fprintf(out,"255\n");

  for (j=0; j < height; j++) {
    fwrite(data+(j* width), 1, width, out);
  }

  fclose(out);
  return(0);
}
