#include "defs.h"
#include "structs.h"
#include "Util.h"

#include "common.h"


static int savemem1[256];

static void InterBorderBlock (Byte *ii, Byte *oi, int sx, int sy,
			      int bw, int bh, int iw, int ih)
{
  Byte *inData,*out2;
  int *out1,*in2;
  int x1,x2,x3;
  int t;

  int i,j;
  int ow = iw<<1;
  int ow2 = ow<<1;

   

  out1 = savemem1;

  for (j=0; j<bh+2; j++, out1+=16) {
    if ((sy+j-1)<0) inData = ii;
    else if ((sy+j-1)>=ih) inData = ii + ((ih-1)*iw);
    else inData  = ii + ((sy+j-1)*iw);
    if (sx==0) {
      x1 = inData[sx];
      x2 = inData[sx];
      x3 = inData[sx+1];
    }
    else {
      x1 = inData[sx-1];
      x2 = inData[sx];
      x3 = inData[sx+1];
    }
    for (i=0; i<bw; i++) {
      t= 3 * x2;
      out1[(i<<1)  ] = x1 + t;
      out1[(i<<1)+1] = t + x3;
      x1 = x2;
      x2 = x3;
      if ((sx+2+i)>=iw) x3 = inData[iw-1];
      else x3 = inData[sx+2+i];
    }
  }

   
  out2 = oi + (ow2*sy) + (2*sx);
  for (i=0; i<(2*bw); i++, out2++) {
    x1 = savemem1[i];
    x2 = savemem1[16+i];
    x3 = savemem1[32+i];
    in2 = savemem1+48+i;
    for (j=0; j<bh; j++, in2+=16) {
      t= 3 * x2;
      out2[(j*ow2)]    = (t+x1+8)>>4;
      out2[(j*ow2)+ow] = (t+x3+8)>>4;
      x1 = x2;
      x2 = x3;
      x3 = in2[0];
    }
  }
}

static void InterInnerBlock (Byte *ii, Byte *oi, int sx, int sy,
			     int bw, int bh, int iw)
{
  Byte *inData, *out2;
  int *in2, *out1;
  int x1,x2,x3;
  int t;

  int i,j;
  int ow = iw<<1;
  int ow2 = ow<<1;

  /* Horizontal upsampling */

  inData  = ii + ((sy-1)*iw) + sx - 1;
  out1 = savemem1;

  for (j=0; j<bh+2; j++, inData+=iw, out1+=16) {
    x1 = inData[0];
    x2 = inData[1];
    x3 = inData[2];
    for (i=0; i<bw; i++) {
      t = 3 * x2;
      out1[i*2] = t + x1;
      out1[i*2+1] = t + x3;
      x1 = x2;
      x2 = x3;
      x3 = inData[3+i];
    }
  }
  /* Vertical upsampling */
  out2 = oi + (ow2*sy) + (2*sx);

  for (i=0; i<(2*bw); i++, out2++) {
    x1 = savemem1[i];
    x2 = savemem1[16+i];
    x3 = savemem1[32+i];
    in2 = savemem1+48+i;
    for (j=0; j<bh; j++, in2+=16) {
      t= 3 * x2;
      out2[(j*ow2)]    = (t+x1+8)>>4;
      out2[(j*ow2)+ow] = (t+x3+8)>>4;
      x1 = x2;
      x2 = x3;
      x3 = *in2;
    }
  }
}

void InterpolateBlock(Byte *ii, Byte *oi, int sx, int sy, int bw, int bh,
		      int iw, int ih)

     /* ii:     pointer to input image
	oi:     pointer to output image
	sx,sy:  x and y coordinates of block in input image
	bw,bh:  width and height of block in input image
	iw,ih:  input image width and height
	*/
{

  if ((sx>0)&&(sy>0)&&(sx<(iw-bw))&&(sy<(ih-bh))) 
    InterInnerBlock(ii, oi, sx, sy, bw, bh, iw);
  else 
    InterBorderBlock(ii, oi, sx, sy, bw, bh, iw, ih);
}


#if 0
static void InterBorderBlockSub (Byte *ii, Byte *oi, int sx, int sy,
				 int bw, int bh, int iw, int ih, int ow)
{
  Byte *inData,*out2;
  int *out1,*in2;
  int x1,x2,x3;
  int t;

  int i,j;
  int ow2 = ow<<1;

   

  out1 = savemem1;

  for (j=0; j<bh+2; j++, out1+=16) {
    if ((sy+j-1)<0) inData = ii;
    else if ((sy+j-1)>=ih) inData = ii + ((ih-1)*iw);
    else inData  = ii + ((sy+j-1)*iw);
    if (sx==0) {
      x1 = inData[sx];
      x2 = inData[sx];
      x3 = inData[sx+1];
    }
    else {
      x1 = inData[sx-1];
      x2 = inData[sx];
      x3 = inData[sx+1];
    }
    for (i=0; i<bw; i++) {
      t= 3 * x2;
      out1[(i<<1)  ] = x1 + t;
      out1[(i<<1)+1] = t + x3;
      x1 = x2;
      x2 = x3;
      if ((sx+2+i)>=iw) x3 = inData[iw-1];
      else x3 = inData[sx+2+i];
    }
  }

   
  out2 = oi + (ow2*sy) + (2*sx);
  for (i=0; i<(2*bw); i++, out2++) {
    x1 = savemem1[i];
    x2 = savemem1[16+i];
    x3 = savemem1[32+i];
    in2 = savemem1+48+i;
    for (j=0; j<bh; j++, in2+=16) {
      t= 3 * x2;
      out2[(j*ow2)]    = (t+x1+8)>>4;
      out2[(j*ow2)+ow] = (t+x3+8)>>4;
      x1 = x2;
      x2 = x3;
      x3 = in2[0];
    }
  }
}
#endif

static void InterBorderBlockSub (Byte *ii, Byte *oi, int sx, int sy,
				 int bw, int bh, int iws, int ihs,
				 int iw, int ow)
{
  Byte *inData,*out2;
  int *out1,*in2;
  int x1,x2,x3;
  int t;

  int i,j;
  int ow2 = ow<<1;



  out1 = savemem1;

  for (j=0; j<bh+2; j++, out1+=16) {
    if ((sy+j-1)<0) inData = ii;
    else if ((sy+j-1)>=ihs) inData = ii + ((ihs-1)*iw);
    else inData  = ii + ((sy+j-1)*iw);
    if (sx==0) {
      x1 = inData[sx];
      x2 = inData[sx];
      x3 = inData[sx+1];
    }
    else {
      x1 = inData[sx-1];
      x2 = inData[sx];
      x3 = inData[sx+1];
    }
    for (i=0; i<bw; i++) {
      t= 3 * x2;
      out1[(i<<1)  ] = x1 + t;
      out1[(i<<1)+1] = t + x3;
      x1 = x2;
      x2 = x3;
      if ((sx+2+i)>=iws) x3 = inData[iws-1];
      else x3 = inData[sx+2+i];
    }
  }


  out2 = oi + (ow2*sy) + (2*sx);
  for (i=0; i<(2*bw); i++, out2++) {
    x1 = savemem1[i];
    x2 = savemem1[16+i];
    x3 = savemem1[32+i];
    in2 = savemem1+48+i;
    for (j=0; j<bh; j++, in2+=16) {
      t= 3 * x2;
      out2[(j*ow2)]    = (t+x1+8)>>4;
      out2[(j*ow2)+ow] = (t+x3+8)>>4;
      x1 = x2;
      x2 = x3;
      x3 = in2[0];
    }
  }
}

static void InterInnerBlockSub (Byte *ii, Byte *oi, int sx, int sy,
				int bw, int bh, int iw, int ow)
{
  Byte *inData, *out2;
  int *in2, *out1;
  int x1,x2,x3;
  int t;

  int i,j;
  int ow2 = ow<<1;

  /* Horizontal upsampling */

  inData  = ii + ((sy-1)*iw) + sx - 1;
  out1 = savemem1;

  for (j=0; j<bh+2; j++, inData+=iw, out1+=16) {
    x1 = inData[0];
    x2 = inData[1];
    x3 = inData[2];
    for (i=0; i<bw; i++) {
      t = 3 * x2;
      out1[i*2] = t + x1;
      out1[i*2+1] = t + x3;
      x1 = x2;
      x2 = x3;
      x3 = inData[3+i];
    }
  }
  /* Vertical upsampling */
  out2 = oi + (ow2*sy) + (2*sx);

  for (i=0; i<(2*bw); i++, out2++) {
    x1 = savemem1[i];
    x2 = savemem1[16+i];
    x3 = savemem1[32+i];
    in2 = savemem1+48+i;
    for (j=0; j<bh; j++, in2+=16) {
      t= 3 * x2;
      out2[(j*ow2)]    = (t+x1+8)>>4;
      out2[(j*ow2)+ow] = (t+x3+8)>>4;
      x1 = x2;
      x2 = x3;
      x3 = *in2;
    }
  }
}

void InterpolateBlockSub(Byte *ii, Byte *oi, int sx, int sy, int bw, int bh,
			 int iws, int ihs, int iw, int ow)

     /* ii:     pointer to input image
	oi:     pointer to output image
	sx,sy:  x and y coordinates of block in input image
	bw,bh:  width and height of block in input image
	iw,ih:  input image width and height
	*/
{

  if ((sx>0)&&(sy>0)&&(sx<(iws-bw))&&(sy<(ihs-bh))) 
    InterInnerBlockSub(ii, oi, sx, sy, bw, bh, iw, ow);
  else
    InterBorderBlockSub(ii, oi, sx, sy, bw, bh, iws, ihs, iw, ow);
}


void InterpolateMacroBlockSub(Picture *pictIn, Picture *pictOut,
			      int sx, int sy)
{
  int iws = pictIn->ws, ihs = pictIn->hs;
  int iw = pictIn->w;
  int ow = pictOut->w;


  InterpolateBlockSub(pictIn->y, pictOut->y, sx, sy,
		      MACROBLOCK_SIZE/2, MACROBLOCK_SIZE/2, iws, ihs, iw, ow);
  sx = sx >> 1;
  sy = sy >> 1;
  iws = iws >> 1;
  ihs = ihs >> 1;
  iw = iw >> 1;
  ow = ow >> 1;
  InterpolateBlockSub(pictIn->u, pictOut->u, sx, sy,
		      MACROBLOCK_SIZE/4, MACROBLOCK_SIZE/4, iws, ihs, iw, ow);
  InterpolateBlockSub(pictIn->v, pictOut->v, sx, sy,
		      MACROBLOCK_SIZE/4, MACROBLOCK_SIZE/4, iws, ihs, iw, ow);
}


extern Picture *filtPict[2];

void MultInterpolateMacroBlockSub(int mult, Picture *pictIn, Picture *pictOut,
				  int sx, int sy)
{
  if (mult == 0) {
    CopyMacroBlockPicture(sx, sy, pictIn, pictOut);
  } else {
    int sxi, syi, sxm, sym;
    int mbSize, mbSizeC, mbSizex, mbSizey, mbSizeCx, mbSizeCy;
    int wi, wis, his, wo;
    Byte *yi, *ui, *vi, *yo, *uo, *vo;


    sxi = (sx >> mult);
    syi = (sy >> mult);
    mbSize = MACROBLOCK_SIZE;
    mbSize = (mbSize >> mult);
    mbSize = MAX(mbSize, 1);
    mbSizeC = mbSize / 2;
    mbSizeC = MAX(mbSizeC, 1);

    yi = pictIn->y;
    ui = pictIn->u;
    vi = pictIn->v;
    wi = pictIn->w;
    wis = pictIn->ws;
    his = pictIn->hs;

    for (mult--; mult; mult--) {
      yo = filtPict[mult&1]->y;
      uo = filtPict[mult&1]->u;
      vo = filtPict[mult&1]->v;
      wo = (pictOut->w >> mult);

      sxm = sxi - mult;
      sxm = MAX(sxm, 0);
      sym = syi - mult;
      sym = MAX(sym, 0);
      mbSize += (mult << 1);
      mbSizeC += (mult << 1);
      mbSizex = MIN(mbSize, wis - sxm);
      mbSizey = MIN(mbSize, his - sym);
      mbSizeCx = MIN(mbSizeC, wis/2 - sxm/2);
      mbSizeCy = MIN(mbSizeC, his/2 - sym/2);

      InterpolateBlockSub(yi, yo, sxm, sym, mbSizex, mbSizey, wis, his, wi,wo);
      InterpolateBlockSub(ui, uo, sxm/2, sym/2, mbSizeCx, mbSizeCy,
			  wis/2, his/2, wi/2, wo/2);
      InterpolateBlockSub(vi, vo, sxm/2, sym/2, mbSizeCx, mbSizeCy,
			  wis/2, his/2, wi/2, wo/2);

      sxi = (sxi << 1);
      syi = (syi << 1);
      mbSize = (MACROBLOCK_SIZE >> mult);
      mbSize = MAX(mbSize, 1);
      mbSizeC = mbSize / 2;
      mbSizeC = MAX(mbSizeC, 1);

      yi = yo;
      ui = uo;
      vi = vo;
      wi = wo;
      wis = (wis << 1);
      his = (his << 1);
    }

    yo = pictOut->y;
    uo = pictOut->u;
    vo = pictOut->v;

    InterpolateBlockSub(yi, yo, sxi, syi, mbSize, mbSize, wis, his, wi,
			pictOut->w);
    InterpolateBlockSub(ui, uo, sxi/2, syi/2, mbSizeC, mbSizeC, wis/2, his/2,
			wi/2, pictOut->w/2);
    InterpolateBlockSub(vi, vo, sxi/2, syi/2, mbSizeC, mbSizeC, wis/2, his/2,
			wi/2, pictOut->w/2);
  }
}


void CopyBlock(Byte *ii, Byte *oi, int sx, int sy, int bw, int bh, int iw)

     /* ii:     pointer to input image
	oi:     pointer to output image
	sx,sy:  x and y coordinates of block in input image
	bw,bh:  width and height of block in input image
	iw:     input image width
	*/
{
  int i;
  int offset = sx + sy * iw;
  Byte *oi_p = oi + offset;
  Byte *ii_p = ii + offset;


  for (i = 0; i < bh; i++) {
    memcpy(oi_p, ii_p, bw * sizeof(Byte));
    oi_p += iw;
    ii_p += iw;
  }
}



void CopyBlockToPicture(Byte *ii, Byte *oi, int sx, int sy, int bw, int bh, int iw)

     /* ii:     pointer to input image
	oi:     pointer to output image
	sx,sy:  x and y coordinates of block in input image
	bw,bh:  width and height of block in input image
	iw:     input image width
	*/
{
  int i;
  int offset = sx + sy * iw;
  Byte *oi_p = oi + offset;
  Byte *ii_p = ii;


  for (i = 0; i < bh; i++) {
    memcpy(oi_p, ii_p, bw * sizeof(Byte));
    oi_p += iw;
    ii_p += bw;
  }
}
