#include <stdio.h>
#include <stdlib.h>

#include <xil/xil.h>	/* redefines NULL */

#include <defs.h>
#include <structs.h>
#include <Util.h>

void grabPicture(Picture *pict)
{
  static int virgin = 1;
  static int w = 0;
  static XilSystemState state;
  static XilImage rtvc_image, scaled_image;
  static float scale_factor;
  Xil_unsigned8 *data_ptr;
  static XilCis cis;
  int nbytes, nframes;
  int x, y;
  unsigned char *yp, *up, *vp;


  if (virgin) {
    unsigned int width, height, nbands;
    int child_width = 0;
    int child_height = 0;
    XilDataType datatype;
    int image_skip = 0;
    int max_buffers = -1;
    int port = 1;
    char *devname = "/dev/rtvc0";



    state = xil_open();
    if (state == NULL) {
	fprintf(stderr, "unable to open xil library\n");
	exit(1);
    }

    {
	XilDevice device;

	if (!(device = xil_device_create(state, "SUNWrtvc"))) {
	    fprintf(stderr, "Unable to create a device object\n");
	    xil_close(state);
	    exit(1);
	}

	xil_device_set_value(device, "DEVICE_NAME", (void *) devname);
	xil_device_set_value(device, "PORT_V", (void *) port);
	if (image_skip)
	    xil_device_set_value(device, "IMAGE_SKIP", (void *) image_skip);
	if (max_buffers >= 0)
	    xil_device_set_value(device, "MAX_BUFFERS", (void *) max_buffers);

	if (!(rtvc_image = xil_create_from_device(state, "SUNWrtvc",
						  device))) {
	    fprintf(stderr, "failed to open SUNWrtvc device\n");
	    xil_close(state);
	    exit(1);
	}
	xil_device_destroy(device);
    }

    {
	int format;

	xil_get_device_attribute(rtvc_image, "FORMAT_V", (void **) &format);
	if (format == 0) {
	    fprintf(stderr, "Unknown video format, exiting.\n");
	    xil_close(state);
	    exit(1);
	}
    }


    xil_get_info(rtvc_image, &width, &height, &nbands, &datatype);

    /* check for width or height too big */
    if (child_width > width || child_height > height) {
	fprintf(stderr, "Maximum width,height = %d,%d\n", width, height);
	xil_close(state);
	exit(1);
    }


    if ((child_width) || (child_height)) {
	if (!child_width)
	    child_width = width;
	if (!child_height)
	    child_height = height;
	if (!(rtvc_image = xil_create_child(rtvc_image,
					    (width - child_width) / 2,
					    (height - child_height) / 2,
					    child_width, child_height,
					    0, nbands))) {
	    fprintf(stderr, "failed to open child image on SUNWrtvc\n");
	    xil_close(state);
	    exit(1);
	}

	xil_get_info(rtvc_image, &width, &height, &nbands, &datatype);
    }

    w = pict->w;
    scale_factor = (float)w / (float)width;
    scale_factor = MAX(scale_factor, ((float)pict->h / (float)height));
    scaled_image = xil_create(state, w, pict->h, nbands, XIL_BYTE);

    cis = xil_cis_create(state, "UYVY");
    xil_cis_set_keep_frames(cis, 1);
    xil_cis_set_max_frames(cis, 1);


    virgin = 0;
  }

  /* Crosscheck the picture size */
  if (pict->w != w) {
    unsigned int width, height, nbands;
    XilDataType datatype;

    xil_get_info(rtvc_image, &width, &height, &nbands, &datatype);

    w = pict->w;
    scale_factor = (float)w / (float)width;
    scale_factor = MAX(scale_factor, ((float)pict->h / (float)height));
    scaled_image = xil_create(state, w, pict->h, nbands, XIL_BYTE);
  }

  xil_scale(rtvc_image, scaled_image, "nearest", scale_factor, scale_factor);
  xil_compress(scaled_image, cis);
  xil_cis_sync(cis);
  xil_toss(scaled_image);
  while (xil_cis_has_frame(cis)) {
    data_ptr = (void *) xil_cis_get_bits_ptr(cis, &nbytes, &nframes);
    yp = pict->y;
    up = pict->u;
    vp = pict->v;
    for (y = 0; y < pict->h; y += 2) {
      for (x = 0; x < w; x += 2) {
	*yp++ = data_ptr[1];
	*yp++ = data_ptr[3];
	*up++ = data_ptr[0];
	*vp++ = data_ptr[2];
	data_ptr += 4;
      }
      for (x = 0; x < w; x += 2) {
	*yp++ = data_ptr[1];
	*yp++ = data_ptr[3];
	data_ptr += 4;
      }
    }
  }
}
