/*
 * main.c - 
 *
 * 15.10.97, jw.
 */
#ifdef LINUX
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#endif
 
#include <stdio.h>
#include <stdlib.h>
#ifdef LINUX
#include <sys/time.h>
#endif
#include <unistd.h>
#include <string.h>
#include <sys/time.h>	/* struct timeval */

#define DEFINE_GLOBALS

#if 0
#define ERROR_PRONE
#endif

#include "options.h"
#include "config.h"	/* Options initializers */
#include "dispconf.h"	/* Options initializers */

/* Prototype files */
#include "h263decoder.h"
#include "display.h"


#define DATABUF 256


#ifdef DEBUG
FILE *debugfp = stderr;
char *debugfilename = NULL;
#endif

static OptionsStruct Init_Options =
{
  NULL,
  USE_VIS,
  USE_DGA,
  USE_SHM,
  DISPLAY,
  0,		/* Default for cover_window: use own toplevel */
  THREAD_YUV,
  GRAY,
  PSEUDOCOLOR,
  EXPAND,
  SIZE_QCIF,
  -1,		/* Default for fps */
  LOOP,
  AUDIO
};

#if defined(__sun) && defined(FILE)
# define memmove(d, s, n) bcopy(s, d, n)
#endif

static void ExitWithUsage(char *msg, int ret)
{
#define O(txt, def, opt) fprintf(stderr, "  -%s. Default: -%s%s.\n", txt, \
def ? "" : "no", opt);
  fprintf(stderr, "Usage: %s [-[no]option ...] file.pyra\n", Options.argv0);
#ifndef WITHOUT_DGA
  O("dga        Use Direct Graphics Access", USE_DGA, "dga");
#endif
  O("windowid   Use given window as parent", 1, " own toplevel");
  O("nodisplay  Don't show the decoded frames", DISPLAY, "display");
  O("expand     Double the size of the image", EXPAND, "expand");
  O("gray       Show video in grayscale", GRAY, "gray");
  O("noaudio    Disable audio", AUDIO, "audio");
/*  O("loop       Repeat the input stream infinitly", LOOP, "loop"); */
  O("pseudo     Show video in PseudoColor (8Bit)", PSEUDOCOLOR,
    "pseudo (TrueColor)");
  O("qcif       Show image in QCIF size", 1, SIZE_QCIF ? "qcif" : "cif");
#ifndef WITHOUT_SHM
  O("noshm      Don't use shared memory", USE_SHM, "shm");
#endif
#ifndef WITHOUT_THREADS
  O("threads    Spawn a thread for color conversion", THREAD_YUV, "threads");
#endif
#ifndef WITHOUT_VIS
  O("vis        Use UltraSparc Visual Instruction Set", USE_VIS, "vis");
#endif
  O("fps        If set, use given framerate", 1, "nofps (unlimited)");
  O("quiet      run in silence", 0, "not quiet");
  if (msg)
    fprintf(stderr, "\nHmmm: %s\n", msg);
  exit(ret);
}

/*
 * sched_timerdiff() returns the difference timeval in result, between future
 * and past.  If the diffeence is negative, result remains untouched and -1 is
 * returned.  Returns 0 on success.
 */
int
sched_timerdiff(result, future, past)
struct timeval *result, *future, *past;
{
  long s, u;
 
  s = future->tv_sec - past->tv_sec;
  if ((u = future->tv_usec - past->tv_usec) < 0)
    { 
      u += 1000000;
      s--;
    }
 
  if (s < 0)
    { 
      /* debug("sched_timerdiff: negative difference"); */
      return -1;
    }
  result->tv_sec = s;
  result->tv_usec = u;
  return 0;
}

/*
 * This WaitFrame() is not good for network transmissions.
 * Consider Buffers here!!!
 *
 * Returns negative, if too late.
 */
int
WaitFrame(int temp_ref, int fps)
{
  struct timeval tv, fut, now;

  static int prev_temp_ref = -100;
  static struct timeval prev_tv;

  if (!fps)
    return 0;

  if (!prev_tv.tv_sec)
    {
      prev_temp_ref = temp_ref;
      gettimeofday(&prev_tv, NULL);
      return 0;
    }
  
  if (fps < 0)
    {
      int i;

#if 1
      tv.tv_usec = 1001000/30;
#else
      tv.tv_usec = this->timebasenom / this->timebasedenom; /* FIXME */
#endif
      i = temp_ref - prev_temp_ref;
      prev_temp_ref = temp_ref;
      /* ASSERT(i == this->trd); */

      if (i < 0) i += 256;

      tv.tv_usec *= i;
      tv.tv_sec = tv.tv_usec / 1000000;
      tv.tv_usec -= 1000000 * tv.tv_sec;
    }
  else
    {
      tv.tv_usec = 1000000/fps;
      tv.tv_sec = 0;
    }
/*  debug1("frametime %d usec, ", (int)tv.tv_usec); */

  
  fut.tv_sec = tv.tv_sec + prev_tv.tv_sec;
  fut.tv_usec = tv.tv_usec + prev_tv.tv_usec;
  if (fut.tv_usec > 1000000)
    {
      fut.tv_sec++;
      fut.tv_usec -= 1000000;
    }

  prev_tv.tv_sec = fut.tv_sec;
  prev_tv.tv_usec = fut.tv_usec;

  gettimeofday(&now, NULL);
  if (sched_timerdiff(&tv, &fut, &now))
    {
      /* already too late */
      return -1;
    }
  select(0, NULL, NULL, NULL, &tv); 
/*  debug1("waiting %d usec\n", (int)tv.tv_usec); */
  return 1;
}


int main(int argc, char *argv[]) 
{
  H263Global *h263Data = NewH263Decoder();
  FILE *stream;
  Byte *databuf = (Byte *) malloc(DATABUF);
  Byte *next, *end = NULL;
  int disp = 0;
  Picture picture;
#ifdef ERROR_PRONE
  int percentLoss = 5;
#endif


  Options = Init_Options; 	/* struct copy */
  Options.argv0 = *argv++;

  while(*argv && **argv == '-' && argv[0][1]) 
    {
      char *o = *argv++;
      int v = strncmp("no", o+1, 2) ? 1 : 0;

      o += v ? 1 : 3;
           if (!strcmp(o, "gray"))	Options.visgray = v;
      else if (!strcmp(o, "grey"))	Options.visgray = v;
      else if (!strcmp(o, "pseudo"))	Options.vis8 = v;
      else if (!strcmp(o, "vis"))	Options.use_vis = v;
      else if (!strcmp(o, "dga"))	Options.use_dga = v;
      else if (!strcmp(o, "shm"))	Options.use_shm = v;
      else if (!strcmp(o, "shmem"))	Options.use_shm = v;
      else if (!strcmp(o, "display"))	Options.display = v;
      else if (!strcmp(o, "thread"))	Options.thread_yuv = v;
      else if (!strcmp(o, "threads"))	Options.thread_yuv = v;
      else if (!strcmp(o, "expand"))	Options.visexpand = v;
      else if (!strcmp(o, "audio"))	Options.audio = v;
      else if (!strcmp(o, "qcif"))	Options.qcif = v;
      else if (!strcmp(o, "cif"))	Options.qcif = !v;
      else if (!strcmp(o, "fps"))	Options.fps = atoi(*argv++);
      else if (!strcmp(o, "quiet"))	h263Data->quiet = 1;
      else if (!strcmp(o, "window"))	
        Options.cover_window = strtol(*argv++, NULL, 0);
      else if (!strcmp(o, "windowid"))	
        Options.cover_window = strtol(*argv++, NULL, 0);
      else if (!strcmp(o, "id"))	
        Options.cover_window = strtol(*argv++, NULL, 0);
/*    else if (!strcmp(o, "loop"))	Options.loop = v;	*/
      else 
        ExitWithUsage("Unknown commandline option.", 1);
    }

  if (!Options.fps)
    {
      if (Options.audio)
	fprintf(stderr, "Audio disabled, -fps missing.\n");
      Options.audio = 0;
    }

  if (!*argv)
    ExitWithUsage("Name of input file is missing.", 0);

  if (argv[0][0] == '-' && argv[0][1] == '\0')
    stream = stdin;
  else if (!(stream = fopen(*argv, "r")))
    fprintf(stderr, "%s: ", *argv),perror("fopen"),exit(0);
  
  /* wrong: init_display should obey -qcif -cif flags */
  if (Options.qcif)
    init_display(QCIF_WIDTH, QCIF_HEIGHT);
  else
    init_display(CIF_WIDTH, CIF_HEIGHT);


  do {
    if (disp == 0) {
#ifdef ERROR_PRONE
      if (ErrorProneCheckInBufferH263(stream, databuf, DATABUF, &next, &end,
				      percentLoss, &(h263Data->next_temp_ref))
	  > 0)
	/* We have lost some packets */
	/* So lets tell the world that we need to resync */
	h263Data->bs->BufState = GOB_EMPTY;
#else
      CheckInBuffer(stream, databuf, DATABUF, &next, &end);
#endif
    }

    disp = HandleH263DataJunk(h263Data, &next, end, feof(stream));

    if (disp == 1) {  /* Do we already have a picture */
      picture.w = h263Data->coded_picture_width;
      picture.h = h263Data->coded_picture_height;
      if (h263Data->pb_frame) {
	/* 	printf("\rt: %3d", h263Data->prev_temp_ref + h263Data->trb); */
	picture.y = h263Data->bframe[0];
	picture.u = h263Data->bframe[1];
	picture.v = h263Data->bframe[2];
	WaitFrame(h263Data->prev_temp_ref + h263Data->trb, Options.fps);
	yuv2rgb(&picture);
      }
      /*       printf("\rt: %3d", h263Data->temp_ref); */
      picture.y = h263Data->newframe[0];
      picture.u = h263Data->newframe[1];
      picture.v = h263Data->newframe[2];
      WaitFrame(h263Data->temp_ref, Options.fps);
      if (picture.w == (Options.qcif ? QCIF_WIDTH : CIF_WIDTH))
	yuv2rgb(&picture);
      else
	/* FIXME: yuv4rgb(&picture, displayBuffer);*/
	return -1;
    }
  } while(!(feof(stream) && next >= end));

  
  /* Clean up */
  fclose(stream);
  DisinitH263Decoder(h263Data);
  FreeH263Decoder(h263Data);
  free(databuf);
  sleep(1);
  exit_display();
  return 0;
}

