/*
 * attr.c -- implement lousy data types from attributed atoms
 *
 * 16.5.97, jw
 */
#include <stdio.h>              /* NULL */
#include <string.h>             /* strrchr() */
#include "jittr/atom.h"		/* atom_name() */
#include "jittr/jittr.h"	/* jittr_opendir() */
#include "jittr/attr.h"

/*
 * Caution: keep this code in sync with jittr_generate_widgets in jxcmd.c
 *
 * Although the link names ".button", ".slider", ".board", ... are understood 
 * here, their use is strongly discouraged. Please use ".widget" links with a
 * value of "button", "slider", "board", ...
 *
 * Caution: Keep this code in sync with jittr_generate_widgets in jxcmd.c
 */
int jittr_get_attr(idx)
int idx;
{
  char *name, *attr;
  int r = JA_T_UNDEF, nchildren = 0;
  struct dstring **dp;
  void *ptr = jittr_opendir(idx, 0);

  while ((dp = jittr_readdir(ptr, &name)))
    {
      if (!*dp || !name || !*name)
        continue;
      if (*name != '.')
        nchildren++;
      else 
        {
	  if (!strcmp(".widget", name))
            attr = jittr_link_resolve(idx, name, 7, NULL, NULL);
	  else 
	    attr = name + 1;

	  if      (!(strcmp(attr, "button")))	r |= JA_W_BUTTON;
	  else if (!(strcmp(attr, "slider")))	r |= JA_W_SLIDER;
	  else if (!(strcmp(attr, "board")))	r |= JA_W_BOARD;
	  else if (!(strcmp(attr, "frame")))	r |= JA_W_FRAME;
	  else if (!(strcmp(attr, "rowcol")))	r |= JA_W_ROWCOL;
	  else if (!(strcmp(attr, "unary")))	r |= JA_T_UNARY;
	  else if (!(strcmp(attr, "state")))	r |= JA_T_STATE;
	  else if (!(strcmp(attr, "min")))	r |= JA_MIN;
	  else if (!(strcmp(attr, "max")))	r |= JA_MAX;
	  else if (!(strcmp(attr, "width")))	r |= JA_MIN;
	  else if (!(strcmp(attr, "height")))	r |= JA_MAX;
	  else if (!(strcmp(attr, "vertical")))	r |= JA_VERTICAL;
	  else if (!(strcmp(attr, "location")))	r |= JA_LOCATION;
	}
    }
  jittr_closedir(ptr);
  
  if (r & JA_W_BUTTON	&& !(r & JA_TYPE))	r |= JA_T_UNARY;
  if (r & JA_W_SLIDER	&& !(r & JA_TYPE)) 	r |= JA_T_RANGE;
  if (r & JA_W_BOARD	                 ) 	r |= JA_T_CONTAINER;
  if (r & JA_W_FRAME	                 )	r |= JA_T_CONTAINER;
  if (r & JA_W_ROWCOL	                 )	r |= JA_T_CONTAINER;
  if (r & JA_MIN  	&& !(r & JA_TYPE)) 	r |= JA_T_RANGE;
  if (r & JA_MAX  	&& !(r & JA_TYPE)) 	r |= JA_T_RANGE;
  if (r & JA_T_RANGE  	&& !(r & JA_WIDGET)) 	r |= JA_W_SLIDER;
  if (r & JA_T_UNARY  	&& !(r & JA_WIDGET)) 	r |= JA_W_BUTTON;

  if (nchildren) r |= JA_T_CONTAINER;

#ifdef DISALLOW_CHILDREN_IN_SIMPLE_WIDGETS
  if (r & (JA_T_UNARY|JA_T_RANGE|JA_T_STATE))
    r & ~JA_T_CONTAINER;
#endif

  return r;
}

char *jittr_get_label(idx)
int idx;
{
  char *r;
  
  if ((r = jittr_link_resolve(idx, ".label", 6, NULL, NULL)))
    return r;
  if ((r = strrchr(atom_name(idx), '/')) && r[1])
    return r+1;
  return atom_name(idx);
}

/*
 * Break menu at blanks or newlines. Poke '\0' bytes there.
 * Returns a malloced vector of (char *), that contains *nitemsp 
 * elements (pointing to the fragemnts of menu) and one trailing NULL
 * element.
 */
char **jittr_chop(menu, nitemsp)
char *menu;
int *nitemsp;
{
  char **v, *s = menu;
  int i = strchr(menu, '\n') ? '\n' : ' ';
  int nitems = 1;
  
  while (*s)
    {
      if (*s == i)
	{
	  nitems++;
	  *s = '\0';		/* seperate strings by nul-bytes */
	}
      s++;
    }

  if (!(v = (char **)calloc(sizeof(char *), nitems+1)))
    return NULL;

  for (s = menu, i = 0; i < nitems; i++)
    {
      v[i] = s;
      while (*s++)	/* advance over the nul-bytes written above */
        ;
    }
  v[i] = NULL;

  if (nitemsp)
    *nitemsp = nitems;
  return v;
}
