# config.mk -- common definitions 
#
# Included by every Makefile in the jittr source tree.
# Edit your customisations below. Do it by hand.
# Sorry, no autoGNUf confiGNUre script here.
#
# jw 25.6.96

CC		= gcc
#CFLAGS		= -DDEBUG -g -Wall #-O2
CFLAGS		= -Wall -O2
#CC		= cc
#CFLAGS		= -g -DDEBUG
M_FLAGS		= $(MFLAGS) #--no-print-directory
LIBXT		= -lXt
INSTALL		= cp
INST_TOP	= ${TOP}
INST_BIN	= ${INST_TOP}/bin
INST_LIB	= ${INST_TOP}/lib
INST_ETC	= ${INST_TOP}/etc
INST_INC	= ${INST_TOP}/include/jittr

#### X11 and my own libfwf_j.a library of the wonderful Bert Bos wbuild widgets.
#### SunOS4.1.3_U1@home
#JFWF_INCDIR	= /src/stand/src/FWF-4.0j/include
#JFWF_LIBDIR	= /src/stand/src/FWF-4.0j/lib
#X11_INCDIR	= /local/X11R6/include
#X11_LIBDIR	= /local/X11R6/lib
#INST_TOP	= $(TOP)
#R6LIBS		= -lSM -lICE
#NETLIB		=
#RANLIB		= ranlib
#DLD		=

### solaris@fau
JFWF_INCDIR	= /local/X/include -I/local/X/include/xpm
JFWF_LIBDIR	= /local/X/lib
X11_INCDIR	= /usr/openwin/include
X11_LIBDIR	= /usr/openwin/lib
R6LIBS		= -R$(X11_LIBDIR) -R$(JFWF_LIBDIR) -lXext
NETLIB		= -lsocket -lnsl
RANLIB		= :
DLD		=

### linux-1.2.13@home
#JFWF_INCDIR	= $(TOP)/FWF-4.0j/include
#JFWF_LIBDIR	= $(TOP)/FWF-4.0j/lib
#X11_INCDIR	= /usr/X11/include
#X11_LIBDIR	= /usr/X11/lib
#INST_TOP	= $(TOP)
#R6LIBS		= -lSM -lICE
#NETLIB		=
#RANLIB		= ranlib
#DLD		= GNU_DLD

#### sunos4@fau
#JFWF_INCDIR	= /local/X11R5/include
#JFWF_LIBDIR	= /local/X11R5/lib
#X11_INCDIR	= /local/X11R5/include
#X11_LIBDIR	= /local/X11R5/lib
#R6LIBS		=
#NETLIB		=
#RANLIB		= ranlib
#DLD		=

#### irix5@fau
#JFWF_INCDIR	= /local/X11R5/include
#JFWF_LIBDIR	= /local/X11R5/lib
#X11_INCDIR	= /usr/include
#X11_LIBDIR	= /usr/lib
#R6LIBS		=
#NETLIB		=
#RANLIB		= :
#DLD		=

### solaris with X11R6
#JFWF_INCDIR	= $(TOP)/FWF-4.0j/include
#JFWF_LIBDIR	= $(TOP)/FWF-4.0j/lib
#X11_INCDIR	= /local/X11R6/include
#X11_LIBDIR	= /local/X11R6/lib
#R6LIBS		= -R$(X11_LIBDIR) -lSM -lICE
#NETLIB		= -lsocket -lnsl
#RANLIB		= :
#DLD		=

### hpux9@fau
#JFWF_INCDIR	= #/local/openwin+/include -I/local/openwin+/include/xpm
#JFWF_LIBDIR	= #/local/openwin+/lib
#X11_INCDIR	= /usr/include
#X11_LIBDIR	= /usr/lib
#R6LIBS		= -lXext
#NETLIB		=
#RANLIB		= ranlib
#DLD		=

### The code as of 0.96 went through purify-2.0. Do you want to do that again?
#PURIFY		= purify

### I have problems with purify-2.0 over gcc-2.6.3 on sos4, this helps:
### Be still careful: I fear that purify introduces subtle bugs in -fpic code.
#PURIFY		= purify -optimize-save-o7=no
#LIBXT		= -Xlinker -Bstatic -lXt -Xlinker -Bdynamic

### Most people don't have the Xpm library. Ist is so tiny, I compile it
### statically into my binaries.
LIBXPM		= -Xlinker -Bstatic -lXpm -Xlinker -Bdynamic

### Do we have DLD = GNU_DLD?  Tested with dld-3.2.6
### If so, where do we have the Gnu dynamic link library and header files? 
GDLDINC		= $(TOP)/dld
GDLDLIB		= $(TOP)/dld


###
############# You should not need to edit anything below this line ###########
###

### The syntax of my Makefiles rules is for /bin/sh. 
SHELL		= /bin/sh

### where the toplevel directory lives.  ".." is correct in most cases.
### If not, override it in your Makefile
TOP		= ..

### where to find the jittr library
JLIBDIR		= $(TOP)/src/jlib
JLIBINCDIR	= $(JLIBDIR)/jittr
JLIB		= -L$(JLIBDIR) -ljittr $(NETLIB)


### collect the requisites needed to build a graphical user interface
JFWF_INC	= -I$(X11_INCDIR) -I$(JFWF_INCDIR)
JFWF_LIB	= -L$(JLIBDIR) -L$(X11_LIBDIR) -L$(JFWF_LIBDIR) -ljxt -lfwf_j -lm $(LIBXPM) -lXmu $(LIBXT) $(R6LIBS) -lX11


### how to build modules
MODMAKE		= GDLDINC="$(GDLDINC)" GDLDLIB="$(GDLDLIB)" $(JLIBDIR)/modmake -v -$(DLD) -$(CC)
MKMBUILTIN	= $(JLIBDIR)/mkmbuiltin.sh
MODS		=
TMODS		=

### how to make clean (most of it)
CLEAN		= *.o *.so mbuiltin.c *.pure* *.bak core

### targets follow, which are not default, skip over them:
default_target_is: all


### how to generate .o files
.c.o:
	$(CC) $(CFLAGS) -I. -I$(JLIBINCDIR) -c $<


### How to generate the static module loader structure
### override MBUILTIN in your Makefile, if you don't want all MODS builtin.
### override OBJS in your Makefile, if you want a different shell.
MBUILTIN	= $(MODS)
MBUILTINT	= $(TMODS)
OBJS		= $(MBUILTIN)  mbuiltin.o  $(JLIBDIR)/jsh.o
TOBJS		= $(MBUILTINT) mbuiltint.o $(JLIBDIR)/jxsh.o

mbuiltin.c: Makefile $(MBUILTIN) $(MKMBUILTIN) $(JLIBDIR)/mbuiltin.h
	rm -f $@
	$(MKMBUILTIN) $(MBUILTIN) > $@
	chmod a=r $@

mbuiltint.c: Makefile $(MBUILTINT) $(MKMBUILTIN) $(JLIBDIR)/mbuiltin.h
	rm -f $@
	$(MKMBUILTIN) $(MBUILTINT) > $@
	chmod a=r $@

### how to install the whole smere

INSTALL_SO	= $(INSTALL) *.so $(INST_LIB)

install: $(INST_BIN) $(INST_LIB)

$(INST_BIN):
	-mkdir -p $(INST_BIN)

$(INST_LIB):
	-mkdir -p $(INST_LIB)

### how to archive the whole source tree
SOURCE		= j*/*.c j*/*.h j*/*.jit j*/*.gif j*/*.jpg
BUILD		= Makefile configure *.mk j*/*.sh j*/Makefile j*/*.mk
DOCS		= mail/* j*/man/* j*/doc/*
ARCHIVE		= $(BUILD) $(SOURCE) $(DOCS)
VERS		= `sed -n -e '/define V/s/^[^"]*"\([^ ]*\).*/\1/p' < jlib/version.h`

zoo jittr.zoo:
	rm -f $(TOP)/jittr-*.zoo
	cd $(TOP); zoo ah jittr-$(VERS).zoo $(ARCHIVE)
	cd $(TOP); zoo PPE jittr-$(VERS).zoo
	cd $(TOP); ls -l jittr-$(VERS).zoo

dist tar:
	rm -f $(TOP)/jittr-*.tar.gz
	cd $(TOP); tar cvf - $(ARCHIVE) | gzip > jittr-$(VERS).tar.gz
	cd $(TOP); ls -l jittr-$(VERS).tar.gz


### how to update dependencies
_depend depend.mk:
	-mv depend.mk depend.mk.bak
	-gcc -I$(JLIBDIR) $(JFWF_INC) -MM *.c > depend.mk
	@echo "  >>>>>>>  Dependencies updated. Please run make again. <<<<<<<<"
