/*
 * I have a problem with gcc-2.6.3
 *
 * Their assert.h uses a special __eprintf() when __GNUC__.
 * When building a library, this is unfair, because the library has 
 * ___eprintf the undefined symbol, which expected to be resolved by libg.a.
 * This means, that one cannot use a gcc compiled library (that uses the
 * assert() macro) in a non-gcc link environment.
 *
 * I herewith provide a replacement.
 * 26.6.96 jw.
 *
 */
#ifndef __GNUC__
#include <stdio.h>

void __eprintf(fmt, file, line, ex)
char *fmt, *file;
int line;
char *ex;
{
  fprintf(stderr, fmt, file, line, ex);
  abort();
}
#endif
