/* action.h -- the jittr interface to the scheduler
 *
 * split from jittr.c because of user.c
 * 07.07.96 jw.
 */

extern int jittr_process __P((void **av));   /* only for reference in user.c */

enum reply_type {RT_CLIENT = 0, RT_ATOM};

/* has to fit into sizeof((struct sched_action).argv) */
struct jittr_action
{
  dstring *args;		/* command string that shall be executed: */
  				/* unparsed parameters start at (char *)data */
				/* and end at buf+length */
  dstring *dflt_fmt;		/* reply-format if specified */
  int atom;			/* ... executed by this atom, */
  enum reply_type type;		/* ... replying to 0: client, 1: atom  */
  union
  {
    struct client *client;	/* pointer used, as we never delete clients */
    int atom;			/* index used, to survive a deleted atom */
  } reply;
  struct client *who;		/* client that scheduled this action */
  struct cwp cwp;		/* clients working point when scheduled */
};
