#ifndef _HAVE_ATOM_H
#define _HAVE_ATOM_H
/*
 * atom.h -- declarations & potatotypes
 *
 * Added dstring based error reporting macros ERR, ERRNL, ERRRET.
 * 27.12.95 jw.
 * put dstring related stuff in dstring.h
 * 30.3.96. jw
 * no more automatic replacement of existing traces.
 * 15.7.96. jw
 */

#ifdef __sgi
# include <bstring.h>          /* bcmp() */
#endif
#include "jittr/dstring.h"

/* flag bits for atom tracing */
#define TRACE_WRITE	0x01	/* call after writing value */
#define TRACE_TRUNC	0x02	/* call when value is length 0 after write */
#define TRACE_READ   	0x04	/* call before reading value */
#define TRACE_UNSET	0x08	/* call before destruction of atom */
#define TRACE_EXEC   	0x10	/* called explicitly, no value change */
#define TRACE_RDWR   	(TRACE_READ|TRACE_WRITE)
#define TRACE_MODE_MASK	0xff

#define TRACE_LATE	0x0100	/* queue new traces before myself */
#define TRACE_LAST	0x0200	/* no more traces following now */
#define TRACE_ONCE	0x0400	/* delete this trace after calling once */
#define TRACE_REPL	0x1000	/* if same trace already exists, update it */
#define TRACE_UNIQ	(TRACE_ONCE|TRACE_REPL)
#define TRACE_WHEN_MASK	0x0f00
#define TRACE_EDIT_MASK	0xf000

#define TRACE_DATA_ALLOCED	0x010000
#define TRACE_DATA_CONTEXT	0x020000
#define TRACE_DATA_MASK		0x0f0000
 
/* ASSERT(TRACE_MODE_MASK+TRACE_WHEN_MASK+TRACE_EDIT_MASK+TRACE_DATA_MASK ==
	  TRACE_MODE_MASK|TRACE_WHEN_MASK|TRACE_EDIT_MASK|TRACE_DATA_MASK); */

typedef struct trace
{
  struct trace *next;		/* linked list */
  int flag;			/* combination of TRACE_... flags */
  void *data;			/* private pointer of trace method */
  int (* fn) __P((int flag, int idx, void *data));
} trace;

/* flag bits for atoms */
#define A_READONLY 	0x01	/* atom_append() forbidden */
#define A_PERMANENT	0x02	/* atom_delete() forbidden */
#define A_DATA_ALLOCED	0x10	/* pass it to free() later */

typedef struct atom
{ 
  struct
  {
    int refcount:16;		/* 0 indicates an unused atom */
    int traced:8;		/* currently executing trace callbacks here */
    int flag:8;
  } a;
  trace *trace;
  dstring *value;
  dstring *name;		/* name of the atom, should also be hashed... */
  void *data;			/* expansion, e.g. struct atom_data * */
} atom;

/* Well known atoms indices. Others don't have assertions on their index */
#define      NEW_ATOM	0	/* manager of atom creation */
#define    REPLY_ATOM	1	/* path back to the current user */
#define   STDOUT_ATOM	REPLY_ATOM	/* a common alias */
#define   STDERR_ATOM	2	/* generic error reporting machanism */
#define HELP_CMD_ATOM	3	/* online help for the current user */
#define  GET_CMD_ATOM	4	/* send value of an atom to user */
#define  SET_CMD_ATOM	5	/* change name or value */
#define  APP_CMD_ATOM	6	/* change name or value */
#define  DEL_CMD_ATOM	7	/* calls atom_delete() */

/* globals that describe our atoms database */
extern int atoms_allocated, atoms_index, atoms_free;
extern struct atom **atoms;

extern int (*atom_lookup_hook) __P((char *path, int len));
extern int (*atom_delete_hook) __P((struct atom *));

#define atom_exists(idx) (((idx) < 0 || (idx) >= atoms_allocated || !atoms[(idx)] || !atoms[(idx)]->a.refcount) ? 0 : 1)

#define atom_set(idx, string, length) \
	atom_append((idx), 0, (string), (length))

#define atom_name(idx) \
	(atom_exists(idx) ? atom_get_name(idx)->buf : "<NONEXISTANT-ATOM>")

/* CAUTION: this macro does not trigger callbacks. Use atom_get instead! */
#define atom_value(idx) \
	(atoms[idx] ? atoms[idx]->value->buf : "")

#define atom_vlen(idx) \
	(atoms[idx] ? atoms[idx]->value->length : 0)

int atom_new __P((int idx, char *name, char *value, int flag));
int atom_new2 __P((int i, char *nam, int nlen, char *val, int vlen, int flag));
int atom_exec __P((int idx, void *data));	/* data currently unused */
int atom_append __P((int, int, char *, int));
#if 0
int atom_appendf __P((/* int, int, char *fmt, ... */)); /* non-existant */
#endif
int atom_update __P((int idx, dstring *new_value));
dstring *atom_get __P((int idx));
dstring *atom_get_name __P((int idx));
int atom_delete __P((int idx));
int atom_lookup_atoms __P((char *name, int len, int idx));
int atom_lookup __P((char *name));
int atom_lookup2 __P((char *name, int len));
int atom_simple_trace __P((int idx, int flag, void *fp));
int atom_init __P((void));
trace **atom_trace_lookup __P((trace **root, int (*fn)__P((int, int, void *)), void *data));
int atom_trace_delete __P((struct trace **));
int atom_trace_set __P((int idx, int flag, int (*fn)__P((int, int, void *)), void *data));
int atom_command __P((int idx, char *name, int (*fn)__P((int, int, void *)), void *data));

int atom_help_fmt __P((dstring **dest, int idx, char *cmd, char *descr));
int atom_help_cmd __P((int idx, int flag, void *helptext));

#endif /* _HAVE_ATOM_H */
