/* 
 * attr.h -- use attributed atoms to define lousy datatypes
 *
 * 16.5.97, jw
 */

enum jittr_attr {
  JA_T_UNDEF	= 0x0000,
  JA_T_UNARY	= 0x0001,
  JA_T_RANGE	= 0x0002,
  JA_T_STATE	= 0x0004,
  JA_T_CONTAINER = 0x0008,
  JA_MIN	= 0x0010,
  JA_MAX	= 0x0020,
  JA_VERTICAL	= 0x0040,
  JA_LOCATION	= 0x0080,
  JA_WIDTH	= 0x0100,
  JA_HEIGHT	= 0x0200,
  JA_W_BUTTON	= 0x0400,
  JA_W_SLIDER	= 0x0800,
  JA_W_BOARD	= 0x1000,
  JA_W_FRAME	= 0x2000,
  JA_W_ROWCOL	= 0x4000
};

#define JA_TYPE		(JA_T_CONTAINER|JA_T_STATE|JA_T_RANGE|JA_T_UNARY)
#define JA_WIDGET	(JA_W_ROWCOL|JA_W_FRAME|JA_W_BOARD|JA_W_SLIDER|JA_W_BUTTON)

extern int jittr_get_attr __P((int atom_index));
extern char *jittr_get_label __P((int atom_index));
extern char **jittr_chop __P((char *menu, int *nitemsp));
