/*
 * jittr.h -- declarations & potatotypes
 *
 * needed by everybody, contains only trivial things.
 * requires "atom.h".
 *
 * Declarations of parse methods moved to parse.h
 * 18.7.96 jw.
 */

#include <stdlib.h>

#ifndef __P
# ifdef __STDC__
#  define __P(a) a
# else
#  define __P(a) ()
# endif
#endif

#ifndef __STDC__
# ifndef const
#  define const
# endif
#endif

#if defined(sun) && defined(__STDC__)
# include "jittr/sun_stdlib.h"	/* stdlib.h @ SunOS4 is too short */
#endif

/*
 * this may be OS depandant:
 */
#ifndef NO_LONGJMP
# define HAVE_LONGJMP
#endif

#ifdef HAVE_LONGJMP
#include <setjmp.h>		/* hold your hat! moving stack frames below! */
#endif
/* used by our IOErrror handler, in an attempt to save our live */
#ifdef HAVE_LONGJMP
extern jmp_buf jittr_resurrect;	/* error handler can use this */
#endif


#define JITTR_PORT 7447		/* on every host involved with jittr, this
				 * port listens to jittr commands.  */

/* 
 * The name of the port is machine dependant, but default speed and other
 * parameters are device dependant.
 */
#ifdef linux
# define JITTR_DEFAULT_TTY "/dev/ttyS0"	/* relax, just defaults */
#else
# ifdef __sgi
#   define JITTR_DEFAULT_TTY "/dev/ttyf1"
# else
#  ifdef __hpux
#   define JITTR_DEFAULT_TTY "/dev/tty00" /* tty0p0 for hpux10 */
#  else
#   ifdef __SVR4
#    define JITTR_DEFAULT_TTY "/dev/term/a"
#   else
#    define JITTR_DEFAULT_TTY "/dev/ttya"
#   endif
#  endif
# endif
#endif

/*
 * Atoms of the jittr core commands have fixed numbers.
 * Programmed commands (as used with export) shall only use the numbers defined
 * here or in atom.h all other commands should be called by name or queried for
 * their number. You may read this table and append to it. Nothing else!
 */
/* jittr_jcmd_init() */
#define      EVAL_CMD_ATOM	 8	/* atom.h:DEL_CMD is 7 */
#define     TRACE_CMD_ATOM	 9
#define      TELL_CMD_ATOM	10
#define    RENAME_CMD_ATOM	11	/* inserted in 1.1 */
#define     CHMOD_CMD_ATOM	12	/* inserted in 1.1 */
/* jittr_link_init() */
#define     MKNOD_CMD_ATOM	13
#define      LINK_CMD_ATOM	14
#define    UNLINK_CMD_ATOM	15
/* jittr_jmod_init() */
#define   MODLOAD_CMD_ATOM	16
#define MODUNLOAD_CMD_ATOM	17
#define    MODDUP_CMD_ATOM	18
#define   MODSTAT_CMD_ATOM	19
#define    EXPORT_CMD_ATOM	20
/* jittr_session_init() */
#define        ID_CMD_ATOM	21
#define    PROMPT_CMD_ATOM	22
#define   NETMASK_CMD_ATOM	23
#define      DATE_CMD_ATOM	24

struct client;			/* shall come from net.h */
struct timeval;			/* allow correct declarations below */

struct cwp
{
  int atom;			/* clients current working point */
  				/* how about remote working points? */
};


/* additional data that the jittr world needs to store with each atom. */
struct atom_data
{
  struct Tcl_HashTable *h;	/* the atom's directory table */
  struct client *who;		/* who is responsible for our contents */
  unsigned long sec;		/* when our contents was last updated. */
  unsigned long usec;
};

enum ds_location_hint { DSHINT_ANY, DSHINT_CLIENT, DSHINT_ATOM, DSHINT_EXEC};

#if JITTR_PTR2DS_IS_MORE_HELPFUL
struct ds_location
{
  enum ds_location_hint type;		/* in what struct it was found */

  int name;			/* it is an atom or client name */
  int atom_index;		/* the atom that rang the bell, or negative */
  int atom_data;		/* boolean, if true, then see below: */
  
  struct client *client;	/* the client that rang the bell */
  /* struct conn, exec_context, etc... */
};
#endif

/* 
 * This structure does not really belong here. but it does not cause
 * harm, as we also provide a dummy declaration of struct client above
 */
struct exec_context
{
  /* what must be the first element of struct exec_context */
  struct dstring *what;		/* command line from jittr_interpret */
  struct client  *who;		/* initiator of command */
  struct cwp      where;	/* his cwp when command was issued */
  struct timeval *when;		/* the actions timestamp */
  int             which;	/* atom that we execute */
};

/* global pointers, sigh! */
extern struct exec_context *exec_context;
extern int (* jittr_gettimeval) __P((struct timeval *now));

/* 
 * we do not declare the first argument as 'struct client *cl' here.
 * It would be too expensive, to include all network header files, wherever
 * jittr.h is included.
 */
extern int jittr_interpret __P((dstring **bufp, struct client *cl, struct cwp *cwp));
extern int jittr_program_export __P((char *client_name, char *s, int slen, char *t, int tlen, int idx));
extern int jittr_change_name __P((int atom_idx, char *basename_av0));
extern int jittr_init __P((char *basename_av0, int preferred_inet_port));
extern int jittr_init1 __P((char *basename_av0));
extern int jittr_init2 __P((int preferred_inet_port));
extern int jittr_loop __P((void));

/* from link.c */
/*
 * When traversing atom hierarchies, read directories like this:
 *   ptr = jittr_opendir(idx, 0);
 *   while ((dp = jittr_readdir(ptr, &name)))
 *     if (*dp)
 *       printf("%s --> %s\n", name, (*dp)->buf);
 *   jittr_closedir(ptr);
 */
extern void *           jittr_opendir  __P((int idx, int flags));
extern struct dstring **jittr_readdir  __P((void *ptr, char **namep));
extern int              jittr_closedir __P((void *ptr));

/*
 * Use these on the data pointer of the dstring that jittr_readdir() returned:
 */
#define JLINK_UNRESOLVED   -1		/* will become an atom later */
#define JLINK_UNRESOLVABLE -2		/* a direct value link */

#define JLINK_IS_RESOLVED(d)     ((int)(d) >= 0)
#define JLINK_IS_UNRESOLVED(d)   ((int)(d) == JLINK_UNRESOLVED)
#define JLINK_IS_UNRESOLVABLE(d) ((int)(d) == JLINK_UNRESOLVABLE)

#define JDIR_SAVE	0x01		/* prevent recursions in opendir() */
#define JDIR_AUTO	0x02		/* try to resolve in readdir() */

#define JDIR_SORT_MASK	0x0c
#define JDIR_SORT_LINK	0x04		/* alphabetical by name */
#define JDIR_SORT_IDX	0x08		/* low number atoms first */

extern int jittr_link_init __P((void));

/*
 * jittr_link() links or unlinks jittr atoms.
 * idx is the atom index of jittr_link()'s working point.
 * path is the sequence of link components under which the destination shall
 * appear at the working point.
 * If dest is NULL, jittr_link() removes the entry link_name. 
 * Otherwise dest gives the name of the links destination.
 *
 * If dlen is negative, the destination points outside the jittr_world and
 * shall not be converted to an atom pointer. It is maked JLINK_UNRESOLVABLE.  
 * If dlen is 0, dest is a NULL-terminated name, otherwise it is a len bytes
 * long name of an atom, where this link points to. The link is marked
 * JLINK_RESOLVABLE, and will be resolved into an atom index during the first
 * lookup or jittr_link_resolve() operation.
 *
 * jittr_link returns 0, unless it is a link/unlink operation that fails.
 * E.g. A non atom link cannot be created, if its complete path is also the
 * name of an existing atom.  In that case it returns with jittr_error. 
 *
 * It does an unlink operation, when dest is NULL.
 * it does an atom link operation, when raw is zero.
 * it does a value link operation, when raw is nonzero.
 * jittr_link resolves complicated paths by using jittr_mkpath. Then it
 * prepares the path until the final component with jittr_do_mknod while
 * duplicating * the permission flags of idx. Finally it calls jittr_do_link()
 * to place the link, which will be either UNRESOLVED or UNRESOLVABLE.
 */
extern int jittr_link __P((int idx, char *path, int plen, char *dest, int dlen, int raw));

/* same as above, but for simple links */
extern int jittr_do_link __P((int idx, char *link_name, int nlen, char *pointer, int len, int raw));

/*
 * Follow a link. Returns the atoms value, or the link value, depending on
 * type.  Returns NULL, depending on errors. Nonnegative atom_index or negative
 * link type is written to *idx_ret, if idx_ret is nonzero.
 * Links to atoms must currently refer to them with absolute path. this is a
 * restriction of jittr_lookup_link(), that has effect here.
 */
extern char *jittr_link_resolve __P((int idx, char *link_component, int len, int *idx_ret, int *len_ret));

/*
 * similar to atom_value(atom_lookup()), but knows how to handle links. If name
 * refers to an atom, its value is returned and its index is written to *idxp.
 * If one of the path components in name cannot be resolved, jittr_link_value()
 * returnes NULL and *idxp is set to JLINK_UNRESOLVED. If everything was
 * resolved fine, but the final component points to a link rather than an atom,
 * jittr_link_value() returns its value and writes JLINK_UNRESOLVABLE to *idxp.
 * *parent_idxp is set to the index of the parent atom.
 */
extern char *jittr_link_value __P((char *name, int nlen, int *idxp, int *lenp, int *parent_idxp));

/* 
 * jittr_mkpath() constructs an absolute path from a current working point and 
 * a relative path. It implements these naming conventions for atoms in the
 * jittr world:
 *
 *   1) A '/' character denotes a level of name hierarchy. Thus a link_name
 *      must not contain this character, if it shall be possible to do a
 *      lookup through that link.
 *   2) The fullname of an atom is the fullname of initial parent, followed
 *      by a '/' character, followed by its link name.
 *   3) The root of this atom hierarchy is atom 0. Its direct children are 
 *      called toplevel atoms. For the purpose of 2), its name is the empty
 *      string. That means, that the fullname of a toplevel atom is simply a
 *      '/' character followed by its link_name.
 *   4) The component "." references the current working point.
 *   5) The component ".." cancels the previous path component. This is
 *      different than unix, because it does not check existence of the
 *      canceled component.
 *   6) A path starting with the '/' character denotes anabsolute path,
 *      while all other paths are interpreted relative to the current
 *      working point.
 *
 * idx is the current working point, path is whatever the user typed,
 * the absolute path leading to the desired atom is constructed in
 * *buf, enough memory shall be provided by the caller.
 * The length of the constructed path is returned. The string is 
 * '\0'-terminated.
 */
extern int jittr_mkpath __P((int idx, char *path, char *buf));

/*
 * jittr_mknod() create a named atom that is linked into a working point.
 * idx is the parent, path is the addiotinal components, flags is the fourth
 * parameter for atom_new(). The atom index of the newly created atom is
 * returned. If a link of that name already exists, it is replaced.  If an atom
 * of the resulting fullname already exists, it is used. (flags are ORed
 * into the atom then.)
 * 
 * The resulting link is not necesarily created in atom idx. It is created,
 * wherever path composition ends up. 
 * jittr_mknod() is similar to jittr_link() with the following exceptions:
 * 1) jittr_mknod can only create links to atoms. Jittr_link can create 
 *    non-atom links and can delete links.
 * 2) jittr_mknod creates the atom it links in the hierarchy using a 
 *    canonical fullname, while links made with jittr_link may point anywhere.
 * 3) jittr_mknod never fails.
 */
extern int jittr_mknod __P((int idx, char *path, int flags));

/* from jcmd.c */
extern int jittr_atom_set __P((int idx, int append, char *s, int len, struct timeval *tv, struct client *who, int noisy));
extern int jittr_atom_tickle __P((int idx));
extern int jittr_jcmd_init __P((void));

/* from jmod.c */
struct mbuiltin;	/* forward declaration */
extern int jittr_jmod_init __P((void));
extern int jittr_mbuiltin_init __P((void));
extern int jittr_init_builtin __P((struct mbuiltin *b));   /* for jxcmd.c */
extern int jittr_program_export_dstring __P((struct dstring **d, char *s, int slen, char *t, int tlen, int cmd_atom));
extern int jittr_check_numeric __P((int idx, int *nump, double *doubp));
extern int jittr_mount __P((int atom, char **hierarchy_description, void *arr));
extern int jittr_umount __P((int atom));
extern int jittr_store_argv __P((char *av0, int *acp, char ***avp));
extern int jittr_shift_argv __P((int where));
extern int jittr_argc;
extern char **jittr_argv;

/* from gettime.c */
extern int gettimeval __P((struct timeval *tv));

/* from jxcmd.c */
extern int jittr_jxcmd_init __P((void));

/* from session.c */
extern int jittr_session_init __P((void));

/* from user.c */
extern int jittr_user_init __P((void));

/* from misc.c */
extern int jittr_telnet_check __P((char *pp, int len));
extern int jittr_purge_telnet __P((char *pp, int len));
extern struct client *jittr_init_tty __P((int idx, char *port, char *opts));
extern int jittr_remake_client __P((struct client *));
extern struct dstring **jittr_ptr2ds __P((char *p, enum ds_location_hint h, void *hdata));

/*
 * jittr_getcwd() reads the current working point from the exec_context of the
 * current client. This is valuable, because it saves us knowledge of client
 * datastructures, where we do not care about network issues.
 * jittr_getcwd returns -1, if there is no exec_context.
 */
extern int jittr_getcwd __P((void));

extern struct atom_data *jittr_atom_data __P((int idx));

extern int jittr_error __P((/* lousy varargs: fmt, a1, a2, a3, a4 */));
extern int jittr_hex_error __P((char *buf, int len, char *prefix));
extern int jittr_hexdump __P((dstring **dst, char *buf, int len, char *prefix));
extern int jittr_nuke_client __P((struct client *cl, struct client *parent));
extern int jittr_setuid __P((char *uid, char *gid));
