/*
 * jqueue.h -- Data structures and prototypes for jittr queueing.
 *
 * 23.5.97, 20.5.98, jw
 */

typedef struct jittr_queue
{
  dstring *name;
  int alloced;
  int next;		/* next free entry in queue */
  struct dstring **q;
  int (*cmp_fn) __P((struct jittr_queue *q, dstring *new, dstring *old, void *data));
  void *cmp_fn_data;
  int (*send_fn) __P((struct jittr_queue *q, dstring *head, void *data));
  void *send_fn_data;
  struct client *cl;	/* the client that is fed by this queue */
  struct dstring **obufp;
  struct dstring *wait;
  int wait_sched_id;	/* the scheduler ID of a delayed send_fn command */
  int flags;
} jittr_queue;

#define JQUEUE_FLAG_DS_DATA_ALLOC   0x01
#define JQUEUE_FLAG_SEND_DATA_ALLOC 0x02
#define JQUEUE_FLAG_CMP_DATA_ALLOC  0x04

struct jittr_queue * jittr_queue_init __P((char *name, struct client *cl, dstring **obufp));
int jittr_queue_free __P((jittr_queue **qq));
int jittr_queue_add_ds __P((jittr_queue *q, dstring **dp));
int jittr_queue_add __P((jittr_queue *q, char *buf, int len, void *data));
int jittr_queue_try __P((jittr_queue *q));

