/*
 * modload.h -- declaration for portable module loading.
 *
 * Copyright (c) 1996
 *      Juergen Weigert (jnweiger@informatik.uni-erlangen.de)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file COPYING); if not, write to the
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 ****************************************************************
 *
 *
 * 28.3.96 jw
 */
#include "jittr/modmake.h"

#ifdef GNU_DLD
# include <dld.h>
# define jmod_shl_t void *
#else
# if defined(sun) || defined(linux) || defined(sgi)
#  include <dlfcn.h>	/* for dlopen() */
#  define jmod_shl_t void *
# endif
# ifdef hpux
#  include <dl.h>	/* for shl_load() */
#  define jmod_shl_t shl_t
# endif
#endif

extern char *jmod_av0_for_dld;	/* you must initialize this on startup */

#ifndef __P
# ifdef __STDC__
#  define __P(a) a
# else
#  define __P(a)
# endif
#endif

/*
 * returns 0, if object at path loaded. *handlep contains a handle then.
 * returns nonzero otherwise, *errp contains a complaint then.
 */
int jmod_dlopen __P((char *path, jmod_shl_t *handlep, struct dstring **errp));

/*
 * returns 0, if the named symbol was found in the object h. symp contains 
 * the value of the symbol then. If needexec is nonzero, we try to avoid
 * non-executable symbols here.
 * returns nonzero otherwise, *errp contains a complaint then.
 */
int jmod_dlsym  __P((char *name, int needexec, jmod_shl_t *h, void **symp, struct dstring **errp)); 

/*
 * Close a module, removing it from address space completely.
 * Should return 0.
 */
int jmod_dlclose __P((jmod_shl_t handle, struct dstring **errp));

