/*
 * parse.h -- declarations of jittr independant and dependant 
 * parser methods. Requires only dstring.h. Split from jittr.h
 *
 * 18.7.96 jw.
 */

extern char *parse_word __P((dstring **dst, char **base_ptr, int *blen, int *ret_len, char *sep));
extern int parse_hexval __P((int byte));
extern int parse_check __P((char *buf, int len, char *delim));
extern int parse_needsq __P((char *buf, int len));

/*
 * jarg_reset marks all memory used in parser buffers o.k. for reuse.
 * It also makes the jarg_raw pointer NULL.
 */
extern int   jarg_reset      __P((void));

/*
 * jarg_name() returns a pointer into into the argv vector.   The string there
 * gives the name under which the atom was executed. It is null terminated and
 * read-only!
 */
extern char  *jarg_name       __P((void));

/*
 * jarg_first_word() and jarg_next_word() parse one element of the argument 
 * vector and return a pointer to a writable and null-terminated string space.
 * The string space remains valid until the next call to jarg_reset().
 */
extern char  *jarg_first_word __P((int *lenp));
extern char  *jarg_next_word  __P((int *lenp));

/*
 * jarg_rawp() returns the adress of the parsers data pointer.
 * read through the pointer to visit the unparsed argument vector string.
 * It is readonly, but not null-terminated. The remaining number of valid bytes
 * is written to *lenp, if possible. Modify the pointer, if you need to do
 * trickery with the parser.
 * The pair
 *	r = *jarg_rawp(NULL);
 *	...
 *	*jarg_rawp(NULL) = r;
 * is a simple save/restore bracket for the parser context. It is exercised in 
 * trace_cmd, which detects the end of options only after parsing the 
 * command text. So that this final step of parsing needs to be undone.
 *
 * Parsing can be redone after resetting *jarg_rawp(), but memory used for
 * previously parsed words is not reused.
 */
extern char **jarg_rawp __P((int *lenp));
