/*
 * geturl.c
 *
 * damned, jw
 */
#include "openurl.h"
#include <sys/fcntl.h>		/* for O_RDONLY */

struct mbuiltin *mbuiltins = NULL;	/* for jittr/jmod.o */

#ifdef DEBUG
FILE *debugfp = stderr;
char *debugfilename = NULL;
#endif

int main(int ac, char **av)
{
  struct url_info u;
  int fd, c;
  FILE *fp;

  if ((fd = OpenUrl(av[1], &u, O_RDONLY)) < 0)
    {
      perror("OpenUrl");
      fprintf(stderr, "OpenUrl: %s/%d, %s\n", u.proto ? u.proto->buf : "<>",
      	u.port, u.host ? u.host->buf : "<>");
      fprintf(stderr, "OpenUrl: size=%d, date=%s\n", u.len, 
      	u.modified ? u.modified->buf : "<>");
      if (u.path)
        fprintf(stderr, "OpenUrl: %d, %s\n", fd, u.path->buf);
      exit(1);
    }

  fprintf(stderr, "%s, length=%d, mtime='%s', %s\n",
  	u.mime->buf, u.len, u.modified ? u.modified->buf : "<>", u.server ? u.server->buf : "");

  if (!(fp = fdopen(fd, "r")))
    perror("fdopen"),exit(2);
  
  while ((c = getc(fp)) != EOF) 
    putchar(c);
  
  FreeUrlInfo(&u);
  fclose(fp);
  return 0;
}
