/*
 * openurl_file.c -- local file open for openurl
 *
 * 24.1.98, jw
 */

#include <sys/types.h>          /* for sys/socket.h */
#include <sys/stat.h>		/* struct stat */
#include <time.h>		/* for ctime() */
#include "openurl.h"

int OpenUrlFile(struct url_info *u)
{
  struct stat st;

  dstring_append(&u->proto, 0, "file", 0);
  dstring_append(&u->host, 0, "localhost", 0);
  if (stat(u->path->buf, &st))
    return -1;
  
  if (S_ISDIR(st.st_mode))
    {
      dstring_append(&u->path, -1, "/index.html", 0);
      if (stat(u->path->buf, &st))
	{
	  dstring_append(&u->path, -2, "", 0);
          if (stat(u->path->buf, &st))
	    {
	      dstring_append(&u->path, -11, "", 0);
	      return -1;
	    }
	}
      dstring_append(&u->mime, 0, MimeTypeBySuffix(u->path->buf), 0);
    }
  u->len = st.st_size;
  dstring_append(&u->modified, 0, ctime(&st.st_mtime), 0);
  dstring_append(&u->modified, -2, "", 0);	/* nuke the \n */
  return open(u->path->buf, u->mode, 0666);
}
