/*
 * openurl_http.c -- http protocol for openurl
 *
 * 24.1.98, jw
 */

#include <errno.h>
#include <unistd.h>		/* read, write */
#include <sys/types.h>		/* for sys/socket.h */
#include <sys/socket.h>		/* for jittr/net.h */
#include <sys/time.h>		/* for jittr/net.h */
#include <jittr/atom.h>		/* for jittr/jittr.h */
#include <jittr/jittr.h>	/* for jittr/net.h */
#include <jittr/net.h>		/* TcpPortConnect() */
#include "openurl.h"

int OpenUrlHttp(struct url_info *u)
{
  static int inside_OpenUrlHttp = 0; 
  int fd, r;
  char *p, *s;
  dstring *d = NULL;
  dstring **v;
  int colon = 0;		/* 0 = begin of line seen, 1 = colon seen */
  int n;

  dstring_append(&u->proto, 0, "http", 0);
  if ((fd = TcpPortConnect(u->host->buf, u->port, u->timeout, NULL)) <= 0)
    return -1;		/* connect to http server failed */
  write(fd, "GET ", 4);
  write(fd, u->path->buf, u->path->length);
  write(fd, " HTTP/1.0\r\n\r\n", 13);

  dstring_append(&d, 0, NULL, 255);
  while ((r = read(fd, p = d->buf+d->length, 1)) > 0)
    {
      d->length++;
      if (*p == ':')
        colon = 1;
      if (*p == '\n' || *p == '\r')
        {
	  colon = 0;
          if ((d->length >= 2) && (!strncmp("\n\n", p-1, 2)))
	    break;
          if ((d->length >= 4) && (!strncmp("\n\r\n\r", p-3, 4)))
	    break;
          if ((d->length >= 4) && (!strncmp("\r\n\r\n", p-3, 4)))
	    break;
	}
      else if (!colon)
        *p = tolower(*p);

      dstring_append(&d, -1, NULL, 1);
    }
  
  for (n = 0, p = d->buf; *p; p++)
    if (*p == '\r' || *p == '\n')
      n++;

  if (!(v = (dstring **)calloc(sizeof(dstring *), n)))
    {
      close(fd);
      free((char *)d);
      return -1000;	/* not enough mem */
    }
  
  for (n = 0, s = p = d->buf; *p; p++)
    {
      if (*p == '\r' || *p == '\r')
        {
	  dstring_append(&v[n++], 0, s, p-s);
	  if (p[0] != p[1] && (p[1] == '\r' || p[1] == '\n')) 
	    p++;
	  s = ++p;
	}
    }

  for (n = 0; v[n]; n++)
    {
      s = p = v[n]->buf;
#define EIF(p, w, l) else if (!strncmp((p), (w), (l)))
      if (!strncmp(p, "http/", 5))
        {
	  while (*p && *p != ' ' && *p != '\t')
	    p++;
	  dstring_append(&u->proto, 0, s, p-s);
	  if (atoi(p) != 200)
	    {
	      dstring_append(&u->path, 0, p, 0);
	      close(fd);
	      fd = -atoi(p);
	    }
	}
      EIF(p, "content-length: ", 16)	u->len = atoi(p + 16);
      EIF(p, "last-modified: ", 15)	dstring_append(&u->modified,0,p+15, 0);
      EIF(p, "accept-ranges: ", 15)	;
      EIF(p, "content-type: ", 14)	dstring_append(&u->mime, 0, p+14, 0);
      EIF(p, "connection: ", 12)	;
      EIF(p, "location: ", 10)		dstring_append(&u->redirect,0,p+10, 0);
      EIF(p, "server: ", 8)		dstring_append(&u->server, 0, p+8, 0);
      EIF(p, "date: ", 6)		dstring_append(&u->date, 0, p+6, 0);
      EIF(p, "etag: ", 6)		;
#undef EIF
    }

  for (n = 0; v[n]; n++)
    free((char *)v[n]);
  free((char *)v);

  if ((fd == -301 || fd == -302) && u->redirect && (inside_OpenUrlHttp < 100))
    {
      /* moved temporarily / moved permanently */
      dstring_append(&d, 0, u->redirect->buf, u->redirect->length);
      inside_OpenUrlHttp++; 
      fd = OpenUrl(d->buf, u, u->mode);	/* start all over again */
      inside_OpenUrlHttp--;
    }

  free((char *)d);
  return fd;
}

