/*
 * modmake.c -- how to build modules and how to use them
 *
 * Copyright (c) 1996
 *      Juergen Weigert (jnweiger@informatik.uni-erlangen.de)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file COPYING); if not, write to the
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 ****************************************************************
 *
 *
 * 29.3.96, jw.
 * -v added, for stdout and stderr output.
 * -template added.
 * 7.6.96, jw.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
#include <stdio.h>	/* for detecting SOLARIS */
#include <string.h>	/* strcasecmp()@solaris */
#include <stdlib.h>	/* getenv() */
#include <unistd.h>	/* access' X_OK */
#include "modmake.h"	/* jmod_make(), CAN_MAKE_MODULE, HAVE_TEMPLATE */
#include "version.h"	/* VERSION */

#if defined(sun) && defined(FILE) && defined(__STDC__)
# include "sun_stdlib.h"
#endif

#if defined(sun) && !defined(FILE) && !defined(SOLARIS)
# define SOLARIS
#endif


struct modmake
{
  char *tag;	/* "", "gcc", "gdld", "gcc-gdld" */
  char *cc, *cflags, *ld, *ldflags, *libs;
};

static struct modmake modmake_main[] =
{
#ifdef sun
#  ifdef SOLARIS
 {"",       "/opt/SUNWspro/bin/cc", "", "/opt/SUNWspro/bin/cc", "", "-ldl"},
 {"gcc",    "gcc",                  "", "gcc",                  "", "-ldl"},
#  else
 {"",       "/usr/bin/cc",          "", "/usr/bin/cc",          "", ""},
 {"gcc",    "gcc",                  "", "gcc",                  "", ""},
#  endif
#endif /* sun */
#ifdef linux
 {"",       "gcc",         "-rdynamic", "gcc",         "-rdynamic", "-ldl"},
 {"gcc",    "gcc",         "-rdynamic", "gcc",         "-rdynamic", "-ldl"},
#endif /* linux */
#ifdef sgi
 {"",       "/usr/bin/cc",          "", "/usr/bin/cc",          "", ""},
 {"gcc",    "gcc",                  "", "gcc",                  "", ""},
#endif /* sgi */
#ifdef hpux
 {"",       "/usr/bin/cc",          "", "/usr/bin/cc",          "", "-ldld"},
 {"gcc",    "gcc",                  "", "gcc",                  "", "-ldld"},
#endif /* hpux */
/* no need to add -R to LDFLAGS (for SunOS), as we must link gnu-dld static */
 {"gdld",    "cc", "-DGNU_DLD -I%s", "cc", "-Bstatic","-L%s -ldld"},
 {"gcc-gdld","gcc","-DGNU_DLD -I%s", "gcc","-static", "-L%s -ldld"},
 {NULL,      NULL,                NULL, NULL,                 NULL, NULL }
};

static struct modmake modmake_mod[] =
{
#ifdef sun
#  ifdef SOLARIS
 {"",        "/opt/SUNWspro/bin/cc","-Kpic", "/opt/SUNWspro/bin/cc",  "-G", ""},
 {"gcc",     "gcc",         "-shared -fpic", "/usr/ccs/bin/ld",       "-G", ""},
#  else
 {"",        "/usr/bin/cc",          "-pic", "/bin/ld","-assert pure-text", ""},
 {"gcc",     "gcc",         "-shared -fpic", "/bin/ld","-assert pure-text", ""},
#  endif
#endif /* sun */
#ifdef linux
 {"",        "cc",          "-shared -fpic", "ld",               "-shared", ""},
 {"gcc",     "gcc",         "-shared -fpic", "ld",               "-shared", ""},
#endif /* linux */
#ifdef sgi
 {"",        "/usr/bin/cc",              "", "/usr/bin/ld",      "-shared", ""},
 {"gcc",     "gcc",         "-shared -fpic", "/usr/bin/ld",      "-shared", ""},
#endif /* sgi */
#ifdef hpux
 {"",        "/usr/bin/cc",            "+z", "/usr/bin/ld",           "-b", ""},
 {"gcc",     "gcc",         "-shared -fpic", "/usr/bin/ld",           "-b", ""},
#endif /* hpux */
 {"gdld",    "cc", "", "sh -c 'while [ \"$2\" != \"-o\" ]; do shift; done; cp $1 $3' --", "", ""},
 {"gcc-gdld","gcc","", "sh -c 'while [ \"$2\" != \"-o\" ]; do shift; done; cp $1 $3' --", "", ""},
 {NULL,       NULL,                    NULL, NULL,                   NULL,NULL}
};

#ifdef HAVE_TEMPLATE
/* a shrink wrapped module that exercises the jittr world: */
# include "jmodtemplate.h"	
#endif

static void
check_executable(buf, env1, env2, def, arg)
char *buf, *env1, *env2, *def, *arg;
{
  char *s, *e;
  int c, r = -1;

  for (s = buf; *s == ' ' || *s == '\t'; s++)
    ;
  e = s;
  while (*e && *e != ' ' && *e != '\t' && *e != ';' && *e != '\n' && *e != '\r')
    e++;
  c = *e;
  *e = '\0';


  if (*s != '/')
    {
      char pth[2048];
      char *p, *ps, *pe; 

      if (!(p = getenv("PATH"))) 
        p = "/bin:/usr/bin:";
      p = strdup(p);

      for (ps = pe = p; *pe; pe++)
	{
	  if (*pe == ':')
	    {
	      *pe = '\0';
	      sprintf(pth, "%s/%s", *ps ? ps : ".", s);
	      if (!(r = access(pth, X_OK)))
	        break;
	      ps = pe + 1;
	    }
	}
      sprintf(pth, "%s/%s", *ps ? ps : ".", s);
      r = access(pth, X_OK);
      free (p);
    }
  else
    r = access(s, X_OK);

  *e = c;

  if (r)       e = getenv(env1);
  if (r && !e) e = getenv(env2);
  if (r && !e) e = def;
  if (r &&  e) sprintf(buf, e, arg);
}

/*
 * This suggests a compiler command line or a linker command line, to create a
 * loadable module. The input file has the suffix ".c" assumed, the output
 * file has the suffix ".so" assumed.
 * Returns NULL, if clueless.
 *
 * Example Usage:
 *   access(".", W_OK);
 *   access("mymod.c", R_OK); 
 *   sprintf(cc_cmd, "%s %s -c mymod.c", jmod_make("", 0), jmod_make("", 1));
 *   system(cc_cmd);
 *   sprintf(ld_cmd, "%s %s mymod.o -o mymod.so %s", jmod_make("", 2), 
 *          jmod_make("", 3), jmod_make("", 4));
 *   system(ld_cmd);
 *   jmod_dlopen("mymod.so", &h, NULL);
 *
 * items 0,1,2,3,4	are mapped to module's cc, cflags, ld, ldflags, libs
 * items 5,6,7,8,9	are mapped to main's   cc, cflags, ld, ldflags, libs
 */
char *
jmod_make(tag, item)
char *tag;
int item;
{
#ifdef CAN_MAKE_MODULE
  static char buf[1024];
  struct modmake *m = modmake_mod;
  char *e[5];

  e[0] = e[2] = e[3] = "XXX";
  if (!(e[1] = getenv("GDLDINC"))) e[1] = ".";
  if (!(e[4] = getenv("GDLDLIB"))) e[4] = e[1];

  if (item > 4)
    {
      m = modmake_main;
      item -= 5;
    }

  while (m->tag)    
    {
      if (!strcmp(m->tag, tag))
        break;
      m++;
    }
  if (!m->tag)
    return NULL;
  switch (item)
    {
    case 0:  sprintf(buf, m->cc,      e[item]);
    	     check_executable(buf, "CC", "CC", "cc", e[item]);
             break;
    case 1:  sprintf(buf, m->cflags,  e[item]); break;
    case 2:  sprintf(buf, m->ld,      e[item]);
    	     check_executable(buf, "LD", "CC", "cc", e[item]);
             break;
    case 3:  sprintf(buf, m->ldflags, e[item]); break;
    default: sprintf(buf, m->libs,    e[item]); break;
    }
  return buf;
#else
  return "; echo sorry, jmod_make() cannot help you on this architecture. ";
#endif
}

#ifdef STANDALONE
int
main(ac, av)
int ac;
char **av;
{
  int item, printed = 0, base = 0;
  char buf[20], *p, *s;
  int verbose = 0;
  extern int isatty();
  
  sprintf(buf, "gcc-"); s = p = buf + 4;

  if (ac > 1 && !strcasecmp(av[1], "-h"))
    {
      fprintf(stderr, "Usage:\n   %s [-v] [-main] [-gcc] [-gdld] [%%CC|%%CFLAGS|%%LD|%%LDFLAGS|%%LIBS] ... \n", av[0]);
      fprintf(stderr, "   %s -test > modtest.c\n", av[0]);
#ifdef HAVE_TEMPLATE
      fprintf(stderr, "   %s -template > jmodtmpl.c\n", av[0]);
#endif
      return 1;
    }

  while (ac > 1 && *av[1] == '-')
    {
      if (!strcasecmp(av[1], "-v"))               { verbose = 1; }
      if (!strcasecmp(av[1], "-main"))               { base = 5; }
      if (!strcasecmp(av[1], "-gcc"))                 { s = buf; }
      if (!strcasecmp(av[1], "-gnu-dld"))  { sprintf(p, "gdld"); }
      if (!strcasecmp(av[1], "-GNU_DLD"))  { sprintf(p, "gdld"); }
      if (!strcasecmp(av[1], "-gdld"))     { sprintf(p, "gdld"); }
      if (ac > 2 && !strcasecmp(av[1], "-tag")) 
	{ sprintf(p, "%s", av[2]); av++; ac--;}
      if (!strcasecmp(av[1], "-test"))
	{
	  puts("/*");
	  puts(" * modtest.c -- the simplest possible loadable module.\n *");
	  printf(" * Generateted by %s -test \t(c) Jrgen Weigert)\n", av[0]);
	  puts(" * 30.3.96 jw.\n */\n#include <stdio.h>");
	  puts("int\nmodmain(n)\nint n;\n{");
	  puts("  fprintf(stderr, \"modmain(%d) called\\n\", n);");
	  puts("  return n * n;\n}\n");
	  return 0;
	}
#ifdef HAVE_TEMPLATE
      if (!strcasecmp(av[1], "-template"))
	{
	  unsigned char *p = jmodtemplate_c;

	  printf("/* Generated for Jittr version %s */\n", VERSION);
	  while (*p)
	    putchar(*p++);
	  return 0;
	}
#endif
      ac--; av++;
    }

  if (s == buf && !*p)
    *(--p) = '\0';

  if (isatty(1) && isatty(2))
    verbose = 0;	/* one terminal is enough. */

  while (ac > 1)
    {
      item = -1; 
      if (!strcasecmp(av[1], "%cc"))           item = 0;
      if (!strcasecmp(av[1], "%cflags"))       item = 1;
      if (!strcasecmp(av[1], "%ld"))           item = 2;
      if (!strcasecmp(av[1], "%ldflags"))      item = 3;
      if (!strcasecmp(av[1], "%libs"))         item = 4;

      if (item < 0)
        {
          printf("%s ", av[1]);
          if (verbose)
	    fprintf(stderr, "%s ", av[1]);
	}
      else
	{
	  p = jmod_make(s, base+item);
	  printf("%s ", p ? p : "");
	  if (verbose)
	    fprintf(stderr, "%s ", p ? p : "");
	}
      printed++;
      av++; ac--;
    }
  if (printed)
    {
      putchar('\n');
      if (verbose)
        putc('\n', stderr);
    }
  return 0;
}
#endif
