#include "bitIn.h"
int GetCombSignHuffCode(Bitstream *bs) {
   unsigned short val = ShowBits(bs, 8);
   switch (val & 0xff80) {
      case 0x80: ConsumeBits(bs, 1); return(8);
   }
   switch (val & 0xffc0) {
      case 0x40: ConsumeBits(bs, 2); return(0);
   }
   switch (val & 0xfff0) {
      case 0x30: ConsumeBits(bs, 4); return(2);
      case 0x20: ConsumeBits(bs, 4); return(4);
      case 0x10: ConsumeBits(bs, 4); return(6);
   }
   switch (val & 0xfff8) {
      case 0x8: ConsumeBits(bs, 5); return(5);
   }
   switch (val & 0xfffc) {
      case 0x4: ConsumeBits(bs, 6); return(7);
   }
   switch (val & 0xfffe) {
      case 0x2: ConsumeBits(bs, 7); return(1);
   }
   switch (val & 0xffff) {
      case 0x1: ConsumeBits(bs, 8); return(3);
   }
   SyntaxError("GetCombSignHuffCode");
   return(-1);
}
