#include "bitIn.h"
int GetInterCBPYHuffCode(Bitstream *bs) {
   unsigned short val;
   
   val = ShowBits(bs, 14);
   
   switch (val & 0xfc00) {
      case 0x3c00: ConsumeBits(bs, 4); return(0);
      case 0x3800: ConsumeBits(bs, 4); return(1);
      case 0x3400: ConsumeBits(bs, 4); return(3);
      case 0x3000: ConsumeBits(bs, 4); return(7);
      case 0x2c00: ConsumeBits(bs, 4); return(15);
      case 0x2800: ConsumeBits(bs, 4); return(31);
      case 0x2400: ConsumeBits(bs, 4); return(63);
      case 0x2000: ConsumeBits(bs, 4); return(127);
   }
   switch (val & 0xfe00) {
      case 0x1e00: ConsumeBits(bs, 5); return(4);
      case 0x1c00: ConsumeBits(bs, 5); return(159);
   }
   switch (val & 0xff00) {
      case 0x1b00: ConsumeBits(bs, 6); return(2);
      case 0x1a00: ConsumeBits(bs, 6); return(9);
      case 0x1900: ConsumeBits(bs, 6); return(11);
   }
   switch (val & 0xff80) {
      case 0x1880: ConsumeBits(bs, 7); return(6);
      case 0x1800: ConsumeBits(bs, 7); return(14);
      case 0x1780: ConsumeBits(bs, 7); return(17);
      case 0x1700: ConsumeBits(bs, 7); return(23);
      case 0x1680: ConsumeBits(bs, 7); return(47);
      case 0x1600: ConsumeBits(bs, 7); return(71);
      case 0x1580: ConsumeBits(bs, 7); return(79);
      case 0x1500: ConsumeBits(bs, 7); return(143);
      case 0x1480: ConsumeBits(bs, 7); return(191);
      case 0x1400: ConsumeBits(bs, 7); return(254);
   }
   switch (val & 0xffc0) {
      case 0x13c0: ConsumeBits(bs, 8); return(5);
      case 0x1380: ConsumeBits(bs, 8); return(8);
      case 0x1340: ConsumeBits(bs, 8); return(10);
      case 0x1300: ConsumeBits(bs, 8); return(12);
      case 0x12c0: ConsumeBits(bs, 8); return(13);
      case 0x1280: ConsumeBits(bs, 8); return(16);
      case 0x1240: ConsumeBits(bs, 8); return(18);
      case 0x1200: ConsumeBits(bs, 8); return(25);
      case 0x11c0: ConsumeBits(bs, 8); return(30);
      case 0x1180: ConsumeBits(bs, 8); return(32);
      case 0x1140: ConsumeBits(bs, 8); return(33);
      case 0x1100: ConsumeBits(bs, 8); return(35);
      case 0x10c0: ConsumeBits(bs, 8); return(49);
      case 0x1080: ConsumeBits(bs, 8); return(65);
      case 0x1040: ConsumeBits(bs, 8); return(67);
      case 0x1000: ConsumeBits(bs, 8); return(75);
      case 0xfc0: ConsumeBits(bs, 8); return(89);
      case 0xf80: ConsumeBits(bs, 8); return(94);
      case 0xf40: ConsumeBits(bs, 8); return(95);
      case 0xf00: ConsumeBits(bs, 8); return(111);
      case 0xec0: ConsumeBits(bs, 8); return(128);
      case 0xe80: ConsumeBits(bs, 8); return(131);
      case 0xe40: ConsumeBits(bs, 8); return(132);
      case 0xe00: ConsumeBits(bs, 8); return(135);
      case 0xdc0: ConsumeBits(bs, 8); return(175);
      case 0xd80: ConsumeBits(bs, 8); return(199);
      case 0xd40: ConsumeBits(bs, 8); return(207);
      case 0xd00: ConsumeBits(bs, 8); return(223);
      case 0xcc0: ConsumeBits(bs, 8); return(239);
      case 0xc80: ConsumeBits(bs, 8); return(249);
   }
   switch (val & 0xffe0) {
      case 0xc60: ConsumeBits(bs, 9); return(19);
      case 0xc40: ConsumeBits(bs, 9); return(20);
      case 0xc20: ConsumeBits(bs, 9); return(36);
      case 0xc00: ConsumeBits(bs, 9); return(39);
      case 0xbe0: ConsumeBits(bs, 9); return(50);
      case 0xbc0: ConsumeBits(bs, 9); return(54);
      case 0xba0: ConsumeBits(bs, 9); return(64);
      case 0xb80: ConsumeBits(bs, 9); return(72);
      case 0xb60: ConsumeBits(bs, 9); return(73);
      case 0xb40: ConsumeBits(bs, 9); return(76);
      case 0xb20: ConsumeBits(bs, 9); return(77);
      case 0xb00: ConsumeBits(bs, 9); return(78);
      case 0xae0: ConsumeBits(bs, 9); return(80);
      case 0xac0: ConsumeBits(bs, 9); return(81);
      case 0xaa0: ConsumeBits(bs, 9); return(84);
      case 0xa80: ConsumeBits(bs, 9); return(87);
      case 0xa60: ConsumeBits(bs, 9); return(90);
      case 0xa40: ConsumeBits(bs, 9); return(121);
      case 0xa20: ConsumeBits(bs, 9); return(126);
      case 0xa00: ConsumeBits(bs, 9); return(129);
      case 0x9e0: ConsumeBits(bs, 9); return(137);
      case 0x9c0: ConsumeBits(bs, 9); return(139);
      case 0x9a0: ConsumeBits(bs, 9); return(160);
      case 0x980: ConsumeBits(bs, 9); return(161);
      case 0x960: ConsumeBits(bs, 9); return(163);
      case 0x940: ConsumeBits(bs, 9); return(167);
      case 0x920: ConsumeBits(bs, 9); return(169);
      case 0x900: ConsumeBits(bs, 9); return(195);
      case 0x8e0: ConsumeBits(bs, 9); return(203);
      case 0x8c0: ConsumeBits(bs, 9); return(204);
      case 0x8a0: ConsumeBits(bs, 9); return(206);
      case 0x880: ConsumeBits(bs, 9); return(215);
      case 0x860: ConsumeBits(bs, 9); return(221);
      case 0x840: ConsumeBits(bs, 9); return(222);
      case 0x820: ConsumeBits(bs, 9); return(231);
      case 0x800: ConsumeBits(bs, 9); return(236);
      case 0x7e0: ConsumeBits(bs, 9); return(238);
      case 0x7c0: ConsumeBits(bs, 9); return(241);
      case 0x7a0: ConsumeBits(bs, 9); return(243);
      case 0x780: ConsumeBits(bs, 9); return(244);
      case 0x760: ConsumeBits(bs, 9); return(247);
      case 0x740: ConsumeBits(bs, 9); return(250);
      case 0x720: ConsumeBits(bs, 9); return(252);
      case 0x700: ConsumeBits(bs, 9); return(253);
   }
   switch (val & 0xfff0) {
      case 0x6f0: ConsumeBits(bs, 10); return(22);
      case 0x6e0: ConsumeBits(bs, 10); return(24);
      case 0x6d0: ConsumeBits(bs, 10); return(26);
      case 0x6c0: ConsumeBits(bs, 10); return(27);
      case 0x6b0: ConsumeBits(bs, 10); return(28);
      case 0x6a0: ConsumeBits(bs, 10); return(29);
      case 0x690: ConsumeBits(bs, 10); return(34);
      case 0x680: ConsumeBits(bs, 10); return(41);
      case 0x670: ConsumeBits(bs, 10); return(42);
      case 0x660: ConsumeBits(bs, 10); return(46);
      case 0x650: ConsumeBits(bs, 10); return(48);
      case 0x640: ConsumeBits(bs, 10); return(51);
      case 0x630: ConsumeBits(bs, 10); return(52);
      case 0x620: ConsumeBits(bs, 10); return(55);
      case 0x610: ConsumeBits(bs, 10); return(57);
      case 0x600: ConsumeBits(bs, 10); return(58);
      case 0x5f0: ConsumeBits(bs, 10); return(61);
      case 0x5e0: ConsumeBits(bs, 10); return(62);
      case 0x5d0: ConsumeBits(bs, 10); return(68);
      case 0x5c0: ConsumeBits(bs, 10); return(69);
      case 0x5b0: ConsumeBits(bs, 10); return(70);
      case 0x5a0: ConsumeBits(bs, 10); return(74);
      case 0x590: ConsumeBits(bs, 10); return(82);
      case 0x580: ConsumeBits(bs, 10); return(83);
      case 0x570: ConsumeBits(bs, 10); return(86);
      case 0x560: ConsumeBits(bs, 10); return(88);
      case 0x550: ConsumeBits(bs, 10); return(91);
      case 0x540: ConsumeBits(bs, 10); return(92);
      case 0x530: ConsumeBits(bs, 10); return(93);
      case 0x520: ConsumeBits(bs, 10); return(97);
      case 0x510: ConsumeBits(bs, 10); return(99);
      case 0x500: ConsumeBits(bs, 10); return(103);
      case 0x4f0: ConsumeBits(bs, 10); return(107);
      case 0x4e0: ConsumeBits(bs, 10); return(112);
      case 0x4d0: ConsumeBits(bs, 10); return(113);
      case 0x4c0: ConsumeBits(bs, 10); return(114);
      case 0x4b0: ConsumeBits(bs, 10); return(118);
      case 0x4a0: ConsumeBits(bs, 10); return(119);
      case 0x490: ConsumeBits(bs, 10); return(122);
      case 0x480: ConsumeBits(bs, 10); return(123);
      case 0x470: ConsumeBits(bs, 10); return(134);
      case 0x460: ConsumeBits(bs, 10); return(138);
      case 0x450: ConsumeBits(bs, 10); return(140);
      case 0x440: ConsumeBits(bs, 10); return(141);
      case 0x430: ConsumeBits(bs, 10); return(142);
      case 0x420: ConsumeBits(bs, 10); return(144);
      case 0x410: ConsumeBits(bs, 10); return(145);
      case 0x400: ConsumeBits(bs, 10); return(147);
      case 0x3f0: ConsumeBits(bs, 10); return(148);
      case 0x3e0: ConsumeBits(bs, 10); return(151);
      case 0x3d0: ConsumeBits(bs, 10); return(164);
      case 0x3c0: ConsumeBits(bs, 10); return(166);
      case 0x3b0: ConsumeBits(bs, 10); return(170);
      case 0x3a0: ConsumeBits(bs, 10); return(171);
      case 0x390: ConsumeBits(bs, 10); return(173);
      case 0x380: ConsumeBits(bs, 10); return(174);
      case 0x370: ConsumeBits(bs, 10); return(176);
      case 0x360: ConsumeBits(bs, 10); return(177);
      case 0x350: ConsumeBits(bs, 10); return(178);
      case 0x340: ConsumeBits(bs, 10); return(179);
      case 0x330: ConsumeBits(bs, 10); return(180);
      case 0x320: ConsumeBits(bs, 10); return(182);
      case 0x310: ConsumeBits(bs, 10); return(183);
      case 0x300: ConsumeBits(bs, 10); return(185);
      case 0x2f0: ConsumeBits(bs, 10); return(186);
      case 0x2e0: ConsumeBits(bs, 10); return(190);
      case 0x2d0: ConsumeBits(bs, 10); return(193);
      case 0x2c0: ConsumeBits(bs, 10); return(196);
      case 0x2b0: ConsumeBits(bs, 10); return(201);
      case 0x2a0: ConsumeBits(bs, 10); return(205);
      case 0x290: ConsumeBits(bs, 10); return(209);
      case 0x280: ConsumeBits(bs, 10); return(217);
      case 0x270: ConsumeBits(bs, 10); return(219);
      case 0x260: ConsumeBits(bs, 10); return(225);
      case 0x250: ConsumeBits(bs, 10); return(227);
      case 0x240: ConsumeBits(bs, 10); return(228);
      case 0x230: ConsumeBits(bs, 10); return(230);
      case 0x220: ConsumeBits(bs, 10); return(233);
      case 0x210: ConsumeBits(bs, 10); return(234);
      case 0x200: ConsumeBits(bs, 10); return(235);
      case 0x1f0: ConsumeBits(bs, 10); return(242);
      case 0x1e0: ConsumeBits(bs, 10); return(246);
      case 0x1d0: ConsumeBits(bs, 10); return(251);
   }
   switch (val & 0xfff8) {
      case 0x1c8: ConsumeBits(bs, 11); return(21);
      case 0x1c0: ConsumeBits(bs, 11); return(37);
      case 0x1b8: ConsumeBits(bs, 11); return(38);
      case 0x1b0: ConsumeBits(bs, 11); return(40);
      case 0x1a8: ConsumeBits(bs, 11); return(43);
      case 0x1a0: ConsumeBits(bs, 11); return(44);
      case 0x198: ConsumeBits(bs, 11); return(45);
      case 0x190: ConsumeBits(bs, 11); return(53);
      case 0x188: ConsumeBits(bs, 11); return(56);
      case 0x180: ConsumeBits(bs, 11); return(59);
      case 0x178: ConsumeBits(bs, 11); return(60);
      case 0x170: ConsumeBits(bs, 11); return(66);
      case 0x168: ConsumeBits(bs, 11); return(85);
      case 0x160: ConsumeBits(bs, 11); return(100);
      case 0x158: ConsumeBits(bs, 11); return(105);
      case 0x150: ConsumeBits(bs, 11); return(109);
      case 0x148: ConsumeBits(bs, 11); return(116);
      case 0x140: ConsumeBits(bs, 11); return(130);
      case 0x138: ConsumeBits(bs, 11); return(133);
      case 0x130: ConsumeBits(bs, 11); return(136);
      case 0x128: ConsumeBits(bs, 11); return(150);
      case 0x120: ConsumeBits(bs, 11); return(153);
      case 0x118: ConsumeBits(bs, 11); return(155);
      case 0x110: ConsumeBits(bs, 11); return(158);
      case 0x108: ConsumeBits(bs, 11); return(162);
      case 0x100: ConsumeBits(bs, 11); return(165);
      case 0xf8: ConsumeBits(bs, 11); return(172);
      case 0xf0: ConsumeBits(bs, 11); return(184);
      case 0xe8: ConsumeBits(bs, 11); return(188);
      case 0xe0: ConsumeBits(bs, 11); return(189);
      case 0xd8: ConsumeBits(bs, 11); return(192);
      case 0xd0: ConsumeBits(bs, 11); return(197);
      case 0xc8: ConsumeBits(bs, 11); return(200);
      case 0xc0: ConsumeBits(bs, 11); return(202);
      case 0xb8: ConsumeBits(bs, 11); return(208);
      case 0xb0: ConsumeBits(bs, 11); return(210);
      case 0xa8: ConsumeBits(bs, 11); return(211);
      case 0xa0: ConsumeBits(bs, 11); return(212);
      case 0x98: ConsumeBits(bs, 11); return(214);
      case 0x90: ConsumeBits(bs, 11); return(220);
      case 0x88: ConsumeBits(bs, 11); return(224);
      case 0x80: ConsumeBits(bs, 11); return(237);
      case 0x78: ConsumeBits(bs, 11); return(240);
      case 0x70: ConsumeBits(bs, 11); return(245);
   }
   switch (val & 0xfffc) {
      case 0x6c: ConsumeBits(bs, 12); return(96);
      case 0x68: ConsumeBits(bs, 12); return(98);
      case 0x64: ConsumeBits(bs, 12); return(102);
      case 0x60: ConsumeBits(bs, 12); return(104);
      case 0x5c: ConsumeBits(bs, 12); return(106);
      case 0x58: ConsumeBits(bs, 12); return(108);
      case 0x54: ConsumeBits(bs, 12); return(110);
      case 0x50: ConsumeBits(bs, 12); return(115);
      case 0x4c: ConsumeBits(bs, 12); return(124);
      case 0x48: ConsumeBits(bs, 12); return(125);
      case 0x44: ConsumeBits(bs, 12); return(146);
      case 0x40: ConsumeBits(bs, 12); return(149);
      case 0x3c: ConsumeBits(bs, 12); return(154);
      case 0x38: ConsumeBits(bs, 12); return(157);
      case 0x34: ConsumeBits(bs, 12); return(168);
      case 0x30: ConsumeBits(bs, 12); return(181);
      case 0x2c: ConsumeBits(bs, 12); return(187);
      case 0x28: ConsumeBits(bs, 12); return(194);
      case 0x24: ConsumeBits(bs, 12); return(198);
      case 0x20: ConsumeBits(bs, 12); return(213);
      case 0x1c: ConsumeBits(bs, 12); return(216);
      case 0x18: ConsumeBits(bs, 12); return(218);
      case 0x14: ConsumeBits(bs, 12); return(226);
      case 0x10: ConsumeBits(bs, 12); return(232);
      case 0xc: ConsumeBits(bs, 12); return(248);
   }
   switch (val & 0xfffe) {
      case 0xa: ConsumeBits(bs, 13); return(101);
      case 0x8: ConsumeBits(bs, 13); return(117);
      case 0x6: ConsumeBits(bs, 13); return(120);
      case 0x4: ConsumeBits(bs, 13); return(152);
      case 0x2: ConsumeBits(bs, 13); return(156);
   }
   switch (val & 0xffff) {
      case 0x1: ConsumeBits(bs, 14); return(229);
   }
   SyntaxError("GetInterCBPYHuffCode");
   return(-1);
}
