#include "bitIn.h"
int GetInterCCP6HuffCode(Bitstream *bs) {
  unsigned short val = ShowBits(bs, 7);
  switch (val & 0xfffe) {
  case 0x0: ConsumeBits(bs, 6); return(0);
  case 0x2: ConsumeBits(bs, 6); return(1);
  case 0x4: ConsumeBits(bs, 6); return(2);
  case 0x6: ConsumeBits(bs, 6); return(3);
  case 0x8: ConsumeBits(bs, 6); return(4);
  case 0xa: ConsumeBits(bs, 6); return(5);
  case 0xc: ConsumeBits(bs, 6); return(6);
  case 0xe: ConsumeBits(bs, 6); return(7);
  case 0x10: ConsumeBits(bs, 6); return(8);
  case 0x12: ConsumeBits(bs, 6); return(9);
  case 0x14: ConsumeBits(bs, 6); return(10);
  case 0x16: ConsumeBits(bs, 6); return(11);
  case 0x18: ConsumeBits(bs, 6); return(12);
  case 0x1a: ConsumeBits(bs, 6); return(13);
  case 0x1c: ConsumeBits(bs, 6); return(14);
  case 0x1e: ConsumeBits(bs, 6); return(15);
  case 0x20: ConsumeBits(bs, 6); return(16);
  case 0x22: ConsumeBits(bs, 6); return(17);
  case 0x24: ConsumeBits(bs, 6); return(18);
  case 0x26: ConsumeBits(bs, 6); return(19);
  case 0x28: ConsumeBits(bs, 6); return(20);
  case 0x2a: ConsumeBits(bs, 6); return(21);
  case 0x2c: ConsumeBits(bs, 6); return(22);
  case 0x2e: ConsumeBits(bs, 6); return(23);
  case 0x30: ConsumeBits(bs, 6); return(24);
  case 0x32: ConsumeBits(bs, 6); return(25);
  case 0x34: ConsumeBits(bs, 6); return(26);
  case 0x36: ConsumeBits(bs, 6); return(27);
  case 0x38: ConsumeBits(bs, 6); return(28);
  case 0x3a: ConsumeBits(bs, 6); return(29);
  case 0x3c: ConsumeBits(bs, 6); return(30);
  case 0x3e: ConsumeBits(bs, 6); return(31);
  case 0x40: ConsumeBits(bs, 6); return(32);
  case 0x42: ConsumeBits(bs, 6); return(33);
  case 0x44: ConsumeBits(bs, 6); return(34);
  case 0x46: ConsumeBits(bs, 6); return(35);
  case 0x48: ConsumeBits(bs, 6); return(36);
  case 0x4a: ConsumeBits(bs, 6); return(37);
  case 0x4c: ConsumeBits(bs, 6); return(38);
  case 0x4e: ConsumeBits(bs, 6); return(39);
  case 0x50: ConsumeBits(bs, 6); return(40);
  case 0x52: ConsumeBits(bs, 6); return(41);
  case 0x54: ConsumeBits(bs, 6); return(42);
  case 0x56: ConsumeBits(bs, 6); return(43);
  case 0x58: ConsumeBits(bs, 6); return(44);
  case 0x5a: ConsumeBits(bs, 6); return(45);
  case 0x5c: ConsumeBits(bs, 6); return(46);
  case 0x5e: ConsumeBits(bs, 6); return(47);
  case 0x60: ConsumeBits(bs, 6); return(48);
  case 0x62: ConsumeBits(bs, 6); return(49);
  case 0x64: ConsumeBits(bs, 6); return(50);
  case 0x66: ConsumeBits(bs, 6); return(51);
  case 0x68: ConsumeBits(bs, 6); return(52);
  case 0x6a: ConsumeBits(bs, 6); return(53);
  case 0x6c: ConsumeBits(bs, 6); return(54);
  case 0x6e: ConsumeBits(bs, 6); return(55);
  case 0x70: ConsumeBits(bs, 6); return(56);
  case 0x72: ConsumeBits(bs, 6); return(57);
  case 0x74: ConsumeBits(bs, 6); return(58);
  case 0x76: ConsumeBits(bs, 6); return(59);
  case 0x78: ConsumeBits(bs, 6); return(60);
  case 0x7a: ConsumeBits(bs, 6); return(61);
  case 0x7c: ConsumeBits(bs, 6); return(62);
  }
  switch (val & 0xffff) {
  case 0x7e: ConsumeBits(bs, 7); return(63);
  }
  fprintf(stderr, "SyntaxError in GetInterCCP6HuffCode");
  return(-1);
}
