#include "bitIn.h"
int GetInterShellCombCHuffCode(Bitstream *bs) {
   unsigned short val = ShowBits(bs, 10);
   switch (val & 0xfe00) {
      case 0x200: ConsumeBits(bs, 1); return(0);
   }
   switch (val & 0xff00) {
      case 0x100: ConsumeBits(bs, 2); return(3);
   }
   switch (val & 0xff80) {
      case 0x80: ConsumeBits(bs, 3); return(4);
   }
   switch (val & 0xffe0) {
      case 0x60: ConsumeBits(bs, 5); return(1);
      case 0x40: ConsumeBits(bs, 5); return(14);
   }
   switch (val & 0xfff0) {
      case 0x30: ConsumeBits(bs, 6); return(7);
      case 0x20: ConsumeBits(bs, 6); return(8);
   }
   switch (val & 0xfff8) {
      case 0x18: ConsumeBits(bs, 7); return(5);
      case 0x10: ConsumeBits(bs, 7); return(6);
   }
   switch (val & 0xfffc) {
      case 0xc: ConsumeBits(bs, 8); return(9);
      case 0x8: ConsumeBits(bs, 8); return(12);
   }
   switch (val & 0xfffe) {
      case 0x6: ConsumeBits(bs, 9); return(2);
      case 0x4: ConsumeBits(bs, 9); return(10);
      case 0x2: ConsumeBits(bs, 9); return(11);
   }
   switch (val & 0xffff) {
      case 0x1: ConsumeBits(bs, 10); return(13);
   }
   SyntaxError("GetInterShellCombCHuffCode");
   return(-1);
}
