#include "bitIn.h"
int GetInterShellCombYHuffCode(Bitstream *bs) {
   unsigned short val = ShowBits(bs, 9);
   switch (val & 0xff00) {
      case 0x100: ConsumeBits(bs, 1); return(3);
   }
   switch (val & 0xff80) {
      case 0x80: ConsumeBits(bs, 2); return(0);
   }
   switch (val & 0xffc0) {
      case 0x40: ConsumeBits(bs, 3); return(4);
   }
   switch (val & 0xfff8) {
      case 0x38: ConsumeBits(bs, 6); return(1);
      case 0x30: ConsumeBits(bs, 6); return(5);
      case 0x28: ConsumeBits(bs, 6); return(7);
      case 0x20: ConsumeBits(bs, 6); return(8);
      case 0x18: ConsumeBits(bs, 6); return(14);
   }
   switch (val & 0xfffc) {
      case 0x14: ConsumeBits(bs, 7); return(2);
      case 0x10: ConsumeBits(bs, 7); return(6);
      case 0xc: ConsumeBits(bs, 7); return(10);
      case 0x8: ConsumeBits(bs, 7); return(11);
      case 0x4: ConsumeBits(bs, 7); return(12);
   }
   switch (val & 0xfffe) {
      case 0x2: ConsumeBits(bs, 8); return(9);
   }
   switch (val & 0xffff) {
      case 0x1: ConsumeBits(bs, 9); return(13);
   }
   SyntaxError("GetInterShellCombYHuffCode");
   return(-1);
}
