#include "bitIn.h"
int GetIntraCBPCHuffCode(Bitstream *bs) {
   unsigned short val = ShowBits(bs, 10);
   switch (val & 0xff80) {
      case 0x380: ConsumeBits(bs, 3); return(15);
   }
   switch (val & 0xffc0) {
      case 0x340: ConsumeBits(bs, 4); return(31);
      case 0x300: ConsumeBits(bs, 4); return(63);
      case 0x2c0: ConsumeBits(bs, 4); return(127);
      case 0x280: ConsumeBits(bs, 4); return(159);
   }
   switch (val & 0xffe0) {
      case 0x260: ConsumeBits(bs, 5); return(0);
      case 0x240: ConsumeBits(bs, 5); return(47);
      case 0x220: ConsumeBits(bs, 5); return(207);
      case 0x200: ConsumeBits(bs, 5); return(239);
   }
   switch (val & 0xfff0) {
      case 0x1f0: ConsumeBits(bs, 6); return(1);
      case 0x1e0: ConsumeBits(bs, 6); return(3);
      case 0x1d0: ConsumeBits(bs, 6); return(7);
      case 0x1c0: ConsumeBits(bs, 6); return(33);
      case 0x1b0: ConsumeBits(bs, 6); return(67);
      case 0x1a0: ConsumeBits(bs, 6); return(79);
      case 0x190: ConsumeBits(bs, 6); return(83);
      case 0x180: ConsumeBits(bs, 6); return(143);
      case 0x170: ConsumeBits(bs, 6); return(199);
   }
   switch (val & 0xfff8) {
      case 0x168: ConsumeBits(bs, 7); return(16);
      case 0x160: ConsumeBits(bs, 7); return(50);
      case 0x158: ConsumeBits(bs, 7); return(84);
      case 0x150: ConsumeBits(bs, 7); return(135);
      case 0x148: ConsumeBits(bs, 7); return(175);
   }
   switch (val & 0xfffc) {
      case 0x144: ConsumeBits(bs, 8); return(2);
      case 0x140: ConsumeBits(bs, 8); return(4);
      case 0x13c: ConsumeBits(bs, 8); return(8);
      case 0x138: ConsumeBits(bs, 8); return(9);
      case 0x134: ConsumeBits(bs, 8); return(11);
      case 0x130: ConsumeBits(bs, 8); return(17);
      case 0x12c: ConsumeBits(bs, 8); return(39);
      case 0x128: ConsumeBits(bs, 8); return(48);
      case 0x124: ConsumeBits(bs, 8); return(64);
      case 0x120: ConsumeBits(bs, 8); return(65);
      case 0x11c: ConsumeBits(bs, 8); return(80);
      case 0x118: ConsumeBits(bs, 8); return(111);
      case 0x114: ConsumeBits(bs, 8); return(161);
      case 0x110: ConsumeBits(bs, 8); return(167);
      case 0x10c: ConsumeBits(bs, 8); return(178);
      case 0x108: ConsumeBits(bs, 8); return(191);
      case 0x104: ConsumeBits(bs, 8); return(195);
      case 0x100: ConsumeBits(bs, 8); return(203);
      case 0xfc: ConsumeBits(bs, 8); return(223);
      case 0xf8: ConsumeBits(bs, 8); return(225);
      case 0xf4: ConsumeBits(bs, 8); return(247);
      case 0xf0: ConsumeBits(bs, 8); return(254);
   }
   switch (val & 0xfffe) {
      case 0xee: ConsumeBits(bs, 9); return(5);
      case 0xec: ConsumeBits(bs, 9); return(6);
      case 0xea: ConsumeBits(bs, 9); return(10);
      case 0xe8: ConsumeBits(bs, 9); return(19);
      case 0xe6: ConsumeBits(bs, 9); return(23);
      case 0xe4: ConsumeBits(bs, 9); return(32);
      case 0xe2: ConsumeBits(bs, 9); return(35);
      case 0xe0: ConsumeBits(bs, 9); return(72);
      case 0xde: ConsumeBits(bs, 9); return(97);
      case 0xdc: ConsumeBits(bs, 9); return(112);
      case 0xda: ConsumeBits(bs, 9); return(115);
      case 0xd8: ConsumeBits(bs, 9); return(116);
      case 0xd6: ConsumeBits(bs, 9); return(128);
      case 0xd4: ConsumeBits(bs, 9); return(139);
      case 0xd2: ConsumeBits(bs, 9); return(144);
      case 0xd0: ConsumeBits(bs, 9); return(176);
      case 0xce: ConsumeBits(bs, 9); return(186);
      case 0xcc: ConsumeBits(bs, 9); return(205);
      case 0xca: ConsumeBits(bs, 9); return(208);
      case 0xc8: ConsumeBits(bs, 9); return(219);
      case 0xc6: ConsumeBits(bs, 9); return(220);
      case 0xc4: ConsumeBits(bs, 9); return(227);
      case 0xc2: ConsumeBits(bs, 9); return(231);
      case 0xc0: ConsumeBits(bs, 9); return(232);
      case 0xbe: ConsumeBits(bs, 9); return(237);
      case 0xbc: ConsumeBits(bs, 9); return(240);
      case 0xba: ConsumeBits(bs, 9); return(245);
      case 0xb8: ConsumeBits(bs, 9); return(249);
      case 0xb6: ConsumeBits(bs, 9); return(251);
   }
   switch (val & 0xffff) {
      case 0xb5: ConsumeBits(bs, 10); return(12);
      case 0xb4: ConsumeBits(bs, 10); return(13);
      case 0xb3: ConsumeBits(bs, 10); return(14);
      case 0xb2: ConsumeBits(bs, 10); return(18);
      case 0xb1: ConsumeBits(bs, 10); return(20);
      case 0xb0: ConsumeBits(bs, 10); return(21);
      case 0xaf: ConsumeBits(bs, 10); return(22);
      case 0xae: ConsumeBits(bs, 10); return(24);
      case 0xad: ConsumeBits(bs, 10); return(25);
      case 0xac: ConsumeBits(bs, 10); return(26);
      case 0xab: ConsumeBits(bs, 10); return(27);
      case 0xaa: ConsumeBits(bs, 10); return(28);
      case 0xa9: ConsumeBits(bs, 10); return(29);
      case 0xa8: ConsumeBits(bs, 10); return(30);
      case 0xa7: ConsumeBits(bs, 10); return(34);
      case 0xa6: ConsumeBits(bs, 10); return(36);
      case 0xa5: ConsumeBits(bs, 10); return(37);
      case 0xa4: ConsumeBits(bs, 10); return(38);
      case 0xa3: ConsumeBits(bs, 10); return(40);
      case 0xa2: ConsumeBits(bs, 10); return(41);
      case 0xa1: ConsumeBits(bs, 10); return(42);
      case 0xa0: ConsumeBits(bs, 10); return(43);
      case 0x9f: ConsumeBits(bs, 10); return(44);
      case 0x9e: ConsumeBits(bs, 10); return(45);
      case 0x9d: ConsumeBits(bs, 10); return(46);
      case 0x9c: ConsumeBits(bs, 10); return(49);
      case 0x9b: ConsumeBits(bs, 10); return(51);
      case 0x9a: ConsumeBits(bs, 10); return(52);
      case 0x99: ConsumeBits(bs, 10); return(53);
      case 0x98: ConsumeBits(bs, 10); return(54);
      case 0x97: ConsumeBits(bs, 10); return(55);
      case 0x96: ConsumeBits(bs, 10); return(56);
      case 0x95: ConsumeBits(bs, 10); return(57);
      case 0x94: ConsumeBits(bs, 10); return(58);
      case 0x93: ConsumeBits(bs, 10); return(59);
      case 0x92: ConsumeBits(bs, 10); return(60);
      case 0x91: ConsumeBits(bs, 10); return(61);
      case 0x90: ConsumeBits(bs, 10); return(62);
      case 0x8f: ConsumeBits(bs, 10); return(66);
      case 0x8e: ConsumeBits(bs, 10); return(68);
      case 0x8d: ConsumeBits(bs, 10); return(69);
      case 0x8c: ConsumeBits(bs, 10); return(70);
      case 0x8b: ConsumeBits(bs, 10); return(71);
      case 0x8a: ConsumeBits(bs, 10); return(73);
      case 0x89: ConsumeBits(bs, 10); return(74);
      case 0x88: ConsumeBits(bs, 10); return(75);
      case 0x87: ConsumeBits(bs, 10); return(76);
      case 0x86: ConsumeBits(bs, 10); return(77);
      case 0x85: ConsumeBits(bs, 10); return(78);
      case 0x84: ConsumeBits(bs, 10); return(81);
      case 0x83: ConsumeBits(bs, 10); return(82);
      case 0x82: ConsumeBits(bs, 10); return(85);
      case 0x81: ConsumeBits(bs, 10); return(86);
      case 0x80: ConsumeBits(bs, 10); return(87);
      case 0x7f: ConsumeBits(bs, 10); return(88);
      case 0x7e: ConsumeBits(bs, 10); return(89);
      case 0x7d: ConsumeBits(bs, 10); return(90);
      case 0x7c: ConsumeBits(bs, 10); return(91);
      case 0x7b: ConsumeBits(bs, 10); return(92);
      case 0x7a: ConsumeBits(bs, 10); return(93);
      case 0x79: ConsumeBits(bs, 10); return(94);
      case 0x78: ConsumeBits(bs, 10); return(95);
      case 0x77: ConsumeBits(bs, 10); return(96);
      case 0x76: ConsumeBits(bs, 10); return(98);
      case 0x75: ConsumeBits(bs, 10); return(99);
      case 0x74: ConsumeBits(bs, 10); return(100);
      case 0x73: ConsumeBits(bs, 10); return(101);
      case 0x72: ConsumeBits(bs, 10); return(102);
      case 0x71: ConsumeBits(bs, 10); return(103);
      case 0x70: ConsumeBits(bs, 10); return(104);
      case 0x6f: ConsumeBits(bs, 10); return(105);
      case 0x6e: ConsumeBits(bs, 10); return(106);
      case 0x6d: ConsumeBits(bs, 10); return(107);
      case 0x6c: ConsumeBits(bs, 10); return(108);
      case 0x6b: ConsumeBits(bs, 10); return(109);
      case 0x6a: ConsumeBits(bs, 10); return(110);
      case 0x69: ConsumeBits(bs, 10); return(113);
      case 0x68: ConsumeBits(bs, 10); return(114);
      case 0x67: ConsumeBits(bs, 10); return(117);
      case 0x66: ConsumeBits(bs, 10); return(118);
      case 0x65: ConsumeBits(bs, 10); return(119);
      case 0x64: ConsumeBits(bs, 10); return(120);
      case 0x63: ConsumeBits(bs, 10); return(121);
      case 0x62: ConsumeBits(bs, 10); return(122);
      case 0x61: ConsumeBits(bs, 10); return(123);
      case 0x60: ConsumeBits(bs, 10); return(124);
      case 0x5f: ConsumeBits(bs, 10); return(125);
      case 0x5e: ConsumeBits(bs, 10); return(126);
      case 0x5d: ConsumeBits(bs, 10); return(129);
      case 0x5c: ConsumeBits(bs, 10); return(130);
      case 0x5b: ConsumeBits(bs, 10); return(131);
      case 0x5a: ConsumeBits(bs, 10); return(132);
      case 0x59: ConsumeBits(bs, 10); return(133);
      case 0x58: ConsumeBits(bs, 10); return(134);
      case 0x57: ConsumeBits(bs, 10); return(136);
      case 0x56: ConsumeBits(bs, 10); return(137);
      case 0x55: ConsumeBits(bs, 10); return(138);
      case 0x54: ConsumeBits(bs, 10); return(140);
      case 0x53: ConsumeBits(bs, 10); return(141);
      case 0x52: ConsumeBits(bs, 10); return(142);
      case 0x51: ConsumeBits(bs, 10); return(145);
      case 0x50: ConsumeBits(bs, 10); return(146);
      case 0x4f: ConsumeBits(bs, 10); return(147);
      case 0x4e: ConsumeBits(bs, 10); return(148);
      case 0x4d: ConsumeBits(bs, 10); return(149);
      case 0x4c: ConsumeBits(bs, 10); return(150);
      case 0x4b: ConsumeBits(bs, 10); return(151);
      case 0x4a: ConsumeBits(bs, 10); return(152);
      case 0x49: ConsumeBits(bs, 10); return(153);
      case 0x48: ConsumeBits(bs, 10); return(154);
      case 0x47: ConsumeBits(bs, 10); return(155);
      case 0x46: ConsumeBits(bs, 10); return(156);
      case 0x45: ConsumeBits(bs, 10); return(157);
      case 0x44: ConsumeBits(bs, 10); return(158);
      case 0x43: ConsumeBits(bs, 10); return(160);
      case 0x42: ConsumeBits(bs, 10); return(162);
      case 0x41: ConsumeBits(bs, 10); return(163);
      case 0x40: ConsumeBits(bs, 10); return(164);
      case 0x3f: ConsumeBits(bs, 10); return(165);
      case 0x3e: ConsumeBits(bs, 10); return(166);
      case 0x3d: ConsumeBits(bs, 10); return(168);
      case 0x3c: ConsumeBits(bs, 10); return(169);
      case 0x3b: ConsumeBits(bs, 10); return(170);
      case 0x3a: ConsumeBits(bs, 10); return(171);
      case 0x39: ConsumeBits(bs, 10); return(172);
      case 0x38: ConsumeBits(bs, 10); return(173);
      case 0x37: ConsumeBits(bs, 10); return(174);
      case 0x36: ConsumeBits(bs, 10); return(177);
      case 0x35: ConsumeBits(bs, 10); return(179);
      case 0x34: ConsumeBits(bs, 10); return(180);
      case 0x33: ConsumeBits(bs, 10); return(181);
      case 0x32: ConsumeBits(bs, 10); return(182);
      case 0x31: ConsumeBits(bs, 10); return(183);
      case 0x30: ConsumeBits(bs, 10); return(184);
      case 0x2f: ConsumeBits(bs, 10); return(185);
      case 0x2e: ConsumeBits(bs, 10); return(187);
      case 0x2d: ConsumeBits(bs, 10); return(188);
      case 0x2c: ConsumeBits(bs, 10); return(189);
      case 0x2b: ConsumeBits(bs, 10); return(190);
      case 0x2a: ConsumeBits(bs, 10); return(192);
      case 0x29: ConsumeBits(bs, 10); return(193);
      case 0x28: ConsumeBits(bs, 10); return(194);
      case 0x27: ConsumeBits(bs, 10); return(196);
      case 0x26: ConsumeBits(bs, 10); return(197);
      case 0x25: ConsumeBits(bs, 10); return(198);
      case 0x24: ConsumeBits(bs, 10); return(200);
      case 0x23: ConsumeBits(bs, 10); return(201);
      case 0x22: ConsumeBits(bs, 10); return(202);
      case 0x21: ConsumeBits(bs, 10); return(204);
      case 0x20: ConsumeBits(bs, 10); return(206);
      case 0x1f: ConsumeBits(bs, 10); return(209);
      case 0x1e: ConsumeBits(bs, 10); return(210);
      case 0x1d: ConsumeBits(bs, 10); return(211);
      case 0x1c: ConsumeBits(bs, 10); return(212);
      case 0x1b: ConsumeBits(bs, 10); return(213);
      case 0x1a: ConsumeBits(bs, 10); return(214);
      case 0x19: ConsumeBits(bs, 10); return(215);
      case 0x18: ConsumeBits(bs, 10); return(216);
      case 0x17: ConsumeBits(bs, 10); return(217);
      case 0x16: ConsumeBits(bs, 10); return(218);
      case 0x15: ConsumeBits(bs, 10); return(221);
      case 0x14: ConsumeBits(bs, 10); return(222);
      case 0x13: ConsumeBits(bs, 10); return(224);
      case 0x12: ConsumeBits(bs, 10); return(226);
      case 0x11: ConsumeBits(bs, 10); return(228);
      case 0x10: ConsumeBits(bs, 10); return(229);
      case 0xf: ConsumeBits(bs, 10); return(230);
      case 0xe: ConsumeBits(bs, 10); return(233);
      case 0xd: ConsumeBits(bs, 10); return(234);
      case 0xc: ConsumeBits(bs, 10); return(235);
      case 0xb: ConsumeBits(bs, 10); return(236);
      case 0xa: ConsumeBits(bs, 10); return(238);
      case 0x9: ConsumeBits(bs, 10); return(241);
      case 0x8: ConsumeBits(bs, 10); return(242);
      case 0x7: ConsumeBits(bs, 10); return(243);
      case 0x6: ConsumeBits(bs, 10); return(244);
      case 0x5: ConsumeBits(bs, 10); return(246);
      case 0x4: ConsumeBits(bs, 10); return(248);
      case 0x3: ConsumeBits(bs, 10); return(250);
      case 0x2: ConsumeBits(bs, 10); return(252);
      case 0x1: ConsumeBits(bs, 10); return(253);
   }
   SyntaxError("GetIntraCBPCHuffCode");
   return(-1);
}
