#include "bitIn.h"
int GetIntraCCP6HuffCode(Bitstream *bs) {
  unsigned short val = ShowBits(bs, 9);
  switch (val & 0xffc0) {
  case 0x0: ConsumeBits(bs, 3); return(59);
  }
  switch (val & 0xffe0) {
  case 0x40: ConsumeBits(bs, 4); return(3);
  case 0x60: ConsumeBits(bs, 4); return(7);
  case 0x80: ConsumeBits(bs, 4); return(11);
  case 0xa0: ConsumeBits(bs, 4); return(19);
  case 0xc0: ConsumeBits(bs, 4); return(27);
  case 0xe0: ConsumeBits(bs, 4); return(43);
  case 0x100: ConsumeBits(bs, 4); return(62);
  }
  switch (val & 0xfff0) {
  case 0x120: ConsumeBits(bs, 5); return(15);
  case 0x130: ConsumeBits(bs, 5); return(31);
  case 0x140: ConsumeBits(bs, 5); return(39);
  case 0x150: ConsumeBits(bs, 5); return(47);
  case 0x160: ConsumeBits(bs, 5); return(51);
  case 0x170: ConsumeBits(bs, 5); return(55);
  }
  switch (val & 0xfff8) {
  case 0x180: ConsumeBits(bs, 6); return(23);
  case 0x188: ConsumeBits(bs, 6); return(46);
  case 0x190: ConsumeBits(bs, 6); return(61);
  }
  switch (val & 0xfffc) {
  case 0x198: ConsumeBits(bs, 7); return(2);
  case 0x19c: ConsumeBits(bs, 7); return(13);
  case 0x1a0: ConsumeBits(bs, 7); return(30);
  case 0x1a4: ConsumeBits(bs, 7); return(34);
  case 0x1a8: ConsumeBits(bs, 7); return(35);
  case 0x1ac: ConsumeBits(bs, 7); return(40);
  case 0x1b0: ConsumeBits(bs, 7); return(60);
  }
  switch (val & 0xfffe) {
  case 0x1b4: ConsumeBits(bs, 8); return(0);
  case 0x1b6: ConsumeBits(bs, 8); return(1);
  case 0x1b8: ConsumeBits(bs, 8); return(4);
  case 0x1ba: ConsumeBits(bs, 8); return(5);
  case 0x1bc: ConsumeBits(bs, 8); return(6);
  case 0x1be: ConsumeBits(bs, 8); return(8);
  case 0x1c0: ConsumeBits(bs, 8); return(9);
  case 0x1c2: ConsumeBits(bs, 8); return(10);
  case 0x1c4: ConsumeBits(bs, 8); return(12);
  case 0x1c6: ConsumeBits(bs, 8); return(14);
  case 0x1c8: ConsumeBits(bs, 8); return(16);
  case 0x1ca: ConsumeBits(bs, 8); return(17);
  case 0x1cc: ConsumeBits(bs, 8); return(18);
  case 0x1ce: ConsumeBits(bs, 8); return(20);
  case 0x1d0: ConsumeBits(bs, 8); return(21);
  case 0x1d2: ConsumeBits(bs, 8); return(22);
  case 0x1d4: ConsumeBits(bs, 8); return(24);
  case 0x1d6: ConsumeBits(bs, 8); return(25);
  case 0x1d8: ConsumeBits(bs, 8); return(26);
  case 0x1da: ConsumeBits(bs, 8); return(28);
  case 0x1dc: ConsumeBits(bs, 8); return(29);
  case 0x1de: ConsumeBits(bs, 8); return(32);
  case 0x1e0: ConsumeBits(bs, 8); return(33);
  case 0x1e2: ConsumeBits(bs, 8); return(36);
  case 0x1e4: ConsumeBits(bs, 8); return(37);
  case 0x1e6: ConsumeBits(bs, 8); return(38);
  case 0x1e8: ConsumeBits(bs, 8); return(41);
  case 0x1ea: ConsumeBits(bs, 8); return(42);
  case 0x1ec: ConsumeBits(bs, 8); return(44);
  case 0x1ee: ConsumeBits(bs, 8); return(45);
  case 0x1f0: ConsumeBits(bs, 8); return(48);
  case 0x1f2: ConsumeBits(bs, 8); return(49);
  case 0x1f4: ConsumeBits(bs, 8); return(50);
  case 0x1f6: ConsumeBits(bs, 8); return(52);
  case 0x1f8: ConsumeBits(bs, 8); return(53);
  case 0x1fa: ConsumeBits(bs, 8); return(58);
  }
  switch (val & 0xffff) {
  case 0x1fc: ConsumeBits(bs, 9); return(54);
  case 0x1fd: ConsumeBits(bs, 9); return(56);
  case 0x1fe: ConsumeBits(bs, 9); return(57);
  }
  fprintf(stderr, "SyntaxError in GetIntraCCP6HuffCode");
  return(-1);
}
