#include "bitIn.h"
int GetIntraCCPHuffCode(Bitstream *bs) {
   unsigned short val = ShowBits(bs, 7);
   switch (val & 0xffc0) {
      case 0x40: ConsumeBits(bs, 1); return(5);
   }
   switch (val & 0xffe0) {
      case 0x20: ConsumeBits(bs, 2); return(1);
   }
   switch (val & 0xfff0) {
      case 0x10: ConsumeBits(bs, 3); return(3);
   }
   switch (val & 0xfff8) {
      case 0x8: ConsumeBits(bs, 4); return(6);
   }
   switch (val & 0xfffc) {
      case 0x4: ConsumeBits(bs, 5); return(0);
   }
   switch (val & 0xfffe) {
      case 0x2: ConsumeBits(bs, 6); return(2);
   }
   switch (val & 0xffff) {
      case 0x1: ConsumeBits(bs, 7); return(4);
   }
   SyntaxError("GetIntraCCPHuffCode");
   return(-1);
}

int GetIntraCCP6HuffCode(Bitstream *bs) {
   unsigned short val = ShowBits(bs, 10);
   switch (val & 0xff00) {
      case 0x300: ConsumeBits(bs, 2); return(61);
   }
   switch (val & 0xff80) {
      case 0x280: ConsumeBits(bs, 3); return(59);
      case 0x200: ConsumeBits(bs, 3); return(62);
   }
   switch (val & 0xffc0) {
      case 0x1c0: ConsumeBits(bs, 4); return(60);
   }
   switch (val & 0xffe0) {
      case 0x1a0: ConsumeBits(bs, 5); return(3);
      case 0x180: ConsumeBits(bs, 5); return(15);
      case 0x160: ConsumeBits(bs, 5); return(31);
   }
   switch (val & 0xfff0) {
      case 0x150: ConsumeBits(bs, 6); return(1);
      case 0x140: ConsumeBits(bs, 6); return(7);
      case 0x130: ConsumeBits(bs, 6); return(11);
      case 0x120: ConsumeBits(bs, 6); return(19);
      case 0x110: ConsumeBits(bs, 6); return(27);
      case 0x100: ConsumeBits(bs, 6); return(39);
      case 0xf0: ConsumeBits(bs, 6); return(43);
      case 0xe0: ConsumeBits(bs, 6); return(47);
      case 0xd0: ConsumeBits(bs, 6); return(51);
      case 0xc0: ConsumeBits(bs, 6); return(55);
   }
   switch (val & 0xfff8) {
      case 0xb8: ConsumeBits(bs, 7); return(12);
      case 0xb0: ConsumeBits(bs, 7); return(14);
      case 0xa8: ConsumeBits(bs, 7); return(30);
      case 0xa0: ConsumeBits(bs, 7); return(35);
      case 0x98: ConsumeBits(bs, 7); return(41);
      case 0x90: ConsumeBits(bs, 7); return(44);
      case 0x88: ConsumeBits(bs, 7); return(46);
      case 0x80: ConsumeBits(bs, 7); return(49);
      case 0x78: ConsumeBits(bs, 7); return(53);
      case 0x70: ConsumeBits(bs, 7); return(57);
      case 0x68: ConsumeBits(bs, 7); return(58);
   }
   switch (val & 0xfffc) {
      case 0x64: ConsumeBits(bs, 8); return(0);
      case 0x60: ConsumeBits(bs, 8); return(4);
      case 0x5c: ConsumeBits(bs, 8); return(8);
      case 0x58: ConsumeBits(bs, 8); return(9);
      case 0x54: ConsumeBits(bs, 8); return(13);
      case 0x50: ConsumeBits(bs, 8); return(17);
      case 0x4c: ConsumeBits(bs, 8); return(20);
      case 0x48: ConsumeBits(bs, 8); return(21);
      case 0x44: ConsumeBits(bs, 8); return(23);
      case 0x40: ConsumeBits(bs, 8); return(28);
      case 0x3c: ConsumeBits(bs, 8); return(29);
      case 0x38: ConsumeBits(bs, 8); return(33);
      case 0x34: ConsumeBits(bs, 8); return(37);
      case 0x30: ConsumeBits(bs, 8); return(40);
      case 0x2c: ConsumeBits(bs, 8); return(42);
      case 0x28: ConsumeBits(bs, 8); return(45);
      case 0x24: ConsumeBits(bs, 8); return(48);
      case 0x20: ConsumeBits(bs, 8); return(52);
      case 0x1c: ConsumeBits(bs, 8); return(54);
      case 0x18: ConsumeBits(bs, 8); return(56);
   }
   switch (val & 0xfffe) {
      case 0x16: ConsumeBits(bs, 9); return(2);
      case 0x14: ConsumeBits(bs, 9); return(5);
      case 0x12: ConsumeBits(bs, 9); return(22);
      case 0x10: ConsumeBits(bs, 9); return(24);
      case 0xe: ConsumeBits(bs, 9); return(25);
      case 0xc: ConsumeBits(bs, 9); return(32);
      case 0xa: ConsumeBits(bs, 9); return(36);
      case 0x8: ConsumeBits(bs, 9); return(50);
   }
   switch (val & 0xffff) {
      case 0x7: ConsumeBits(bs, 10); return(6);
      case 0x6: ConsumeBits(bs, 10); return(10);
      case 0x5: ConsumeBits(bs, 10); return(16);
      case 0x4: ConsumeBits(bs, 10); return(18);
      case 0x3: ConsumeBits(bs, 10); return(26);
      case 0x2: ConsumeBits(bs, 10); return(34);
      case 0x1: ConsumeBits(bs, 10); return(38);
   }
   SyntaxError("GetIntraCCP6HuffCode");
   return(-1);
}

