#include "bitIn.h"
int GetShell1SPYHuffCode(Bitstream *bs) {
   unsigned short val = ShowBits(bs, 14);
   switch (val & 0xf800) {
      case 0x3800: ConsumeBits(bs, 3); return(0);
      case 0x3000: ConsumeBits(bs, 3); return(114);
   }
   switch (val & 0xfc00) {
      case 0x2c00: ConsumeBits(bs, 4); return(6);
      case 0x2800: ConsumeBits(bs, 4); return(41);
      case 0x2400: ConsumeBits(bs, 4); return(44);
      case 0x2000: ConsumeBits(bs, 4); return(45);
   }
   switch (val & 0xfe00) {
      case 0x1e00: ConsumeBits(bs, 5); return(7);
      case 0x1c00: ConsumeBits(bs, 5); return(28);
      case 0x1a00: ConsumeBits(bs, 5); return(29);
      case 0x1800: ConsumeBits(bs, 5); return(54);
      case 0x1600: ConsumeBits(bs, 5); return(64);
      case 0x1400: ConsumeBits(bs, 5); return(86);
      case 0x1200: ConsumeBits(bs, 5); return(87);
      case 0x1000: ConsumeBits(bs, 5); return(101);
   }
   switch (val & 0xff00) {
      case 0xf00: ConsumeBits(bs, 6); return(53);
      case 0xe00: ConsumeBits(bs, 6); return(63);
      case 0xd00: ConsumeBits(bs, 6); return(73);
      case 0xc00: ConsumeBits(bs, 6); return(112);
      case 0xb00: ConsumeBits(bs, 6); return(119);
   }
   switch (val & 0xff80) {
      case 0xa80: ConsumeBits(bs, 7); return(11);
      case 0xa00: ConsumeBits(bs, 7); return(23);
      case 0x980: ConsumeBits(bs, 7); return(43);
      case 0x900: ConsumeBits(bs, 7); return(58);
      case 0x880: ConsumeBits(bs, 7); return(65);
      case 0x800: ConsumeBits(bs, 7); return(95);
      case 0x780: ConsumeBits(bs, 7); return(98);
      case 0x700: ConsumeBits(bs, 7); return(108);
      case 0x680: ConsumeBits(bs, 7); return(109);
   }
   switch (val & 0xffc0) {
      case 0x640: ConsumeBits(bs, 8); return(8);
      case 0x600: ConsumeBits(bs, 8); return(10);
      case 0x5c0: ConsumeBits(bs, 8); return(34);
      case 0x580: ConsumeBits(bs, 8); return(38);
      case 0x540: ConsumeBits(bs, 8); return(49);
      case 0x500: ConsumeBits(bs, 8); return(59);
      case 0x4c0: ConsumeBits(bs, 8); return(67);
      case 0x480: ConsumeBits(bs, 8); return(75);
      case 0x440: ConsumeBits(bs, 8); return(76);
      case 0x400: ConsumeBits(bs, 8); return(77);
      case 0x3c0: ConsumeBits(bs, 8); return(78);
      case 0x380: ConsumeBits(bs, 8); return(97);
      case 0x340: ConsumeBits(bs, 8); return(116);
   }
   switch (val & 0xffe0) {
      case 0x320: ConsumeBits(bs, 9); return(3);
      case 0x300: ConsumeBits(bs, 9); return(12);
      case 0x2e0: ConsumeBits(bs, 9); return(15);
      case 0x2c0: ConsumeBits(bs, 9); return(25);
      case 0x2a0: ConsumeBits(bs, 9); return(32);
      case 0x280: ConsumeBits(bs, 9); return(47);
      case 0x260: ConsumeBits(bs, 9); return(48);
      case 0x240: ConsumeBits(bs, 9); return(50);
      case 0x220: ConsumeBits(bs, 9); return(57);
      case 0x200: ConsumeBits(bs, 9); return(60);
      case 0x1e0: ConsumeBits(bs, 9); return(72);
      case 0x1c0: ConsumeBits(bs, 9); return(107);
      case 0x1a0: ConsumeBits(bs, 9); return(118);
   }
   switch (val & 0xfff0) {
      case 0x190: ConsumeBits(bs, 10); return(4);
      case 0x180: ConsumeBits(bs, 10); return(13);
      case 0x170: ConsumeBits(bs, 10); return(14);
      case 0x160: ConsumeBits(bs, 10); return(20);
      case 0x150: ConsumeBits(bs, 10); return(21);
      case 0x140: ConsumeBits(bs, 10); return(22);
      case 0x130: ConsumeBits(bs, 10); return(46);
      case 0x120: ConsumeBits(bs, 10); return(56);
      case 0x110: ConsumeBits(bs, 10); return(90);
      case 0x100: ConsumeBits(bs, 10); return(96);
      case 0xf0: ConsumeBits(bs, 10); return(111);
      case 0xe0: ConsumeBits(bs, 10); return(113);
   }
   switch (val & 0xfff8) {
      case 0xd8: ConsumeBits(bs, 11); return(1);
      case 0xd0: ConsumeBits(bs, 11); return(2);
      case 0xc8: ConsumeBits(bs, 11); return(9);
      case 0xc0: ConsumeBits(bs, 11); return(33);
      case 0xb8: ConsumeBits(bs, 11); return(52);
      case 0xb0: ConsumeBits(bs, 11); return(55);
      case 0xa8: ConsumeBits(bs, 11); return(66);
      case 0xa0: ConsumeBits(bs, 11); return(68);
      case 0x98: ConsumeBits(bs, 11); return(79);
      case 0x90: ConsumeBits(bs, 11); return(82);
      case 0x88: ConsumeBits(bs, 11); return(83);
      case 0x80: ConsumeBits(bs, 11); return(91);
      case 0x78: ConsumeBits(bs, 11); return(92);
      case 0x70: ConsumeBits(bs, 11); return(93);
      case 0x68: ConsumeBits(bs, 11); return(106);
      case 0x60: ConsumeBits(bs, 11); return(110);
      case 0x58: ConsumeBits(bs, 11); return(115);
   }
   switch (val & 0xfffc) {
      case 0x54: ConsumeBits(bs, 12); return(16);
      case 0x50: ConsumeBits(bs, 12); return(19);
      case 0x4c: ConsumeBits(bs, 12); return(26);
      case 0x48: ConsumeBits(bs, 12); return(27);
      case 0x44: ConsumeBits(bs, 12); return(31);
      case 0x40: ConsumeBits(bs, 12); return(37);
      case 0x3c: ConsumeBits(bs, 12); return(39);
      case 0x38: ConsumeBits(bs, 12); return(51);
      case 0x34: ConsumeBits(bs, 12); return(69);
      case 0x30: ConsumeBits(bs, 12); return(70);
      case 0x2c: ConsumeBits(bs, 12); return(71);
      case 0x28: ConsumeBits(bs, 12); return(80);
   }
   switch (val & 0xfffe) {
      case 0x26: ConsumeBits(bs, 13); return(5);
      case 0x24: ConsumeBits(bs, 13); return(30);
      case 0x22: ConsumeBits(bs, 13); return(35);
      case 0x20: ConsumeBits(bs, 13); return(42);
      case 0x1e: ConsumeBits(bs, 13); return(62);
      case 0x1c: ConsumeBits(bs, 13); return(74);
      case 0x1a: ConsumeBits(bs, 13); return(84);
      case 0x18: ConsumeBits(bs, 13); return(85);
      case 0x16: ConsumeBits(bs, 13); return(94);
      case 0x14: ConsumeBits(bs, 13); return(99);
      case 0x12: ConsumeBits(bs, 13); return(102);
      case 0x10: ConsumeBits(bs, 13); return(103);
      case 0xe: ConsumeBits(bs, 13); return(105);
      case 0xc: ConsumeBits(bs, 13); return(117);
   }
   switch (val & 0xffff) {
      case 0xb: ConsumeBits(bs, 14); return(17);
      case 0xa: ConsumeBits(bs, 14); return(18);
      case 0x9: ConsumeBits(bs, 14); return(24);
      case 0x8: ConsumeBits(bs, 14); return(36);
      case 0x7: ConsumeBits(bs, 14); return(40);
      case 0x6: ConsumeBits(bs, 14); return(61);
      case 0x5: ConsumeBits(bs, 14); return(81);
      case 0x4: ConsumeBits(bs, 14); return(88);
      case 0x3: ConsumeBits(bs, 14); return(89);
      case 0x2: ConsumeBits(bs, 14); return(100);
      case 0x1: ConsumeBits(bs, 14); return(104);
   }
   SyntaxError("GetShell1SPYHuffCode");
   return(-1);
}
