#include "bitIn.h"
int GetShell1TPCHuffCode(Bitstream *bs) {
   unsigned short val = ShowBits(bs, 13);
   switch (val & 0xf000) {
      case 0x1000: ConsumeBits(bs, 1); return(0);
   }
   switch (val & 0xfe00) {
      case 0xe00: ConsumeBits(bs, 4); return(114);
   }
   switch (val & 0xff00) {
      case 0xd00: ConsumeBits(bs, 5); return(6);
      case 0xc00: ConsumeBits(bs, 5); return(44);
      case 0xb00: ConsumeBits(bs, 5); return(86);
   }
   switch (val & 0xff80) {
      case 0xa80: ConsumeBits(bs, 6); return(7);
      case 0xa00: ConsumeBits(bs, 6); return(28);
      case 0x980: ConsumeBits(bs, 6); return(29);
      case 0x900: ConsumeBits(bs, 6); return(45);
      case 0x880: ConsumeBits(bs, 6); return(53);
      case 0x800: ConsumeBits(bs, 6); return(54);
      case 0x780: ConsumeBits(bs, 6); return(58);
      case 0x700: ConsumeBits(bs, 6); return(63);
      case 0x680: ConsumeBits(bs, 6); return(64);
      case 0x600: ConsumeBits(bs, 6); return(87);
      case 0x580: ConsumeBits(bs, 6); return(101);
   }
   switch (val & 0xffc0) {
      case 0x540: ConsumeBits(bs, 7); return(59);
      case 0x500: ConsumeBits(bs, 7); return(77);
      case 0x4c0: ConsumeBits(bs, 7); return(95);
      case 0x480: ConsumeBits(bs, 7); return(108);
   }
   switch (val & 0xffe0) {
      case 0x460: ConsumeBits(bs, 8); return(11);
      case 0x440: ConsumeBits(bs, 8); return(48);
      case 0x420: ConsumeBits(bs, 8); return(49);
      case 0x400: ConsumeBits(bs, 8); return(65);
      case 0x3e0: ConsumeBits(bs, 8); return(67);
      case 0x3c0: ConsumeBits(bs, 8); return(73);
      case 0x3a0: ConsumeBits(bs, 8); return(96);
      case 0x380: ConsumeBits(bs, 8); return(109);
      case 0x360: ConsumeBits(bs, 8); return(112);
      case 0x340: ConsumeBits(bs, 8); return(119);
   }
   switch (val & 0xfff0) {
      case 0x330: ConsumeBits(bs, 9); return(3);
      case 0x320: ConsumeBits(bs, 9); return(8);
      case 0x310: ConsumeBits(bs, 9); return(10);
      case 0x300: ConsumeBits(bs, 9); return(13);
      case 0x2f0: ConsumeBits(bs, 9); return(14);
      case 0x2e0: ConsumeBits(bs, 9); return(16);
      case 0x2d0: ConsumeBits(bs, 9); return(17);
      case 0x2c0: ConsumeBits(bs, 9); return(25);
      case 0x2b0: ConsumeBits(bs, 9); return(26);
      case 0x2a0: ConsumeBits(bs, 9); return(33);
      case 0x290: ConsumeBits(bs, 9); return(34);
      case 0x280: ConsumeBits(bs, 9); return(38);
      case 0x270: ConsumeBits(bs, 9); return(41);
      case 0x260: ConsumeBits(bs, 9); return(43);
      case 0x250: ConsumeBits(bs, 9); return(50);
      case 0x240: ConsumeBits(bs, 9); return(66);
      case 0x230: ConsumeBits(bs, 9); return(69);
      case 0x220: ConsumeBits(bs, 9); return(72);
      case 0x210: ConsumeBits(bs, 9); return(75);
      case 0x200: ConsumeBits(bs, 9); return(76);
      case 0x1f0: ConsumeBits(bs, 9); return(78);
      case 0x1e0: ConsumeBits(bs, 9); return(83);
      case 0x1d0: ConsumeBits(bs, 9); return(90);
      case 0x1c0: ConsumeBits(bs, 9); return(91);
      case 0x1b0: ConsumeBits(bs, 9); return(98);
      case 0x1a0: ConsumeBits(bs, 9); return(99);
      case 0x190: ConsumeBits(bs, 9); return(102);
      case 0x180: ConsumeBits(bs, 9); return(107);
      case 0x170: ConsumeBits(bs, 9); return(113);
      case 0x160: ConsumeBits(bs, 9); return(115);
      case 0x150: ConsumeBits(bs, 9); return(116);
      case 0x140: ConsumeBits(bs, 9); return(118);
   }
   switch (val & 0xfff8) {
      case 0x138: ConsumeBits(bs, 10); return(2);
      case 0x130: ConsumeBits(bs, 10); return(4);
      case 0x128: ConsumeBits(bs, 10); return(5);
      case 0x120: ConsumeBits(bs, 10); return(9);
      case 0x118: ConsumeBits(bs, 10); return(12);
      case 0x110: ConsumeBits(bs, 10); return(15);
      case 0x108: ConsumeBits(bs, 10); return(18);
      case 0x100: ConsumeBits(bs, 10); return(19);
      case 0xf8: ConsumeBits(bs, 10); return(22);
      case 0xf0: ConsumeBits(bs, 10); return(23);
      case 0xe8: ConsumeBits(bs, 10); return(27);
      case 0xe0: ConsumeBits(bs, 10); return(30);
      case 0xd8: ConsumeBits(bs, 10); return(32);
      case 0xd0: ConsumeBits(bs, 10); return(39);
      case 0xc8: ConsumeBits(bs, 10); return(51);
      case 0xc0: ConsumeBits(bs, 10); return(52);
      case 0xb8: ConsumeBits(bs, 10); return(55);
      case 0xb0: ConsumeBits(bs, 10); return(57);
      case 0xa8: ConsumeBits(bs, 10); return(61);
      case 0xa0: ConsumeBits(bs, 10); return(82);
      case 0x98: ConsumeBits(bs, 10); return(97);
      case 0x90: ConsumeBits(bs, 10); return(100);
      case 0x88: ConsumeBits(bs, 10); return(103);
      case 0x80: ConsumeBits(bs, 10); return(105);
      case 0x78: ConsumeBits(bs, 10); return(111);
      case 0x70: ConsumeBits(bs, 10); return(117);
   }
   switch (val & 0xfffc) {
      case 0x6c: ConsumeBits(bs, 11); return(1);
      case 0x68: ConsumeBits(bs, 11); return(21);
      case 0x64: ConsumeBits(bs, 11); return(24);
      case 0x60: ConsumeBits(bs, 11); return(40);
      case 0x5c: ConsumeBits(bs, 11); return(46);
      case 0x58: ConsumeBits(bs, 11); return(47);
      case 0x54: ConsumeBits(bs, 11); return(56);
      case 0x50: ConsumeBits(bs, 11); return(62);
      case 0x4c: ConsumeBits(bs, 11); return(68);
      case 0x48: ConsumeBits(bs, 11); return(70);
      case 0x44: ConsumeBits(bs, 11); return(74);
      case 0x40: ConsumeBits(bs, 11); return(79);
      case 0x3c: ConsumeBits(bs, 11); return(80);
      case 0x38: ConsumeBits(bs, 11); return(81);
      case 0x34: ConsumeBits(bs, 11); return(84);
      case 0x30: ConsumeBits(bs, 11); return(85);
      case 0x2c: ConsumeBits(bs, 11); return(88);
      case 0x28: ConsumeBits(bs, 11); return(89);
      case 0x24: ConsumeBits(bs, 11); return(92);
      case 0x20: ConsumeBits(bs, 11); return(93);
      case 0x1c: ConsumeBits(bs, 11); return(94);
      case 0x18: ConsumeBits(bs, 11); return(104);
      case 0x14: ConsumeBits(bs, 11); return(106);
      case 0x10: ConsumeBits(bs, 11); return(110);
   }
   switch (val & 0xfffe) {
      case 0xe: ConsumeBits(bs, 12); return(20);
      case 0xc: ConsumeBits(bs, 12); return(31);
      case 0xa: ConsumeBits(bs, 12); return(35);
      case 0x8: ConsumeBits(bs, 12); return(36);
      case 0x6: ConsumeBits(bs, 12); return(37);
      case 0x4: ConsumeBits(bs, 12); return(42);
      case 0x2: ConsumeBits(bs, 12); return(60);
   }
   switch (val & 0xffff) {
      case 0x1: ConsumeBits(bs, 13); return(71);
   }
   SyntaxError("GetShell1TPCHuffCode");
   return(-1);
}
