#include "bitIn.h"
int GetShell2TPCHuffCode(Bitstream *bs) {
   unsigned short val = ShowBits(bs, 11);
   switch (val & 0xff00) {
      case 0x700: ConsumeBits(bs, 3); return(739);
   }
   switch (val & 0xffe0) {
      case 0x6e0: ConsumeBits(bs, 6); return(599);
   }
   switch (val & 0xfff0) {
      case 0x6d0: ConsumeBits(bs, 7); return(447);
   }
   switch (val & 0xfff8) {
      case 0x6c8: ConsumeBits(bs, 8); return(53);
      case 0x6c0: ConsumeBits(bs, 8); return(91);
      case 0x6b8: ConsumeBits(bs, 8); return(144);
      case 0x6b0: ConsumeBits(bs, 8); return(176);
      case 0x6a8: ConsumeBits(bs, 8); return(240);
      case 0x6a0: ConsumeBits(bs, 8); return(316);
      case 0x698: ConsumeBits(bs, 8); return(356);
      case 0x690: ConsumeBits(bs, 8); return(380);
      case 0x688: ConsumeBits(bs, 8); return(396);
      case 0x680: ConsumeBits(bs, 8); return(404);
      case 0x678: ConsumeBits(bs, 8); return(468);
      case 0x670: ConsumeBits(bs, 8); return(472);
      case 0x668: ConsumeBits(bs, 8); return(476);
      case 0x660: ConsumeBits(bs, 8); return(590);
      case 0x658: ConsumeBits(bs, 8); return(699);
      case 0x650: ConsumeBits(bs, 8); return(779);
   }
   switch (val & 0xfffc) {
      case 0x64c: ConsumeBits(bs, 9); return(5);
      case 0x648: ConsumeBits(bs, 9); return(23);
      case 0x644: ConsumeBits(bs, 9); return(31);
      case 0x640: ConsumeBits(bs, 9); return(69);
      case 0x63c: ConsumeBits(bs, 9); return(74);
      case 0x638: ConsumeBits(bs, 9); return(117);
      case 0x634: ConsumeBits(bs, 9); return(134);
      case 0x630: ConsumeBits(bs, 9); return(138);
      case 0x62c: ConsumeBits(bs, 9); return(147);
      case 0x628: ConsumeBits(bs, 9); return(160);
      case 0x624: ConsumeBits(bs, 9); return(167);
      case 0x620: ConsumeBits(bs, 9); return(172);
      case 0x61c: ConsumeBits(bs, 9); return(185);
      case 0x618: ConsumeBits(bs, 9); return(200);
      case 0x614: ConsumeBits(bs, 9); return(203);
      case 0x610: ConsumeBits(bs, 9); return(216);
      case 0x60c: ConsumeBits(bs, 9); return(229);
      case 0x608: ConsumeBits(bs, 9); return(230);
      case 0x604: ConsumeBits(bs, 9); return(236);
      case 0x600: ConsumeBits(bs, 9); return(237);
      case 0x5fc: ConsumeBits(bs, 9); return(246);
      case 0x5f8: ConsumeBits(bs, 9); return(257);
      case 0x5f4: ConsumeBits(bs, 9); return(262);
      case 0x5f0: ConsumeBits(bs, 9); return(299);
      case 0x5ec: ConsumeBits(bs, 9); return(301);
      case 0x5e8: ConsumeBits(bs, 9); return(324);
      case 0x5e4: ConsumeBits(bs, 9); return(328);
      case 0x5e0: ConsumeBits(bs, 9); return(361);
      case 0x5dc: ConsumeBits(bs, 9); return(390);
      case 0x5d8: ConsumeBits(bs, 9); return(391);
      case 0x5d4: ConsumeBits(bs, 9); return(405);
      case 0x5d0: ConsumeBits(bs, 9); return(411);
      case 0x5cc: ConsumeBits(bs, 9); return(412);
      case 0x5c8: ConsumeBits(bs, 9); return(416);
      case 0x5c4: ConsumeBits(bs, 9); return(419);
      case 0x5c0: ConsumeBits(bs, 9); return(425);
      case 0x5bc: ConsumeBits(bs, 9); return(432);
      case 0x5b8: ConsumeBits(bs, 9); return(433);
      case 0x5b4: ConsumeBits(bs, 9); return(440);
      case 0x5b0: ConsumeBits(bs, 9); return(444);
      case 0x5ac: ConsumeBits(bs, 9); return(448);
      case 0x5a8: ConsumeBits(bs, 9); return(467);
      case 0x5a4: ConsumeBits(bs, 9); return(485);
      case 0x5a0: ConsumeBits(bs, 9); return(486);
      case 0x59c: ConsumeBits(bs, 9); return(504);
      case 0x598: ConsumeBits(bs, 9); return(526);
      case 0x594: ConsumeBits(bs, 9); return(547);
      case 0x590: ConsumeBits(bs, 9); return(552);
      case 0x58c: ConsumeBits(bs, 9); return(555);
      case 0x588: ConsumeBits(bs, 9); return(595);
      case 0x584: ConsumeBits(bs, 9); return(598);
      case 0x580: ConsumeBits(bs, 9); return(604);
      case 0x57c: ConsumeBits(bs, 9); return(623);
      case 0x578: ConsumeBits(bs, 9); return(628);
      case 0x574: ConsumeBits(bs, 9); return(633);
      case 0x570: ConsumeBits(bs, 9); return(647);
      case 0x56c: ConsumeBits(bs, 9); return(659);
      case 0x568: ConsumeBits(bs, 9); return(663);
      case 0x564: ConsumeBits(bs, 9); return(672);
      case 0x560: ConsumeBits(bs, 9); return(678);
      case 0x55c: ConsumeBits(bs, 9); return(686);
      case 0x558: ConsumeBits(bs, 9); return(691);
      case 0x554: ConsumeBits(bs, 9); return(696);
      case 0x550: ConsumeBits(bs, 9); return(719);
      case 0x54c: ConsumeBits(bs, 9); return(731);
      case 0x548: ConsumeBits(bs, 9); return(771);
      case 0x544: ConsumeBits(bs, 9); return(783);
   }
   switch (val & 0xfffe) {
      case 0x542: ConsumeBits(bs, 10); return(0);
      case 0x540: ConsumeBits(bs, 10); return(1);
      case 0x53e: ConsumeBits(bs, 10); return(2);
      case 0x53c: ConsumeBits(bs, 10); return(3);
      case 0x53a: ConsumeBits(bs, 10); return(4);
      case 0x538: ConsumeBits(bs, 10); return(6);
      case 0x536: ConsumeBits(bs, 10); return(7);
      case 0x534: ConsumeBits(bs, 10); return(8);
      case 0x532: ConsumeBits(bs, 10); return(9);
      case 0x530: ConsumeBits(bs, 10); return(10);
      case 0x52e: ConsumeBits(bs, 10); return(11);
      case 0x52c: ConsumeBits(bs, 10); return(12);
      case 0x52a: ConsumeBits(bs, 10); return(13);
      case 0x528: ConsumeBits(bs, 10); return(14);
      case 0x526: ConsumeBits(bs, 10); return(15);
      case 0x524: ConsumeBits(bs, 10); return(16);
      case 0x522: ConsumeBits(bs, 10); return(17);
      case 0x520: ConsumeBits(bs, 10); return(18);
      case 0x51e: ConsumeBits(bs, 10); return(19);
      case 0x51c: ConsumeBits(bs, 10); return(20);
      case 0x51a: ConsumeBits(bs, 10); return(21);
      case 0x518: ConsumeBits(bs, 10); return(22);
      case 0x516: ConsumeBits(bs, 10); return(24);
      case 0x514: ConsumeBits(bs, 10); return(25);
      case 0x512: ConsumeBits(bs, 10); return(26);
      case 0x510: ConsumeBits(bs, 10); return(27);
      case 0x50e: ConsumeBits(bs, 10); return(28);
      case 0x50c: ConsumeBits(bs, 10); return(29);
      case 0x50a: ConsumeBits(bs, 10); return(30);
      case 0x508: ConsumeBits(bs, 10); return(32);
      case 0x506: ConsumeBits(bs, 10); return(33);
      case 0x504: ConsumeBits(bs, 10); return(34);
      case 0x502: ConsumeBits(bs, 10); return(35);
      case 0x500: ConsumeBits(bs, 10); return(36);
      case 0x4fe: ConsumeBits(bs, 10); return(37);
      case 0x4fc: ConsumeBits(bs, 10); return(38);
      case 0x4fa: ConsumeBits(bs, 10); return(39);
      case 0x4f8: ConsumeBits(bs, 10); return(40);
      case 0x4f6: ConsumeBits(bs, 10); return(41);
      case 0x4f4: ConsumeBits(bs, 10); return(42);
      case 0x4f2: ConsumeBits(bs, 10); return(43);
      case 0x4f0: ConsumeBits(bs, 10); return(44);
      case 0x4ee: ConsumeBits(bs, 10); return(45);
      case 0x4ec: ConsumeBits(bs, 10); return(46);
      case 0x4ea: ConsumeBits(bs, 10); return(47);
      case 0x4e8: ConsumeBits(bs, 10); return(48);
      case 0x4e6: ConsumeBits(bs, 10); return(49);
      case 0x4e4: ConsumeBits(bs, 10); return(50);
      case 0x4e2: ConsumeBits(bs, 10); return(51);
      case 0x4e0: ConsumeBits(bs, 10); return(52);
      case 0x4de: ConsumeBits(bs, 10); return(54);
      case 0x4dc: ConsumeBits(bs, 10); return(55);
      case 0x4da: ConsumeBits(bs, 10); return(56);
      case 0x4d8: ConsumeBits(bs, 10); return(57);
      case 0x4d6: ConsumeBits(bs, 10); return(58);
      case 0x4d4: ConsumeBits(bs, 10); return(59);
      case 0x4d2: ConsumeBits(bs, 10); return(60);
      case 0x4d0: ConsumeBits(bs, 10); return(61);
      case 0x4ce: ConsumeBits(bs, 10); return(62);
      case 0x4cc: ConsumeBits(bs, 10); return(63);
      case 0x4ca: ConsumeBits(bs, 10); return(64);
      case 0x4c8: ConsumeBits(bs, 10); return(65);
      case 0x4c6: ConsumeBits(bs, 10); return(66);
      case 0x4c4: ConsumeBits(bs, 10); return(67);
      case 0x4c2: ConsumeBits(bs, 10); return(68);
      case 0x4c0: ConsumeBits(bs, 10); return(70);
      case 0x4be: ConsumeBits(bs, 10); return(71);
      case 0x4bc: ConsumeBits(bs, 10); return(72);
      case 0x4ba: ConsumeBits(bs, 10); return(73);
      case 0x4b8: ConsumeBits(bs, 10); return(75);
      case 0x4b6: ConsumeBits(bs, 10); return(76);
      case 0x4b4: ConsumeBits(bs, 10); return(77);
      case 0x4b2: ConsumeBits(bs, 10); return(78);
      case 0x4b0: ConsumeBits(bs, 10); return(79);
      case 0x4ae: ConsumeBits(bs, 10); return(80);
      case 0x4ac: ConsumeBits(bs, 10); return(81);
      case 0x4aa: ConsumeBits(bs, 10); return(82);
      case 0x4a8: ConsumeBits(bs, 10); return(83);
      case 0x4a6: ConsumeBits(bs, 10); return(84);
      case 0x4a4: ConsumeBits(bs, 10); return(85);
      case 0x4a2: ConsumeBits(bs, 10); return(86);
      case 0x4a0: ConsumeBits(bs, 10); return(87);
      case 0x49e: ConsumeBits(bs, 10); return(88);
      case 0x49c: ConsumeBits(bs, 10); return(89);
      case 0x49a: ConsumeBits(bs, 10); return(90);
      case 0x498: ConsumeBits(bs, 10); return(92);
      case 0x496: ConsumeBits(bs, 10); return(93);
      case 0x494: ConsumeBits(bs, 10); return(94);
      case 0x492: ConsumeBits(bs, 10); return(95);
      case 0x490: ConsumeBits(bs, 10); return(96);
      case 0x48e: ConsumeBits(bs, 10); return(97);
      case 0x48c: ConsumeBits(bs, 10); return(98);
      case 0x48a: ConsumeBits(bs, 10); return(99);
      case 0x488: ConsumeBits(bs, 10); return(100);
      case 0x486: ConsumeBits(bs, 10); return(101);
      case 0x484: ConsumeBits(bs, 10); return(102);
      case 0x482: ConsumeBits(bs, 10); return(103);
      case 0x480: ConsumeBits(bs, 10); return(104);
      case 0x47e: ConsumeBits(bs, 10); return(105);
      case 0x47c: ConsumeBits(bs, 10); return(106);
      case 0x47a: ConsumeBits(bs, 10); return(107);
      case 0x478: ConsumeBits(bs, 10); return(108);
      case 0x476: ConsumeBits(bs, 10); return(109);
      case 0x474: ConsumeBits(bs, 10); return(110);
      case 0x472: ConsumeBits(bs, 10); return(111);
      case 0x470: ConsumeBits(bs, 10); return(112);
      case 0x46e: ConsumeBits(bs, 10); return(113);
      case 0x46c: ConsumeBits(bs, 10); return(114);
      case 0x46a: ConsumeBits(bs, 10); return(115);
      case 0x468: ConsumeBits(bs, 10); return(116);
      case 0x466: ConsumeBits(bs, 10); return(118);
      case 0x464: ConsumeBits(bs, 10); return(119);
      case 0x462: ConsumeBits(bs, 10); return(120);
      case 0x460: ConsumeBits(bs, 10); return(121);
      case 0x45e: ConsumeBits(bs, 10); return(122);
      case 0x45c: ConsumeBits(bs, 10); return(123);
      case 0x45a: ConsumeBits(bs, 10); return(124);
      case 0x458: ConsumeBits(bs, 10); return(125);
      case 0x456: ConsumeBits(bs, 10); return(126);
      case 0x454: ConsumeBits(bs, 10); return(127);
      case 0x452: ConsumeBits(bs, 10); return(128);
      case 0x450: ConsumeBits(bs, 10); return(129);
      case 0x44e: ConsumeBits(bs, 10); return(130);
      case 0x44c: ConsumeBits(bs, 10); return(131);
      case 0x44a: ConsumeBits(bs, 10); return(132);
      case 0x448: ConsumeBits(bs, 10); return(133);
      case 0x446: ConsumeBits(bs, 10); return(135);
      case 0x444: ConsumeBits(bs, 10); return(136);
      case 0x442: ConsumeBits(bs, 10); return(137);
      case 0x440: ConsumeBits(bs, 10); return(139);
      case 0x43e: ConsumeBits(bs, 10); return(140);
      case 0x43c: ConsumeBits(bs, 10); return(141);
      case 0x43a: ConsumeBits(bs, 10); return(142);
      case 0x438: ConsumeBits(bs, 10); return(143);
      case 0x436: ConsumeBits(bs, 10); return(145);
      case 0x434: ConsumeBits(bs, 10); return(146);
      case 0x432: ConsumeBits(bs, 10); return(148);
      case 0x430: ConsumeBits(bs, 10); return(149);
      case 0x42e: ConsumeBits(bs, 10); return(150);
      case 0x42c: ConsumeBits(bs, 10); return(151);
      case 0x42a: ConsumeBits(bs, 10); return(152);
      case 0x428: ConsumeBits(bs, 10); return(153);
      case 0x426: ConsumeBits(bs, 10); return(154);
      case 0x424: ConsumeBits(bs, 10); return(155);
      case 0x422: ConsumeBits(bs, 10); return(156);
      case 0x420: ConsumeBits(bs, 10); return(157);
      case 0x41e: ConsumeBits(bs, 10); return(158);
      case 0x41c: ConsumeBits(bs, 10); return(159);
      case 0x41a: ConsumeBits(bs, 10); return(161);
      case 0x418: ConsumeBits(bs, 10); return(162);
      case 0x416: ConsumeBits(bs, 10); return(163);
      case 0x414: ConsumeBits(bs, 10); return(164);
      case 0x412: ConsumeBits(bs, 10); return(165);
      case 0x410: ConsumeBits(bs, 10); return(166);
      case 0x40e: ConsumeBits(bs, 10); return(168);
      case 0x40c: ConsumeBits(bs, 10); return(169);
      case 0x40a: ConsumeBits(bs, 10); return(170);
      case 0x408: ConsumeBits(bs, 10); return(171);
      case 0x406: ConsumeBits(bs, 10); return(173);
      case 0x404: ConsumeBits(bs, 10); return(174);
      case 0x402: ConsumeBits(bs, 10); return(175);
      case 0x400: ConsumeBits(bs, 10); return(177);
      case 0x3fe: ConsumeBits(bs, 10); return(178);
      case 0x3fc: ConsumeBits(bs, 10); return(179);
      case 0x3fa: ConsumeBits(bs, 10); return(180);
      case 0x3f8: ConsumeBits(bs, 10); return(181);
      case 0x3f6: ConsumeBits(bs, 10); return(182);
      case 0x3f4: ConsumeBits(bs, 10); return(183);
      case 0x3f2: ConsumeBits(bs, 10); return(184);
      case 0x3f0: ConsumeBits(bs, 10); return(186);
      case 0x3ee: ConsumeBits(bs, 10); return(187);
      case 0x3ec: ConsumeBits(bs, 10); return(188);
      case 0x3ea: ConsumeBits(bs, 10); return(189);
      case 0x3e8: ConsumeBits(bs, 10); return(190);
      case 0x3e6: ConsumeBits(bs, 10); return(191);
      case 0x3e4: ConsumeBits(bs, 10); return(192);
      case 0x3e2: ConsumeBits(bs, 10); return(193);
      case 0x3e0: ConsumeBits(bs, 10); return(194);
      case 0x3de: ConsumeBits(bs, 10); return(195);
      case 0x3dc: ConsumeBits(bs, 10); return(196);
      case 0x3da: ConsumeBits(bs, 10); return(197);
      case 0x3d8: ConsumeBits(bs, 10); return(198);
      case 0x3d6: ConsumeBits(bs, 10); return(199);
      case 0x3d4: ConsumeBits(bs, 10); return(201);
      case 0x3d2: ConsumeBits(bs, 10); return(202);
      case 0x3d0: ConsumeBits(bs, 10); return(204);
      case 0x3ce: ConsumeBits(bs, 10); return(205);
      case 0x3cc: ConsumeBits(bs, 10); return(206);
      case 0x3ca: ConsumeBits(bs, 10); return(207);
      case 0x3c8: ConsumeBits(bs, 10); return(208);
      case 0x3c6: ConsumeBits(bs, 10); return(209);
      case 0x3c4: ConsumeBits(bs, 10); return(210);
      case 0x3c2: ConsumeBits(bs, 10); return(211);
      case 0x3c0: ConsumeBits(bs, 10); return(212);
      case 0x3be: ConsumeBits(bs, 10); return(213);
      case 0x3bc: ConsumeBits(bs, 10); return(214);
      case 0x3ba: ConsumeBits(bs, 10); return(215);
      case 0x3b8: ConsumeBits(bs, 10); return(217);
      case 0x3b6: ConsumeBits(bs, 10); return(218);
      case 0x3b4: ConsumeBits(bs, 10); return(219);
      case 0x3b2: ConsumeBits(bs, 10); return(220);
      case 0x3b0: ConsumeBits(bs, 10); return(221);
      case 0x3ae: ConsumeBits(bs, 10); return(222);
      case 0x3ac: ConsumeBits(bs, 10); return(223);
      case 0x3aa: ConsumeBits(bs, 10); return(224);
      case 0x3a8: ConsumeBits(bs, 10); return(225);
      case 0x3a6: ConsumeBits(bs, 10); return(226);
      case 0x3a4: ConsumeBits(bs, 10); return(227);
      case 0x3a2: ConsumeBits(bs, 10); return(228);
      case 0x3a0: ConsumeBits(bs, 10); return(231);
      case 0x39e: ConsumeBits(bs, 10); return(232);
      case 0x39c: ConsumeBits(bs, 10); return(233);
      case 0x39a: ConsumeBits(bs, 10); return(234);
      case 0x398: ConsumeBits(bs, 10); return(235);
      case 0x396: ConsumeBits(bs, 10); return(238);
      case 0x394: ConsumeBits(bs, 10); return(239);
      case 0x392: ConsumeBits(bs, 10); return(241);
      case 0x390: ConsumeBits(bs, 10); return(242);
      case 0x38e: ConsumeBits(bs, 10); return(243);
      case 0x38c: ConsumeBits(bs, 10); return(244);
      case 0x38a: ConsumeBits(bs, 10); return(245);
      case 0x388: ConsumeBits(bs, 10); return(247);
      case 0x386: ConsumeBits(bs, 10); return(248);
      case 0x384: ConsumeBits(bs, 10); return(249);
      case 0x382: ConsumeBits(bs, 10); return(250);
      case 0x380: ConsumeBits(bs, 10); return(251);
      case 0x37e: ConsumeBits(bs, 10); return(252);
      case 0x37c: ConsumeBits(bs, 10); return(253);
      case 0x37a: ConsumeBits(bs, 10); return(254);
      case 0x378: ConsumeBits(bs, 10); return(255);
      case 0x376: ConsumeBits(bs, 10); return(256);
      case 0x374: ConsumeBits(bs, 10); return(258);
      case 0x372: ConsumeBits(bs, 10); return(259);
      case 0x370: ConsumeBits(bs, 10); return(260);
      case 0x36e: ConsumeBits(bs, 10); return(261);
      case 0x36c: ConsumeBits(bs, 10); return(263);
      case 0x36a: ConsumeBits(bs, 10); return(264);
      case 0x368: ConsumeBits(bs, 10); return(265);
      case 0x366: ConsumeBits(bs, 10); return(266);
      case 0x364: ConsumeBits(bs, 10); return(267);
      case 0x362: ConsumeBits(bs, 10); return(268);
      case 0x360: ConsumeBits(bs, 10); return(269);
      case 0x35e: ConsumeBits(bs, 10); return(270);
      case 0x35c: ConsumeBits(bs, 10); return(271);
      case 0x35a: ConsumeBits(bs, 10); return(272);
      case 0x358: ConsumeBits(bs, 10); return(273);
      case 0x356: ConsumeBits(bs, 10); return(274);
      case 0x354: ConsumeBits(bs, 10); return(275);
      case 0x352: ConsumeBits(bs, 10); return(276);
      case 0x350: ConsumeBits(bs, 10); return(277);
      case 0x34e: ConsumeBits(bs, 10); return(278);
      case 0x34c: ConsumeBits(bs, 10); return(279);
      case 0x34a: ConsumeBits(bs, 10); return(280);
      case 0x348: ConsumeBits(bs, 10); return(281);
      case 0x346: ConsumeBits(bs, 10); return(282);
      case 0x344: ConsumeBits(bs, 10); return(283);
      case 0x342: ConsumeBits(bs, 10); return(284);
      case 0x340: ConsumeBits(bs, 10); return(285);
      case 0x33e: ConsumeBits(bs, 10); return(286);
      case 0x33c: ConsumeBits(bs, 10); return(287);
      case 0x33a: ConsumeBits(bs, 10); return(288);
      case 0x338: ConsumeBits(bs, 10); return(289);
      case 0x336: ConsumeBits(bs, 10); return(290);
      case 0x334: ConsumeBits(bs, 10); return(291);
      case 0x332: ConsumeBits(bs, 10); return(292);
      case 0x330: ConsumeBits(bs, 10); return(293);
      case 0x32e: ConsumeBits(bs, 10); return(294);
      case 0x32c: ConsumeBits(bs, 10); return(295);
      case 0x32a: ConsumeBits(bs, 10); return(296);
      case 0x328: ConsumeBits(bs, 10); return(297);
      case 0x326: ConsumeBits(bs, 10); return(298);
      case 0x324: ConsumeBits(bs, 10); return(300);
      case 0x322: ConsumeBits(bs, 10); return(302);
      case 0x320: ConsumeBits(bs, 10); return(303);
      case 0x31e: ConsumeBits(bs, 10); return(304);
      case 0x31c: ConsumeBits(bs, 10); return(305);
      case 0x31a: ConsumeBits(bs, 10); return(306);
      case 0x318: ConsumeBits(bs, 10); return(307);
      case 0x316: ConsumeBits(bs, 10); return(308);
      case 0x314: ConsumeBits(bs, 10); return(309);
      case 0x312: ConsumeBits(bs, 10); return(310);
      case 0x310: ConsumeBits(bs, 10); return(311);
      case 0x30e: ConsumeBits(bs, 10); return(312);
      case 0x30c: ConsumeBits(bs, 10); return(313);
      case 0x30a: ConsumeBits(bs, 10); return(314);
      case 0x308: ConsumeBits(bs, 10); return(315);
      case 0x306: ConsumeBits(bs, 10); return(317);
      case 0x304: ConsumeBits(bs, 10); return(318);
      case 0x302: ConsumeBits(bs, 10); return(319);
      case 0x300: ConsumeBits(bs, 10); return(320);
      case 0x2fe: ConsumeBits(bs, 10); return(321);
      case 0x2fc: ConsumeBits(bs, 10); return(322);
      case 0x2fa: ConsumeBits(bs, 10); return(323);
      case 0x2f8: ConsumeBits(bs, 10); return(325);
      case 0x2f6: ConsumeBits(bs, 10); return(326);
      case 0x2f4: ConsumeBits(bs, 10); return(327);
      case 0x2f2: ConsumeBits(bs, 10); return(329);
      case 0x2f0: ConsumeBits(bs, 10); return(330);
      case 0x2ee: ConsumeBits(bs, 10); return(331);
      case 0x2ec: ConsumeBits(bs, 10); return(332);
      case 0x2ea: ConsumeBits(bs, 10); return(333);
      case 0x2e8: ConsumeBits(bs, 10); return(334);
      case 0x2e6: ConsumeBits(bs, 10); return(335);
      case 0x2e4: ConsumeBits(bs, 10); return(336);
      case 0x2e2: ConsumeBits(bs, 10); return(337);
      case 0x2e0: ConsumeBits(bs, 10); return(338);
      case 0x2de: ConsumeBits(bs, 10); return(339);
      case 0x2dc: ConsumeBits(bs, 10); return(340);
      case 0x2da: ConsumeBits(bs, 10); return(341);
      case 0x2d8: ConsumeBits(bs, 10); return(342);
      case 0x2d6: ConsumeBits(bs, 10); return(343);
      case 0x2d4: ConsumeBits(bs, 10); return(344);
      case 0x2d2: ConsumeBits(bs, 10); return(345);
      case 0x2d0: ConsumeBits(bs, 10); return(346);
      case 0x2ce: ConsumeBits(bs, 10); return(347);
      case 0x2cc: ConsumeBits(bs, 10); return(348);
      case 0x2ca: ConsumeBits(bs, 10); return(349);
      case 0x2c8: ConsumeBits(bs, 10); return(350);
      case 0x2c6: ConsumeBits(bs, 10); return(351);
      case 0x2c4: ConsumeBits(bs, 10); return(352);
      case 0x2c2: ConsumeBits(bs, 10); return(353);
      case 0x2c0: ConsumeBits(bs, 10); return(354);
      case 0x2be: ConsumeBits(bs, 10); return(355);
      case 0x2bc: ConsumeBits(bs, 10); return(357);
      case 0x2ba: ConsumeBits(bs, 10); return(358);
      case 0x2b8: ConsumeBits(bs, 10); return(359);
      case 0x2b6: ConsumeBits(bs, 10); return(360);
      case 0x2b4: ConsumeBits(bs, 10); return(362);
      case 0x2b2: ConsumeBits(bs, 10); return(363);
      case 0x2b0: ConsumeBits(bs, 10); return(364);
      case 0x2ae: ConsumeBits(bs, 10); return(365);
      case 0x2ac: ConsumeBits(bs, 10); return(366);
      case 0x2aa: ConsumeBits(bs, 10); return(367);
      case 0x2a8: ConsumeBits(bs, 10); return(368);
      case 0x2a6: ConsumeBits(bs, 10); return(369);
      case 0x2a4: ConsumeBits(bs, 10); return(370);
      case 0x2a2: ConsumeBits(bs, 10); return(371);
      case 0x2a0: ConsumeBits(bs, 10); return(372);
      case 0x29e: ConsumeBits(bs, 10); return(373);
      case 0x29c: ConsumeBits(bs, 10); return(374);
      case 0x29a: ConsumeBits(bs, 10); return(375);
      case 0x298: ConsumeBits(bs, 10); return(376);
      case 0x296: ConsumeBits(bs, 10); return(377);
      case 0x294: ConsumeBits(bs, 10); return(378);
      case 0x292: ConsumeBits(bs, 10); return(379);
      case 0x290: ConsumeBits(bs, 10); return(381);
      case 0x28e: ConsumeBits(bs, 10); return(382);
      case 0x28c: ConsumeBits(bs, 10); return(383);
      case 0x28a: ConsumeBits(bs, 10); return(384);
      case 0x288: ConsumeBits(bs, 10); return(385);
      case 0x286: ConsumeBits(bs, 10); return(386);
      case 0x284: ConsumeBits(bs, 10); return(387);
      case 0x282: ConsumeBits(bs, 10); return(388);
      case 0x280: ConsumeBits(bs, 10); return(389);
      case 0x27e: ConsumeBits(bs, 10); return(392);
      case 0x27c: ConsumeBits(bs, 10); return(393);
      case 0x27a: ConsumeBits(bs, 10); return(394);
      case 0x278: ConsumeBits(bs, 10); return(395);
      case 0x276: ConsumeBits(bs, 10); return(397);
      case 0x274: ConsumeBits(bs, 10); return(398);
      case 0x272: ConsumeBits(bs, 10); return(399);
      case 0x270: ConsumeBits(bs, 10); return(400);
      case 0x26e: ConsumeBits(bs, 10); return(401);
      case 0x26c: ConsumeBits(bs, 10); return(402);
      case 0x26a: ConsumeBits(bs, 10); return(403);
      case 0x268: ConsumeBits(bs, 10); return(406);
      case 0x266: ConsumeBits(bs, 10); return(407);
      case 0x264: ConsumeBits(bs, 10); return(408);
      case 0x262: ConsumeBits(bs, 10); return(409);
      case 0x260: ConsumeBits(bs, 10); return(410);
      case 0x25e: ConsumeBits(bs, 10); return(413);
      case 0x25c: ConsumeBits(bs, 10); return(414);
      case 0x25a: ConsumeBits(bs, 10); return(415);
      case 0x258: ConsumeBits(bs, 10); return(417);
      case 0x256: ConsumeBits(bs, 10); return(418);
      case 0x254: ConsumeBits(bs, 10); return(420);
      case 0x252: ConsumeBits(bs, 10); return(421);
      case 0x250: ConsumeBits(bs, 10); return(422);
      case 0x24e: ConsumeBits(bs, 10); return(423);
      case 0x24c: ConsumeBits(bs, 10); return(424);
      case 0x24a: ConsumeBits(bs, 10); return(426);
      case 0x248: ConsumeBits(bs, 10); return(427);
      case 0x246: ConsumeBits(bs, 10); return(428);
      case 0x244: ConsumeBits(bs, 10); return(429);
      case 0x242: ConsumeBits(bs, 10); return(430);
      case 0x240: ConsumeBits(bs, 10); return(431);
      case 0x23e: ConsumeBits(bs, 10); return(434);
      case 0x23c: ConsumeBits(bs, 10); return(435);
      case 0x23a: ConsumeBits(bs, 10); return(436);
      case 0x238: ConsumeBits(bs, 10); return(437);
      case 0x236: ConsumeBits(bs, 10); return(438);
      case 0x234: ConsumeBits(bs, 10); return(439);
      case 0x232: ConsumeBits(bs, 10); return(441);
      case 0x230: ConsumeBits(bs, 10); return(442);
      case 0x22e: ConsumeBits(bs, 10); return(443);
      case 0x22c: ConsumeBits(bs, 10); return(445);
      case 0x22a: ConsumeBits(bs, 10); return(446);
      case 0x228: ConsumeBits(bs, 10); return(449);
      case 0x226: ConsumeBits(bs, 10); return(450);
      case 0x224: ConsumeBits(bs, 10); return(451);
      case 0x222: ConsumeBits(bs, 10); return(452);
      case 0x220: ConsumeBits(bs, 10); return(453);
      case 0x21e: ConsumeBits(bs, 10); return(454);
      case 0x21c: ConsumeBits(bs, 10); return(455);
      case 0x21a: ConsumeBits(bs, 10); return(456);
      case 0x218: ConsumeBits(bs, 10); return(457);
      case 0x216: ConsumeBits(bs, 10); return(458);
      case 0x214: ConsumeBits(bs, 10); return(459);
      case 0x212: ConsumeBits(bs, 10); return(460);
      case 0x210: ConsumeBits(bs, 10); return(461);
      case 0x20e: ConsumeBits(bs, 10); return(462);
      case 0x20c: ConsumeBits(bs, 10); return(463);
      case 0x20a: ConsumeBits(bs, 10); return(464);
      case 0x208: ConsumeBits(bs, 10); return(465);
      case 0x206: ConsumeBits(bs, 10); return(466);
      case 0x204: ConsumeBits(bs, 10); return(469);
      case 0x202: ConsumeBits(bs, 10); return(470);
      case 0x200: ConsumeBits(bs, 10); return(471);
      case 0x1fe: ConsumeBits(bs, 10); return(473);
      case 0x1fc: ConsumeBits(bs, 10); return(474);
      case 0x1fa: ConsumeBits(bs, 10); return(475);
      case 0x1f8: ConsumeBits(bs, 10); return(477);
      case 0x1f6: ConsumeBits(bs, 10); return(478);
      case 0x1f4: ConsumeBits(bs, 10); return(479);
      case 0x1f2: ConsumeBits(bs, 10); return(480);
      case 0x1f0: ConsumeBits(bs, 10); return(481);
      case 0x1ee: ConsumeBits(bs, 10); return(482);
      case 0x1ec: ConsumeBits(bs, 10); return(483);
      case 0x1ea: ConsumeBits(bs, 10); return(484);
      case 0x1e8: ConsumeBits(bs, 10); return(487);
      case 0x1e6: ConsumeBits(bs, 10); return(488);
      case 0x1e4: ConsumeBits(bs, 10); return(489);
      case 0x1e2: ConsumeBits(bs, 10); return(490);
      case 0x1e0: ConsumeBits(bs, 10); return(491);
      case 0x1de: ConsumeBits(bs, 10); return(492);
      case 0x1dc: ConsumeBits(bs, 10); return(493);
      case 0x1da: ConsumeBits(bs, 10); return(494);
      case 0x1d8: ConsumeBits(bs, 10); return(495);
      case 0x1d6: ConsumeBits(bs, 10); return(496);
      case 0x1d4: ConsumeBits(bs, 10); return(497);
      case 0x1d2: ConsumeBits(bs, 10); return(498);
      case 0x1d0: ConsumeBits(bs, 10); return(499);
      case 0x1ce: ConsumeBits(bs, 10); return(500);
      case 0x1cc: ConsumeBits(bs, 10); return(501);
      case 0x1ca: ConsumeBits(bs, 10); return(502);
      case 0x1c8: ConsumeBits(bs, 10); return(503);
      case 0x1c6: ConsumeBits(bs, 10); return(505);
      case 0x1c4: ConsumeBits(bs, 10); return(506);
      case 0x1c2: ConsumeBits(bs, 10); return(507);
      case 0x1c0: ConsumeBits(bs, 10); return(508);
      case 0x1be: ConsumeBits(bs, 10); return(509);
      case 0x1bc: ConsumeBits(bs, 10); return(510);
      case 0x1ba: ConsumeBits(bs, 10); return(511);
      case 0x1b8: ConsumeBits(bs, 10); return(512);
      case 0x1b6: ConsumeBits(bs, 10); return(513);
      case 0x1b4: ConsumeBits(bs, 10); return(514);
      case 0x1b2: ConsumeBits(bs, 10); return(515);
      case 0x1b0: ConsumeBits(bs, 10); return(516);
      case 0x1ae: ConsumeBits(bs, 10); return(517);
      case 0x1ac: ConsumeBits(bs, 10); return(518);
      case 0x1aa: ConsumeBits(bs, 10); return(519);
      case 0x1a8: ConsumeBits(bs, 10); return(520);
      case 0x1a6: ConsumeBits(bs, 10); return(521);
      case 0x1a4: ConsumeBits(bs, 10); return(522);
      case 0x1a2: ConsumeBits(bs, 10); return(523);
      case 0x1a0: ConsumeBits(bs, 10); return(524);
      case 0x19e: ConsumeBits(bs, 10); return(525);
      case 0x19c: ConsumeBits(bs, 10); return(527);
      case 0x19a: ConsumeBits(bs, 10); return(528);
      case 0x198: ConsumeBits(bs, 10); return(529);
      case 0x196: ConsumeBits(bs, 10); return(530);
      case 0x194: ConsumeBits(bs, 10); return(531);
      case 0x192: ConsumeBits(bs, 10); return(532);
      case 0x190: ConsumeBits(bs, 10); return(533);
      case 0x18e: ConsumeBits(bs, 10); return(534);
      case 0x18c: ConsumeBits(bs, 10); return(535);
      case 0x18a: ConsumeBits(bs, 10); return(536);
      case 0x188: ConsumeBits(bs, 10); return(537);
      case 0x186: ConsumeBits(bs, 10); return(538);
      case 0x184: ConsumeBits(bs, 10); return(539);
      case 0x182: ConsumeBits(bs, 10); return(540);
      case 0x180: ConsumeBits(bs, 10); return(541);
      case 0x17e: ConsumeBits(bs, 10); return(542);
      case 0x17c: ConsumeBits(bs, 10); return(543);
      case 0x17a: ConsumeBits(bs, 10); return(544);
      case 0x178: ConsumeBits(bs, 10); return(545);
      case 0x176: ConsumeBits(bs, 10); return(546);
      case 0x174: ConsumeBits(bs, 10); return(548);
      case 0x172: ConsumeBits(bs, 10); return(549);
      case 0x170: ConsumeBits(bs, 10); return(550);
      case 0x16e: ConsumeBits(bs, 10); return(551);
      case 0x16c: ConsumeBits(bs, 10); return(553);
      case 0x16a: ConsumeBits(bs, 10); return(554);
      case 0x168: ConsumeBits(bs, 10); return(556);
      case 0x166: ConsumeBits(bs, 10); return(557);
      case 0x164: ConsumeBits(bs, 10); return(558);
      case 0x162: ConsumeBits(bs, 10); return(559);
      case 0x160: ConsumeBits(bs, 10); return(560);
      case 0x15e: ConsumeBits(bs, 10); return(561);
      case 0x15c: ConsumeBits(bs, 10); return(562);
      case 0x15a: ConsumeBits(bs, 10); return(563);
      case 0x158: ConsumeBits(bs, 10); return(564);
      case 0x156: ConsumeBits(bs, 10); return(565);
      case 0x154: ConsumeBits(bs, 10); return(566);
      case 0x152: ConsumeBits(bs, 10); return(567);
      case 0x150: ConsumeBits(bs, 10); return(568);
      case 0x14e: ConsumeBits(bs, 10); return(569);
      case 0x14c: ConsumeBits(bs, 10); return(570);
      case 0x14a: ConsumeBits(bs, 10); return(571);
      case 0x148: ConsumeBits(bs, 10); return(572);
      case 0x146: ConsumeBits(bs, 10); return(573);
      case 0x144: ConsumeBits(bs, 10); return(574);
      case 0x142: ConsumeBits(bs, 10); return(575);
      case 0x140: ConsumeBits(bs, 10); return(576);
      case 0x13e: ConsumeBits(bs, 10); return(577);
      case 0x13c: ConsumeBits(bs, 10); return(578);
      case 0x13a: ConsumeBits(bs, 10); return(579);
      case 0x138: ConsumeBits(bs, 10); return(580);
      case 0x136: ConsumeBits(bs, 10); return(581);
      case 0x134: ConsumeBits(bs, 10); return(582);
      case 0x132: ConsumeBits(bs, 10); return(583);
      case 0x130: ConsumeBits(bs, 10); return(584);
      case 0x12e: ConsumeBits(bs, 10); return(585);
      case 0x12c: ConsumeBits(bs, 10); return(586);
      case 0x12a: ConsumeBits(bs, 10); return(587);
      case 0x128: ConsumeBits(bs, 10); return(588);
      case 0x126: ConsumeBits(bs, 10); return(589);
      case 0x124: ConsumeBits(bs, 10); return(591);
      case 0x122: ConsumeBits(bs, 10); return(592);
      case 0x120: ConsumeBits(bs, 10); return(593);
      case 0x11e: ConsumeBits(bs, 10); return(594);
      case 0x11c: ConsumeBits(bs, 10); return(596);
      case 0x11a: ConsumeBits(bs, 10); return(597);
      case 0x118: ConsumeBits(bs, 10); return(600);
      case 0x116: ConsumeBits(bs, 10); return(601);
      case 0x114: ConsumeBits(bs, 10); return(602);
      case 0x112: ConsumeBits(bs, 10); return(603);
      case 0x110: ConsumeBits(bs, 10); return(605);
      case 0x10e: ConsumeBits(bs, 10); return(606);
      case 0x10c: ConsumeBits(bs, 10); return(607);
      case 0x10a: ConsumeBits(bs, 10); return(608);
      case 0x108: ConsumeBits(bs, 10); return(609);
      case 0x106: ConsumeBits(bs, 10); return(610);
      case 0x104: ConsumeBits(bs, 10); return(611);
      case 0x102: ConsumeBits(bs, 10); return(612);
      case 0x100: ConsumeBits(bs, 10); return(613);
      case 0xfe: ConsumeBits(bs, 10); return(614);
      case 0xfc: ConsumeBits(bs, 10); return(615);
      case 0xfa: ConsumeBits(bs, 10); return(616);
      case 0xf8: ConsumeBits(bs, 10); return(617);
      case 0xf6: ConsumeBits(bs, 10); return(618);
      case 0xf4: ConsumeBits(bs, 10); return(619);
      case 0xf2: ConsumeBits(bs, 10); return(620);
      case 0xf0: ConsumeBits(bs, 10); return(621);
      case 0xee: ConsumeBits(bs, 10); return(622);
      case 0xec: ConsumeBits(bs, 10); return(624);
      case 0xea: ConsumeBits(bs, 10); return(625);
      case 0xe8: ConsumeBits(bs, 10); return(626);
      case 0xe6: ConsumeBits(bs, 10); return(627);
      case 0xe4: ConsumeBits(bs, 10); return(629);
      case 0xe2: ConsumeBits(bs, 10); return(630);
      case 0xe0: ConsumeBits(bs, 10); return(631);
      case 0xde: ConsumeBits(bs, 10); return(632);
      case 0xdc: ConsumeBits(bs, 10); return(634);
      case 0xda: ConsumeBits(bs, 10); return(635);
      case 0xd8: ConsumeBits(bs, 10); return(636);
      case 0xd6: ConsumeBits(bs, 10); return(637);
      case 0xd4: ConsumeBits(bs, 10); return(638);
      case 0xd2: ConsumeBits(bs, 10); return(639);
      case 0xd0: ConsumeBits(bs, 10); return(640);
      case 0xce: ConsumeBits(bs, 10); return(641);
      case 0xcc: ConsumeBits(bs, 10); return(642);
      case 0xca: ConsumeBits(bs, 10); return(643);
      case 0xc8: ConsumeBits(bs, 10); return(644);
      case 0xc6: ConsumeBits(bs, 10); return(645);
      case 0xc4: ConsumeBits(bs, 10); return(646);
      case 0xc2: ConsumeBits(bs, 10); return(648);
      case 0xc0: ConsumeBits(bs, 10); return(649);
      case 0xbe: ConsumeBits(bs, 10); return(650);
      case 0xbc: ConsumeBits(bs, 10); return(651);
      case 0xba: ConsumeBits(bs, 10); return(652);
      case 0xb8: ConsumeBits(bs, 10); return(653);
      case 0xb6: ConsumeBits(bs, 10); return(654);
      case 0xb4: ConsumeBits(bs, 10); return(655);
      case 0xb2: ConsumeBits(bs, 10); return(656);
      case 0xb0: ConsumeBits(bs, 10); return(657);
      case 0xae: ConsumeBits(bs, 10); return(658);
      case 0xac: ConsumeBits(bs, 10); return(660);
      case 0xaa: ConsumeBits(bs, 10); return(661);
      case 0xa8: ConsumeBits(bs, 10); return(662);
      case 0xa6: ConsumeBits(bs, 10); return(664);
      case 0xa4: ConsumeBits(bs, 10); return(665);
      case 0xa2: ConsumeBits(bs, 10); return(666);
      case 0xa0: ConsumeBits(bs, 10); return(667);
      case 0x9e: ConsumeBits(bs, 10); return(668);
      case 0x9c: ConsumeBits(bs, 10); return(669);
      case 0x9a: ConsumeBits(bs, 10); return(670);
      case 0x98: ConsumeBits(bs, 10); return(671);
      case 0x96: ConsumeBits(bs, 10); return(673);
      case 0x94: ConsumeBits(bs, 10); return(674);
      case 0x92: ConsumeBits(bs, 10); return(675);
      case 0x90: ConsumeBits(bs, 10); return(676);
      case 0x8e: ConsumeBits(bs, 10); return(677);
      case 0x8c: ConsumeBits(bs, 10); return(679);
      case 0x8a: ConsumeBits(bs, 10); return(680);
      case 0x88: ConsumeBits(bs, 10); return(681);
      case 0x86: ConsumeBits(bs, 10); return(682);
      case 0x84: ConsumeBits(bs, 10); return(683);
      case 0x82: ConsumeBits(bs, 10); return(684);
      case 0x80: ConsumeBits(bs, 10); return(685);
      case 0x7e: ConsumeBits(bs, 10); return(687);
      case 0x7c: ConsumeBits(bs, 10); return(688);
      case 0x7a: ConsumeBits(bs, 10); return(689);
      case 0x78: ConsumeBits(bs, 10); return(690);
      case 0x76: ConsumeBits(bs, 10); return(692);
      case 0x74: ConsumeBits(bs, 10); return(693);
      case 0x72: ConsumeBits(bs, 10); return(694);
      case 0x70: ConsumeBits(bs, 10); return(695);
      case 0x6e: ConsumeBits(bs, 10); return(697);
      case 0x6c: ConsumeBits(bs, 10); return(698);
      case 0x6a: ConsumeBits(bs, 10); return(700);
      case 0x68: ConsumeBits(bs, 10); return(701);
      case 0x66: ConsumeBits(bs, 10); return(702);
      case 0x64: ConsumeBits(bs, 10); return(703);
      case 0x62: ConsumeBits(bs, 10); return(738);
      case 0x60: ConsumeBits(bs, 10); return(740);
      case 0x5e: ConsumeBits(bs, 10); return(760);
      case 0x5c: ConsumeBits(bs, 10); return(761);
      case 0x5a: ConsumeBits(bs, 10); return(762);
      case 0x58: ConsumeBits(bs, 10); return(773);
      case 0x56: ConsumeBits(bs, 10); return(786);
      case 0x54: ConsumeBits(bs, 10); return(791);
      case 0x52: ConsumeBits(bs, 10); return(796);
   }
   switch (val & 0xffff) {
      case 0x51: ConsumeBits(bs, 11); return(704);
      case 0x50: ConsumeBits(bs, 11); return(705);
      case 0x4f: ConsumeBits(bs, 11); return(706);
      case 0x4e: ConsumeBits(bs, 11); return(707);
      case 0x4d: ConsumeBits(bs, 11); return(708);
      case 0x4c: ConsumeBits(bs, 11); return(709);
      case 0x4b: ConsumeBits(bs, 11); return(710);
      case 0x4a: ConsumeBits(bs, 11); return(711);
      case 0x49: ConsumeBits(bs, 11); return(712);
      case 0x48: ConsumeBits(bs, 11); return(713);
      case 0x47: ConsumeBits(bs, 11); return(714);
      case 0x46: ConsumeBits(bs, 11); return(715);
      case 0x45: ConsumeBits(bs, 11); return(716);
      case 0x44: ConsumeBits(bs, 11); return(717);
      case 0x43: ConsumeBits(bs, 11); return(718);
      case 0x42: ConsumeBits(bs, 11); return(720);
      case 0x41: ConsumeBits(bs, 11); return(721);
      case 0x40: ConsumeBits(bs, 11); return(722);
      case 0x3f: ConsumeBits(bs, 11); return(723);
      case 0x3e: ConsumeBits(bs, 11); return(724);
      case 0x3d: ConsumeBits(bs, 11); return(725);
      case 0x3c: ConsumeBits(bs, 11); return(726);
      case 0x3b: ConsumeBits(bs, 11); return(727);
      case 0x3a: ConsumeBits(bs, 11); return(728);
      case 0x39: ConsumeBits(bs, 11); return(729);
      case 0x38: ConsumeBits(bs, 11); return(730);
      case 0x37: ConsumeBits(bs, 11); return(732);
      case 0x36: ConsumeBits(bs, 11); return(733);
      case 0x35: ConsumeBits(bs, 11); return(734);
      case 0x34: ConsumeBits(bs, 11); return(735);
      case 0x33: ConsumeBits(bs, 11); return(736);
      case 0x32: ConsumeBits(bs, 11); return(737);
      case 0x31: ConsumeBits(bs, 11); return(741);
      case 0x30: ConsumeBits(bs, 11); return(742);
      case 0x2f: ConsumeBits(bs, 11); return(743);
      case 0x2e: ConsumeBits(bs, 11); return(744);
      case 0x2d: ConsumeBits(bs, 11); return(745);
      case 0x2c: ConsumeBits(bs, 11); return(746);
      case 0x2b: ConsumeBits(bs, 11); return(747);
      case 0x2a: ConsumeBits(bs, 11); return(748);
      case 0x29: ConsumeBits(bs, 11); return(749);
      case 0x28: ConsumeBits(bs, 11); return(750);
      case 0x27: ConsumeBits(bs, 11); return(751);
      case 0x26: ConsumeBits(bs, 11); return(752);
      case 0x25: ConsumeBits(bs, 11); return(753);
      case 0x24: ConsumeBits(bs, 11); return(754);
      case 0x23: ConsumeBits(bs, 11); return(755);
      case 0x22: ConsumeBits(bs, 11); return(756);
      case 0x21: ConsumeBits(bs, 11); return(757);
      case 0x20: ConsumeBits(bs, 11); return(758);
      case 0x1f: ConsumeBits(bs, 11); return(759);
      case 0x1e: ConsumeBits(bs, 11); return(763);
      case 0x1d: ConsumeBits(bs, 11); return(764);
      case 0x1c: ConsumeBits(bs, 11); return(765);
      case 0x1b: ConsumeBits(bs, 11); return(766);
      case 0x1a: ConsumeBits(bs, 11); return(767);
      case 0x19: ConsumeBits(bs, 11); return(768);
      case 0x18: ConsumeBits(bs, 11); return(769);
      case 0x17: ConsumeBits(bs, 11); return(770);
      case 0x16: ConsumeBits(bs, 11); return(772);
      case 0x15: ConsumeBits(bs, 11); return(774);
      case 0x14: ConsumeBits(bs, 11); return(775);
      case 0x13: ConsumeBits(bs, 11); return(776);
      case 0x12: ConsumeBits(bs, 11); return(777);
      case 0x11: ConsumeBits(bs, 11); return(778);
      case 0x10: ConsumeBits(bs, 11); return(780);
      case 0xf: ConsumeBits(bs, 11); return(781);
      case 0xe: ConsumeBits(bs, 11); return(782);
      case 0xd: ConsumeBits(bs, 11); return(784);
      case 0xc: ConsumeBits(bs, 11); return(785);
      case 0xb: ConsumeBits(bs, 11); return(787);
      case 0xa: ConsumeBits(bs, 11); return(788);
      case 0x9: ConsumeBits(bs, 11); return(789);
      case 0x8: ConsumeBits(bs, 11); return(790);
      case 0x7: ConsumeBits(bs, 11); return(792);
      case 0x6: ConsumeBits(bs, 11); return(793);
      case 0x5: ConsumeBits(bs, 11); return(794);
      case 0x4: ConsumeBits(bs, 11); return(795);
      case 0x3: ConsumeBits(bs, 11); return(797);
      case 0x2: ConsumeBits(bs, 11); return(798);
      case 0x1: ConsumeBits(bs, 11); return(799);
   }
   SyntaxError("GetShell2TPCHuffCode");
   return(-1);
}
