#include "bitIn.h"
int GetShell2TPYHuffCode(Bitstream *bs) {
   unsigned short val = ShowBits(bs, 12);
   switch (val & 0xfe00) {
      case 0xe00: ConsumeBits(bs, 3); return(739);
   }
   switch (val & 0xff00) {
      case 0xd00: ConsumeBits(bs, 4); return(599);
   }
   switch (val & 0xffc0) {
      case 0xcc0: ConsumeBits(bs, 6); return(356);
      case 0xc80: ConsumeBits(bs, 6); return(416);
      case 0xc40: ConsumeBits(bs, 6); return(419);
      case 0xc00: ConsumeBits(bs, 6); return(447);
      case 0xbc0: ConsumeBits(bs, 6); return(699);
   }
   switch (val & 0xffe0) {
      case 0xba0: ConsumeBits(bs, 7); return(91);
      case 0xb80: ConsumeBits(bs, 7); return(354);
      case 0xb60: ConsumeBits(bs, 7); return(380);
      case 0xb40: ConsumeBits(bs, 7); return(411);
      case 0xb20: ConsumeBits(bs, 7); return(448);
      case 0xb00: ConsumeBits(bs, 7); return(468);
      case 0xae0: ConsumeBits(bs, 7); return(498);
      case 0xac0: ConsumeBits(bs, 7); return(590);
      case 0xaa0: ConsumeBits(bs, 7); return(598);
   }
   switch (val & 0xfff0) {
      case 0xa90: ConsumeBits(bs, 8); return(6);
      case 0xa80: ConsumeBits(bs, 8); return(23);
      case 0xa70: ConsumeBits(bs, 8); return(31);
      case 0xa60: ConsumeBits(bs, 8); return(97);
      case 0xa50: ConsumeBits(bs, 8); return(138);
      case 0xa40: ConsumeBits(bs, 8); return(176);
      case 0xa30: ConsumeBits(bs, 8); return(200);
      case 0xa20: ConsumeBits(bs, 8); return(203);
      case 0xa10: ConsumeBits(bs, 8); return(228);
      case 0xa00: ConsumeBits(bs, 8); return(236);
      case 0x9f0: ConsumeBits(bs, 8); return(240);
      case 0x9e0: ConsumeBits(bs, 8); return(256);
      case 0x9d0: ConsumeBits(bs, 8); return(261);
      case 0x9c0: ConsumeBits(bs, 8); return(316);
      case 0x9b0: ConsumeBits(bs, 8); return(357);
      case 0x9a0: ConsumeBits(bs, 8); return(360);
      case 0x990: ConsumeBits(bs, 8); return(384);
      case 0x980: ConsumeBits(bs, 8); return(396);
      case 0x970: ConsumeBits(bs, 8); return(412);
      case 0x960: ConsumeBits(bs, 8); return(418);
      case 0x950: ConsumeBits(bs, 8); return(440);
      case 0x940: ConsumeBits(bs, 8); return(472);
      case 0x930: ConsumeBits(bs, 8); return(481);
      case 0x920: ConsumeBits(bs, 8); return(615);
      case 0x910: ConsumeBits(bs, 8); return(678);
      case 0x900: ConsumeBits(bs, 8); return(686);
      case 0x8f0: ConsumeBits(bs, 8); return(733);
      case 0x8e0: ConsumeBits(bs, 8); return(750);
      case 0x8d0: ConsumeBits(bs, 8); return(773);
      case 0x8c0: ConsumeBits(bs, 8); return(779);
      case 0x8b0: ConsumeBits(bs, 8); return(783);
      case 0x8a0: ConsumeBits(bs, 8); return(786);
   }
   switch (val & 0xfff8) {
      case 0x898: ConsumeBits(bs, 9); return(2);
      case 0x890: ConsumeBits(bs, 9); return(3);
      case 0x888: ConsumeBits(bs, 9); return(5);
      case 0x880: ConsumeBits(bs, 9); return(8);
      case 0x878: ConsumeBits(bs, 9); return(27);
      case 0x870: ConsumeBits(bs, 9); return(29);
      case 0x868: ConsumeBits(bs, 9); return(30);
      case 0x860: ConsumeBits(bs, 9); return(37);
      case 0x858: ConsumeBits(bs, 9); return(38);
      case 0x850: ConsumeBits(bs, 9); return(52);
      case 0x848: ConsumeBits(bs, 9); return(53);
      case 0x840: ConsumeBits(bs, 9); return(59);
      case 0x838: ConsumeBits(bs, 9); return(64);
      case 0x830: ConsumeBits(bs, 9); return(74);
      case 0x828: ConsumeBits(bs, 9); return(98);
      case 0x820: ConsumeBits(bs, 9); return(104);
      case 0x818: ConsumeBits(bs, 9); return(115);
      case 0x810: ConsumeBits(bs, 9); return(117);
      case 0x808: ConsumeBits(bs, 9); return(118);
      case 0x800: ConsumeBits(bs, 9); return(134);
      case 0x7f8: ConsumeBits(bs, 9); return(139);
      case 0x7f0: ConsumeBits(bs, 9); return(144);
      case 0x7e8: ConsumeBits(bs, 9); return(147);
      case 0x7e0: ConsumeBits(bs, 9); return(149);
      case 0x7d8: ConsumeBits(bs, 9); return(159);
      case 0x7d0: ConsumeBits(bs, 9); return(164);
      case 0x7c8: ConsumeBits(bs, 9); return(167);
      case 0x7c0: ConsumeBits(bs, 9); return(171);
      case 0x7b8: ConsumeBits(bs, 9); return(184);
      case 0x7b0: ConsumeBits(bs, 9); return(187);
      case 0x7a8: ConsumeBits(bs, 9); return(208);
      case 0x7a0: ConsumeBits(bs, 9); return(217);
      case 0x798: ConsumeBits(bs, 9); return(229);
      case 0x790: ConsumeBits(bs, 9); return(230);
      case 0x788: ConsumeBits(bs, 9); return(233);
      case 0x780: ConsumeBits(bs, 9); return(237);
      case 0x778: ConsumeBits(bs, 9); return(244);
      case 0x770: ConsumeBits(bs, 9); return(245);
      case 0x768: ConsumeBits(bs, 9); return(247);
      case 0x760: ConsumeBits(bs, 9); return(260);
      case 0x758: ConsumeBits(bs, 9); return(267);
      case 0x750: ConsumeBits(bs, 9); return(273);
      case 0x748: ConsumeBits(bs, 9); return(277);
      case 0x740: ConsumeBits(bs, 9); return(293);
      case 0x738: ConsumeBits(bs, 9); return(301);
      case 0x730: ConsumeBits(bs, 9); return(307);
      case 0x728: ConsumeBits(bs, 9); return(329);
      case 0x720: ConsumeBits(bs, 9); return(336);
      case 0x718: ConsumeBits(bs, 9); return(342);
      case 0x710: ConsumeBits(bs, 9); return(350);
      case 0x708: ConsumeBits(bs, 9); return(352);
      case 0x700: ConsumeBits(bs, 9); return(358);
      case 0x6f8: ConsumeBits(bs, 9); return(364);
      case 0x6f0: ConsumeBits(bs, 9); return(367);
      case 0x6e8: ConsumeBits(bs, 9); return(376);
      case 0x6e0: ConsumeBits(bs, 9); return(387);
      case 0x6d8: ConsumeBits(bs, 9); return(388);
      case 0x6d0: ConsumeBits(bs, 9); return(397);
      case 0x6c8: ConsumeBits(bs, 9); return(404);
      case 0x6c0: ConsumeBits(bs, 9); return(420);
      case 0x6b8: ConsumeBits(bs, 9); return(425);
      case 0x6b0: ConsumeBits(bs, 9); return(432);
      case 0x6a8: ConsumeBits(bs, 9); return(435);
      case 0x6a0: ConsumeBits(bs, 9); return(444);
      case 0x698: ConsumeBits(bs, 9); return(471);
      case 0x690: ConsumeBits(bs, 9); return(476);
      case 0x688: ConsumeBits(bs, 9); return(480);
      case 0x680: ConsumeBits(bs, 9); return(502);
      case 0x678: ConsumeBits(bs, 9); return(523);
      case 0x670: ConsumeBits(bs, 9); return(526);
      case 0x668: ConsumeBits(bs, 9); return(549);
      case 0x660: ConsumeBits(bs, 9); return(577);
      case 0x658: ConsumeBits(bs, 9); return(584);
      case 0x650: ConsumeBits(bs, 9); return(594);
      case 0x648: ConsumeBits(bs, 9); return(596);
      case 0x640: ConsumeBits(bs, 9); return(607);
      case 0x638: ConsumeBits(bs, 9); return(628);
      case 0x630: ConsumeBits(bs, 9); return(634);
      case 0x628: ConsumeBits(bs, 9); return(646);
      case 0x620: ConsumeBits(bs, 9); return(647);
      case 0x618: ConsumeBits(bs, 9); return(659);
      case 0x610: ConsumeBits(bs, 9); return(661);
      case 0x608: ConsumeBits(bs, 9); return(663);
      case 0x600: ConsumeBits(bs, 9); return(667);
      case 0x5f8: ConsumeBits(bs, 9); return(668);
      case 0x5f0: ConsumeBits(bs, 9); return(705);
      case 0x5e8: ConsumeBits(bs, 9); return(738);
      case 0x5e0: ConsumeBits(bs, 9); return(742);
   }
   switch (val & 0xfffc) {
      case 0x5dc: ConsumeBits(bs, 10); return(1);
      case 0x5d8: ConsumeBits(bs, 10); return(7);
      case 0x5d4: ConsumeBits(bs, 10); return(10);
      case 0x5d0: ConsumeBits(bs, 10); return(12);
      case 0x5cc: ConsumeBits(bs, 10); return(14);
      case 0x5c8: ConsumeBits(bs, 10); return(15);
      case 0x5c4: ConsumeBits(bs, 10); return(19);
      case 0x5c0: ConsumeBits(bs, 10); return(20);
      case 0x5bc: ConsumeBits(bs, 10); return(21);
      case 0x5b8: ConsumeBits(bs, 10); return(26);
      case 0x5b4: ConsumeBits(bs, 10); return(33);
      case 0x5b0: ConsumeBits(bs, 10); return(41);
      case 0x5ac: ConsumeBits(bs, 10); return(43);
      case 0x5a8: ConsumeBits(bs, 10); return(46);
      case 0x5a4: ConsumeBits(bs, 10); return(47);
      case 0x5a0: ConsumeBits(bs, 10); return(50);
      case 0x59c: ConsumeBits(bs, 10); return(57);
      case 0x598: ConsumeBits(bs, 10); return(61);
      case 0x594: ConsumeBits(bs, 10); return(67);
      case 0x590: ConsumeBits(bs, 10); return(68);
      case 0x58c: ConsumeBits(bs, 10); return(70);
      case 0x588: ConsumeBits(bs, 10); return(79);
      case 0x584: ConsumeBits(bs, 10); return(82);
      case 0x580: ConsumeBits(bs, 10); return(83);
      case 0x57c: ConsumeBits(bs, 10); return(84);
      case 0x578: ConsumeBits(bs, 10); return(87);
      case 0x574: ConsumeBits(bs, 10); return(93);
      case 0x570: ConsumeBits(bs, 10); return(94);
      case 0x56c: ConsumeBits(bs, 10); return(95);
      case 0x568: ConsumeBits(bs, 10); return(101);
      case 0x564: ConsumeBits(bs, 10); return(102);
      case 0x560: ConsumeBits(bs, 10); return(105);
      case 0x55c: ConsumeBits(bs, 10); return(110);
      case 0x558: ConsumeBits(bs, 10); return(112);
      case 0x554: ConsumeBits(bs, 10); return(113);
      case 0x550: ConsumeBits(bs, 10); return(124);
      case 0x54c: ConsumeBits(bs, 10); return(126);
      case 0x548: ConsumeBits(bs, 10); return(128);
      case 0x544: ConsumeBits(bs, 10); return(131);
      case 0x540: ConsumeBits(bs, 10); return(132);
      case 0x53c: ConsumeBits(bs, 10); return(135);
      case 0x538: ConsumeBits(bs, 10); return(136);
      case 0x534: ConsumeBits(bs, 10); return(145);
      case 0x530: ConsumeBits(bs, 10); return(151);
      case 0x52c: ConsumeBits(bs, 10); return(160);
      case 0x528: ConsumeBits(bs, 10); return(161);
      case 0x524: ConsumeBits(bs, 10); return(162);
      case 0x520: ConsumeBits(bs, 10); return(163);
      case 0x51c: ConsumeBits(bs, 10); return(168);
      case 0x518: ConsumeBits(bs, 10); return(169);
      case 0x514: ConsumeBits(bs, 10); return(170);
      case 0x510: ConsumeBits(bs, 10); return(172);
      case 0x50c: ConsumeBits(bs, 10); return(173);
      case 0x508: ConsumeBits(bs, 10); return(174);
      case 0x504: ConsumeBits(bs, 10); return(177);
      case 0x500: ConsumeBits(bs, 10); return(182);
      case 0x4fc: ConsumeBits(bs, 10); return(191);
      case 0x4f8: ConsumeBits(bs, 10); return(192);
      case 0x4f4: ConsumeBits(bs, 10); return(194);
      case 0x4f0: ConsumeBits(bs, 10); return(195);
      case 0x4ec: ConsumeBits(bs, 10); return(196);
      case 0x4e8: ConsumeBits(bs, 10); return(199);
      case 0x4e4: ConsumeBits(bs, 10); return(201);
      case 0x4e0: ConsumeBits(bs, 10); return(204);
      case 0x4dc: ConsumeBits(bs, 10); return(205);
      case 0x4d8: ConsumeBits(bs, 10); return(209);
      case 0x4d4: ConsumeBits(bs, 10); return(210);
      case 0x4d0: ConsumeBits(bs, 10); return(215);
      case 0x4cc: ConsumeBits(bs, 10); return(216);
      case 0x4c8: ConsumeBits(bs, 10); return(223);
      case 0x4c4: ConsumeBits(bs, 10); return(225);
      case 0x4c0: ConsumeBits(bs, 10); return(226);
      case 0x4bc: ConsumeBits(bs, 10); return(227);
      case 0x4b8: ConsumeBits(bs, 10); return(241);
      case 0x4b4: ConsumeBits(bs, 10); return(246);
      case 0x4b0: ConsumeBits(bs, 10); return(248);
      case 0x4ac: ConsumeBits(bs, 10); return(250);
      case 0x4a8: ConsumeBits(bs, 10); return(251);
      case 0x4a4: ConsumeBits(bs, 10); return(253);
      case 0x4a0: ConsumeBits(bs, 10); return(257);
      case 0x49c: ConsumeBits(bs, 10); return(262);
      case 0x498: ConsumeBits(bs, 10); return(265);
      case 0x494: ConsumeBits(bs, 10); return(268);
      case 0x490: ConsumeBits(bs, 10); return(272);
      case 0x48c: ConsumeBits(bs, 10); return(276);
      case 0x488: ConsumeBits(bs, 10); return(279);
      case 0x484: ConsumeBits(bs, 10); return(280);
      case 0x480: ConsumeBits(bs, 10); return(281);
      case 0x47c: ConsumeBits(bs, 10); return(295);
      case 0x478: ConsumeBits(bs, 10); return(298);
      case 0x474: ConsumeBits(bs, 10); return(299);
      case 0x470: ConsumeBits(bs, 10); return(303);
      case 0x46c: ConsumeBits(bs, 10); return(306);
      case 0x468: ConsumeBits(bs, 10); return(309);
      case 0x464: ConsumeBits(bs, 10); return(315);
      case 0x460: ConsumeBits(bs, 10); return(318);
      case 0x45c: ConsumeBits(bs, 10); return(320);
      case 0x458: ConsumeBits(bs, 10); return(321);
      case 0x454: ConsumeBits(bs, 10); return(323);
      case 0x450: ConsumeBits(bs, 10); return(325);
      case 0x44c: ConsumeBits(bs, 10); return(332);
      case 0x448: ConsumeBits(bs, 10); return(333);
      case 0x444: ConsumeBits(bs, 10); return(340);
      case 0x440: ConsumeBits(bs, 10); return(344);
      case 0x43c: ConsumeBits(bs, 10); return(346);
      case 0x438: ConsumeBits(bs, 10); return(351);
      case 0x434: ConsumeBits(bs, 10); return(361);
      case 0x430: ConsumeBits(bs, 10); return(362);
      case 0x42c: ConsumeBits(bs, 10); return(363);
      case 0x428: ConsumeBits(bs, 10); return(365);
      case 0x424: ConsumeBits(bs, 10); return(369);
      case 0x420: ConsumeBits(bs, 10); return(370);
      case 0x41c: ConsumeBits(bs, 10); return(372);
      case 0x418: ConsumeBits(bs, 10); return(373);
      case 0x414: ConsumeBits(bs, 10); return(375);
      case 0x410: ConsumeBits(bs, 10); return(378);
      case 0x40c: ConsumeBits(bs, 10); return(381);
      case 0x408: ConsumeBits(bs, 10); return(385);
      case 0x404: ConsumeBits(bs, 10); return(390);
      case 0x400: ConsumeBits(bs, 10); return(392);
      case 0x3fc: ConsumeBits(bs, 10); return(413);
      case 0x3f8: ConsumeBits(bs, 10); return(417);
      case 0x3f4: ConsumeBits(bs, 10); return(423);
      case 0x3f0: ConsumeBits(bs, 10); return(431);
      case 0x3ec: ConsumeBits(bs, 10); return(433);
      case 0x3e8: ConsumeBits(bs, 10); return(455);
      case 0x3e4: ConsumeBits(bs, 10); return(462);
      case 0x3e0: ConsumeBits(bs, 10); return(467);
      case 0x3dc: ConsumeBits(bs, 10); return(469);
      case 0x3d8: ConsumeBits(bs, 10); return(470);
      case 0x3d4: ConsumeBits(bs, 10); return(479);
      case 0x3d0: ConsumeBits(bs, 10); return(485);
      case 0x3cc: ConsumeBits(bs, 10); return(486);
      case 0x3c8: ConsumeBits(bs, 10); return(490);
      case 0x3c4: ConsumeBits(bs, 10); return(499);
      case 0x3c0: ConsumeBits(bs, 10); return(506);
      case 0x3bc: ConsumeBits(bs, 10); return(512);
      case 0x3b8: ConsumeBits(bs, 10); return(513);
      case 0x3b4: ConsumeBits(bs, 10); return(518);
      case 0x3b0: ConsumeBits(bs, 10); return(520);
      case 0x3ac: ConsumeBits(bs, 10); return(538);
      case 0x3a8: ConsumeBits(bs, 10); return(548);
      case 0x3a4: ConsumeBits(bs, 10); return(551);
      case 0x3a0: ConsumeBits(bs, 10); return(554);
      case 0x39c: ConsumeBits(bs, 10); return(555);
      case 0x398: ConsumeBits(bs, 10); return(557);
      case 0x394: ConsumeBits(bs, 10); return(558);
      case 0x390: ConsumeBits(bs, 10); return(564);
      case 0x38c: ConsumeBits(bs, 10); return(568);
      case 0x388: ConsumeBits(bs, 10); return(572);
      case 0x384: ConsumeBits(bs, 10); return(574);
      case 0x380: ConsumeBits(bs, 10); return(575);
      case 0x37c: ConsumeBits(bs, 10); return(581);
      case 0x378: ConsumeBits(bs, 10); return(582);
      case 0x374: ConsumeBits(bs, 10); return(589);
      case 0x370: ConsumeBits(bs, 10); return(600);
      case 0x36c: ConsumeBits(bs, 10); return(622);
      case 0x368: ConsumeBits(bs, 10); return(623);
      case 0x364: ConsumeBits(bs, 10); return(633);
      case 0x360: ConsumeBits(bs, 10); return(672);
      case 0x35c: ConsumeBits(bs, 10); return(675);
      case 0x358: ConsumeBits(bs, 10); return(679);
      case 0x354: ConsumeBits(bs, 10); return(692);
      case 0x350: ConsumeBits(bs, 10); return(696);
      case 0x34c: ConsumeBits(bs, 10); return(708);
      case 0x348: ConsumeBits(bs, 10); return(713);
      case 0x344: ConsumeBits(bs, 10); return(714);
      case 0x340: ConsumeBits(bs, 10); return(720);
      case 0x33c: ConsumeBits(bs, 10); return(723);
      case 0x338: ConsumeBits(bs, 10); return(725);
      case 0x334: ConsumeBits(bs, 10); return(731);
      case 0x330: ConsumeBits(bs, 10); return(736);
      case 0x32c: ConsumeBits(bs, 10); return(740);
      case 0x328: ConsumeBits(bs, 10); return(745);
      case 0x324: ConsumeBits(bs, 10); return(746);
      case 0x320: ConsumeBits(bs, 10); return(748);
      case 0x31c: ConsumeBits(bs, 10); return(753);
      case 0x318: ConsumeBits(bs, 10); return(754);
      case 0x314: ConsumeBits(bs, 10); return(768);
      case 0x310: ConsumeBits(bs, 10); return(769);
      case 0x30c: ConsumeBits(bs, 10); return(772);
      case 0x308: ConsumeBits(bs, 10); return(785);
      case 0x304: ConsumeBits(bs, 10); return(787);
      case 0x300: ConsumeBits(bs, 10); return(797);
   }
   switch (val & 0xfffe) {
      case 0x2fe: ConsumeBits(bs, 11); return(0);
      case 0x2fc: ConsumeBits(bs, 11); return(4);
      case 0x2fa: ConsumeBits(bs, 11); return(9);
      case 0x2f8: ConsumeBits(bs, 11); return(11);
      case 0x2f6: ConsumeBits(bs, 11); return(13);
      case 0x2f4: ConsumeBits(bs, 11); return(16);
      case 0x2f2: ConsumeBits(bs, 11); return(17);
      case 0x2f0: ConsumeBits(bs, 11); return(18);
      case 0x2ee: ConsumeBits(bs, 11); return(22);
      case 0x2ec: ConsumeBits(bs, 11); return(24);
      case 0x2ea: ConsumeBits(bs, 11); return(25);
      case 0x2e8: ConsumeBits(bs, 11); return(28);
      case 0x2e6: ConsumeBits(bs, 11); return(32);
      case 0x2e4: ConsumeBits(bs, 11); return(34);
      case 0x2e2: ConsumeBits(bs, 11); return(35);
      case 0x2e0: ConsumeBits(bs, 11); return(36);
      case 0x2de: ConsumeBits(bs, 11); return(39);
      case 0x2dc: ConsumeBits(bs, 11); return(40);
      case 0x2da: ConsumeBits(bs, 11); return(42);
      case 0x2d8: ConsumeBits(bs, 11); return(44);
      case 0x2d6: ConsumeBits(bs, 11); return(45);
      case 0x2d4: ConsumeBits(bs, 11); return(48);
      case 0x2d2: ConsumeBits(bs, 11); return(49);
      case 0x2d0: ConsumeBits(bs, 11); return(51);
      case 0x2ce: ConsumeBits(bs, 11); return(54);
      case 0x2cc: ConsumeBits(bs, 11); return(55);
      case 0x2ca: ConsumeBits(bs, 11); return(56);
      case 0x2c8: ConsumeBits(bs, 11); return(58);
      case 0x2c6: ConsumeBits(bs, 11); return(60);
      case 0x2c4: ConsumeBits(bs, 11); return(62);
      case 0x2c2: ConsumeBits(bs, 11); return(63);
      case 0x2c0: ConsumeBits(bs, 11); return(65);
      case 0x2be: ConsumeBits(bs, 11); return(66);
      case 0x2bc: ConsumeBits(bs, 11); return(69);
      case 0x2ba: ConsumeBits(bs, 11); return(71);
      case 0x2b8: ConsumeBits(bs, 11); return(72);
      case 0x2b6: ConsumeBits(bs, 11); return(73);
      case 0x2b4: ConsumeBits(bs, 11); return(75);
      case 0x2b2: ConsumeBits(bs, 11); return(76);
      case 0x2b0: ConsumeBits(bs, 11); return(77);
      case 0x2ae: ConsumeBits(bs, 11); return(78);
      case 0x2ac: ConsumeBits(bs, 11); return(80);
      case 0x2aa: ConsumeBits(bs, 11); return(81);
      case 0x2a8: ConsumeBits(bs, 11); return(85);
      case 0x2a6: ConsumeBits(bs, 11); return(86);
      case 0x2a4: ConsumeBits(bs, 11); return(88);
      case 0x2a2: ConsumeBits(bs, 11); return(89);
      case 0x2a0: ConsumeBits(bs, 11); return(90);
      case 0x29e: ConsumeBits(bs, 11); return(92);
      case 0x29c: ConsumeBits(bs, 11); return(96);
      case 0x29a: ConsumeBits(bs, 11); return(99);
      case 0x298: ConsumeBits(bs, 11); return(100);
      case 0x296: ConsumeBits(bs, 11); return(103);
      case 0x294: ConsumeBits(bs, 11); return(106);
      case 0x292: ConsumeBits(bs, 11); return(107);
      case 0x290: ConsumeBits(bs, 11); return(108);
      case 0x28e: ConsumeBits(bs, 11); return(109);
      case 0x28c: ConsumeBits(bs, 11); return(111);
      case 0x28a: ConsumeBits(bs, 11); return(114);
      case 0x288: ConsumeBits(bs, 11); return(116);
      case 0x286: ConsumeBits(bs, 11); return(119);
      case 0x284: ConsumeBits(bs, 11); return(120);
      case 0x282: ConsumeBits(bs, 11); return(121);
      case 0x280: ConsumeBits(bs, 11); return(122);
      case 0x27e: ConsumeBits(bs, 11); return(123);
      case 0x27c: ConsumeBits(bs, 11); return(125);
      case 0x27a: ConsumeBits(bs, 11); return(127);
      case 0x278: ConsumeBits(bs, 11); return(129);
      case 0x276: ConsumeBits(bs, 11); return(130);
      case 0x274: ConsumeBits(bs, 11); return(133);
      case 0x272: ConsumeBits(bs, 11); return(137);
      case 0x270: ConsumeBits(bs, 11); return(140);
      case 0x26e: ConsumeBits(bs, 11); return(141);
      case 0x26c: ConsumeBits(bs, 11); return(142);
      case 0x26a: ConsumeBits(bs, 11); return(143);
      case 0x268: ConsumeBits(bs, 11); return(146);
      case 0x266: ConsumeBits(bs, 11); return(148);
      case 0x264: ConsumeBits(bs, 11); return(150);
      case 0x262: ConsumeBits(bs, 11); return(152);
      case 0x260: ConsumeBits(bs, 11); return(153);
      case 0x25e: ConsumeBits(bs, 11); return(154);
      case 0x25c: ConsumeBits(bs, 11); return(155);
      case 0x25a: ConsumeBits(bs, 11); return(156);
      case 0x258: ConsumeBits(bs, 11); return(157);
      case 0x256: ConsumeBits(bs, 11); return(158);
      case 0x254: ConsumeBits(bs, 11); return(165);
      case 0x252: ConsumeBits(bs, 11); return(166);
      case 0x250: ConsumeBits(bs, 11); return(175);
      case 0x24e: ConsumeBits(bs, 11); return(178);
      case 0x24c: ConsumeBits(bs, 11); return(179);
      case 0x24a: ConsumeBits(bs, 11); return(180);
      case 0x248: ConsumeBits(bs, 11); return(181);
      case 0x246: ConsumeBits(bs, 11); return(183);
      case 0x244: ConsumeBits(bs, 11); return(185);
      case 0x242: ConsumeBits(bs, 11); return(186);
      case 0x240: ConsumeBits(bs, 11); return(188);
      case 0x23e: ConsumeBits(bs, 11); return(189);
      case 0x23c: ConsumeBits(bs, 11); return(190);
      case 0x23a: ConsumeBits(bs, 11); return(193);
      case 0x238: ConsumeBits(bs, 11); return(197);
      case 0x236: ConsumeBits(bs, 11); return(198);
      case 0x234: ConsumeBits(bs, 11); return(202);
      case 0x232: ConsumeBits(bs, 11); return(206);
      case 0x230: ConsumeBits(bs, 11); return(207);
      case 0x22e: ConsumeBits(bs, 11); return(211);
      case 0x22c: ConsumeBits(bs, 11); return(212);
      case 0x22a: ConsumeBits(bs, 11); return(213);
      case 0x228: ConsumeBits(bs, 11); return(214);
      case 0x226: ConsumeBits(bs, 11); return(218);
      case 0x224: ConsumeBits(bs, 11); return(219);
      case 0x222: ConsumeBits(bs, 11); return(220);
      case 0x220: ConsumeBits(bs, 11); return(221);
      case 0x21e: ConsumeBits(bs, 11); return(222);
      case 0x21c: ConsumeBits(bs, 11); return(224);
      case 0x21a: ConsumeBits(bs, 11); return(231);
      case 0x218: ConsumeBits(bs, 11); return(232);
      case 0x216: ConsumeBits(bs, 11); return(234);
      case 0x214: ConsumeBits(bs, 11); return(235);
      case 0x212: ConsumeBits(bs, 11); return(238);
      case 0x210: ConsumeBits(bs, 11); return(239);
      case 0x20e: ConsumeBits(bs, 11); return(242);
      case 0x20c: ConsumeBits(bs, 11); return(243);
      case 0x20a: ConsumeBits(bs, 11); return(249);
      case 0x208: ConsumeBits(bs, 11); return(252);
      case 0x206: ConsumeBits(bs, 11); return(254);
      case 0x204: ConsumeBits(bs, 11); return(255);
      case 0x202: ConsumeBits(bs, 11); return(258);
      case 0x200: ConsumeBits(bs, 11); return(259);
      case 0x1fe: ConsumeBits(bs, 11); return(263);
      case 0x1fc: ConsumeBits(bs, 11); return(264);
      case 0x1fa: ConsumeBits(bs, 11); return(266);
      case 0x1f8: ConsumeBits(bs, 11); return(269);
      case 0x1f6: ConsumeBits(bs, 11); return(270);
      case 0x1f4: ConsumeBits(bs, 11); return(271);
      case 0x1f2: ConsumeBits(bs, 11); return(274);
      case 0x1f0: ConsumeBits(bs, 11); return(275);
      case 0x1ee: ConsumeBits(bs, 11); return(278);
      case 0x1ec: ConsumeBits(bs, 11); return(282);
      case 0x1ea: ConsumeBits(bs, 11); return(283);
      case 0x1e8: ConsumeBits(bs, 11); return(284);
      case 0x1e6: ConsumeBits(bs, 11); return(285);
      case 0x1e4: ConsumeBits(bs, 11); return(286);
      case 0x1e2: ConsumeBits(bs, 11); return(287);
      case 0x1e0: ConsumeBits(bs, 11); return(288);
      case 0x1de: ConsumeBits(bs, 11); return(289);
      case 0x1dc: ConsumeBits(bs, 11); return(290);
      case 0x1da: ConsumeBits(bs, 11); return(291);
      case 0x1d8: ConsumeBits(bs, 11); return(292);
      case 0x1d6: ConsumeBits(bs, 11); return(294);
      case 0x1d4: ConsumeBits(bs, 11); return(296);
      case 0x1d2: ConsumeBits(bs, 11); return(297);
      case 0x1d0: ConsumeBits(bs, 11); return(300);
      case 0x1ce: ConsumeBits(bs, 11); return(302);
      case 0x1cc: ConsumeBits(bs, 11); return(304);
      case 0x1ca: ConsumeBits(bs, 11); return(305);
      case 0x1c8: ConsumeBits(bs, 11); return(308);
      case 0x1c6: ConsumeBits(bs, 11); return(310);
      case 0x1c4: ConsumeBits(bs, 11); return(311);
      case 0x1c2: ConsumeBits(bs, 11); return(312);
      case 0x1c0: ConsumeBits(bs, 11); return(313);
      case 0x1be: ConsumeBits(bs, 11); return(314);
      case 0x1bc: ConsumeBits(bs, 11); return(317);
      case 0x1ba: ConsumeBits(bs, 11); return(319);
      case 0x1b8: ConsumeBits(bs, 11); return(322);
      case 0x1b6: ConsumeBits(bs, 11); return(324);
      case 0x1b4: ConsumeBits(bs, 11); return(326);
      case 0x1b2: ConsumeBits(bs, 11); return(327);
      case 0x1b0: ConsumeBits(bs, 11); return(328);
      case 0x1ae: ConsumeBits(bs, 11); return(330);
      case 0x1ac: ConsumeBits(bs, 11); return(331);
      case 0x1aa: ConsumeBits(bs, 11); return(334);
      case 0x1a8: ConsumeBits(bs, 11); return(335);
      case 0x1a6: ConsumeBits(bs, 11); return(337);
      case 0x1a4: ConsumeBits(bs, 11); return(338);
      case 0x1a2: ConsumeBits(bs, 11); return(339);
      case 0x1a0: ConsumeBits(bs, 11); return(341);
      case 0x19e: ConsumeBits(bs, 11); return(343);
      case 0x19c: ConsumeBits(bs, 11); return(345);
      case 0x19a: ConsumeBits(bs, 11); return(347);
      case 0x198: ConsumeBits(bs, 11); return(348);
      case 0x196: ConsumeBits(bs, 11); return(349);
      case 0x194: ConsumeBits(bs, 11); return(353);
      case 0x192: ConsumeBits(bs, 11); return(355);
      case 0x190: ConsumeBits(bs, 11); return(359);
      case 0x18e: ConsumeBits(bs, 11); return(366);
      case 0x18c: ConsumeBits(bs, 11); return(368);
      case 0x18a: ConsumeBits(bs, 11); return(371);
      case 0x188: ConsumeBits(bs, 11); return(374);
      case 0x186: ConsumeBits(bs, 11); return(377);
      case 0x184: ConsumeBits(bs, 11); return(379);
      case 0x182: ConsumeBits(bs, 11); return(382);
      case 0x180: ConsumeBits(bs, 11); return(383);
      case 0x17e: ConsumeBits(bs, 11); return(386);
      case 0x17c: ConsumeBits(bs, 11); return(389);
      case 0x17a: ConsumeBits(bs, 11); return(391);
      case 0x178: ConsumeBits(bs, 11); return(393);
      case 0x176: ConsumeBits(bs, 11); return(394);
      case 0x174: ConsumeBits(bs, 11); return(395);
      case 0x172: ConsumeBits(bs, 11); return(398);
      case 0x170: ConsumeBits(bs, 11); return(399);
      case 0x16e: ConsumeBits(bs, 11); return(400);
      case 0x16c: ConsumeBits(bs, 11); return(401);
      case 0x16a: ConsumeBits(bs, 11); return(402);
      case 0x168: ConsumeBits(bs, 11); return(403);
      case 0x166: ConsumeBits(bs, 11); return(405);
      case 0x164: ConsumeBits(bs, 11); return(409);
      case 0x162: ConsumeBits(bs, 11); return(422);
      case 0x160: ConsumeBits(bs, 11); return(424);
      case 0x15e: ConsumeBits(bs, 11); return(427);
      case 0x15c: ConsumeBits(bs, 11); return(429);
      case 0x15a: ConsumeBits(bs, 11); return(442);
      case 0x158: ConsumeBits(bs, 11); return(446);
      case 0x156: ConsumeBits(bs, 11); return(450);
      case 0x154: ConsumeBits(bs, 11); return(451);
      case 0x152: ConsumeBits(bs, 11); return(457);
      case 0x150: ConsumeBits(bs, 11); return(464);
      case 0x14e: ConsumeBits(bs, 11); return(484);
      case 0x14c: ConsumeBits(bs, 11); return(488);
      case 0x14a: ConsumeBits(bs, 11); return(494);
      case 0x148: ConsumeBits(bs, 11); return(503);
      case 0x146: ConsumeBits(bs, 11); return(505);
      case 0x144: ConsumeBits(bs, 11); return(514);
      case 0x142: ConsumeBits(bs, 11); return(519);
      case 0x140: ConsumeBits(bs, 11); return(525);
      case 0x13e: ConsumeBits(bs, 11); return(527);
      case 0x13c: ConsumeBits(bs, 11); return(530);
      case 0x13a: ConsumeBits(bs, 11); return(535);
      case 0x138: ConsumeBits(bs, 11); return(543);
      case 0x136: ConsumeBits(bs, 11); return(547);
      case 0x134: ConsumeBits(bs, 11); return(552);
      case 0x132: ConsumeBits(bs, 11); return(556);
      case 0x130: ConsumeBits(bs, 11); return(559);
      case 0x12e: ConsumeBits(bs, 11); return(561);
      case 0x12c: ConsumeBits(bs, 11); return(566);
      case 0x12a: ConsumeBits(bs, 11); return(573);
      case 0x128: ConsumeBits(bs, 11); return(576);
      case 0x126: ConsumeBits(bs, 11); return(588);
      case 0x124: ConsumeBits(bs, 11); return(591);
      case 0x122: ConsumeBits(bs, 11); return(592);
      case 0x120: ConsumeBits(bs, 11); return(595);
      case 0x11e: ConsumeBits(bs, 11); return(601);
      case 0x11c: ConsumeBits(bs, 11); return(604);
      case 0x11a: ConsumeBits(bs, 11); return(606);
      case 0x118: ConsumeBits(bs, 11); return(608);
      case 0x116: ConsumeBits(bs, 11); return(610);
      case 0x114: ConsumeBits(bs, 11); return(614);
      case 0x112: ConsumeBits(bs, 11); return(616);
      case 0x110: ConsumeBits(bs, 11); return(621);
      case 0x10e: ConsumeBits(bs, 11); return(625);
      case 0x10c: ConsumeBits(bs, 11); return(626);
      case 0x10a: ConsumeBits(bs, 11); return(627);
      case 0x108: ConsumeBits(bs, 11); return(629);
      case 0x106: ConsumeBits(bs, 11); return(635);
      case 0x104: ConsumeBits(bs, 11); return(636);
      case 0x102: ConsumeBits(bs, 11); return(638);
      case 0x100: ConsumeBits(bs, 11); return(642);
      case 0xfe: ConsumeBits(bs, 11); return(655);
      case 0xfc: ConsumeBits(bs, 11); return(657);
      case 0xfa: ConsumeBits(bs, 11); return(658);
      case 0xf8: ConsumeBits(bs, 11); return(666);
      case 0xf6: ConsumeBits(bs, 11); return(680);
      case 0xf4: ConsumeBits(bs, 11); return(682);
      case 0xf2: ConsumeBits(bs, 11); return(684);
      case 0xf0: ConsumeBits(bs, 11); return(685);
      case 0xee: ConsumeBits(bs, 11); return(687);
      case 0xec: ConsumeBits(bs, 11); return(688);
      case 0xea: ConsumeBits(bs, 11); return(690);
      case 0xe8: ConsumeBits(bs, 11); return(694);
      case 0xe6: ConsumeBits(bs, 11); return(698);
      case 0xe4: ConsumeBits(bs, 11); return(700);
      case 0xe2: ConsumeBits(bs, 11); return(716);
      case 0xe0: ConsumeBits(bs, 11); return(724);
      case 0xde: ConsumeBits(bs, 11); return(735);
      case 0xdc: ConsumeBits(bs, 11); return(747);
      case 0xda: ConsumeBits(bs, 11); return(755);
      case 0xd8: ConsumeBits(bs, 11); return(761);
      case 0xd6: ConsumeBits(bs, 11); return(762);
      case 0xd4: ConsumeBits(bs, 11); return(764);
      case 0xd2: ConsumeBits(bs, 11); return(765);
      case 0xd0: ConsumeBits(bs, 11); return(766);
      case 0xce: ConsumeBits(bs, 11); return(771);
      case 0xcc: ConsumeBits(bs, 11); return(781);
      case 0xca: ConsumeBits(bs, 11); return(789);
      case 0xc8: ConsumeBits(bs, 11); return(790);
      case 0xc6: ConsumeBits(bs, 11); return(791);
      case 0xc4: ConsumeBits(bs, 11); return(796);
      case 0xc2: ConsumeBits(bs, 11); return(799);
   }
   switch (val & 0xffff) {
      case 0xc1: ConsumeBits(bs, 12); return(406);
      case 0xc0: ConsumeBits(bs, 12); return(407);
      case 0xbf: ConsumeBits(bs, 12); return(408);
      case 0xbe: ConsumeBits(bs, 12); return(410);
      case 0xbd: ConsumeBits(bs, 12); return(414);
      case 0xbc: ConsumeBits(bs, 12); return(415);
      case 0xbb: ConsumeBits(bs, 12); return(421);
      case 0xba: ConsumeBits(bs, 12); return(426);
      case 0xb9: ConsumeBits(bs, 12); return(428);
      case 0xb8: ConsumeBits(bs, 12); return(430);
      case 0xb7: ConsumeBits(bs, 12); return(434);
      case 0xb6: ConsumeBits(bs, 12); return(436);
      case 0xb5: ConsumeBits(bs, 12); return(437);
      case 0xb4: ConsumeBits(bs, 12); return(438);
      case 0xb3: ConsumeBits(bs, 12); return(439);
      case 0xb2: ConsumeBits(bs, 12); return(441);
      case 0xb1: ConsumeBits(bs, 12); return(443);
      case 0xb0: ConsumeBits(bs, 12); return(445);
      case 0xaf: ConsumeBits(bs, 12); return(449);
      case 0xae: ConsumeBits(bs, 12); return(452);
      case 0xad: ConsumeBits(bs, 12); return(453);
      case 0xac: ConsumeBits(bs, 12); return(454);
      case 0xab: ConsumeBits(bs, 12); return(456);
      case 0xaa: ConsumeBits(bs, 12); return(458);
      case 0xa9: ConsumeBits(bs, 12); return(459);
      case 0xa8: ConsumeBits(bs, 12); return(460);
      case 0xa7: ConsumeBits(bs, 12); return(461);
      case 0xa6: ConsumeBits(bs, 12); return(463);
      case 0xa5: ConsumeBits(bs, 12); return(465);
      case 0xa4: ConsumeBits(bs, 12); return(466);
      case 0xa3: ConsumeBits(bs, 12); return(473);
      case 0xa2: ConsumeBits(bs, 12); return(474);
      case 0xa1: ConsumeBits(bs, 12); return(475);
      case 0xa0: ConsumeBits(bs, 12); return(477);
      case 0x9f: ConsumeBits(bs, 12); return(478);
      case 0x9e: ConsumeBits(bs, 12); return(482);
      case 0x9d: ConsumeBits(bs, 12); return(483);
      case 0x9c: ConsumeBits(bs, 12); return(487);
      case 0x9b: ConsumeBits(bs, 12); return(489);
      case 0x9a: ConsumeBits(bs, 12); return(491);
      case 0x99: ConsumeBits(bs, 12); return(492);
      case 0x98: ConsumeBits(bs, 12); return(493);
      case 0x97: ConsumeBits(bs, 12); return(495);
      case 0x96: ConsumeBits(bs, 12); return(496);
      case 0x95: ConsumeBits(bs, 12); return(497);
      case 0x94: ConsumeBits(bs, 12); return(500);
      case 0x93: ConsumeBits(bs, 12); return(501);
      case 0x92: ConsumeBits(bs, 12); return(504);
      case 0x91: ConsumeBits(bs, 12); return(507);
      case 0x90: ConsumeBits(bs, 12); return(508);
      case 0x8f: ConsumeBits(bs, 12); return(509);
      case 0x8e: ConsumeBits(bs, 12); return(510);
      case 0x8d: ConsumeBits(bs, 12); return(511);
      case 0x8c: ConsumeBits(bs, 12); return(515);
      case 0x8b: ConsumeBits(bs, 12); return(516);
      case 0x8a: ConsumeBits(bs, 12); return(517);
      case 0x89: ConsumeBits(bs, 12); return(521);
      case 0x88: ConsumeBits(bs, 12); return(522);
      case 0x87: ConsumeBits(bs, 12); return(524);
      case 0x86: ConsumeBits(bs, 12); return(528);
      case 0x85: ConsumeBits(bs, 12); return(529);
      case 0x84: ConsumeBits(bs, 12); return(531);
      case 0x83: ConsumeBits(bs, 12); return(532);
      case 0x82: ConsumeBits(bs, 12); return(533);
      case 0x81: ConsumeBits(bs, 12); return(534);
      case 0x80: ConsumeBits(bs, 12); return(536);
      case 0x7f: ConsumeBits(bs, 12); return(537);
      case 0x7e: ConsumeBits(bs, 12); return(539);
      case 0x7d: ConsumeBits(bs, 12); return(540);
      case 0x7c: ConsumeBits(bs, 12); return(541);
      case 0x7b: ConsumeBits(bs, 12); return(542);
      case 0x7a: ConsumeBits(bs, 12); return(544);
      case 0x79: ConsumeBits(bs, 12); return(545);
      case 0x78: ConsumeBits(bs, 12); return(546);
      case 0x77: ConsumeBits(bs, 12); return(550);
      case 0x76: ConsumeBits(bs, 12); return(553);
      case 0x75: ConsumeBits(bs, 12); return(560);
      case 0x74: ConsumeBits(bs, 12); return(562);
      case 0x73: ConsumeBits(bs, 12); return(563);
      case 0x72: ConsumeBits(bs, 12); return(565);
      case 0x71: ConsumeBits(bs, 12); return(567);
      case 0x70: ConsumeBits(bs, 12); return(569);
      case 0x6f: ConsumeBits(bs, 12); return(570);
      case 0x6e: ConsumeBits(bs, 12); return(571);
      case 0x6d: ConsumeBits(bs, 12); return(578);
      case 0x6c: ConsumeBits(bs, 12); return(579);
      case 0x6b: ConsumeBits(bs, 12); return(580);
      case 0x6a: ConsumeBits(bs, 12); return(583);
      case 0x69: ConsumeBits(bs, 12); return(585);
      case 0x68: ConsumeBits(bs, 12); return(586);
      case 0x67: ConsumeBits(bs, 12); return(587);
      case 0x66: ConsumeBits(bs, 12); return(593);
      case 0x65: ConsumeBits(bs, 12); return(597);
      case 0x64: ConsumeBits(bs, 12); return(602);
      case 0x63: ConsumeBits(bs, 12); return(603);
      case 0x62: ConsumeBits(bs, 12); return(605);
      case 0x61: ConsumeBits(bs, 12); return(609);
      case 0x60: ConsumeBits(bs, 12); return(611);
      case 0x5f: ConsumeBits(bs, 12); return(612);
      case 0x5e: ConsumeBits(bs, 12); return(613);
      case 0x5d: ConsumeBits(bs, 12); return(617);
      case 0x5c: ConsumeBits(bs, 12); return(618);
      case 0x5b: ConsumeBits(bs, 12); return(619);
      case 0x5a: ConsumeBits(bs, 12); return(620);
      case 0x59: ConsumeBits(bs, 12); return(624);
      case 0x58: ConsumeBits(bs, 12); return(630);
      case 0x57: ConsumeBits(bs, 12); return(631);
      case 0x56: ConsumeBits(bs, 12); return(632);
      case 0x55: ConsumeBits(bs, 12); return(637);
      case 0x54: ConsumeBits(bs, 12); return(639);
      case 0x53: ConsumeBits(bs, 12); return(640);
      case 0x52: ConsumeBits(bs, 12); return(641);
      case 0x51: ConsumeBits(bs, 12); return(643);
      case 0x50: ConsumeBits(bs, 12); return(644);
      case 0x4f: ConsumeBits(bs, 12); return(645);
      case 0x4e: ConsumeBits(bs, 12); return(648);
      case 0x4d: ConsumeBits(bs, 12); return(649);
      case 0x4c: ConsumeBits(bs, 12); return(650);
      case 0x4b: ConsumeBits(bs, 12); return(651);
      case 0x4a: ConsumeBits(bs, 12); return(652);
      case 0x49: ConsumeBits(bs, 12); return(653);
      case 0x48: ConsumeBits(bs, 12); return(654);
      case 0x47: ConsumeBits(bs, 12); return(656);
      case 0x46: ConsumeBits(bs, 12); return(660);
      case 0x45: ConsumeBits(bs, 12); return(662);
      case 0x44: ConsumeBits(bs, 12); return(664);
      case 0x43: ConsumeBits(bs, 12); return(665);
      case 0x42: ConsumeBits(bs, 12); return(669);
      case 0x41: ConsumeBits(bs, 12); return(670);
      case 0x40: ConsumeBits(bs, 12); return(671);
      case 0x3f: ConsumeBits(bs, 12); return(673);
      case 0x3e: ConsumeBits(bs, 12); return(674);
      case 0x3d: ConsumeBits(bs, 12); return(676);
      case 0x3c: ConsumeBits(bs, 12); return(677);
      case 0x3b: ConsumeBits(bs, 12); return(681);
      case 0x3a: ConsumeBits(bs, 12); return(683);
      case 0x39: ConsumeBits(bs, 12); return(689);
      case 0x38: ConsumeBits(bs, 12); return(691);
      case 0x37: ConsumeBits(bs, 12); return(693);
      case 0x36: ConsumeBits(bs, 12); return(695);
      case 0x35: ConsumeBits(bs, 12); return(697);
      case 0x34: ConsumeBits(bs, 12); return(701);
      case 0x33: ConsumeBits(bs, 12); return(702);
      case 0x32: ConsumeBits(bs, 12); return(703);
      case 0x31: ConsumeBits(bs, 12); return(704);
      case 0x30: ConsumeBits(bs, 12); return(706);
      case 0x2f: ConsumeBits(bs, 12); return(707);
      case 0x2e: ConsumeBits(bs, 12); return(709);
      case 0x2d: ConsumeBits(bs, 12); return(710);
      case 0x2c: ConsumeBits(bs, 12); return(711);
      case 0x2b: ConsumeBits(bs, 12); return(712);
      case 0x2a: ConsumeBits(bs, 12); return(715);
      case 0x29: ConsumeBits(bs, 12); return(717);
      case 0x28: ConsumeBits(bs, 12); return(718);
      case 0x27: ConsumeBits(bs, 12); return(719);
      case 0x26: ConsumeBits(bs, 12); return(721);
      case 0x25: ConsumeBits(bs, 12); return(722);
      case 0x24: ConsumeBits(bs, 12); return(726);
      case 0x23: ConsumeBits(bs, 12); return(727);
      case 0x22: ConsumeBits(bs, 12); return(728);
      case 0x21: ConsumeBits(bs, 12); return(729);
      case 0x20: ConsumeBits(bs, 12); return(730);
      case 0x1f: ConsumeBits(bs, 12); return(732);
      case 0x1e: ConsumeBits(bs, 12); return(734);
      case 0x1d: ConsumeBits(bs, 12); return(737);
      case 0x1c: ConsumeBits(bs, 12); return(741);
      case 0x1b: ConsumeBits(bs, 12); return(743);
      case 0x1a: ConsumeBits(bs, 12); return(744);
      case 0x19: ConsumeBits(bs, 12); return(749);
      case 0x18: ConsumeBits(bs, 12); return(751);
      case 0x17: ConsumeBits(bs, 12); return(752);
      case 0x16: ConsumeBits(bs, 12); return(756);
      case 0x15: ConsumeBits(bs, 12); return(757);
      case 0x14: ConsumeBits(bs, 12); return(758);
      case 0x13: ConsumeBits(bs, 12); return(759);
      case 0x12: ConsumeBits(bs, 12); return(760);
      case 0x11: ConsumeBits(bs, 12); return(763);
      case 0x10: ConsumeBits(bs, 12); return(767);
      case 0xf: ConsumeBits(bs, 12); return(770);
      case 0xe: ConsumeBits(bs, 12); return(774);
      case 0xd: ConsumeBits(bs, 12); return(775);
      case 0xc: ConsumeBits(bs, 12); return(776);
      case 0xb: ConsumeBits(bs, 12); return(777);
      case 0xa: ConsumeBits(bs, 12); return(778);
      case 0x9: ConsumeBits(bs, 12); return(780);
      case 0x8: ConsumeBits(bs, 12); return(782);
      case 0x7: ConsumeBits(bs, 12); return(784);
      case 0x6: ConsumeBits(bs, 12); return(788);
      case 0x5: ConsumeBits(bs, 12); return(792);
      case 0x4: ConsumeBits(bs, 12); return(793);
      case 0x3: ConsumeBits(bs, 12); return(794);
      case 0x2: ConsumeBits(bs, 12); return(795);
      case 0x1: ConsumeBits(bs, 12); return(798);
   }
   SyntaxError("GetShell2TPYHuffCode");
   return(-1);
}
