#include "bitIn.h"
int GetTPCClassHuffCode(Bitstream *bs) {
   unsigned short val = ShowBits(bs, 9);
   switch (val & 0xff80) {
      case 0x180: ConsumeBits(bs, 2); return(9);
      case 0x100: ConsumeBits(bs, 2); return(64);
   }
   switch (val & 0xffc0) {
      case 0xc0: ConsumeBits(bs, 3); return(41);
   }
   switch (val & 0xffe0) {
      case 0xa0: ConsumeBits(bs, 4); return(0);
      case 0x80: ConsumeBits(bs, 4); return(1);
   }
   switch (val & 0xfff0) {
      case 0x70: ConsumeBits(bs, 5); return(2);
      case 0x60: ConsumeBits(bs, 5); return(5);
   }
   switch (val & 0xfff8) {
      case 0x58: ConsumeBits(bs, 6); return(3);
      case 0x50: ConsumeBits(bs, 6); return(4);
      case 0x48: ConsumeBits(bs, 6); return(7);
      case 0x40: ConsumeBits(bs, 6); return(15);
   }
   switch (val & 0xfffc) {
      case 0x3c: ConsumeBits(bs, 7); return(14);
   }
   switch (val & 0xfffe) {
      case 0x3a: ConsumeBits(bs, 8); return(6);
      case 0x38: ConsumeBits(bs, 8); return(8);
      case 0x36: ConsumeBits(bs, 8); return(12);
      case 0x34: ConsumeBits(bs, 8); return(16);
      case 0x32: ConsumeBits(bs, 8); return(20);
      case 0x30: ConsumeBits(bs, 8); return(40);
   }
   switch (val & 0xffff) {
      case 0x2f: ConsumeBits(bs, 9); return(10);
      case 0x2e: ConsumeBits(bs, 9); return(11);
      case 0x2d: ConsumeBits(bs, 9); return(13);
      case 0x2c: ConsumeBits(bs, 9); return(17);
      case 0x2b: ConsumeBits(bs, 9); return(18);
      case 0x2a: ConsumeBits(bs, 9); return(19);
      case 0x29: ConsumeBits(bs, 9); return(21);
      case 0x28: ConsumeBits(bs, 9); return(22);
      case 0x27: ConsumeBits(bs, 9); return(23);
      case 0x26: ConsumeBits(bs, 9); return(24);
      case 0x25: ConsumeBits(bs, 9); return(25);
      case 0x24: ConsumeBits(bs, 9); return(26);
      case 0x23: ConsumeBits(bs, 9); return(27);
      case 0x22: ConsumeBits(bs, 9); return(28);
      case 0x21: ConsumeBits(bs, 9); return(29);
      case 0x20: ConsumeBits(bs, 9); return(30);
      case 0x1f: ConsumeBits(bs, 9); return(31);
      case 0x1e: ConsumeBits(bs, 9); return(32);
      case 0x1d: ConsumeBits(bs, 9); return(33);
      case 0x1c: ConsumeBits(bs, 9); return(34);
      case 0x1b: ConsumeBits(bs, 9); return(35);
      case 0x1a: ConsumeBits(bs, 9); return(36);
      case 0x19: ConsumeBits(bs, 9); return(37);
      case 0x18: ConsumeBits(bs, 9); return(38);
      case 0x17: ConsumeBits(bs, 9); return(39);
      case 0x16: ConsumeBits(bs, 9); return(42);
      case 0x15: ConsumeBits(bs, 9); return(43);
      case 0x14: ConsumeBits(bs, 9); return(44);
      case 0x13: ConsumeBits(bs, 9); return(45);
      case 0x12: ConsumeBits(bs, 9); return(46);
      case 0x11: ConsumeBits(bs, 9); return(47);
      case 0x10: ConsumeBits(bs, 9); return(48);
      case 0xf: ConsumeBits(bs, 9); return(49);
      case 0xe: ConsumeBits(bs, 9); return(50);
      case 0xd: ConsumeBits(bs, 9); return(51);
      case 0xc: ConsumeBits(bs, 9); return(52);
      case 0xb: ConsumeBits(bs, 9); return(53);
      case 0xa: ConsumeBits(bs, 9); return(54);
      case 0x9: ConsumeBits(bs, 9); return(55);
      case 0x8: ConsumeBits(bs, 9); return(56);
      case 0x7: ConsumeBits(bs, 9); return(57);
      case 0x6: ConsumeBits(bs, 9); return(58);
      case 0x5: ConsumeBits(bs, 9); return(59);
      case 0x4: ConsumeBits(bs, 9); return(60);
      case 0x3: ConsumeBits(bs, 9); return(61);
      case 0x2: ConsumeBits(bs, 9); return(62);
      case 0x1: ConsumeBits(bs, 9); return(63);
   }
   SyntaxError("GetTPCClassHuffCode");
   return(-1);
}
