#include "bitIn.h"
int GetVMagHuffCode(Bitstream *bs) {
   unsigned short val = ShowBits(bs, 7);
   switch (val & 0xffe0) {
      case 0x60: ConsumeBits(bs, 2); return(1);
      case 0x40: ConsumeBits(bs, 2); return(2);
      case 0x20: ConsumeBits(bs, 2); return(3);
   }
   switch (val & 0xfff0) {
      case 0x10: ConsumeBits(bs, 3); return(4);
   }
   switch (val & 0xfff8) {
      case 0x8: ConsumeBits(bs, 4); return(5);
   }
   switch (val & 0xfffc) {
      case 0x4: ConsumeBits(bs, 5); return(6);
   }
   switch (val & 0xfffe) {
      case 0x2: ConsumeBits(bs, 6); return(0);
   }
   switch (val & 0xffff) {
      case 0x1: ConsumeBits(bs, 7); return(7);
   }
   SyntaxError("GetVMagHuffCode");
   return(-1);
}
