/************************************************************************
 *
 *  recon.c, motion compensation routines for tmndecode (H.263 decoder)
 *  Copyright (C) 1995, 1996  Telenor R&D, Norway
 *        Karl Olav Lillevold <Karl.Lillevold@nta.no>
 *  
 *  Contacts: 
 *  Karl Olav Lillevold               <Karl.Lillevold@nta.no>, or
 *  Robert Danielsen                  <Robert.Danielsen@nta.no>
 *
 *  Telenor Research and Development  http://www.nta.no/brukere/DVC/
 *  P.O.Box 83                        tel.:   +47 63 84 84 00
 *  N-2007 Kjeller, Norway            fax.:   +47 63 81 00 76
 *  
 ************************************************************************/

/*
 * Disclaimer of Warranty
 *
 * These software programs are available to the user without any
 * license fee or royalty on an "as is" basis.  Telenor Research and
 * Development disclaims any and all warranties, whether express,
 * implied, or statuary, including any implied warranties or
 * merchantability or of fitness for a particular purpose.  In no
 * event shall the copyright-holder be liable for any incidental,
 * punitive, or consequential damages of any kind whatsoever arising
 * from the use of these programs.
 *
 * This disclaimer of warranty extends to the user of these programs
 * and user's customers, employees, agents, transferees, successors,
 * and assigns.
 *
 * Telenor Research and Development does not represent or warrant that
 * the programs furnished hereunder are free of infringement of any
 * third-party patents.
 *
 * Commercial implementations of H.263, including shareware, are
 * subject to royalty fees to patent holders.  Many of these patents
 * are general enough such that they are unavoidable regardless of
 * implementation design.
 * */


/*
 * based on mpeg2decode, (C) 1994, MPEG Software Simulation Group
 * and mpeg2play, (C) 1994 Stefan Eckart
 *                         <stefan@lis.e-technik.tu-muenchen.de>
 *
 */


#include <stdio.h>
#include <stdlib.h>

#include "pyradecoder.h"

#include "Util.h"
#include "common.h"




void reconstructPyra(PyraGlobal *pyraData, int bx, int by, int P, int bdx, int bdy)
{
  int w,h,lx,lx2,dx,dy;
  int x,y,i,mode;
  unsigned char *src[3];

  x = bx/16; y = by/16;
  i = x + y * pyraData->mvf.w;
  lx = pyraData->width;

  lx2 = pyraData->width;
  src[0] = pyraData->TempRefPic->y;
  src[1] = pyraData->TempRefPic->u;
  src[2] = pyraData->TempRefPic->v;

  mode = pyraData->mvf.mode[i];

  /* P prediction */
  w = 16; h = 16;
  dx = pyraData->mvf.mx[i];
  dy = pyraData->mvf.my[i];

  /* Y */
  recon_comp(src[0],pyraData->DecPic->y, lx,lx2,w,h,bx,by,dx,dy,0);

  lx>>=1; w>>=1; bx>>=1; lx2>>=1; 
  h>>=1; by>>=1;  
  /* chroma rounding */
  dx = ( dx % 4 == 0 ? dx >> 1 : (dx>>1)|1 );
  dy = ( dy % 4 == 0 ? dy >> 1 : (dy>>1)|1 );

  /* Chroma */
  recon_comp(src[1],pyraData->DecPic->u, lx,lx2,w,h,bx,by,dx,dy,1);
  recon_comp(src[2],pyraData->DecPic->v, lx,lx2,w,h,bx,by,dx,dy,2);
}
