#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "defs.h"
#include "Util.h"
#include "bitOut.h"

#include "structs.h"
#include "pyraencoder.h"
#include "Lattice.h"
#include "motion.h"
#include "pyracoder.p"


#define CBSIZE 64

		/* Converts vector components into a linear index range */
int ConvTab[CBSIZE][8] = { 
  {-1,1,-1,0,-1,-1,-1,-1,}, {0,-1,1,-1,-1,-1,-1,-1,}, {2,-1,1,-1,0,-1,-1,-1,}, {1,-1,2,-1,0,-1,-1,-1,}, {-1,1,-1,0,-1,-1,-1,-1,}, {-1,0,-1,1,-1,-1,-1,-1,}, {0,-1,2,-1,1,-1,-1,-1,}, {2,-1,0,-1,1,-1,-1,-1,}, {0,-1,2,-1,1,-1,-1,-1,}, {-1,-1,0,-1,-1,-1,-1,-1,}, {-1,2,-1,1,-1,0,-1,-1,}, {-1,2,-1,0,-1,1,-1,-1,}, {-1,0,-1,1,-1,-1,-1,-1,}, {-1,2,-1,1,-1,0,-1,-1,}, {-1,-1,1,-1,0,-1,-1,-1,}, {-1,0,-1,1,-1,-1,-1,-1,}, {1,-1,-1,-1,0,-1,-1,-1,}, {0,-1,2,-1,1,-1,-1,-1,}, {-1,1,-1,2,-1,0,-1,-1,}, {-1,2,-1,0,-1,1,-1,-1,}, {-1,1,-1,-1,-1,0,-1,-1,}, {1,-1,0,-1,2,-1,-1,-1,}, {0,-1,1,-1,2,-1,-1,-1,}, {-1,-1,0,-1,1,-1,-1,-1,}, {2,-1,3,-1,0,-1,1,-1,}, {-1,0,-1,2,-1,1,-1,-1,}, {-1,1,-1,2,-1,0,-1,-1,}, {2,-1,1,-1,-1,-1,0,-1,}, {1,-1,3,-1,2,-1,0,-1,}, {-1,2,-1,0,-1,1,-1,-1,}, {-1,1,-1,-1,-1,0,-1,-1,}, {-1,1,-1,2,-1,0,-1,-1,}, {3,-1,0,-1,1,-1,2,-1,}, {0,-1,-1,-1,1,-1,-1,-1,}, {-1,-1,2,-1,1,-1,0,-1,}, {1,-1,2,-1,-1,-1,0,-1,}, {0,-1,3,-1,1,-1,2,-1,}, {-1,1,-1,0,-1,2,-1,-1,}, {0,-1,2,-1,3,-1,1,-1,}, {0,-1,1,-1,2,-1,-1,-1,}, {-1,0,-1,2,-1,1,-1,-1,}, {-1,-1,-1,0,-1,-1,-1,-1,}, {2,-1,0,-1,-1,-1,1,-1,}, {-1,-1,-1,1,-1,0,-1,-1,}, {-1,-1,1,-1,2,-1,0,-1,}, {-1,0,-1,2,-1,1,-1,-1,}, {-1,2,-1,0,-1,-1,-1,1,}, {0,-1,1,-1,2,-1,3,-1,}, {-1,-1,0,-1,2,-1,1,-1,}, {-1,0,-1,1,-1,2,-1,-1,}, {-1,0,-1,2,-1,1,-1,-1,}, {3,-1,0,-1,2,-1,1,-1,}, {-1,2,-1,3,-1,0,-1,1,}, {-1,0,-1,1,-1,2,-1,-1,}, {-1,-1,0,-1,1,-1,-1,-1,}, {-1,0,-1,1,-1,-1,-1,-1,}, {-1,2,-1,0,-1,1,-1,-1,}, {-1,-1,2,-1,0,-1,1,-1,}, {-1,-1,-1,0,-1,1,-1,-1,}, {-1,2,-1,1,-1,-1,-1,0,}, {0,-1,3,-1,1,-1,2,-1,}, {0,-1,1,-1,3,-1,2,-1,}, {3,-1,1,-1,0,-1,2,-1,}, {0,-1,2,-1,-1,-1,1,-1,}
};

/* 0: not 1, 2 or 3
   1: D8 with odd number of signs
   2: D8 with even number of signs
   3: E8 with eight signs
*/

int SignType[CBSIZE] = { 2, 0, 0, 0, 1, 2, 0, 0, 0, 3, 2, 1, 1, 1, 3, 2, 0, 0, 2, 2, 2, 0, 0, 3, 0, 2, 1, 0, 0, 1, 2, 1, 0, 0, 3, 0, 0, 2, 0, 0, 2, 2, 0, 2, 3, 2, 2, 0, 3, 2, 1, 0, 2, 1, 3, 1, 1, 3, 2, 2, 0, 0, 0, 0 };


/* How many bits to we need for one index ? */

int CompBits[CBSIZE] = { 5, 5, 8, 9, 6, 7, 9, 9, 6, 0, 8, 6, 6, 9, 5, 5, 5, 9, 9, 9, 3, 10, 9, 7, 11, 9, 10, 9, 11, 8, 5, 8, 9, 7, 8, 8, 9, 10, 11, 8, 6, 0, 6, 5, 9, 9, 6, 12, 9, 9, 8, 10, 11, 10, 5, 3, 9, 9, 7, 9, 10, 11, 11, 9 };

/*
int VectBits[CBSIZE] = { 12, 11, 11, 14, 13, 14, 15, 13, 13, 8, 15,
13, 13, 16, 13, 12, 7, 16, 16, 16, 10, 15, 15, 15, 16, 16, 17, 13, 17,
15, 12, 15, 12, 11, 16, 14, 16, 17, 18, 15, 13, 7, 8, 12, 17, 16, 13,
18, 17, 16, 15, 14, 18, 17, 13, 10, 16, 17, 14, 16, 17, 18, 16, 15 };

int IndexBits[CBSIZE+1] = { 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
6, 6, 6, 6 };
*/

static int EncEvenSignTable[256];
static int EncOddSignTable[256];
static int DecEvenSignTable[256];
static int DecOddSignTable[256];

static int Table17[8+1];
static int Table26[28+1];
static int Table35[56+1];
static int Table44[70+1];

static int Table116[56+1];
static int Table125[168+1];
static int Table134[280+1];
static int Table224[420+1];
static int Table233[560+1];

static int Table1115[336+1];
static int Table1124[840+1];
static int Table1133[1120+1];
static int Table1223[1680+1];
static int Table2222[2520+1];

				/* Which table is appropriate for the given codebook index ? */
static int *CodingTables[CBSIZE] = { 
Table26, Table26, Table125, Table134, Table35, Table44, Table224, Table224, Table116, NULL, Table125, Table116, Table35, Table134, Table26, Table26, Table26, Table134, Table134, Table224, Table17, Table233, Table224, Table44, Table1133, Table224, Table233, Table134, Table1223, Table125, Table26, Table125, Table1115, Table44, Table125, Table125, Table1115, Table233, Table1133, Table125, Table116, NULL, Table116, Table26, Table134, Table134, Table116, Table2222, Table224, Table224, Table125, Table1124, Table1133, Table233, Table26, Table17, Table134, Table224, Table44, Table134, Table1124, Table1223, Table1223, Table224
};

				/* How many bits do we need to encode one component index ? */

static int IndexSize[CBSIZE] = {
  1, 1, 2, 2, 1, 1, 2, 2, 2, 0, 2, 2, 1, 2, 1, 1, 1, 2, 2, 2, 1, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 0, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 2, 2, 1, 2, 2, 2, 2, 2 };


int IndexHist[CBSIZE+1] = { 0 };
int EvenSignHist[128] = { 0 };
int OddSignHist[128] = { 0 };
int AllSignHist[256] = { 0 };

				/* Describes all the structures within the codebook */
Byte StructCB[CBSIZE][8] = {
{0,6,0,2,0,0,0,0,}, {2,0,6,0,0,0,0,0,}, {5,0,2,0,1,0,0,0,}, {3,0,4,0,1,0,0,0,}, {0,5,0,3,0,0,0,0,}, {0,4,0,4,0,0,0,0,}, {2,0,4,0,2,0,0,0,}, {4,0,2,0,2,0,0,0,}, {1,0,6,0,1,0,0,0,}, {0,0,8,0,0,0,0,0,}, {0,5,0,2,0,1,0,0,}, {0,6,0,1,0,1,0,0,}, {0,3,0,5,0,0,0,0,}, {0,4,0,3,0,1,0,0,}, {0,0,6,0,2,0,0,0,}, {0,2,0,6,0,0,0,0,}, {6,0,0,0,2,0,0,0,}, {1,0,4,0,3,0,0,0,}, {0,3,0,4,0,1,0,0,}, {0,4,0,2,0,2,0,0,}, {0,7,0,0,0,1,0,0,}, {3,0,2,0,3,0,0,0,}, {2,0,2,0,4,0,0,0,}, {0,0,4,0,4,0,0,0,}, {3,0,3,0,1,0,1,0,}, {0,2,0,4,0,2,0,0,}, {0,3,0,3,0,2,0,0,}, {4,0,3,0,0,0,1,0,}, {2,0,3,0,2,0,1,0,}, {0,5,0,1,0,2,0,0,}, {0,6,0,0,0,2,0,0,}, {0,2,0,5,0,1,0,0,}, {5,0,1,0,1,0,1,0,}, {4,0,0,0,4,0,0,0,}, {0,0,5,0,2,0,1,0,}, {2,0,5,0,0,0,1,0,}, {1,0,5,0,1,0,1,0,}, {0,3,0,2,0,3,0,0,}, {1,0,3,0,3,0,1,0,}, {1,0,2,0,5,0,0,0,}, {0,1,0,6,0,1,0,0,}, {0,0,0,8,0,0,0,0,}, {6,0,1,0,0,0,1,0,}, {0,0,0,6,0,2,0,0,}, {0,0,3,0,4,0,1,0,}, {0,1,0,4,0,3,0,0,}, {0,6,0,1,0,0,0,1,}, {2,0,2,0,2,0,2,0,}, {0,0,2,0,4,0,2,0,}, {0,2,0,2,0,4,0,0,}, {0,1,0,5,0,2,0,0,}, {4,0,1,0,2,0,1,0,}, {0,3,0,3,0,1,0,1,}, {0,2,0,3,0,3,0,0,}, {0,0,2,0,6,0,0,0,}, {0,1,0,7,0,0,0,0,}, {0,4,0,1,0,3,0,0,}, {0,0,4,0,2,0,2,0,}, {0,0,0,4,0,4,0,0,}, {0,4,0,3,0,0,0,1,}, {1,0,4,0,1,0,2,0,}, {1,0,2,0,3,0,2,0,}, {3,0,2,0,1,0,2,0,}, {2,0,4,0,0,0,2,0,}
};
  
  
void PrintSignPattern(int sign) {
  int i;

  for (i=0; i<4; i++) {
    if (sign & (1<<(7-i))) fprintf(stderr,"+"); else fprintf(stderr,"-");
  }
  fprintf(stderr," ");
  for (i=4; i<8; i++) {
    if (sign & (1<<(7-i))) fprintf(stderr,"+"); else fprintf(stderr,"-");
  }
}


void PrintIndexHist() {
  int i;
  int sign;

  return;

  for (i=0; i<CBSIZE+1; i++) {
    fprintf(stderr,"%d ", IndexHist[i]);
  }
  fprintf(stderr,"\nEvenSigns\n");

  for (i=0; i<128; i++) {
    fprintf(stderr,"%d ", EvenSignHist[i]);
    sign = DecEvenSignTable[i];
    /* PrintSignPattern(sign);
    fprintf(stderr,"\n");  */
  }
  fprintf(stderr,"\nOddSigns\n");

  for (i=0; i<128; i++) {
    fprintf(stderr,"%d ", OddSignHist[i]);
    sign = DecOddSignTable[i];
    /* PrintSignPattern(sign);
    fprintf(stderr,"\n"); */
  }

  fprintf(stderr,"\nAllSigns\n");

  for (i=0; i<256; i++) {
    fprintf(stderr,"%d ", AllSignHist[i]);
    /* PrintSignPattern(i);
    fprintf(stderr,"\n"); */
  }

}


int FindCBIndex(float *v, int *sign, int *nsign) {
				/* Compute histogram and search through codebook */
  int i;
  int vabs;
  Byte hist[8];

  memset(hist,0,8);		/* Initialize histogram */
  *sign = *nsign = 0;

  for (i=0; i<8; i++) {		/* Make histogram and bit pattern of signs */
    vabs = (int)(2*fabs(v[i]));
    if (vabs>7) {
      return(CBSIZE);
    }
    hist[vabs]++;
    if (vabs != 0) { (*nsign)++; *sign = (((*sign)<<1) | ( (v[i]<0) ? 1 : 0)); }
  }

  for (i=0; i<64; i++) {
    if (memcmp(hist,StructCB[i],8)==0) return(i); /* Return index if found */
  }
  return(CBSIZE); /* Not found */
}

int EncSign(int index, int sign, int nsign, Bitstr *bs) {
  int UsedBits = 0;
  int type;

  type = SignType[index];

  switch(type) {
  case 0: 
    UsedBits += EmitBits(sign, nsign,"Ext signs 0", bs);
    if ((nsign>2)&&((sign&3)==0)) UsedBits += EmitBits(1,1,"Stuffing", bs);
    /* to prevent sync code faking */
#ifdef COUNT_BITS
    bitCountP->totalBits += UsedBits;
    bitCountP->lum3Bits += UsedBits;
#endif
    break;
  case 1: 
    sign = EncOddSignTable[sign]; 
    UsedBits += EmitBits(sign, 7,"Ext signs 1", bs);
    if ((sign&3)==0) UsedBits += EmitBits(1,1,"Stuffing", bs);
    /* to prevent sync code faking */
#ifdef COUNT_BITS
    bitCountP->totalBits += UsedBits;
    bitCountP->lum3Bits += UsedBits;
#endif
    break;
  case 2:
    sign = EncEvenSignTable[sign];
    UsedBits += PutEvenSignHuffCode(sign, bs);
    break;
  case 3:
    UsedBits += PutAllSignsHuffCode(sign, bs);
    break;
  }
  return(UsedBits);
}

static int FindComp(int comp, int *table) {
  
  int i;

  for (i=1; i<=table[0]; i++) {
    if (comp==table[i]) return(i-1);
  }
  fprintf(stderr,"Not found\n");
  return(-1);
}


int EncodeComponents(float v[8], int index, Bitstr *bs) {
  int UsedBits = 0;
  int i;
  int vi, comp, ti;
  int *table;

  table = CodingTables[index];

  if (table==NULL) return(0); /* Nothing needs to be coded here */

  comp = 0;
  switch (IndexSize[index]) {
  case 1:
    /* Make 8*1=8 bit word */
    for (i=0; i<8; i++) {
      vi = (int)(2*fabs(v[i]));
      comp  |= (ConvTab[index][vi]<<(7-i));
    }
    break;
  case 2:
    /* Make 8*2=16 bit word */
    for (i=0; i<8; i++) {
      vi = (int)(2*fabs(v[i]));
      comp  |= (ConvTab[index][vi]<<((7-i)*2));
    }
  }
  ti = FindComp(comp, table);
  UsedBits += EmitBits(ti,CompBits[index],"CompBits", bs);
  if ((ti&3)==0) UsedBits += EmitBits(1,1,"Stuffing", bs);
  /* to prevent sync code faking */
#ifdef COUNT_BITS
  bitCountP->totalBits += UsedBits;
  bitCountP->lum3Bits += UsedBits;
#endif

  return(UsedBits);
}

int EncodeExtVector(float v[8], int index, int sign, int nsign, Bitstr *bs) {
				/* Simulates coding of an external vector */
				/* Returns the number of bits VLC coding of index and 
				   fixed lenght coding of vector */
  int UsedBits = 0;

  UsedBits += EncodeComponents(v, index, bs);
  UsedBits += EncSign(index, sign, nsign, bs);
  return(UsedBits);
}

static int CountOnes(int number) {
  int n;
  int one = 0;
  for (n=0; n<8; n++) if ((1<<n)&number) one++;
  return(one);
}

static int CheckHisto(int number, int *matchhist, int size) {

  int i;
  int comp;
  int histo[4];
  int match;

  histo[0] = histo[1] = histo[2] = histo[3] = 0;

  for (i=0; i<8; i++) {
    comp = (number>>((7-i)*2))&3;
    if (comp<size) histo[comp]++;
  }

  match = 1;

  for (i=0; i<size; i++) {
    if (histo[i]!=matchhist[i]) {
      match = 0;
      break;
    }
  }
  return(match);
}

void InitExtVectTables() {
  int i;
  int ones;
  int index;
  int oddIndex = 0;
  int evenIndex = 0;
  int hist[4];

  memset(EncOddSignTable, -1, 256*sizeof(int));
  memset(EncEvenSignTable, -1, 256*sizeof(int));
  memset(DecOddSignTable, -1, 256*sizeof(int));
  memset(DecEvenSignTable, -1, 256*sizeof(int));
 
  for (i=0; i<256; i++) {
    ones = CountOnes(i);
    if (ones&1) {
      EncOddSignTable[i] = oddIndex;
      DecOddSignTable[oddIndex] = i;
      oddIndex++;
    } else {
      EncEvenSignTable[i] = evenIndex;
      DecEvenSignTable[evenIndex] = i;
      evenIndex++;
    }
  }

  memset(Table17, -1, 9*sizeof(int));
  Table17[0] = 8;
  index = 1;
  for (i=0; i<256; i++) {
    ones = CountOnes(i);
    if (ones==7) {
      Table17[index++] = i;
    }
  }

  memset(Table26, -1, 29*sizeof(int));
  Table26[0] = 28;
  index = 1;
  for (i=0; i<256; i++) {
    ones = CountOnes(i);
    if (ones==6) {
      Table26[index++] = i;
    }
  }

  memset(Table35, -1, 57*sizeof(int));
  Table35[0] = 56;
  index = 1;
  for (i=0; i<256; i++) {
    ones = CountOnes(i);
    if (ones==5) Table35[index++] = i;
  }

  memset(Table44, -1, 71*sizeof(int));
  Table44[0]=70;
  index = 1;
  for (i=0; i<256; i++) {
    ones = CountOnes(i);
    if (ones==4) Table44[index++] = i;
  }

  hist[0] = 1; hist[1] = 1; hist[2] = 6;
  memset(Table116, -1, 57*sizeof(int));
  Table116[0]=56;
  index = 1;
  for (i=0; i<65536; i++) {
    if (CheckHisto(i, hist,3)) {
      Table116[index++] = i;
    }
  }

  hist[0] = 1; hist[1] = 2; hist[2] = 5;
  memset(Table125, -1, 169*sizeof(int));
  Table125[0]=168;
  index = 1;
  for (i=0; i<65536; i++) {
    if (CheckHisto(i, hist,3)) {
      Table125[index++] = i;
    }
  }

  hist[0] = 1; hist[1] = 3; hist[2] = 4;

  memset(Table134, -1, 281*sizeof(int));
  Table134[0]=280;

  index = 1;
  for (i=0; i<65536; i++) {
    if (CheckHisto(i, hist,3)) {
      Table134[index++] = i;
    }
  }

  hist[0] = 2; hist[1] = 2; hist[2] = 4;

  memset(Table224, -1, 421*sizeof(int));
  Table224[0]=420;

  index = 1;
  for (i=0; i<65536; i++) {
    if (CheckHisto(i, hist,3)) {
      Table224[index++] = i;
    }
  }

  hist[0] = 2; hist[1] = 3; hist[2] = 3;

  memset(Table233, -1, 561*sizeof(int));
  Table233[0] = 560;

  index = 1;
  for (i=0; i<65536; i++) {
    if (CheckHisto(i, hist,3)) {
      Table233[index++] = i;
    }
  }

  hist[0] = 1; hist[1] = 1; hist[2] = 3; hist[3] = 3;

  memset(Table1133, -1, 1121*sizeof(int));
  Table1133[0] = 1120;
  index = 1;
  for (i=0; i<65536; i++) {
    if (CheckHisto(i, hist,4)) {
      Table1133[index++] = i;
    }
  }

  hist[0] = 1; hist[1] = 1; hist[2] = 1; hist[3] = 5;

  memset(Table1115, -1, 337*sizeof(int));
  Table1115[0] = 336;
  index = 1;
  for (i=0; i<65536; i++) {
    if (CheckHisto(i, hist,4)) {
      Table1115[index++] = i;
    }
  }

  /* Component 0 occurs 1 times, component 1 2 times and so forth */
  hist[0] = 1; hist[1] = 2; hist[2] = 2; hist[3] = 3;

  memset(Table1223, -1, 1681*sizeof(int));
  Table1223[0] = 1680;
  index = 1;
  for (i=0; i<65536; i++) {
    if (CheckHisto(i, hist,4)) {
      Table1223[index++] = i;
    }
  }

  hist[0] = 2; hist[1] = 2; hist[2] = 2; hist[3] = 2;

  memset(Table2222, -1, 2521*sizeof(int));
  Table2222[0] = 2520;

  index = 1;
  for (i=0; i<65536; i++) {
    if (CheckHisto(i, hist,4)) {
      Table2222[index++] = i;
    }
  }

  hist[0] = 1; hist[1] = 1; hist[2] = 2; hist[3] = 4;

  memset(Table1124, -1, 841*sizeof(int));
  Table1124[0] = 840;
  index = 1;
  for (i=0; i<65536; i++) {
    if (CheckHisto(i, hist,4)) {
      Table1124[index++] = i;
    }
  }

  hist[0] = 1; hist[1] = 2; hist[2] = 2; hist[3] = 3;

  memset(Table1223, -1, 1681*sizeof(int));
  Table1223[0] = 1680;
  index = 1;
  for (i=0; i<65536; i++) {
    if (CheckHisto(i, hist,4)) {
      Table1223[index++] = i;
    }
  }

}
