#include <stdlib.h>
#include <string.h>

#include "Lattice.h"
#include "defs.h"
#include "Util.h"
#include "bitOut.h"
#include "code.h"

#include "H263_mvd.h"

#include "structs.h"
#include "pyraencoder.h"
#include "motion.h"
#include "pyracoder.p"
#include "common.p"


#define TRAINING 
/*
#define TRACE
#define TRAINING 
#define VERBOSE 
*/
int CombSignHuffCodeTab[18] = {1, 2, 1, 7, 3, 4, 1, 8, 2, 4, 1, 5, 1,
4, 1, 6, 1, 1, };

int VCombHuffCodeTab[128] = {9, 4, 13, 6, 12, 6, 11, 6, 13, 7, 19, 9,
19, 10, 18, 10, 10, 6, 8, 4, 13, 5, 12, 5, 12, 7, 19, 8, 18, 8, 17,
10, 11, 5, 10, 5, 3, 2, 7, 4, 17, 8, 18, 9, 17, 9, 16, 10, 9, 6, 9, 5,
8, 5, 5, 3, 8, 6, 16, 8, 15, 8, 15, 10, 16, 9, 11, 7, 14, 8, 10, 7, 7,
5, 15, 9, 14, 9, 14, 10, 13, 9, 13, 8, 12, 9, 12, 8, 11, 8, 7, 6, 13,
10, 12, 10, 11, 9, 10, 8, 11, 10, 10, 10, 9, 10, 8, 10, 7, 10, 6, 10,
5, 10, 4, 10, 10, 9, 3, 10, 2, 10, 3, 11, 2, 11, 1, 11, };

int VMagHuffCodeTab[16] = {1, 6, 3, 2, 2, 2, 1, 2, 1, 3, 1, 4, 1, 5,
1, 7, };

int DiffHuffCodeTab[256] = {9, 4, 3, 2, 5, 3, 8, 4, 7, 4, 6, 4, 11, 5,
10, 5, 19, 6, 18, 6, 17, 6, 16, 6, 25, 7, 24, 7, 15, 6, 14, 6, 23, 7,
13, 6, 22, 7, 21, 7, 20, 7, 37, 8, 36, 8, 19, 7, 35, 8, 59, 9, 34, 8,
33, 8, 32, 8, 31, 8, 58, 9, 57, 9, 56, 9, 55, 9, 54, 9, 53, 9, 52, 9,
51, 9, 50, 9, 49, 9, 48, 9, 47, 9, 46, 9, 30, 8, 45, 9, 44, 9, 43, 9,
42, 9, 41, 9, 40, 9, 39, 9, 77, 10, 76, 10, 75, 10, 74, 10, 73, 10,
72, 10, 71, 10, 70, 10, 69, 10, 68, 10, 67, 10, 66, 10, 65, 10, 64,
10, 63, 10, 62, 10, 61, 10, 60, 10, 59, 10, 58, 10, 57, 10, 56, 10,
55, 10, 54, 10, 53, 10, 52, 10, 51, 10, 50, 10, 49, 10, 48, 10, 47,
10, 46, 10, 45, 10, 44, 10, 43, 10, 42, 10, 41, 10, 40, 10, 39, 10,
38, 10, 37, 10, 36, 10, 35, 10, 34, 10, 33, 10, 32, 10, 31, 10, 30,
10, 29, 10, 28, 10, 27, 10, 26, 10, 25, 10, 24, 10, 23, 10, 22, 10,
21, 10, 20, 10, 19, 10, 18, 10, 17, 10, 16, 10, 15, 10, 14, 10, 13,
10, 12, 10, 11, 10, 10, 10, 9, 10, 8, 10, 7, 10, 6, 10, 5, 10, 4, 10,
3, 10, 2, 10, 1, 10, };


int EvenSignHuffCodeTab[256] = {7, 3, 25, 7, 37, 10, 37, 8, 25, 6, 53,
9, 24, 7, 11, 4, 10, 4, 52, 9, 36, 10, 36, 8, 24, 6, 51, 9, 50, 9, 49,
9, 35, 10, 48, 9, 34, 10, 47, 9, 31, 11, 30, 11, 29, 11, 33, 10, 23,
6, 22, 6, 28, 11, 32, 10, 21, 6, 31, 10, 46, 9, 15, 5, 45, 9, 44, 9,
23, 7, 43, 9, 42, 9, 27, 11, 26, 11, 30, 10, 25, 11, 24, 11, 41, 9,
40, 9, 23, 11, 22, 11, 39, 9, 29, 10, 38, 9, 37, 9, 21, 11, 22, 7, 20,
11, 19, 11, 35, 8, 36, 9, 34, 8, 35, 9, 28, 10, 20, 6, 34, 9, 33, 9,
27, 10, 32, 9, 21, 7, 26, 10, 31, 9, 30, 9, 9, 4, 33, 8, 29, 9, 19, 6,
28, 9, 32, 8, 18, 11, 17, 11, 14, 5, 25, 10, 20, 7, 18, 6, 16, 11, 15,
11, 14, 11, 13, 11, 12, 11, 24, 10, 23, 10, 11, 11, 27, 9, 22, 10, 21,
10, 20, 10, 19, 7, 31, 8, 19, 10, 10, 11, 17, 6, 26, 9, 9, 11, 18, 10,
30, 8, 17, 10, 16, 6, 13, 5, 29, 8, 8, 11, 7, 11, 6, 11, 25, 9, 5, 11,
24, 9, 23, 9, 16, 10, 4, 11, 22, 9, 28, 8, 21, 9, 3, 11, 20, 9, 15, 6,
8, 4, 14, 6, 19, 9, 2, 11, 27, 8, 1, 11, 13, 6, 6, 3, };


int AllSignsHuffCodeTab[512] = {3, 2, 75, 8, 133, 9, 132, 9, 131, 9,
130, 9, 129, 9, 128, 9, 127, 9, 126, 9, 125, 9, 124, 9, 74, 8, 73, 8,
123, 9, 5, 3, 122, 9, 72, 8, 121, 9, 120, 9, 119, 9, 118, 9, 207, 10,
206, 10, 205, 10, 204, 10, 203, 10, 202, 10, 201, 10, 200, 10, 199,
10, 198, 10, 197, 10, 196, 10, 195, 10, 194, 10, 193, 10, 192, 10,
191, 10, 117, 9, 190, 10, 189, 10, 188, 10, 187, 10, 186, 10, 185, 10,
184, 10, 183, 10, 116, 9, 182, 10, 181, 10, 41, 7, 180, 10, 179, 10,
178, 10, 177, 10, 176, 10, 175, 10, 174, 10, 173, 10, 115, 9, 172, 10,
171, 10, 170, 10, 169, 10, 168, 10, 167, 10, 166, 10, 165, 10, 164,
10, 163, 10, 162, 10, 161, 10, 160, 10, 159, 10, 158, 10, 114, 9, 157,
10, 156, 10, 155, 10, 154, 10, 153, 10, 152, 10, 151, 10, 150, 10,
149, 10, 148, 10, 147, 10, 146, 10, 145, 10, 144, 10, 143, 10, 142,
10, 141, 10, 140, 10, 139, 10, 138, 10, 137, 10, 136, 10, 135, 10,
134, 10, 133, 10, 132, 10, 40, 7, 131, 10, 130, 10, 129, 10, 128, 10,
127, 10, 126, 10, 125, 10, 124, 10, 113, 9, 123, 10, 122, 10, 71, 8,
121, 10, 120, 10, 119, 10, 112, 9, 118, 10, 117, 10, 116, 10, 115, 10,
114, 10, 113, 10, 112, 10, 111, 9, 70, 8, 111, 10, 110, 10, 109, 10,
108, 10, 107, 10, 106, 10, 105, 10, 21, 6, 104, 10, 103, 10, 102, 10,
101, 10, 100, 10, 99, 10, 98, 10, 97, 10, 39, 7, 96, 10, 95, 10, 94,
10, 93, 10, 92, 10, 91, 10, 90, 10, 11, 5, 89, 10, 88, 10, 87, 10, 86,
10, 85, 10, 110, 9, 84, 10, 83, 10, 82, 10, 81, 10, 80, 10, 79, 10,
78, 10, 77, 10, 76, 10, 75, 10, 74, 10, 73, 10, 72, 10, 71, 10, 70,
10, 69, 10, 68, 10, 67, 10, 66, 10, 65, 10, 64, 10, 63, 10, 62, 10,
61, 10, 60, 10, 59, 10, 58, 10, 57, 10, 56, 10, 55, 10, 54, 10, 53,
10, 109, 9, 52, 10, 51, 10, 50, 10, 49, 10, 48, 10, 47, 10, 46, 10,
45, 10, 44, 10, 43, 10, 42, 10, 38, 7, 108, 9, 107, 9, 106, 9, 41, 10,
40, 10, 39, 10, 38, 10, 37, 10, 36, 10, 35, 10, 34, 10, 33, 10, 32,
10, 31, 10, 30, 10, 69, 8, 29, 10, 28, 10, 27, 10, 26, 10, 25, 10, 24,
10, 23, 10, 22, 10, 21, 10, 20, 10, 19, 10, 18, 10, 17, 10, 16, 10,
15, 10, 14, 10, 13, 10, 68, 8, 12, 10, 4, 3, 11, 10, 10, 10, 67, 8, 9,
10, 8, 10, 7, 10, 105, 9, 6, 10, 5, 10, 4, 10, 3, 10, 2, 10, 1, 10,
104, 9, 3, 3, };


int PPredTypeHuffCodeTab[8] = {1, 1, 1, 2, 1, 3, 1, 4, }; 

/* int PPredTypeHuffCodeTab[12] = {1, 4, 1, 3, 1, 1, 1, 2, 1, 5, 1, 6, }; */

int IntraShellCombCHuffCodeTab[30] = {1, 1, 3, 5, 5, 6, 1, 2, 1, 3,
3, 7, 4, 6, 3, 8, 3, 6, 2, 8, 2, 7, 1, 10, 1, 8, 1, 9, 2, 6, };


int Shell1SPYHuffCodeTab[240] = {7, 3, 27, 11, 26, 11, 25, 9, 25, 10,
19, 13, 11, 4, 15, 5, 25, 8, 25, 11, 24, 8, 21, 7, 24, 9, 24, 10, 23,
10, 23, 9, 21, 12, 11, 14, 10, 14, 20, 12, 22, 10, 21, 10, 20, 10, 20,
7, 9, 14, 22, 9, 19, 12, 18, 12, 14, 5, 13, 5, 18, 13, 17, 12, 21, 9,
24, 11, 23, 8, 17, 13, 8, 14, 16, 12, 22, 8, 15, 12, 7, 14, 10, 4, 16,
13, 19, 7, 9, 4, 8, 4, 19, 10, 20, 9, 19, 9, 21, 8, 18, 9, 14, 12, 23,
11, 15, 6, 12, 5, 22, 11, 18, 10, 17, 9, 18, 7, 20, 8, 16, 9, 6, 14,
15, 13, 14, 6, 11, 5, 17, 7, 21, 11, 19, 8, 20, 11, 13, 12, 12, 12,
11, 12, 15, 9, 13, 6, 14, 13, 18, 8, 17, 8, 16, 8, 15, 8, 19, 11, 10,
12, 5, 14, 18, 11, 17, 11, 13, 13, 12, 13, 10, 5, 9, 5, 4, 14, 3, 14,
17, 10, 16, 11, 15, 11, 14, 11, 11, 13, 16, 7, 16, 10, 14, 8, 15, 7,
10, 13, 2, 14, 8, 5, 9, 13, 8, 13, 1, 14, 7, 13, 13, 11, 14, 9, 14, 7,
13, 7, 12, 11, 15, 10, 12, 6, 14, 10, 6, 3, 11, 11, 13, 8, 6, 13, 13,
9, 11, 6, };


int Shell1SPCHuffCodeTab[240] = {3, 2, 53, 10, 52, 10, 55, 9, 51, 10,
50, 10, 15, 5, 14, 5, 54, 9, 49, 10, 53, 9, 29, 7, 37, 8, 48, 10, 47,
10, 46, 10, 45, 10, 44, 10, 43, 10, 42, 10, 41, 10, 52, 9, 40, 10, 51,
9, 50, 9, 36, 8, 39, 10, 49, 9, 28, 7, 13, 5, 38, 10, 37, 10, 36, 10,
35, 10, 35, 8, 48, 9, 34, 10, 33, 10, 47, 9, 46, 9, 32, 10, 12, 5, 31,
10, 34, 8, 11, 5, 10, 5, 33, 8, 32, 8, 30, 10, 27, 7, 45, 9, 44, 9,
29, 10, 26, 7, 19, 6, 43, 9, 42, 9, 41, 9, 9, 4, 40, 9, 39, 9, 28, 10,
27, 10, 25, 7, 24, 7, 23, 7, 26, 10, 25, 10, 24, 10, 23, 10, 22, 10,
21, 10, 38, 9, 31, 8, 20, 10, 37, 9, 36, 9, 18, 6, 30, 8, 19, 10, 18,
10, 17, 10, 16, 10, 35, 9, 15, 10, 14, 10, 22, 7, 17, 6, 34, 9, 13,
10, 12, 10, 33, 9, 11, 10, 32, 9, 10, 10, 31, 9, 9, 10, 30, 9, 29, 9,
8, 10, 7, 10, 8, 4, 29, 8, 21, 7, 6, 10, 5, 10, 4, 10, 28, 9, 16, 6,
15, 6, 27, 9, 28, 8, 20, 7, 3, 10, 5, 3, 3, 11, 2, 10, 2, 11, 1, 11,
19, 7, };


int Shell2SPYHuffCodeTab[1600] = {363, 11, 543, 12, 155, 9, 542, 12,
362, 11, 541, 12, 154, 9, 115, 8, 114, 8, 540, 12, 539, 12, 538, 12,
537, 12, 536, 12, 535, 12, 534, 12, 361, 11, 533, 12, 360, 11, 532,
12, 531, 12, 359, 11, 249, 10, 113, 8, 112, 8, 530, 12, 529, 12, 111,
8, 528, 12, 153, 9, 248, 10, 110, 8, 527, 12, 526, 12, 358, 11, 525,
12, 524, 12, 523, 12, 357, 11, 522, 12, 521, 12, 247, 10, 520, 12,
519, 12, 518, 12, 517, 12, 152, 9, 246, 10, 516, 12, 515, 12, 356, 11,
514, 12, 151, 9, 355, 11, 513, 12, 512, 12, 245, 10, 354, 11, 511, 12,
77, 7, 510, 12, 509, 12, 508, 12, 507, 12, 244, 10, 243, 10, 506, 12,
242, 10, 505, 12, 504, 12, 503, 12, 502, 12, 241, 10, 501, 12, 353,
11, 500, 12, 352, 11, 499, 12, 498, 12, 497, 12, 109, 8, 496, 12, 495,
12, 494, 12, 351, 11, 493, 12, 492, 12, 491, 12, 108, 8, 490, 12, 489,
12, 76, 7, 488, 12, 487, 12, 486, 12, 485, 12, 484, 12, 483, 12, 240,
10, 482, 12, 481, 12, 480, 12, 239, 10, 479, 12, 107, 8, 478, 12, 477,
12, 476, 12, 475, 12, 474, 12, 473, 12, 472, 12, 238, 10, 471, 12,
470, 12, 237, 10, 469, 12, 468, 12, 467, 12, 466, 12, 465, 12, 464,
12, 236, 10, 463, 12, 462, 12, 461, 12, 460, 12, 459, 12, 458, 12,
457, 12, 350, 11, 456, 12, 455, 12, 454, 12, 235, 10, 150, 9, 453, 12,
452, 12, 43, 6, 451, 12, 450, 12, 449, 12, 349, 11, 448, 12, 75, 7,
106, 8, 447, 12, 234, 10, 446, 12, 233, 10, 445, 12, 232, 10, 444, 12,
443, 12, 442, 12, 348, 11, 441, 12, 440, 12, 439, 12, 347, 11, 438,
12, 437, 12, 436, 12, 435, 12, 434, 12, 433, 12, 432, 12, 105, 8, 431,
12, 430, 12, 429, 12, 428, 12, 104, 8, 427, 12, 426, 12, 425, 12, 103,
8, 424, 12, 423, 12, 422, 12, 421, 12, 420, 12, 419, 12, 346, 11, 345,
11, 418, 12, 417, 12, 102, 8, 416, 12, 415, 12, 231, 10, 344, 11, 101,
8, 414, 12, 413, 12, 412, 12, 411, 12, 410, 12, 409, 12, 408, 12, 149,
9, 407, 12, 406, 12, 23, 5, 343, 11, 405, 12, 404, 12, 403, 12, 342,
11, 402, 12, 401, 12, 341, 11, 400, 12, 399, 12, 398, 12, 397, 12,
396, 12, 395, 12, 394, 12, 393, 12, 392, 12, 391, 12, 390, 12, 389,
12, 388, 12, 340, 11, 387, 12, 339, 11, 74, 7, 230, 10, 338, 11, 386,
12, 385, 12, 337, 11, 384, 12, 383, 12, 73, 7, 148, 9, 382, 12, 336,
11, 72, 7, 381, 12, 380, 12, 379, 12, 378, 12, 147, 9, 335, 11, 334,
11, 377, 12, 376, 12, 375, 12, 374, 12, 373, 12, 372, 12, 371, 12,
370, 12, 369, 12, 368, 12, 367, 12, 366, 12, 146, 9, 71, 7, 365, 12,
364, 12, 363, 12, 362, 12, 361, 12, 145, 9, 360, 12, 100, 8, 359, 12,
358, 12, 357, 12, 333, 11, 356, 12, 355, 12, 354, 12, 332, 11, 353,
12, 352, 12, 351, 12, 350, 12, 349, 12, 348, 12, 347, 12, 331, 11,
346, 12, 345, 12, 344, 12, 343, 12, 342, 12, 341, 12, 340, 12, 229,
10, 330, 11, 99, 8, 339, 12, 329, 11, 338, 12, 337, 12, 336, 12, 228,
10, 144, 9, 335, 12, 334, 12, 333, 12, 328, 11, 227, 10, 332, 12, 143,
9, 226, 10, 331, 12, 330, 12, 329, 12, 328, 12, 327, 12, 70, 7, 326,
12, 325, 12, 324, 12, 225, 10, 327, 11, 323, 12, 322, 12, 321, 12,
320, 12, 319, 12, 318, 12, 224, 10, 223, 10, 317, 12, 316, 12, 315,
12, 314, 12, 313, 12, 312, 12, 311, 12, 310, 12, 309, 12, 308, 12,
142, 9, 307, 12, 306, 12, 305, 12, 98, 8, 304, 12, 303, 12, 302, 12,
301, 12, 300, 12, 222, 10, 299, 12, 326, 11, 298, 12, 325, 11, 297,
12, 42, 6, 97, 8, 296, 12, 295, 12, 41, 6, 221, 10, 294, 12, 293, 12,
69, 7, 292, 12, 324, 11, 291, 12, 290, 12, 289, 12, 288, 12, 287, 12,
286, 12, 323, 11, 285, 12, 284, 12, 220, 10, 283, 12, 282, 12, 281,
12, 141, 9, 280, 12, 279, 12, 278, 12, 96, 8, 277, 12, 276, 12, 275,
12, 274, 12, 273, 12, 272, 12, 219, 10, 271, 12, 270, 12, 269, 12,
268, 12, 267, 12, 218, 10, 266, 12, 265, 12, 264, 12, 263, 12, 262,
12, 95, 8, 217, 10, 216, 10, 261, 12, 260, 12, 259, 12, 258, 12, 257,
12, 68, 7, 256, 12, 255, 12, 322, 11, 321, 11, 215, 10, 254, 12, 253,
12, 214, 10, 320, 11, 252, 12, 251, 12, 94, 8, 250, 12, 213, 10, 249,
12, 319, 11, 248, 12, 247, 12, 246, 12, 140, 9, 245, 12, 212, 10, 244,
12, 139, 9, 243, 12, 242, 12, 318, 11, 241, 12, 40, 6, 240, 12, 317,
11, 211, 10, 210, 10, 239, 12, 238, 12, 67, 7, 138, 9, 237, 12, 137,
9, 236, 12, 93, 8, 235, 12, 234, 12, 233, 12, 232, 12, 231, 12, 230,
12, 229, 12, 228, 12, 227, 12, 226, 12, 225, 12, 224, 12, 223, 12,
222, 12, 209, 10, 136, 9, 221, 12, 220, 12, 66, 7, 92, 8, 219, 12,
218, 12, 217, 12, 135, 9, 216, 12, 215, 12, 214, 12, 316, 11, 315, 11,
213, 12, 212, 12, 211, 12, 314, 11, 208, 10, 210, 12, 209, 12, 208,
12, 313, 11, 207, 12, 206, 12, 205, 12, 204, 12, 203, 12, 202, 12,
312, 11, 22, 5, 201, 12, 200, 12, 311, 11, 207, 10, 310, 11, 199, 12,
91, 8, 309, 11, 198, 12, 197, 12, 196, 12, 195, 12, 194, 12, 206, 10,
90, 8, 308, 11, 193, 12, 192, 12, 191, 12, 307, 11, 190, 12, 205, 10,
189, 12, 188, 12, 187, 12, 186, 12, 185, 12, 204, 10, 184, 12, 203,
10, 183, 12, 134, 9, 182, 12, 181, 12, 180, 12, 179, 12, 178, 12, 306,
11, 177, 12, 176, 12, 175, 12, 174, 12, 173, 12, 172, 12, 171, 12,
170, 12, 169, 12, 305, 11, 202, 10, 133, 9, 168, 12, 167, 12, 166, 12,
165, 12, 164, 12, 163, 12, 201, 10, 200, 10, 304, 11, 162, 12, 89, 8,
161, 12, 160, 12, 159, 12, 158, 12, 303, 11, 157, 12, 156, 12, 155,
12, 199, 10, 154, 12, 153, 12, 152, 12, 151, 12, 150, 12, 149, 12,
198, 10, 148, 12, 147, 12, 146, 12, 302, 11, 145, 12, 144, 12, 301,
11, 143, 12, 197, 10, 142, 12, 141, 12, 300, 11, 140, 12, 139, 12, 39,
6, 299, 11, 138, 12, 137, 12, 196, 10, 298, 11, 65, 7, 136, 12, 64, 7,
63, 7, 297, 11, 135, 12, 134, 12, 88, 8, 195, 10, 133, 12, 132, 12,
132, 9, 194, 10, 131, 12, 87, 8, 130, 12, 129, 12, 128, 12, 296, 11,
86, 8, 85, 8, 127, 12, 126, 12, 125, 12, 124, 12, 84, 8, 193, 10, 131,
9, 123, 12, 122, 12, 121, 12, 120, 12, 83, 8, 119, 12, 118, 12, 117,
12, 116, 12, 295, 11, 82, 8, 115, 12, 294, 11, 114, 12, 293, 11, 113,
12, 112, 12, 111, 12, 110, 12, 109, 12, 108, 12, 107, 12, 106, 12,
105, 12, 104, 12, 103, 12, 102, 12, 101, 12, 292, 11, 100, 12, 99, 12,
98, 12, 97, 12, 96, 12, 95, 12, 94, 12, 93, 12, 192, 10, 92, 12, 81,
8, 91, 12, 90, 12, 89, 12, 191, 10, 130, 9, 88, 12, 87, 12, 86, 12,
190, 10, 85, 12, 84, 12, 83, 12, 82, 12, 291, 11, 80, 8, 290, 11, 289,
11, 288, 11, 81, 12, 287, 11, 80, 12, 79, 12, 286, 11, 78, 12, 77, 12,
76, 12, 75, 12, 74, 12, 73, 12, 72, 12, 71, 12, 70, 12, 62, 7, 69, 12,
285, 11, 61, 7, 68, 12, 67, 12, 66, 12, 65, 12, 64, 12, 129, 9, 284,
11, 63, 12, 128, 9, 62, 12, 61, 12, 60, 12, 59, 12, 127, 9, 283, 11,
58, 12, 57, 12, 126, 9, 56, 12, 55, 12, 54, 12, 53, 12, 52, 12, 51,
12, 282, 11, 281, 11, 50, 12, 49, 12, 48, 12, 47, 12, 46, 12, 45, 12,
79, 8, 78, 8, 44, 12, 189, 10, 43, 12, 42, 12, 41, 12, 3, 2, 40, 12,
39, 12, 188, 10, 38, 12, 37, 12, 36, 12, 35, 12, 34, 12, 280, 11, 33,
12, 187, 10, 32, 12, 31, 12, 30, 12, 279, 11, 29, 12, 278, 11, 28, 12,
27, 12, 26, 12, 25, 12, 277, 11, 186, 10, 24, 12, 185, 10, 184, 10,
23, 12, 22, 12, 21, 12, 20, 12, 183, 10, 19, 12, 182, 10, 60, 7, 18,
12, 17, 12, 16, 12, 15, 12, 14, 12, 59, 7, 13, 12, 276, 11, 12, 12,
58, 7, 11, 12, 10, 12, 9, 12, 8, 12, 7, 12, 275, 11, 274, 11, 125, 9,
6, 12, 5, 12, 4, 12, 3, 12, 2, 12, 273, 11, 1, 12, 272, 11, };


int Shell2SPCHuffCodeTab[1600] = {459, 9, 458, 9, 235, 8, 457, 9,
456, 9, 455, 9, 454, 9, 453, 9, 452, 9, 451, 9, 450, 9, 449, 9, 448,
9, 447, 9, 446, 9, 445, 9, 444, 9, 443, 9, 442, 9, 441, 9, 440, 9,
439, 9, 438, 9, 437, 9, 436, 9, 435, 9, 434, 9, 433, 9, 432, 9, 431,
9, 430, 9, 429, 9, 428, 9, 427, 9, 426, 9, 425, 9, 424, 9, 423, 9,
422, 9, 421, 9, 420, 9, 419, 9, 418, 9, 417, 9, 416, 9, 415, 9, 414,
9, 413, 9, 412, 9, 411, 9, 410, 9, 409, 9, 408, 9, 407, 9, 406, 9,
405, 9, 404, 9, 403, 9, 402, 9, 401, 9, 400, 9, 399, 9, 398, 9, 397,
9, 396, 9, 395, 9, 394, 9, 393, 9, 392, 9, 391, 9, 390, 9, 389, 9,
388, 9, 387, 9, 386, 9, 385, 9, 384, 9, 383, 9, 234, 8, 382, 9, 381,
9, 380, 9, 379, 9, 378, 9, 377, 9, 376, 9, 375, 9, 374, 9, 373, 9,
372, 9, 371, 9, 370, 9, 369, 9, 368, 9, 367, 9, 366, 9, 365, 9, 364,
9, 363, 9, 362, 9, 361, 9, 360, 9, 359, 9, 358, 9, 357, 9, 356, 9,
355, 9, 354, 9, 353, 9, 352, 9, 351, 9, 350, 9, 349, 9, 348, 9, 347,
9, 346, 9, 665, 10, 664, 10, 663, 10, 662, 10, 661, 10, 660, 10, 659,
10, 658, 10, 657, 10, 656, 10, 655, 10, 654, 10, 653, 10, 652, 10,
651, 10, 650, 10, 649, 10, 648, 10, 647, 10, 646, 10, 645, 10, 644,
10, 345, 9, 643, 10, 642, 10, 641, 10, 233, 8, 640, 10, 232, 8, 639,
10, 638, 10, 637, 10, 636, 10, 635, 10, 634, 10, 633, 10, 632, 10,
631, 10, 630, 10, 629, 10, 628, 10, 627, 10, 626, 10, 625, 10, 624,
10, 623, 10, 622, 10, 621, 10, 620, 10, 619, 10, 618, 10, 617, 10,
616, 10, 615, 10, 614, 10, 613, 10, 612, 10, 611, 10, 610, 10, 609,
10, 608, 10, 607, 10, 606, 10, 605, 10, 604, 10, 603, 10, 602, 10,
601, 10, 600, 10, 599, 10, 598, 10, 597, 10, 596, 10, 595, 10, 594,
10, 593, 10, 592, 10, 591, 10, 590, 10, 589, 10, 588, 10, 587, 10,
586, 10, 585, 10, 584, 10, 583, 10, 582, 10, 344, 9, 581, 10, 580, 10,
579, 10, 578, 10, 577, 10, 576, 10, 575, 10, 574, 10, 573, 10, 572,
10, 571, 10, 570, 10, 569, 10, 568, 10, 567, 10, 566, 10, 565, 10,
564, 10, 563, 10, 562, 10, 561, 10, 560, 10, 559, 10, 558, 10, 343, 9,
557, 10, 556, 10, 555, 10, 554, 10, 553, 10, 552, 10, 551, 10, 550,
10, 549, 10, 548, 10, 547, 10, 546, 10, 545, 10, 544, 10, 543, 10,
542, 10, 541, 10, 540, 10, 539, 10, 538, 10, 537, 10, 342, 9, 536, 10,
535, 10, 534, 10, 533, 10, 532, 10, 531, 10, 530, 10, 529, 10, 528,
10, 527, 10, 341, 9, 526, 10, 525, 10, 524, 10, 523, 10, 522, 10, 340,
9, 521, 10, 520, 10, 519, 10, 518, 10, 517, 10, 516, 10, 515, 10, 514,
10, 513, 10, 512, 10, 511, 10, 510, 10, 509, 10, 508, 10, 507, 10,
506, 10, 505, 10, 504, 10, 503, 10, 502, 10, 501, 10, 500, 10, 499,
10, 498, 10, 497, 10, 339, 9, 496, 10, 495, 10, 494, 10, 493, 10, 492,
10, 491, 10, 490, 10, 489, 10, 488, 10, 487, 10, 486, 10, 485, 10,
484, 10, 483, 10, 482, 10, 481, 10, 480, 10, 479, 10, 478, 10, 477,
10, 476, 10, 475, 10, 474, 10, 473, 10, 472, 10, 471, 10, 470, 10,
469, 10, 468, 10, 467, 10, 466, 10, 465, 10, 464, 10, 463, 10, 462,
10, 461, 10, 460, 10, 459, 10, 458, 10, 457, 10, 456, 10, 455, 10,
454, 10, 453, 10, 452, 10, 451, 10, 450, 10, 449, 10, 448, 10, 447,
10, 446, 10, 445, 10, 444, 10, 443, 10, 442, 10, 441, 10, 440, 10,
439, 10, 438, 10, 437, 10, 436, 10, 435, 10, 434, 10, 433, 10, 432,
10, 431, 10, 338, 9, 430, 10, 429, 10, 428, 10, 427, 10, 426, 10, 425,
10, 424, 10, 423, 10, 422, 10, 421, 10, 420, 10, 419, 10, 418, 10,
417, 10, 337, 9, 416, 10, 415, 10, 414, 10, 413, 10, 412, 10, 411, 10,
410, 10, 409, 10, 408, 10, 407, 10, 406, 10, 405, 10, 404, 10, 403,
10, 402, 10, 401, 10, 400, 10, 399, 10, 398, 10, 397, 10, 396, 10,
395, 10, 394, 10, 393, 10, 392, 10, 391, 10, 390, 10, 389, 10, 388,
10, 387, 10, 386, 10, 385, 10, 384, 10, 383, 10, 382, 10, 381, 10,
380, 10, 379, 10, 378, 10, 377, 10, 376, 10, 375, 10, 374, 10, 373,
10, 372, 10, 371, 10, 370, 10, 336, 9, 369, 10, 368, 10, 367, 10, 366,
10, 365, 10, 364, 10, 363, 10, 362, 10, 361, 10, 360, 10, 359, 10,
358, 10, 357, 10, 356, 10, 355, 10, 354, 10, 353, 10, 352, 10, 351,
10, 350, 10, 349, 10, 348, 10, 347, 10, 346, 10, 345, 10, 344, 10,
343, 10, 342, 10, 341, 10, 340, 10, 339, 10, 338, 10, 337, 10, 336,
10, 335, 10, 334, 10, 333, 10, 332, 10, 331, 10, 330, 10, 329, 10,
328, 10, 327, 10, 326, 10, 325, 10, 324, 10, 323, 10, 322, 10, 321,
10, 320, 10, 319, 10, 318, 10, 317, 10, 316, 10, 315, 10, 314, 10,
313, 10, 312, 10, 311, 10, 310, 10, 309, 10, 308, 10, 307, 10, 306,
10, 305, 10, 304, 10, 303, 10, 302, 10, 301, 10, 300, 10, 299, 10,
298, 10, 297, 10, 296, 10, 295, 10, 294, 10, 293, 10, 292, 10, 231, 8,
291, 10, 290, 10, 289, 10, 288, 10, 287, 10, 286, 10, 285, 10, 284,
10, 283, 10, 282, 10, 281, 10, 280, 10, 279, 10, 278, 10, 277, 10,
276, 10, 275, 10, 274, 10, 273, 10, 272, 10, 271, 10, 270, 10, 269,
10, 268, 10, 267, 10, 266, 10, 265, 10, 264, 10, 263, 10, 262, 10,
261, 10, 260, 10, 259, 10, 258, 10, 257, 10, 256, 10, 255, 10, 254,
10, 253, 10, 252, 10, 251, 10, 250, 10, 249, 10, 248, 10, 247, 10,
246, 10, 245, 10, 244, 10, 243, 10, 242, 10, 241, 10, 240, 10, 239,
10, 238, 10, 237, 10, 236, 10, 235, 10, 234, 10, 233, 10, 232, 10,
231, 10, 230, 10, 229, 10, 228, 10, 227, 10, 226, 10, 225, 10, 224,
10, 223, 10, 222, 10, 221, 10, 220, 10, 219, 10, 218, 10, 217, 10,
216, 10, 215, 10, 214, 10, 213, 10, 212, 10, 211, 10, 210, 10, 209,
10, 208, 10, 207, 10, 206, 10, 205, 10, 204, 10, 203, 10, 202, 10,
201, 10, 200, 10, 199, 10, 335, 9, 198, 10, 230, 8, 59, 6, 197, 10,
196, 10, 195, 10, 194, 10, 193, 10, 192, 10, 191, 10, 190, 10, 189,
10, 188, 10, 187, 10, 186, 10, 185, 10, 184, 10, 183, 10, 182, 10,
181, 10, 180, 10, 179, 10, 178, 10, 177, 10, 176, 10, 175, 10, 174,
10, 173, 10, 172, 10, 171, 10, 170, 10, 169, 10, 168, 10, 167, 10,
166, 10, 165, 10, 164, 10, 163, 10, 162, 10, 161, 10, 160, 10, 159,
10, 158, 10, 157, 10, 156, 10, 155, 10, 154, 10, 153, 10, 152, 10,
151, 10, 150, 10, 149, 10, 148, 10, 147, 10, 146, 10, 145, 10, 144,
10, 143, 10, 142, 10, 141, 10, 140, 10, 139, 10, 138, 10, 137, 10,
136, 10, 135, 10, 134, 10, 133, 10, 132, 10, 131, 10, 130, 10, 129,
10, 128, 10, 127, 10, 126, 10, 125, 10, 124, 10, 123, 10, 122, 10,
121, 10, 120, 10, 119, 10, 118, 10, 117, 10, 116, 10, 115, 10, 114,
10, 113, 10, 112, 10, 111, 10, 110, 10, 109, 10, 108, 10, 107, 10,
106, 10, 105, 10, 104, 10, 103, 10, 102, 10, 101, 10, 100, 10, 99, 10,
98, 10, 97, 10, 96, 10, 95, 10, 94, 10, 93, 10, 92, 10, 91, 10, 90,
10, 89, 10, 88, 10, 87, 10, 86, 10, 85, 10, 84, 10, 83, 10, 82, 10,
81, 10, 80, 10, 79, 10, 78, 10, 77, 10, 76, 10, 75, 10, 74, 10, 73,
10, 72, 10, 71, 10, 70, 10, 69, 10, 68, 10, 67, 10, 66, 10, 334, 9,
65, 10, 64, 10, 63, 10, 62, 10, 61, 10, 60, 10, 15, 4, 59, 10, 58, 10,
57, 10, 56, 10, 55, 10, 54, 10, 53, 10, 52, 10, 51, 10, 50, 10, 49,
10, 48, 10, 47, 10, 46, 10, 45, 10, 44, 10, 43, 10, 42, 10, 41, 10,
40, 10, 39, 10, 38, 10, 37, 10, 36, 10, 35, 10, 34, 10, 33, 10, 32,
10, 31, 10, 30, 10, 29, 10, 28, 10, 27, 10, 26, 10, 25, 10, 24, 10,
23, 10, 22, 10, 21, 10, 20, 10, 19, 10, 18, 10, 17, 10, 333, 9, 16,
10, 15, 10, 14, 10, 13, 10, 12, 10, 11, 10, 10, 10, 9, 10, 8, 10, 7,
10, 6, 10, 5, 10, 4, 10, 3, 10, 2, 10, 1, 10, };


int SPYClassHuffCodeTab[130] = {3, 2, 2, 2, 11, 6, 7, 5, 5, 4, 3, 3,
10, 6, 9, 6, 8, 6, 4, 4, 15, 8, 13, 7, 7, 6, 14, 8, 12, 7, 11, 7, 11,
11, 13, 8, 10, 7, 25, 9, 24, 9, 23, 9, 19, 10, 9, 7, 22, 9, 21, 9, 20,
9, 18, 10, 19, 9, 10, 11, 17, 10, 18, 9, 5, 12, 4, 12, 17, 9, 16, 10,
16, 9, 9, 11, 15, 10, 8, 7, 14, 10, 15, 9, 13, 10, 14, 9, 12, 10, 13,
9, 8, 11, 3, 12, 2, 12, 7, 11, 11, 10, 1, 12, 6, 11, 5, 11, 12, 9, 11,
9, 4, 11, 10, 10, 10, 9, 9, 10, 8, 10, 7, 10, 3, 11, 6, 10, 6, 5, };


int SPCClassHuffCodeTab[130] = {7, 3, 11, 4, 35, 6, 47, 7, 34, 6, 10,
4, 33, 6, 32, 6, 31, 6, 6, 3, 46, 7, 45, 7, 44, 7, 43, 7, 30, 6, 42,
7, 41, 7, 40, 7, 39, 7, 29, 6, 38, 7, 37, 7, 28, 6, 27, 6, 36, 7, 35,
7, 34, 7, 33, 7, 32, 7, 26, 6, 31, 7, 25, 6, 30, 7, 29, 7, 24, 6, 28,
7, 27, 7, 26, 7, 25, 7, 24, 7, 23, 7, 22, 7, 21, 7, 20, 7, 19, 7, 18,
7, 17, 7, 16, 7, 15, 7, 14, 7, 13, 7, 12, 7, 11, 7, 10, 7, 9, 7, 8, 7,
7, 7, 6, 7, 5, 7, 4, 7, 3, 7, 2, 7, 1, 7, 1, 8, 9, 4, };


int IntraCCPHuffCodeTab[14] = {1, 5, 1, 2, 1, 6, 1, 3, 1, 7, 1, 1, 1,
4, };

int IntraCCP6HuffCodeTab[126] = {25, 8, 21, 6, 11, 9, 13, 5, 24, 8, 10, 9, 7, 10, 20, 6, 23, 8, 22, 8, 6, 10, 19, 6, 23, 7, 21, 8, 22, 7, 12, 5, 5, 10, 20, 8, 4, 10, 18, 6, 19, 8, 18, 8, 9, 9, 17, 8, 8, 9, 7, 9, 3, 10, 17, 6, 16, 8, 15, 8, 21, 7, 11, 5, 6, 9, 14, 8, 2, 10, 20, 7, 5, 9, 13, 8, 1, 10, 16, 6, 12, 8, 19, 7, 11, 8, 15, 6, 18, 7, 10, 8, 17, 7, 14, 6, 9, 8, 16, 7, 4, 9, 13, 6, 8, 8, 15, 7, 7, 8, 12, 6, 6, 8, 14, 7, 13, 7, 5, 3, 7, 4, 3, 2, 4, 3, };
int InterCCP6HuffCodeTab[128] = { 0 };

int IntraCBPYHuffCodeTab[510] = {27, 5, 43, 6, 42, 6, 15, 4, 26, 5,
85, 8, 65, 7, 25, 5, 84, 8, 41, 6, 64, 7, 63, 7, 62, 7, 83, 8, 40, 6,
39, 6, 97, 9, 61, 7, 60, 7, 96, 9, 95, 9, 85, 10, 82, 8, 94, 9, 47,
11, 81, 8, 93, 9, 92, 9, 91, 9, 80, 8, 79, 8, 24, 5, 78, 8, 90, 9, 89,
9, 84, 10, 77, 8, 46, 11, 83, 10, 82, 10, 23, 12, 45, 11, 81, 10, 44,
11, 88, 9, 43, 11, 80, 10, 59, 7, 87, 9, 76, 8, 38, 6, 79, 10, 86, 9,
42, 11, 85, 9, 84, 9, 22, 12, 78, 10, 77, 10, 76, 10, 83, 9, 75, 10,
75, 8, 37, 6, 74, 10, 82, 9, 73, 10, 74, 8, 72, 10, 41, 11, 40, 11,
36, 6, 73, 8, 58, 7, 72, 8, 57, 7, 81, 9, 80, 9, 71, 8, 56, 7, 79, 9,
70, 8, 69, 8, 71, 10, 78, 9, 77, 9, 76, 9, 55, 7, 70, 10, 35, 6, 54,
7, 75, 9, 74, 9, 68, 8, 53, 7, 73, 9, 69, 10, 39, 11, 21, 12, 20, 12,
68, 10, 19, 12, 18, 12, 17, 12, 16, 12, 67, 10, 38, 11, 15, 12, 37,
11, 14, 12, 13, 12, 67, 8, 66, 10, 72, 9, 12, 12, 65, 10, 64, 10, 63,
10, 62, 10, 66, 8, 61, 10, 52, 7, 60, 10, 71, 9, 59, 10, 70, 9, 51, 7,
23, 5, 65, 8, 58, 10, 57, 10, 69, 9, 64, 8, 11, 12, 56, 10, 68, 9, 36,
11, 55, 10, 10, 12, 67, 9, 66, 9, 54, 10, 35, 11, 50, 7, 34, 11, 65,
9, 33, 11, 53, 10, 64, 9, 9, 12, 8, 12, 32, 11, 7, 12, 52, 10, 6, 12,
51, 10, 50, 10, 31, 11, 30, 11, 22, 5, 63, 8, 63, 9, 29, 11, 62, 8,
61, 8, 49, 10, 62, 9, 60, 8, 5, 12, 61, 9, 4, 12, 28, 11, 48, 10, 47,
10, 27, 11, 34, 6, 46, 10, 60, 9, 59, 9, 26, 11, 45, 10, 25, 11, 58,
9, 44, 10, 24, 11, 57, 9, 3, 12, 23, 11, 56, 9, 43, 10, 55, 9, 49, 7,
54, 9, 22, 11, 59, 8, 58, 8, 42, 10, 41, 10, 21, 11, 57, 8, 20, 11,
40, 10, 39, 10, 48, 7, 53, 9, 38, 10, 37, 10, 47, 7, 52, 9, 36, 10,
35, 10, 19, 11, 18, 11, 2, 12, 17, 11, 51, 9, 34, 10, 46, 7, 33, 10,
50, 9, 16, 11, 49, 9, 56, 8, 45, 7, 32, 10, 15, 11, 31, 10, 55, 8, 30,
10, 29, 10, 14, 11, 48, 9, 13, 11, 28, 10, 1, 12, 54, 8, 27, 10, 26,
10, 53, 8, 33, 6, 25, 10, 52, 8, 47, 9, 46, 9, 51, 8, 12, 11, 45, 9,
50, 8, 24, 10, 44, 7, 43, 7, 44, 9, 43, 9, 49, 8, 14, 4, };


int IntraCBPCHuffCodeTab[510] = {19, 5, 31, 6, 81, 8, 30, 6, 80, 8,
119, 9, 118, 9, 29, 6, 79, 8, 78, 8, 117, 9, 77, 8, 181, 10, 180, 10,
179, 10, 7, 3, 45, 7, 76, 8, 178, 10, 116, 9, 177, 10, 176, 10, 175,
10, 115, 9, 174, 10, 173, 10, 172, 10, 171, 10, 170, 10, 169, 10, 168,
10, 13, 4, 114, 9, 28, 6, 167, 10, 113, 9, 166, 10, 165, 10, 164, 10,
75, 8, 163, 10, 162, 10, 161, 10, 160, 10, 159, 10, 158, 10, 157, 10,
18, 5, 74, 8, 156, 10, 44, 7, 155, 10, 154, 10, 153, 10, 152, 10, 151,
10, 150, 10, 149, 10, 148, 10, 147, 10, 146, 10, 145, 10, 144, 10, 12,
4, 73, 8, 72, 8, 143, 10, 27, 6, 142, 10, 141, 10, 140, 10, 139, 10,
112, 9, 138, 10, 137, 10, 136, 10, 135, 10, 134, 10, 133, 10, 26, 6,
71, 8, 132, 10, 131, 10, 25, 6, 43, 7, 130, 10, 129, 10, 128, 10, 127,
10, 126, 10, 125, 10, 124, 10, 123, 10, 122, 10, 121, 10, 120, 10,
119, 10, 111, 9, 118, 10, 117, 10, 116, 10, 115, 10, 114, 10, 113, 10,
112, 10, 111, 10, 110, 10, 109, 10, 108, 10, 107, 10, 106, 10, 70, 8,
110, 9, 105, 10, 104, 10, 109, 9, 108, 9, 103, 10, 102, 10, 101, 10,
100, 10, 99, 10, 98, 10, 97, 10, 96, 10, 95, 10, 94, 10, 11, 4, 107,
9, 93, 10, 92, 10, 91, 10, 90, 10, 89, 10, 88, 10, 42, 7, 87, 10, 86,
10, 85, 10, 106, 9, 84, 10, 83, 10, 82, 10, 24, 6, 105, 9, 81, 10, 80,
10, 79, 10, 78, 10, 77, 10, 76, 10, 75, 10, 74, 10, 73, 10, 72, 10,
71, 10, 70, 10, 69, 10, 68, 10, 10, 4, 67, 10, 69, 8, 66, 10, 65, 10,
64, 10, 63, 10, 62, 10, 68, 8, 61, 10, 60, 10, 59, 10, 58, 10, 57, 10,
56, 10, 55, 10, 41, 7, 104, 9, 54, 10, 67, 8, 53, 10, 52, 10, 51, 10,
50, 10, 49, 10, 48, 10, 47, 10, 103, 9, 46, 10, 45, 10, 44, 10, 43,
10, 66, 8, 42, 10, 41, 10, 40, 10, 65, 8, 39, 10, 38, 10, 37, 10, 23,
6, 36, 10, 35, 10, 34, 10, 64, 8, 33, 10, 102, 9, 32, 10, 17, 5, 101,
9, 31, 10, 30, 10, 29, 10, 28, 10, 27, 10, 26, 10, 25, 10, 24, 10, 23,
10, 22, 10, 100, 9, 99, 9, 21, 10, 20, 10, 63, 8, 19, 10, 62, 8, 18,
10, 98, 9, 17, 10, 16, 10, 15, 10, 97, 9, 96, 9, 14, 10, 13, 10, 12,
10, 11, 10, 95, 9, 10, 10, 16, 5, 94, 9, 9, 10, 8, 10, 7, 10, 6, 10,
93, 9, 5, 10, 61, 8, 4, 10, 92, 9, 3, 10, 91, 9, 2, 10, 1, 10, 60, 8,
};


int IntraShellCombYHuffCodeTab[30] = {3, 2, 5, 6, 1, 7, 2, 2, 1, 2,
7, 5, 4, 6, 3, 6, 6, 5, 2, 6, 1, 6, 1, 8, 5, 5, 4, 5, 3, 5, };


int InterCCPHuffCodeTab[16] = {3, 2, 1, 5, 2, 2, 1, 6, 1, 3, 1, 7, 1, 2, 1, 4};


int InterCBPYHuffCodeTab[510] = {15, 4, 14, 4, 27, 6, 13, 4, 15, 5,
79, 8, 49, 7, 12, 4, 78, 8, 26, 6, 77, 8, 25, 6, 76, 8, 75, 8, 48, 7,
11, 4, 74, 8, 47, 7, 73, 8, 99, 9, 98, 9, 57, 11, 111, 10, 46, 7, 110,
10, 72, 8, 109, 10, 108, 10, 107, 10, 106, 10, 71, 8, 10, 4, 70, 8,
69, 8, 105, 10, 68, 8, 97, 9, 56, 11, 55, 11, 96, 9, 54, 11, 104, 10,
103, 10, 53, 11, 52, 11, 51, 11, 102, 10, 45, 7, 101, 10, 67, 8, 95,
9, 100, 10, 99, 10, 50, 11, 94, 9, 98, 10, 49, 11, 97, 10, 96, 10, 48,
11, 47, 11, 95, 10, 94, 10, 9, 4, 93, 9, 66, 8, 46, 11, 65, 8, 93, 10,
92, 10, 91, 10, 44, 7, 92, 9, 91, 9, 90, 10, 64, 8, 90, 9, 89, 9, 88,
9, 43, 7, 87, 9, 86, 9, 89, 10, 88, 10, 85, 9, 45, 11, 87, 10, 84, 9,
86, 10, 63, 8, 83, 9, 85, 10, 84, 10, 83, 10, 62, 8, 61, 8, 27, 12,
82, 10, 26, 12, 81, 10, 44, 11, 5, 13, 25, 12, 80, 10, 24, 12, 43, 11,
23, 12, 79, 10, 22, 12, 42, 11, 21, 12, 60, 8, 78, 10, 77, 10, 76, 10,
20, 12, 41, 11, 4, 13, 75, 10, 74, 10, 3, 13, 82, 9, 73, 10, 72, 10,
19, 12, 18, 12, 81, 9, 8, 4, 59, 8, 80, 9, 40, 11, 58, 8, 57, 8, 39,
11, 71, 10, 56, 8, 38, 11, 79, 9, 70, 10, 78, 9, 69, 10, 68, 10, 67,
10, 42, 7, 66, 10, 65, 10, 17, 12, 64, 10, 63, 10, 16, 12, 37, 11, 62,
10, 2, 13, 36, 11, 15, 12, 35, 11, 1, 13, 14, 12, 34, 11, 14, 5, 77,
9, 76, 9, 33, 11, 75, 9, 61, 10, 32, 11, 60, 10, 74, 9, 13, 12, 73, 9,
59, 10, 58, 10, 31, 11, 57, 10, 56, 10, 55, 8, 55, 10, 54, 10, 53, 10,
52, 10, 51, 10, 12, 12, 50, 10, 49, 10, 30, 11, 48, 10, 47, 10, 11,
12, 29, 11, 28, 11, 46, 10, 41, 7, 27, 11, 45, 10, 10, 12, 72, 9, 44,
10, 26, 11, 9, 12, 54, 8, 25, 11, 43, 10, 24, 11, 71, 9, 70, 9, 42,
10, 69, 9, 53, 8, 23, 11, 41, 10, 22, 11, 21, 11, 20, 11, 8, 12, 19,
11, 68, 9, 7, 12, 40, 10, 6, 12, 39, 10, 18, 11, 67, 9, 66, 9, 52, 8,
17, 11, 38, 10, 5, 12, 37, 10, 36, 10, 1, 14, 35, 10, 65, 9, 4, 12,
34, 10, 33, 10, 32, 10, 64, 9, 16, 11, 63, 9, 51, 8, 15, 11, 62, 9,
31, 10, 61, 9, 60, 9, 14, 11, 30, 10, 59, 9, 3, 12, 50, 8, 58, 9, 29,
10, 57, 9, 56, 9, 40, 7, };


int InterCBPCHuffCodeTab[510] = {21, 5, 31, 6, 93, 9, 20, 5, 92, 9,
91, 9, 99, 10, 19, 5, 90, 9, 73, 8, 98, 10, 97, 10, 113, 11, 112, 11,
111, 11, 7, 3, 18, 5, 72, 8, 89, 9, 71, 8, 96, 10, 95, 10, 110, 11,
88, 9, 94, 10, 93, 10, 109, 11, 92, 10, 108, 11, 107, 11, 106, 11, 13,
4, 87, 9, 30, 6, 105, 11, 91, 10, 104, 11, 103, 11, 102, 11, 70, 8,
101, 11, 86, 9, 100, 11, 90, 10, 99, 11, 98, 11, 97, 11, 29, 6, 45, 7,
44, 7, 28, 6, 96, 11, 89, 10, 95, 11, 94, 11, 88, 10, 93, 11, 92, 11,
91, 11, 90, 11, 89, 11, 88, 11, 87, 11, 12, 4, 69, 8, 68, 8, 87, 10,
27, 6, 67, 8, 85, 9, 86, 11, 86, 10, 84, 9, 85, 11, 84, 11, 85, 10,
84, 10, 83, 11, 82, 11, 17, 5, 43, 7, 83, 9, 81, 11, 26, 6, 42, 7, 80,
11, 83, 10, 82, 9, 79, 11, 78, 11, 77, 11, 81, 9, 82, 10, 76, 11, 75,
11, 41, 7, 74, 11, 66, 8, 80, 9, 79, 9, 81, 10, 78, 9, 73, 11, 72, 11,
71, 11, 70, 11, 69, 11, 68, 11, 67, 11, 66, 11, 65, 11, 65, 8, 80, 10,
77, 9, 64, 8, 76, 9, 75, 9, 63, 8, 74, 9, 64, 11, 63, 11, 62, 11, 61,
11, 79, 10, 73, 9, 60, 11, 59, 11, 11, 4, 62, 8, 61, 8, 78, 10, 72, 9,
58, 11, 57, 11, 56, 11, 16, 5, 55, 11, 71, 9, 54, 11, 70, 9, 53, 11,
52, 11, 51, 11, 60, 8, 69, 9, 50, 11, 77, 10, 49, 11, 76, 10, 48, 11,
47, 11, 75, 10, 68, 9, 46, 11, 45, 11, 74, 10, 44, 11, 43, 11, 42, 11,
25, 6, 41, 11, 40, 7, 40, 11, 67, 9, 39, 11, 38, 11, 37, 11, 24, 6,
36, 11, 39, 7, 35, 11, 34, 11, 33, 11, 32, 11, 31, 11, 66, 9, 59, 8,
58, 8, 65, 9, 73, 10, 30, 11, 29, 11, 72, 10, 64, 9, 28, 11, 63, 9,
57, 8, 27, 11, 26, 11, 25, 11, 24, 11, 38, 7, 71, 10, 23, 11, 70, 10,
37, 7, 69, 10, 22, 11, 21, 11, 56, 8, 62, 9, 20, 11, 19, 11, 55, 8,
18, 11, 17, 11, 16, 11, 54, 8, 61, 9, 68, 10, 15, 11, 60, 9, 53, 8,
14, 11, 13, 11, 59, 9, 12, 11, 11, 11, 10, 11, 67, 10, 58, 9, 66, 10,
9, 11, 65, 10, 8, 11, 7, 11, 64, 10, 63, 10, 6, 11, 5, 11, 62, 10, 61,
10, 4, 11, 57, 9, 60, 10, 56, 9, 3, 11, 52, 8, 2, 11, 51, 8, 59, 10,
1, 11, 55, 9, 54, 9, 58, 10, 53, 9, 50, 8, 52, 9, 57, 10, 51, 9, 49,
8, 50, 9, 48, 8, 47, 8, 23, 6, };


int InterShellCombCHuffCodeTab[30] = {1, 1, 3, 5, 3, 9, 1, 2, 1, 3,
3, 7, 2, 7, 3, 6, 2, 6, 3, 8, 2, 9, 1, 9, 2, 8, 1, 10, 2, 5, };


int InterShellCombYHuffCodeTab[30] = {1, 2, 7, 6, 5, 7, 1, 1, 1, 3,
6, 6, 4, 7, 5, 6, 4, 6, 1, 8, 3, 7, 2, 7, 1, 7, 1, 9, 3, 6, };


int TPYClassHuffCodeTab[130] = {3, 2, 5, 3, 9, 4, 8, 4, 9, 5, 7, 4,
15, 6, 8, 5, 14, 6, 6, 4, 21, 7, 20, 7, 19, 7, 23, 8, 18, 7, 13, 6,
12, 6, 17, 7, 22, 8, 21, 8, 16, 7, 15, 7, 20, 8, 14, 7, 19, 8, 19, 9,
18, 9, 17, 9, 18, 8, 17, 8, 16, 8, 16, 9, 13, 7, 15, 8, 9, 10, 8, 10,
7, 10, 15, 9, 14, 9, 13, 9, 14, 8, 11, 6, 13, 8, 12, 9, 6, 10, 11, 9,
5, 10, 10, 9, 9, 9, 8, 9, 3, 11, 12, 8, 4, 10, 3, 10, 12, 7, 2, 11,
11, 8, 7, 9, 6, 9, 1, 11, 1, 12, 5, 9, 10, 8, 2, 10, 5, 4, };


int TPCClassHuffCodeTab[130] = {5, 4, 4, 4, 7, 5, 11, 6, 10, 6, 6, 5,
29, 8, 9, 6, 28, 8, 3, 2, 47, 9, 46, 9, 27, 8, 45, 9, 15, 7, 8, 6, 26,
8, 44, 9, 43, 9, 42, 9, 25, 8, 41, 9, 40, 9, 39, 9, 38, 9, 37, 9, 36,
9, 35, 9, 34, 9, 33, 9, 32, 9, 31, 9, 30, 9, 29, 9, 28, 9, 27, 9, 26,
9, 25, 9, 24, 9, 23, 9, 24, 8, 3, 3, 22, 9, 21, 9, 20, 9, 19, 9, 18,
9, 17, 9, 16, 9, 15, 9, 14, 9, 13, 9, 12, 9, 11, 9, 10, 9, 9, 9, 8, 9,
7, 9, 6, 9, 5, 9, 4, 9, 3, 9, 2, 9, 1, 9, 2, 2, };


int Shell1TPYHuffCodeTab[240] = {3, 2, 51, 9, 23, 10, 51, 8, 50, 9,
49, 9, 11, 4, 19, 5, 50, 8, 48, 9, 49, 8, 48, 8, 47, 8, 47, 9, 46, 9,
45, 9, 44, 9, 22, 10, 21, 10, 43, 9, 42, 9, 20, 10, 41, 9, 46, 8, 19,
10, 40, 9, 39, 9, 38, 9, 18, 5, 23, 6, 37, 9, 18, 10, 45, 8, 17, 10,
44, 8, 1, 12, 1, 13, 16, 10, 43, 8, 15, 10, 36, 9, 22, 6, 9, 11, 42,
8, 17, 5, 16, 5, 35, 9, 34, 9, 41, 8, 40, 8, 39, 8, 33, 9, 14, 10, 15,
5, 21, 6, 32, 9, 31, 9, 30, 9, 20, 6, 38, 8, 29, 9, 28, 9, 13, 10, 14,
5, 19, 6, 29, 7, 27, 9, 37, 8, 12, 10, 11, 10, 10, 10, 8, 11, 36, 8,
28, 7, 9, 10, 35, 8, 34, 8, 18, 6, 33, 8, 26, 9, 8, 10, 7, 11, 25, 9,
7, 10, 24, 9, 6, 11, 13, 5, 17, 6, 6, 10, 5, 11, 23, 9, 22, 9, 21, 9,
20, 9, 4, 11, 16, 6, 32, 8, 31, 8, 30, 8, 19, 9, 3, 11, 12, 5, 18, 9,
17, 9, 2, 11, 1, 11, 16, 9, 15, 9, 15, 6, 29, 8, 5, 10, 14, 9, 27, 7,
28, 8, 10, 4, 13, 9, 27, 8, 26, 8, 12, 9, 26, 7, };


int Shell1TPCHuffCodeTab[240] = {1, 1, 27, 11, 39, 10, 51, 9, 38, 10,
37, 10, 13, 5, 21, 6, 50, 9, 36, 10, 49, 9, 35, 8, 35, 10, 48, 9, 47,
9, 34, 10, 46, 9, 45, 9, 33, 10, 32, 10, 7, 12, 26, 11, 31, 10, 30,
10, 25, 11, 44, 9, 43, 9, 29, 10, 20, 6, 19, 6, 28, 10, 6, 12, 27, 10,
42, 9, 41, 9, 5, 12, 4, 12, 3, 12, 40, 9, 26, 10, 24, 11, 39, 9, 2,
12, 38, 9, 12, 5, 18, 6, 23, 11, 22, 11, 34, 8, 33, 8, 37, 9, 25, 10,
24, 10, 17, 6, 16, 6, 23, 10, 21, 11, 22, 10, 15, 6, 21, 7, 1, 12, 21,
10, 20, 11, 14, 6, 13, 6, 32, 8, 36, 9, 31, 8, 19, 11, 35, 9, 18, 11,
1, 13, 34, 9, 30, 8, 17, 11, 33, 9, 32, 9, 20, 7, 31, 9, 16, 11, 15,
11, 14, 11, 20, 10, 30, 9, 13, 11, 12, 11, 11, 5, 12, 6, 11, 11, 10,
11, 29, 9, 28, 9, 9, 11, 8, 11, 7, 11, 19, 7, 29, 8, 19, 10, 27, 9,
26, 9, 18, 10, 11, 6, 25, 9, 17, 10, 6, 11, 16, 10, 5, 11, 24, 9, 18,
7, 28, 8, 4, 11, 15, 10, 27, 8, 23, 9, 7, 4, 22, 9, 21, 9, 14, 10, 20,
9, 26, 8, };


int Shell2TPYHuffCodeTab[1600] = {383, 11, 375, 10, 275, 9, 274, 9,
382, 11, 273, 9, 169, 8, 374, 10, 272, 9, 381, 11, 373, 10, 380, 11,
372, 10, 379, 11, 371, 10, 370, 10, 378, 11, 377, 11, 376, 11, 369,
10, 368, 10, 367, 10, 375, 11, 168, 8, 374, 11, 373, 11, 366, 10, 271,
9, 372, 11, 270, 9, 269, 9, 167, 8, 371, 11, 365, 10, 370, 11, 369,
11, 368, 11, 268, 9, 267, 9, 367, 11, 366, 11, 364, 10, 365, 11, 363,
10, 364, 11, 363, 11, 362, 10, 361, 10, 362, 11, 361, 11, 360, 10,
360, 11, 266, 9, 265, 9, 359, 11, 358, 11, 357, 11, 359, 10, 356, 11,
264, 9, 355, 11, 358, 10, 354, 11, 353, 11, 263, 9, 352, 11, 351, 11,
357, 10, 356, 10, 350, 11, 355, 10, 349, 11, 348, 11, 347, 11, 262, 9,
346, 11, 345, 11, 344, 11, 343, 11, 354, 10, 342, 11, 341, 11, 353,
10, 352, 10, 351, 10, 340, 11, 339, 11, 350, 10, 338, 11, 337, 11,
336, 11, 93, 7, 335, 11, 349, 10, 348, 10, 347, 10, 334, 11, 166, 8,
261, 9, 333, 11, 332, 11, 346, 10, 345, 10, 331, 11, 260, 9, 344, 10,
330, 11, 329, 11, 328, 11, 327, 11, 343, 10, 326, 11, 342, 10, 341,
10, 325, 11, 259, 9, 324, 11, 258, 9, 257, 9, 323, 11, 322, 11, 321,
11, 320, 11, 319, 11, 340, 10, 318, 11, 339, 10, 317, 11, 338, 10,
316, 11, 315, 11, 337, 10, 336, 10, 314, 11, 256, 9, 335, 10, 334, 10,
313, 11, 165, 8, 255, 9, 312, 11, 311, 11, 310, 11, 309, 11, 254, 9,
333, 10, 308, 11, 253, 9, 307, 11, 252, 9, 306, 11, 332, 10, 305, 11,
304, 11, 303, 11, 302, 11, 301, 11, 300, 11, 299, 11, 251, 9, 331, 10,
330, 10, 329, 10, 328, 10, 250, 9, 298, 11, 297, 11, 249, 9, 327, 10,
326, 10, 325, 10, 248, 9, 324, 10, 323, 10, 322, 10, 296, 11, 164, 8,
321, 10, 295, 11, 294, 11, 293, 11, 292, 11, 320, 10, 291, 11, 247, 9,
290, 11, 289, 11, 246, 9, 288, 11, 287, 11, 286, 11, 319, 10, 318, 10,
285, 11, 317, 10, 316, 10, 315, 10, 284, 11, 283, 11, 314, 10, 163, 8,
313, 10, 282, 11, 162, 8, 312, 10, 311, 10, 281, 11, 280, 11, 245, 9,
310, 10, 309, 10, 279, 11, 278, 11, 277, 11, 276, 11, 308, 10, 307,
10, 244, 9, 275, 11, 274, 11, 273, 11, 272, 11, 271, 11, 306, 10, 270,
11, 305, 10, 304, 10, 303, 10, 161, 8, 243, 9, 242, 9, 269, 11, 268,
11, 241, 9, 267, 11, 266, 11, 160, 8, 240, 9, 265, 11, 264, 11, 159,
8, 302, 10, 263, 11, 262, 11, 239, 9, 238, 9, 301, 10, 237, 9, 300,
10, 261, 11, 299, 10, 298, 10, 260, 11, 297, 10, 259, 11, 258, 11,
158, 8, 296, 10, 257, 11, 256, 11, 236, 9, 157, 8, 295, 10, 255, 11,
254, 11, 294, 10, 253, 11, 235, 9, 293, 10, 252, 11, 251, 11, 250, 11,
292, 10, 234, 9, 249, 11, 248, 11, 291, 10, 233, 9, 247, 11, 290, 10,
289, 10, 288, 10, 246, 11, 245, 11, 244, 11, 243, 11, 242, 11, 241,
11, 240, 11, 239, 11, 238, 11, 237, 11, 236, 11, 232, 9, 235, 11, 287,
10, 234, 11, 233, 11, 286, 10, 285, 10, 232, 11, 231, 9, 231, 11, 284,
10, 230, 11, 229, 11, 283, 10, 230, 9, 228, 11, 282, 10, 227, 11, 226,
11, 225, 11, 224, 11, 223, 11, 281, 10, 156, 8, 222, 11, 280, 10, 221,
11, 279, 10, 278, 10, 220, 11, 277, 10, 219, 11, 276, 10, 218, 11,
217, 11, 216, 11, 229, 9, 215, 11, 214, 11, 275, 10, 274, 10, 213, 11,
212, 11, 228, 9, 211, 11, 210, 11, 209, 11, 273, 10, 208, 11, 227, 9,
207, 11, 272, 10, 206, 11, 271, 10, 205, 11, 204, 11, 203, 11, 226, 9,
270, 10, 225, 9, 202, 11, 92, 7, 201, 11, 51, 6, 155, 8, 224, 9, 200,
11, 154, 8, 269, 10, 268, 10, 267, 10, 223, 9, 266, 10, 199, 11, 222,
9, 198, 11, 265, 10, 264, 10, 197, 11, 263, 10, 262, 10, 196, 11, 261,
10, 221, 9, 195, 11, 260, 10, 194, 11, 91, 7, 259, 10, 193, 11, 192,
11, 153, 8, 258, 10, 191, 11, 220, 9, 219, 9, 190, 11, 257, 10, 189,
11, 256, 10, 188, 11, 187, 11, 186, 11, 152, 8, 218, 9, 185, 11, 184,
11, 183, 11, 182, 11, 181, 11, 180, 11, 217, 9, 179, 11, 193, 12, 192,
12, 191, 12, 178, 11, 190, 12, 90, 7, 151, 8, 255, 10, 189, 12, 188,
12, 50, 6, 254, 10, 150, 8, 49, 6, 216, 9, 187, 12, 177, 11, 253, 10,
176, 11, 215, 9, 186, 12, 175, 11, 185, 12, 174, 11, 184, 12, 252, 10,
214, 9, 251, 10, 183, 12, 213, 9, 182, 12, 181, 12, 180, 12, 179, 12,
149, 8, 178, 12, 173, 11, 177, 12, 212, 9, 176, 12, 172, 11, 48, 6,
89, 7, 175, 12, 171, 11, 170, 11, 174, 12, 173, 12, 172, 12, 250, 10,
171, 12, 169, 11, 170, 12, 169, 12, 168, 12, 167, 12, 249, 10, 166,
12, 168, 11, 165, 12, 164, 12, 248, 10, 88, 7, 247, 10, 246, 10, 211,
9, 148, 8, 163, 12, 162, 12, 161, 12, 210, 9, 160, 12, 159, 12, 245,
10, 209, 9, 147, 8, 158, 12, 157, 12, 167, 11, 244, 10, 243, 10, 156,
12, 166, 11, 155, 12, 242, 10, 154, 12, 153, 12, 152, 12, 165, 11,
151, 12, 150, 12, 149, 12, 87, 7, 241, 10, 148, 12, 147, 12, 208, 9,
164, 11, 146, 12, 163, 11, 240, 10, 145, 12, 144, 12, 143, 12, 142,
12, 141, 12, 239, 10, 238, 10, 162, 11, 140, 12, 139, 12, 138, 12,
237, 10, 161, 11, 236, 10, 137, 12, 136, 12, 207, 9, 135, 12, 160, 11,
206, 9, 159, 11, 134, 12, 133, 12, 158, 11, 132, 12, 131, 12, 130, 12,
129, 12, 157, 11, 128, 12, 127, 12, 235, 10, 126, 12, 125, 12, 124,
12, 123, 12, 156, 11, 122, 12, 121, 12, 120, 12, 155, 11, 234, 10,
205, 9, 119, 12, 233, 10, 154, 11, 118, 12, 232, 10, 231, 10, 153, 11,
230, 10, 229, 10, 152, 11, 117, 12, 151, 11, 116, 12, 115, 12, 228,
10, 114, 12, 150, 11, 113, 12, 227, 10, 112, 12, 111, 12, 110, 12,
226, 10, 149, 11, 225, 10, 224, 10, 148, 11, 204, 9, 109, 12, 108, 12,
107, 12, 223, 10, 222, 10, 106, 12, 203, 9, 105, 12, 104, 12, 103, 12,
147, 11, 221, 10, 86, 7, 146, 11, 145, 11, 102, 12, 202, 9, 144, 11,
201, 9, 101, 12, 85, 7, 13, 4, 220, 10, 143, 11, 100, 12, 99, 12, 142,
11, 98, 12, 141, 11, 200, 9, 140, 11, 97, 12, 139, 11, 96, 12, 95, 12,
94, 12, 138, 11, 146, 8, 137, 11, 93, 12, 92, 12, 91, 12, 90, 12, 136,
11, 219, 10, 218, 10, 89, 12, 135, 11, 134, 11, 133, 11, 199, 9, 132,
11, 88, 12, 87, 12, 86, 12, 217, 10, 198, 9, 131, 11, 130, 11, 85, 12,
129, 11, 84, 12, 83, 12, 82, 12, 128, 11, 81, 12, 80, 12, 79, 12, 197,
9, 196, 9, 78, 12, 77, 12, 76, 12, 75, 12, 74, 12, 73, 12, 72, 12,
127, 11, 71, 12, 126, 11, 125, 11, 195, 9, 70, 12, 194, 9, 69, 12,
193, 9, 68, 12, 67, 12, 124, 11, 192, 9, 191, 9, 66, 12, 65, 12, 64,
12, 216, 10, 63, 12, 62, 12, 215, 10, 61, 12, 60, 12, 145, 8, 214, 10,
123, 11, 59, 12, 122, 11, 58, 12, 121, 11, 120, 11, 144, 8, 119, 11,
118, 11, 57, 12, 117, 11, 56, 12, 213, 10, 55, 12, 116, 11, 54, 12,
212, 10, 53, 12, 115, 11, 47, 6, 114, 11, 52, 12, 51, 12, 50, 12, 49,
12, 190, 9, 48, 12, 47, 12, 211, 10, 46, 12, 45, 12, 44, 12, 43, 12,
210, 10, 209, 10, 42, 12, 113, 11, 41, 12, 40, 12, 39, 12, 208, 10,
38, 12, 37, 12, 207, 10, 112, 11, 206, 10, 36, 12, 35, 12, 34, 12, 33,
12, 32, 12, 205, 10, 31, 12, 143, 8, 30, 12, 111, 11, 204, 10, 29, 12,
189, 9, 7, 3, 203, 10, 28, 12, 188, 9, 27, 12, 26, 12, 202, 10, 201,
10, 110, 11, 200, 10, 25, 12, 142, 8, 24, 12, 23, 12, 199, 10, 198,
10, 109, 11, 22, 12, 21, 12, 20, 12, 19, 12, 18, 12, 108, 11, 107, 11,
17, 12, 106, 11, 105, 11, 104, 11, 16, 12, 197, 10, 196, 10, 15, 12,
103, 11, 195, 10, 141, 8, 14, 12, 13, 12, 12, 12, 11, 12, 10, 12, 140,
8, 9, 12, 102, 11, 8, 12, 139, 8, 7, 12, 194, 10, 138, 8, 193, 10, 6,
12, 101, 11, 100, 11, 99, 11, 5, 12, 4, 12, 3, 12, 2, 12, 98, 11, 192,
10, 1, 12, 97, 11, };


int Shell2TPCHuffCodeTab[1600] = {673, 10, 672, 10, 671, 10, 670, 10,
669, 10, 403, 9, 668, 10, 667, 10, 666, 10, 665, 10, 664, 10, 663, 10,
662, 10, 661, 10, 660, 10, 659, 10, 658, 10, 657, 10, 656, 10, 655,
10, 654, 10, 653, 10, 652, 10, 402, 9, 651, 10, 650, 10, 649, 10, 648,
10, 647, 10, 646, 10, 645, 10, 401, 9, 644, 10, 643, 10, 642, 10, 641,
10, 640, 10, 639, 10, 638, 10, 637, 10, 636, 10, 635, 10, 634, 10,
633, 10, 632, 10, 631, 10, 630, 10, 629, 10, 628, 10, 627, 10, 626,
10, 625, 10, 624, 10, 217, 8, 623, 10, 622, 10, 621, 10, 620, 10, 619,
10, 618, 10, 617, 10, 616, 10, 615, 10, 614, 10, 613, 10, 612, 10,
611, 10, 610, 10, 609, 10, 400, 9, 608, 10, 607, 10, 606, 10, 605, 10,
399, 9, 604, 10, 603, 10, 602, 10, 601, 10, 600, 10, 599, 10, 598, 10,
597, 10, 596, 10, 595, 10, 594, 10, 593, 10, 592, 10, 591, 10, 590,
10, 589, 10, 216, 8, 588, 10, 587, 10, 586, 10, 585, 10, 584, 10, 583,
10, 582, 10, 581, 10, 580, 10, 579, 10, 578, 10, 577, 10, 576, 10,
575, 10, 574, 10, 573, 10, 572, 10, 571, 10, 570, 10, 569, 10, 568,
10, 567, 10, 566, 10, 565, 10, 564, 10, 398, 9, 563, 10, 562, 10, 561,
10, 560, 10, 559, 10, 558, 10, 557, 10, 556, 10, 555, 10, 554, 10,
553, 10, 552, 10, 551, 10, 550, 10, 549, 10, 548, 10, 397, 9, 547, 10,
546, 10, 545, 10, 396, 9, 544, 10, 543, 10, 542, 10, 541, 10, 540, 10,
215, 8, 539, 10, 538, 10, 395, 9, 537, 10, 536, 10, 535, 10, 534, 10,
533, 10, 532, 10, 531, 10, 530, 10, 529, 10, 528, 10, 527, 10, 526,
10, 394, 9, 525, 10, 524, 10, 523, 10, 522, 10, 521, 10, 520, 10, 393,
9, 519, 10, 518, 10, 517, 10, 516, 10, 392, 9, 515, 10, 514, 10, 513,
10, 214, 8, 512, 10, 511, 10, 510, 10, 509, 10, 508, 10, 507, 10, 506,
10, 505, 10, 391, 9, 504, 10, 503, 10, 502, 10, 501, 10, 500, 10, 499,
10, 498, 10, 497, 10, 496, 10, 495, 10, 494, 10, 493, 10, 492, 10,
491, 10, 390, 9, 490, 10, 489, 10, 389, 9, 488, 10, 487, 10, 486, 10,
485, 10, 484, 10, 483, 10, 482, 10, 481, 10, 480, 10, 479, 10, 478,
10, 477, 10, 388, 9, 476, 10, 475, 10, 474, 10, 473, 10, 472, 10, 471,
10, 470, 10, 469, 10, 468, 10, 467, 10, 466, 10, 465, 10, 387, 9, 386,
9, 464, 10, 463, 10, 462, 10, 461, 10, 460, 10, 385, 9, 384, 9, 459,
10, 458, 10, 213, 8, 457, 10, 456, 10, 455, 10, 454, 10, 453, 10, 383,
9, 452, 10, 451, 10, 450, 10, 449, 10, 448, 10, 447, 10, 446, 10, 445,
10, 444, 10, 443, 10, 382, 9, 442, 10, 441, 10, 440, 10, 439, 10, 381,
9, 438, 10, 437, 10, 436, 10, 435, 10, 434, 10, 433, 10, 432, 10, 431,
10, 430, 10, 429, 10, 428, 10, 427, 10, 426, 10, 425, 10, 424, 10,
423, 10, 422, 10, 421, 10, 420, 10, 419, 10, 418, 10, 417, 10, 416,
10, 415, 10, 414, 10, 413, 10, 412, 10, 411, 10, 410, 10, 409, 10,
408, 10, 407, 10, 406, 10, 405, 10, 404, 10, 403, 10, 380, 9, 402, 10,
379, 9, 401, 10, 400, 10, 399, 10, 398, 10, 397, 10, 396, 10, 395, 10,
394, 10, 393, 10, 392, 10, 391, 10, 390, 10, 389, 10, 388, 10, 212, 8,
387, 10, 386, 10, 385, 10, 384, 10, 383, 10, 382, 10, 381, 10, 378, 9,
380, 10, 379, 10, 378, 10, 377, 9, 377, 10, 376, 10, 375, 10, 374, 10,
373, 10, 372, 10, 371, 10, 370, 10, 369, 10, 368, 10, 367, 10, 366,
10, 365, 10, 364, 10, 363, 10, 362, 10, 361, 10, 360, 10, 359, 10,
358, 10, 357, 10, 356, 10, 355, 10, 354, 10, 353, 10, 352, 10, 351,
10, 211, 8, 350, 10, 349, 10, 348, 10, 347, 10, 376, 9, 346, 10, 345,
10, 344, 10, 343, 10, 342, 10, 341, 10, 340, 10, 339, 10, 338, 10,
337, 10, 336, 10, 335, 10, 334, 10, 333, 10, 332, 10, 331, 10, 330,
10, 329, 10, 210, 8, 328, 10, 327, 10, 326, 10, 325, 10, 324, 10, 323,
10, 322, 10, 321, 10, 320, 10, 375, 9, 374, 9, 319, 10, 318, 10, 317,
10, 316, 10, 209, 8, 315, 10, 314, 10, 313, 10, 312, 10, 311, 10, 310,
10, 309, 10, 208, 8, 373, 9, 308, 10, 307, 10, 306, 10, 305, 10, 304,
10, 372, 9, 371, 9, 303, 10, 302, 10, 301, 10, 370, 9, 300, 10, 299,
10, 369, 9, 298, 10, 297, 10, 296, 10, 295, 10, 294, 10, 368, 9, 293,
10, 292, 10, 291, 10, 290, 10, 289, 10, 288, 10, 367, 9, 366, 9, 287,
10, 286, 10, 285, 10, 284, 10, 283, 10, 282, 10, 365, 9, 281, 10, 280,
10, 279, 10, 364, 9, 278, 10, 277, 10, 109, 7, 363, 9, 276, 10, 275,
10, 274, 10, 273, 10, 272, 10, 271, 10, 270, 10, 269, 10, 268, 10,
267, 10, 266, 10, 265, 10, 264, 10, 263, 10, 262, 10, 261, 10, 260,
10, 259, 10, 362, 9, 207, 8, 258, 10, 257, 10, 256, 10, 206, 8, 255,
10, 254, 10, 253, 10, 205, 8, 252, 10, 251, 10, 250, 10, 249, 10, 248,
10, 247, 10, 246, 10, 245, 10, 361, 9, 360, 9, 244, 10, 243, 10, 242,
10, 241, 10, 240, 10, 239, 10, 238, 10, 237, 10, 236, 10, 235, 10,
234, 10, 233, 10, 232, 10, 231, 10, 230, 10, 229, 10, 228, 10, 359, 9,
227, 10, 226, 10, 225, 10, 224, 10, 223, 10, 222, 10, 221, 10, 220,
10, 219, 10, 218, 10, 217, 10, 216, 10, 215, 10, 214, 10, 213, 10,
212, 10, 211, 10, 210, 10, 209, 10, 208, 10, 207, 10, 358, 9, 206, 10,
205, 10, 204, 10, 203, 10, 202, 10, 201, 10, 200, 10, 199, 10, 198,
10, 197, 10, 196, 10, 195, 10, 194, 10, 193, 10, 192, 10, 191, 10,
190, 10, 189, 10, 188, 10, 187, 10, 357, 9, 186, 10, 185, 10, 184, 10,
183, 10, 356, 9, 182, 10, 181, 10, 355, 9, 180, 10, 179, 10, 178, 10,
177, 10, 176, 10, 175, 10, 174, 10, 173, 10, 172, 10, 171, 10, 170,
10, 169, 10, 168, 10, 167, 10, 166, 10, 165, 10, 164, 10, 163, 10,
162, 10, 161, 10, 160, 10, 159, 10, 158, 10, 157, 10, 156, 10, 155,
10, 154, 10, 153, 10, 152, 10, 151, 10, 150, 10, 149, 10, 148, 10,
147, 10, 204, 8, 146, 10, 145, 10, 144, 10, 143, 10, 354, 9, 142, 10,
141, 10, 353, 9, 55, 6, 140, 10, 139, 10, 138, 10, 137, 10, 352, 9,
136, 10, 135, 10, 134, 10, 133, 10, 132, 10, 131, 10, 130, 10, 129,
10, 128, 10, 127, 10, 126, 10, 125, 10, 124, 10, 123, 10, 122, 10,
121, 10, 120, 10, 119, 10, 351, 9, 118, 10, 117, 10, 116, 10, 115, 10,
350, 9, 114, 10, 113, 10, 112, 10, 111, 10, 349, 9, 110, 10, 109, 10,
108, 10, 107, 10, 106, 10, 105, 10, 104, 10, 103, 10, 102, 10, 101,
10, 100, 10, 99, 10, 98, 10, 348, 9, 97, 10, 96, 10, 95, 10, 94, 10,
93, 10, 92, 10, 91, 10, 90, 10, 89, 10, 88, 10, 87, 10, 347, 9, 86,
10, 85, 10, 84, 10, 346, 9, 83, 10, 82, 10, 81, 10, 80, 10, 79, 10,
78, 10, 77, 10, 76, 10, 345, 9, 75, 10, 74, 10, 73, 10, 72, 10, 71,
10, 344, 9, 70, 10, 69, 10, 68, 10, 67, 10, 66, 10, 65, 10, 64, 10,
343, 9, 63, 10, 62, 10, 61, 10, 60, 10, 342, 9, 59, 10, 58, 10, 57,
10, 56, 10, 341, 9, 55, 10, 54, 10, 203, 8, 53, 10, 52, 10, 51, 10,
50, 10, 81, 11, 80, 11, 79, 11, 78, 11, 77, 11, 76, 11, 75, 11, 74,
11, 73, 11, 72, 11, 71, 11, 70, 11, 69, 11, 68, 11, 67, 11, 340, 9,
66, 11, 65, 11, 64, 11, 63, 11, 62, 11, 61, 11, 60, 11, 59, 11, 58,
11, 57, 11, 56, 11, 339, 9, 55, 11, 54, 11, 53, 11, 52, 11, 51, 11,
50, 11, 49, 10, 7, 3, 48, 10, 49, 11, 48, 11, 47, 11, 46, 11, 45, 11,
44, 11, 43, 11, 42, 11, 41, 11, 40, 11, 39, 11, 38, 11, 37, 11, 36,
11, 35, 11, 34, 11, 33, 11, 32, 11, 31, 11, 47, 10, 46, 10, 45, 10,
30, 11, 29, 11, 28, 11, 27, 11, 26, 11, 25, 11, 24, 11, 23, 11, 338,
9, 22, 11, 44, 10, 21, 11, 20, 11, 19, 11, 18, 11, 17, 11, 202, 8, 16,
11, 15, 11, 14, 11, 337, 9, 13, 11, 12, 11, 43, 10, 11, 11, 10, 11, 9,
11, 8, 11, 42, 10, 7, 11, 6, 11, 5, 11, 4, 11, 41, 10, 3, 11, 2, 11,
1, 11, };

/* ========================================================================= */

struct VLC {  /* root of VLC tree */
  char name[80];
  int size;
  int maxlength;
  unsigned long Bits;
  int *HuffCode;
  unsigned long *histo;
};

typedef struct VLC VLCTree, *VLCRoot;

static VLCTree *DiffHuffCode;

/* Coding modes intermediate inter layer */
static VLCTree *PPredTypeHuffCode;

/* Coding modes first inter layer */
/*static VLCTree *PLowPredTypeHuffCode;*/

/* Coded components for Intra/Inter mode */
static VLCTree *IntraCCPHuffCode;
static VLCTree *InterCCPHuffCode;

/* Coded 8 4x4 blocks in an 16x8 block */
static VLCTree *CBPHuffCode[4];

/* Coded 6 4x4 blocks */
static VLCTree *IntraCCP6HuffCode;
static VLCTree *InterCCP6HuffCode;

/* Two shell numbers */
static VLCTree *ShellHuffCode[4];

/* Shell 1 indices */
static VLCTree *Shell1HuffCode[4];

/* Shell 2 indices */
static VLCTree *Shell2HuffCode[4];

/* Points from Classes */
static VLCTree *ClassHuffCode[4];

/* Signs */
static VLCTree *EvenSignHuffCode;
static VLCTree *AllSignsHuffCode;

/* External points */
static VLCTree *VCombHuffCode;
static VLCTree *VMagHuffCode;
static VLCTree *CombSignHuffCode;


/* ========================================================================= */

#ifdef TRAINING
static VLCTree *AllTrees[100];
static int nextTree = 0;

static void AddVLCTree(VLCTree *t) {
  AllTrees[nextTree++] = t;
  AllTrees[nextTree] = NULL;
}

static void ResetCodeHist(VLCRoot table) {
  memset(table->histo, 0, table->size*sizeof(long));
}

static void ResetHistograms() {
  int i = 0;

  while(AllTrees[i] != NULL) {
    ResetCodeHist(AllTrees[i]);
    i++;
  }
}

static void PrintCodeHist(VLCRoot table, FILE *fp) {
  int i;
  int sum;

  fprintf(fp,"\n%s %d ", table->name, table->size);
  sum = 0;
  for (i=0; i<table->size; i++) {
    sum += table->histo[i];
    fprintf(fp,"%lu ", table->histo[i]);
  }
  /* fprintf(stderr,"Overall=%d BitsUsed=%d\n", sum, table->Bits); */
}

void PrintHuffCodeHistos() {
  int i = 0;
  FILE *fp = fopen("hist", "w");

  while(AllTrees[i] != NULL) {
    PrintCodeHist(AllTrees[i], fp);
    i++;
  }
  fprintf(fp,"\n");

  fclose(fp);
}

#endif

static void InitHuffTable (VLCTree **code_table, char *name, int *code, int size)
{
  (*code_table) =  NEW(VLCTree);

  if ((*code_table) == NULL) {
    fprintf(stderr, "Malloc failed");
    exit(1);
  }
  
  sprintf((*code_table)->name,"%s",name);
  (*code_table)->size = size;
  (*code_table)->maxlength = 0;

  (*code_table)->histo = NEWELEMS(unsigned long, size);
  memset((*code_table)->histo, 0, size*sizeof(long));

  (*code_table)->HuffCode = code;
#ifdef TRAINING
  AddVLCTree( (*code_table) );
#endif
}

/* ========================================================================= */

/* 0 = Intra/Y
 * 1 = Intra/C
 * 2 = Inter/Y
 * 3 = Inter/C
 */

/* ========================================================================= */

void InitHuffTables() {

  /* This routine is called once at the beginning and initializes all
   * the Huffman-Tables from the arrays given above.
   * InitHuffTable is just a little helper function.
   */

  InitHuffTable(&DiffHuffCode,"DiffHuffCode", DiffHuffCodeTab, 128);

  /* Prediction modes for first Inter-Layer */
  /*InitHuffTable(&PLowPredTypeHuffCode,"PLowPredTypeHuffCode", PLowPredTypeHuffCodeTab, 4);*/

  /* Prediction modes for other Inter-Layers */
  InitHuffTable(&PPredTypeHuffCode,"PPredTypeHuffCode", PPredTypeHuffCodeTab, 6);

  /* Coded-block pattern for Y1, Y2, and C */
  InitHuffTable(&IntraCCPHuffCode,"IntraCCPHuffCode", IntraCCPHuffCodeTab, 7);
  InitHuffTable(&InterCCPHuffCode,"InterCCPHuffCode", InterCCPHuffCodeTab, 8);

  /* Coded-block pattern for 6 4x4 blocks */
  InitHuffTable(&IntraCCP6HuffCode,"IntraCCP6HuffCode", IntraCCP6HuffCodeTab, 63);
  InitHuffTable(&InterCCP6HuffCode,"InterCCP6HuffCode", InterCCP6HuffCodeTab, 64);

  /* Coded-block pattern for 8 4x4 blocks */
  InitHuffTable(&CBPHuffCode[0],"IntraCBPYHuffCode", IntraCBPYHuffCodeTab, 255);
  InitHuffTable(&CBPHuffCode[1],"IntraCBPCHuffCode", IntraCBPCHuffCodeTab, 255);
  InitHuffTable(&CBPHuffCode[2],"InterCBPYHuffCode", InterCBPYHuffCodeTab, 255);
  InitHuffTable(&CBPHuffCode[3],"InterCBPCHuffCode", InterCBPCHuffCodeTab, 255);

  /* Shell numbers for two vectors within a 4x4 block */
  InitHuffTable(&ShellHuffCode[0],"IntraShellCombYHuffCode", IntraShellCombYHuffCodeTab, 15);
  InitHuffTable(&ShellHuffCode[1],"IntraShellCombCHuffCode", IntraShellCombCHuffCodeTab, 15);
  InitHuffTable(&ShellHuffCode[2],"InterShellCombYHuffCode", InterShellCombYHuffCodeTab, 15);
  InitHuffTable(&ShellHuffCode[3],"InterShellCombCHuffCode", InterShellCombCHuffCodeTab, 15);

  /* VLC-Codes for Shell 1 indices */
  InitHuffTable(&Shell1HuffCode[0],"Shell1SPYHuffCode", Shell1SPYHuffCodeTab, 120);
  InitHuffTable(&Shell1HuffCode[1],"Shell1SPCHuffCode", Shell1SPCHuffCodeTab, 120);
  InitHuffTable(&Shell1HuffCode[2],"Shell1TPYHuffCode", Shell1TPYHuffCodeTab, 120);
  InitHuffTable(&Shell1HuffCode[3],"Shell1TPCHuffCode", Shell1TPCHuffCodeTab, 120);

  /* VLC-Codes for Shell 2 indices */
  InitHuffTable(&Shell2HuffCode[0],"Shell2SPYHuffCode", Shell2SPYHuffCodeTab, 800);
  InitHuffTable(&Shell2HuffCode[1],"Shell2SPCHuffCode", Shell2SPCHuffCodeTab, 800);
  InitHuffTable(&Shell2HuffCode[2],"Shell2TPYHuffCode", Shell2TPYHuffCodeTab, 800);
  InitHuffTable(&Shell2HuffCode[3],"Shell2TPCHuffCode", Shell2TPCHuffCodeTab, 800);

  /* Class-codes for points outside the codebook */
  InitHuffTable(&ClassHuffCode[0],"SPYClassHuffCode", SPYClassHuffCodeTab, 65);
  InitHuffTable(&ClassHuffCode[1],"SPCClassHuffCode", SPCClassHuffCodeTab, 65);
  InitHuffTable(&ClassHuffCode[2],"TPYClassHuffCode", TPYClassHuffCodeTab, 65);
  InitHuffTable(&ClassHuffCode[3],"TPCClassHuffCode", TPCClassHuffCodeTab, 65);

  /* Signs of points from one of the classes  */
  InitHuffTable(&EvenSignHuffCode,"EvenSignHuffCode", EvenSignHuffCodeTab, 128);
  InitHuffTable(&AllSignsHuffCode,"AllSignsHuffCode", AllSignsHuffCodeTab, 256);

  /* External E8 points */
  InitHuffTable(&VMagHuffCode,"VMagHuffCode", VMagHuffCodeTab, 8);
  InitHuffTable(&VCombHuffCode,"VCombHuffCode", VCombHuffCodeTab, 64);
  InitHuffTable(&CombSignHuffCode,"CombSignHuffCode", CombSignHuffCodeTab, 9);

#ifdef TRAINING
  ResetHistograms();
#endif
}

/* ========================================================================= */

static int PutHuffCode (VLCRoot table, int val, Bitstr *bs) {
  if ( val < table->size ) {
#ifdef TRAINING
    table->histo[val]++;
    table->Bits += table->HuffCode[2*val+1];
#endif
#ifdef VERBOSE
    fprintf(stderr,"Using table %s. Coding value %d.\n", table->name, val);
#endif
    EmitBits(table->HuffCode[2*val], table->HuffCode[2*val+1], table->name,bs);
#ifdef COUNT_BITS
    bitCountP->totalBits += table->HuffCode[2*val+1];
    bitCountP->lumBits += table->HuffCode[2*val+1];
#endif
  }
  else {
    fprintf(stderr,"Using table %s. Coding value %d.\n", table->name, val);
    fprintf (stderr,"PutVLC ERROR: No Code defined for value.\n");
  }
  return(table->HuffCode[2*val+1]);
}

/* ========================================================================= */

void SendShell1Vect(LatticePointInfo *lpi, int mode, Bitstr *bs) {
  PutHuffCode(Shell1HuffCode[mode], lpi->index, bs);
  EmitBits(lpi->sign,1,"Shell1 sign", bs);
#ifdef COUNT_BITS
    bitCountP->totalBits += 1;
    bitCountP->lum1Bits += 1;
#endif
}

/* ========================================================================= */

void SendShell2Vect(LatticePointInfo *lpi, int mode, Bitstr *bs) {
  PutHuffCode(Shell2HuffCode[mode], lpi->index, bs);
  EmitBits(lpi->sign,1,"Shell2 sign", bs);
  if (lpi->trans != -1)
    EmitBits(lpi->trans,1,"Shell2 trans", bs);
#ifdef COUNT_BITS
  bitCountP->totalBits += 1;
  bitCountP->lum2Bits += 1;
  if (lpi->trans != -1) {
    bitCountP->totalBits += 1;
    bitCountP->lum2Bits += 1;
  }
#endif
}

/* ========================================================================= */

static void EncodeSpecial(float v[8], Bitstr *bs) {
  int i;
  int v1, v2, s1, s2, sc,vc;
  int translate;

  if (v[0]!=(int)v[0])
    translate = 1;
  else 
    translate = 0;

  EmitBits(translate,1,"Other translate", bs);
#ifdef COUNT_BITS
    bitCountP->totalBits += 1;
    bitCountP->lum3Bits += 1;
#endif

  for (i=0; i<4; i++) {

    s1 = ZSGN(v[i]);
    if (translate) {
      if (s1==1) v1 = (int) (fabs(v[i])-0.5);
      else if (s1==-1) v1 = (int) (fabs(v[i])-0.5);
    } else v1 = (int) fabs(v[i]);

    if (v1>7) { v1 = 7; }

    s2 = ZSGN(v[i+4]);
    if (translate) {
      if (s2==1) v2 = (int) (fabs(v[i+4])-0.5);
      else if (s2==-1) v2 = (int) (fabs(v[i+4])-0.5);
    } else v2 = (int) fabs(v[i+4]);

    if (v2>7) { v2 = 7; }

    sc = 3*(s1+1) + (s2+1);

    PutHuffCode(CombSignHuffCode, sc, bs);

    if ((s1 != 0)&&(s2 !=0)) {
      vc = ((v1)<<3)|(v2);
      PutHuffCode(VCombHuffCode, vc, bs);
    } else {
      if (s1 != 0) PutHuffCode(VMagHuffCode,v1, bs);
      if (s2 != 0) PutHuffCode(VMagHuffCode,v2, bs);
    }

    if (translate) {
      if (s1==1) v[i] = v1 + 0.5;
      else if (s1==-1) v[i] = -v1 - 0.5;
    } else v[i] = s1*v1;

    if (translate) {
      if (s2==1) v[i+4] = v2 + 0.5;
      else if (s2==-1) v[i+4] = -v2 - 0.5;
    } else v[i+4] = s2*v2;
  }
}

/* ========================================================================= */

extern int FindCBIndex(float *v, int *sign, int *nsign);

static void SendOuterVect(float x[8], int mode, Bitstr *bs) {
  int index;
  int sign, nsign;

  index = FindCBIndex(x, &sign, &nsign);
  PutHuffCode(ClassHuffCode[mode], index, bs);

  if (index==64) 
    EncodeSpecial(x, bs);
  else
    EncodeExtVector(x, index, sign, nsign, bs);
  
}

/* ========================================================================= */

int EncodeDiff(int val, Bitstr *bs) {
  int x = ROUND(val/2.0);
  PutHuffCode(DiffHuffCode, labs(x), bs);
  if (x!=0) {
    if (x<0)
      EmitBits(1,1,"Diff sign", bs);
    else
      EmitBits(0,1,"Diff sign", bs);
#ifdef COUNT_BITS
    bitCountP->totalBits += 1;
    bitCountP->lumBits += 1;
#endif
  }
  return(2*x);
}

/* ========================================================================= */

void SendVect(LatticePointInfo *lpi, int mode, Bitstr *bs) {
  switch (lpi->l2norm) {
  case 0: break; /* Nothing to do */
  case 2: SendShell1Vect(lpi, mode, bs); break;
  case 4: SendShell2Vect(lpi, mode, bs); break;
  default: 
    SendOuterVect(lpi->point, mode, bs);
    break;
  }
}

/* ========================================================================= */

int PutAllSignsHuffCode (int val, Bitstr *bs) {
  return(PutHuffCode(AllSignsHuffCode,val, bs));
}

/* ========================================================================= */

int PutEvenSignHuffCode (int val, Bitstr *bs) {
  return(PutHuffCode(EvenSignHuffCode,val, bs));
}

/* ========================================================================= */

int PutCBP(int cbp, int mode, Bitstr *bs) {
  return(PutHuffCode(CBPHuffCode[mode], cbp, bs));
}

int PutCombShell(int comb_shell, int mode, Bitstr *bs) {
  return(PutHuffCode(ShellHuffCode[mode], comb_shell, bs));
}

int PutCCP(int ccp, int mode, Bitstr *bs) {
  if (mode&2) return(PutHuffCode(InterCCPHuffCode, ccp, bs));
  return(PutHuffCode(IntraCCPHuffCode, ccp, bs));
}

int Put8x8CCP(int ccp, int mode, Bitstr *bs) {
  if (mode&2) return(PutHuffCode(InterCCP6HuffCode, ccp, bs));
  return(PutHuffCode(IntraCCP6HuffCode, ccp, bs));
}

int PutMode(int mode, Bitstr *bs) {
  return(PutHuffCode(PPredTypeHuffCode, mode, bs));
}

int PutMV(int mvx, int mvy, Bitstr *bs) {
  int         ix, iy;
  static int  virgin = 1;
  static Code *mvCode;


  if (virgin) {
    int  mvd_event[H263_MVD_SIZE * H263_MVD_EVENT_DIM] = H263_MVD_EVENT;
    char *mvd_bits[H263_MVD_SIZE] = H263_MVD_BITS;

    virgin = 0;
    mvCode = InitCode("H263-MVD", H263_MVD_SIZE, H263_MVD_EVENT_DIM,
		      mvd_event, mvd_bits);
  }

  /* Send motion vector */
  ix = mvx + 32;
  if (!PutIndexToBitstr(mvCode, ix, bs)) {
    fprintf(stderr, "PutMV: wrong mv index!\n");
    exit(-1);
  }
#ifdef TRACE
  fprintf(stdout,"Emitting 0X%X with %d bits (%s)\n", mvCode->cwTable[ix].bits,
	  mvCode->cwTable[ix].size, "mvx");
#endif
  iy = mvy + 32;
  if (!PutIndexToBitstr(mvCode, iy, bs)) {
    fprintf(stderr, "PutMV: wrong mv index!\n");
    exit(-1);
  }
#ifdef TRACE
  fprintf(stdout,"Emitting 0X%X with %d bits (%s)\n", mvCode->cwTable[iy].bits,
	  mvCode->cwTable[iy].size, "mvy");
#endif

#ifdef COUNT_BITS
  bitCountP->totalBits += mvCode->cwTable[ix].size + mvCode->cwTable[iy].size;
  bitCountP->motionBits += mvCode->cwTable[ix].size + mvCode->cwTable[iy].size;
#endif

  return(mvCode->cwTable[ix].size + mvCode->cwTable[iy].size);
}


int EmitBits(int sym, int size, char *comment, Bitstr *bs) {

#ifdef TRACE
  fprintf(stdout,"Emitting 0X%X with %d bits (%s)\n", sym, size, comment);
#endif

  PutNumberX(sym, size, bs);
  return(size);
}
