#include "Lattice.h"
#include "Util.h"

#include "Codebooks.p"


#define TRUNC(a) ((a)==0 ? 0 : ((a)>0) ? (int)(a) : -(int)(1-(a))) /* Truncation */
#define NNI(x,f) (((x)-(f))<0 ? ((f)-1): ((f)+1))        /* Next nearest integer */

/* ========================================================================= */
/* ========================================================================= */
/* #define CODEBOOK_TRAINING */
#ifdef CODEBOOK_TRAINING
static float *hist_Codebooks[8];
static int *histCount_Codebooks[8];
static int  hist_CodebookSize[8];
static char *hist_CodebookNames[8];

static int histCount_Shell1SPYCodebook[120];
static int histCount_Shell1SPCCodebook[120];
static int histCount_Shell1TPYCodebook[120];
static int histCount_Shell1TPCCodebook[120];
static int histCount_Shell2SPYCodebook[800];
static int histCount_Shell2SPCCodebook[800];
static int histCount_Shell2TPYCodebook[800];
static int histCount_Shell2TPCCodebook[800];

static float hist_Shell1SPYCodebook[120*8];
static float hist_Shell1SPCCodebook[120*8];
static float hist_Shell1TPYCodebook[120*8];
static float hist_Shell1TPCCodebook[120*8];
static float hist_Shell2SPYCodebook[800*8];
static float hist_Shell2SPCCodebook[800*8];
static float hist_Shell2TPYCodebook[800*8];
static float hist_Shell2TPCCodebook[800*8];
/* ========================================================================= */

void ResetCodebookHistos() {
  int i;


  hist_Codebooks[0] = hist_Shell1SPYCodebook;
  histCount_Codebooks[0] = histCount_Shell1SPYCodebook;
  hist_CodebookSize[0] = 120;
  hist_CodebookNames[0] = "Shell1SPYCodebook";

  hist_Codebooks[1] = hist_Shell1SPCCodebook;
  histCount_Codebooks[1] = histCount_Shell1SPCCodebook;
  hist_CodebookSize[1] = 120;
  hist_CodebookNames[1] = "Shell1SPCCodebook";

  hist_Codebooks[2] = hist_Shell1TPYCodebook;
  histCount_Codebooks[2] = histCount_Shell1TPYCodebook;
  hist_CodebookSize[2] = 120;
  hist_CodebookNames[2] = "Shell1TPYCodebook";

  hist_Codebooks[3] = hist_Shell1TPCCodebook;
  histCount_Codebooks[3] = histCount_Shell1TPCCodebook;
  hist_CodebookSize[3] = 120;
  hist_CodebookNames[3] = "Shell1TPCCodebook";

  hist_Codebooks[4] = hist_Shell2SPYCodebook;
  histCount_Codebooks[4] = histCount_Shell2SPYCodebook;
  hist_CodebookSize[4] = 800;
  hist_CodebookNames[4] = "Shell2SPYCodebook";

  hist_Codebooks[5] = hist_Shell2SPCCodebook;
  histCount_Codebooks[5] = histCount_Shell2SPCCodebook;
  hist_CodebookSize[5] = 800;
  hist_CodebookNames[5] = "Shell2SPCCodebook";

  hist_Codebooks[6] = hist_Shell2TPYCodebook;
  histCount_Codebooks[6] = histCount_Shell2TPYCodebook;
  hist_CodebookSize[6] = 800;
  hist_CodebookNames[6] = "Shell2TPYCodebook";

  hist_Codebooks[7] = hist_Shell2TPCCodebook;
  histCount_Codebooks[7] = histCount_Shell2TPCCodebook;
  hist_CodebookSize[7] = 800;
  hist_CodebookNames[7] = "Shell2TPCCodebook";

  for (i = 0; i < 8; i++) {
    /* Reset Codebooks */
    memset(hist_Codebooks[i], 0, hist_CodebookSize[i]*8*sizeof(float));
    /* Reset Counter */
    memset(histCount_Codebooks[i], 0, hist_CodebookSize[i]*sizeof(int));
  }
}


void AddVectorCodebookHist(int cn, int n, float v[8]) {
  int i;


  histCount_Codebooks[cn]++;
  for (i = 0; i < 8; i++) {
    hist_Codebooks[cn][8*n+i] += v[i];
  }
}


static void PrintCodebookHist(int cn, FILE *fp) {
  int i, j;

  fprintf(fp,"\nfloat %s[%d*8] = {\n", hist_CodebookNames[cn],
	  hist_CodebookSize[cn]);
  for (i = 0; i < hist_CodebookSize[cn]; i++) {
    if (histCount_Codebooks[cn][i]) {
      for (j = 0; j < 8; j++)
	fprintf(fp, "%f, ", hist_Codebooks[cn][8*i+j] /
		(float)(histCount_Codebooks[cn][i]));
      fprintf(fp, "\n");
    } else {
      fprintf(stderr, "PrintCodebookHist: Entry %d of Codebook %d not used\n",
	      i, cn);
      exit(1);
  }
  fprintf(fp, "};\n");

  /* fprintf(stderr,"Overall=%d BitsUsed=%d\n", sum, table->Bits); */
}

void PrintCodebookHistos() {
  int i = 0;
  FILE *fp = fopen("ShellCodebooks.c", "w");

  for (i = 0; i < 8; i++) {
    PrintCodebookHist(i, fp);
    fprintf(fp,"\n");
  }
  fprintf(fp,"\n");

  fclose(fp);
}

#endif    /* #ifdef CODEBOOK_TRAINING */

/* ========================================================================= */
/* ========================================================================= */


/* Shell1 Centroids */

#if 0
static float Shell1SPYCodebook[120*8] = {
0.342011, 0.358190, 0.364004, 0.338272, 0.347892, 0.361185, 0.357242, 0.322354,
0.739796, 0.030612, 0.091837, -0.028061, -0.117347, -0.007653, 0.466837, 0.084184,
0.245657, -0.274389, -0.479269, -0.513422, -0.394097, -0.349573, 0.242474, -0.279444,
0.657636, 0.196280, -0.062102, -0.035600, 0.233963, 0.612589, 0.245732, -0.056095,
0.346939, -0.255102, -0.642857, -0.528061, -0.160714, 0.214286, -0.237245, -0.633929,
0.029412, -0.073529, -0.176471, 0.191176, 0.279412, 0.985294, -0.838235, 0.000000,
0.652927, 0.079794, -0.058214, 0.002930, 0.635836, 0.050579, -0.079778, -0.019774,
0.343866, -0.295325, -0.453778, -0.223401, 0.355035, -0.307300, -0.478530, -0.234759,
0.227984, 0.071854, -0.137042, -0.054989, 0.753502, -0.182870, -0.724540, 0.012548,
-0.043949, -0.291075, -0.153989, -0.001183, 0.842461, -0.720081, -0.124746, 0.049527,
0.562005, 0.229808, 0.149558, 0.669018, 0.109576, 0.032078, -0.041382, 0.142448,
0.267984, -0.334140, -0.290282, 0.278160, -0.346422, -0.461222, -0.440582, -0.298724,
-0.034814, -0.201406, -0.028864, 0.753498, 0.080337, -0.188160, -0.555817, -0.068252,
0.048995, -0.053755, 0.209381, 0.711325, -0.165061, -0.524341, -0.201946, 0.110164,
-0.060693, -0.008540, 0.102538, 0.557962, -0.606393, -0.213135, -0.206120, 0.091374,
-0.341677, -0.526325, -0.266334, 0.242339, 0.409133, 0.497542, 0.201375, -0.234899,
0.803571, 0.106092, 0.675420, 0.085872, 0.023634, -0.155987, -0.005777, -0.032563,
0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000,
0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000,
-0.220063, -0.016807, 0.751313, 0.056460, -0.055410, -0.798845, 0.018908, 0.076681,
-0.148037, 0.294101, 0.556816, 0.212920, -0.768986, -0.178312, 0.064080, -0.088693,
-0.446542, -0.230934, 0.149512, -0.401552, 0.338946, 0.447412, 0.376059, -0.470688,
-0.016387, 0.175980, 0.645168, -0.809524, -0.026961, -0.012815, 0.137605, -0.062815,
-0.486985, -0.216354, 0.386108, 0.418315, -0.319212, 0.409396, 0.493947, -0.153316,
-0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
-0.424642, -0.215221, 0.271718, 0.449266, 0.435219, 0.236146, -0.214275, -0.427593,
0.006218, -0.658950, -0.121891, 0.026176, -0.001429, -0.104286, -0.155546, -0.707731,
0.296429, -0.092857, 0.425000, 0.485714, 0.371429, 0.439286, 0.339286, -0.325000,
0.727046, 0.603060, 0.236144, 0.035335, 0.086086, -0.010616, -0.065772, -0.004140,
0.364938, 0.193116, -0.157109, -0.370100, -0.368325, -0.484413, -0.475360, -0.327654,
0.000000, 0.808824, -0.014706, -0.176471, -0.161765, -0.073529, -0.970588, 0.117647,
-0.009804, 0.794118, 0.137255, -0.107843, 0.029412, -0.784314, -0.117647, 0.196078,
0.071057, 0.577571, 0.140730, -0.094986, -0.757176, -0.043759, 0.160524, 0.004191,
-0.217070, 0.290563, -0.100111, -0.452478, 0.246912, 0.486965, 0.307424, -0.433190,
0.103005, 0.655382, 0.003439, -0.771915, -0.066459, 0.069048, 0.006548, -0.152910,
-0.525000, 0.625000, -0.250000, 0.300000, -0.500000, 0.600000, 0.400000, -0.400000,
-0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
-0.541667, 0.297619, -0.375000, 0.142857, 0.285714, 0.440476, -0.410714, -0.327381,
0.143763, -0.214309, -0.698854, -0.131811, 0.100452, 0.161606, -0.175682, -0.646439,
0.485294, 0.255924, -0.192269, 0.304790, 0.420756, 0.482899, 0.400420, -0.231261,
0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
-0.229992, 0.411318, 0.354101, -0.357321, -0.230042, 0.419415, 0.359169, -0.361551,
-0.338235, 0.411765, 0.617647, -0.470588, 0.529412, -0.294118, 0.352941, -0.455882,
-0.138449, 0.480307, 0.329980, -0.348580, 0.312163, 0.367743, -0.249925, -0.493733,
0.002240, 0.109563, 0.033660, -0.710155, -0.000986, 0.115255, 0.021239, -0.737980,
0.208076, 0.462656, 0.300990, -0.378530, 0.198161, 0.456145, 0.297347, -0.367568,
-0.178910, 0.333990, 0.543904, 0.487931, -0.467857, -0.373707, 0.122075, -0.102494,
-0.317951, 0.338595, 0.484885, 0.427693, -0.344916, 0.228056, -0.058766, -0.394032,
-0.087306, 0.153923, 0.115917, -0.006795, -0.719867, -0.217549, -0.154689, -0.714277,
0.279999, 0.430907, 0.459459, 0.319758, -0.227979, 0.303091, 0.328281, -0.222927,
-0.124448, 0.202810, 0.449860, 0.458973, 0.167304, -0.196718, -0.480881, -0.424060,
0.027381, 0.045238, 0.084524, 0.007143, -0.086905, -0.689286, -0.333333, -0.911905,
0.557468, 0.317532, 0.468182, 0.467532, 0.317532, -0.088312, 0.131169, -0.183766,
-0.000021, 0.028509, 0.015454, -0.034564, -0.029123, -0.243097, -0.622326, -0.703261,
0.304023, 0.440998, 0.481578, 0.365633, 0.390411, 0.174917, -0.175205, -0.376341,
0.685624, 0.162065, 0.007803, -0.035564, 0.006303, -0.068577, -0.135954, -0.628752,
0.681265, 0.196275, -0.062731, -0.010122, 0.089401, -0.232143, -0.526786, -0.174530,
0.737499, 0.164895, -0.109625, -0.062133, -0.075913, -0.554931, -0.236641, -0.009591,
0.033834, -0.076615, -0.067992, 0.087276, -0.104407, -0.664987, -0.696544, -0.093275,
0.442391, 0.363699, 0.343974, 0.387829, 0.223853, -0.319442, -0.243609, 0.254222,
0.683676, 0.162294, -0.072852, -0.047277, -0.647261, -0.175630, 0.052155, 0.028291,
0.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.505882, 0.515686, 0.512745, 0.640196, -0.461765, 0.239216, -0.240196, 0.519608,
-0.013957, 0.031954, 0.029564, 0.005451, -0.728938, -0.597167, -0.260203, -0.058811,
0.434813, 0.507419, 0.491839, 0.362897, -0.351985, -0.179940, 0.164720, 0.370286,
-0.325141, 0.200029, 0.514060, 0.402451, -0.383282, -0.517288, -0.232398, 0.269145,
0.713305, 0.224811, -0.253480, -0.598634, 0.063834, 0.010927, 0.026810, -0.058274,
0.025104, 0.022397, -0.235113, -0.735343, 0.052488, -0.224081, -0.652711, -0.191227,
0.464286, 0.576531, 0.132653, -0.170918, 0.584184, 0.405612, -0.099490, 0.301020,
-0.002311, 0.031933, -0.143277, -0.695798, -0.198739, -0.687395, -0.250840, -0.016387,
0.458403, 0.468908, 0.440546, -0.357563, 0.325000, -0.048739, 0.400210, 0.530672,
-0.147321, 0.441964, 0.267857, -0.357143, 0.468750, -0.250000, -0.562500, 0.187500,
-0.035135, 0.093336, -0.209777, -0.641426, -0.691751, -0.251405, 0.032416, -0.031867,
0.392904, 0.536160, 0.232392, -0.231037, -0.216988, 0.236767, 0.531225, 0.393342,
-0.607143, 0.544643, 0.357143, -0.375000, -0.348214, 0.491071, -0.312500, 0.276786,
-0.349405, 0.347975, 0.462417, -0.103313, -0.490992, -0.232273, 0.360890, 0.383612,
0.711782, -0.094356, -0.513044, -0.114840, 0.163824, -0.114984, -0.164234, -0.014881,
0.089489, -0.158684, -0.618657, -0.074252, 0.073412, -0.221913, -0.670493, -0.048013,
0.486938, 0.294218, -0.192681, 0.417622, 0.560520, 0.301334, -0.197668, 0.539889,
0.161895, -0.155781, -0.758168, -0.030459, -0.078644, -0.781810, -0.204658, 0.165130,
0.464286, 0.135714, -0.253571, 0.407143, 0.107143, -0.335714, 0.410714, 0.639286,
-0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
0.008720, -0.104114, -0.558036, -0.154978, -0.744481, -0.100954, -0.067173, 0.037702,
0.453986, 0.367387, -0.111509, 0.145208, -0.448724, 0.418439, 0.628359, 0.496585,
-0.424510, 0.499020, -0.368627, 0.566667, -0.303922, 0.521569, -0.335294, 0.583333,
-0.397059, 0.235294, -0.455882, 0.323529, -0.485294, -0.514706, 0.264706, 0.382353,
-0.055009, -0.267944, -0.625412, -0.706627, -0.000298, 0.039525, 0.026444, -0.022557,
0.374940, 0.177224, -0.182388, -0.371610, 0.336807, 0.455859, 0.497280, 0.443486,
-0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-0.456710, 0.151286, -0.212418, -0.376992, -0.508833, 0.262163, 0.406735, 0.365939,
0.056443, 0.619936, 0.218343, -0.106204, -0.000230, 0.203120, -0.126133, -0.803894,
0.807323, -0.698229, -0.020258, 0.070828, 0.123800, -0.212935, 0.058824, 0.095588,
-0.077614, -0.616013, -0.253618, 0.119631, -0.002568, -0.245798, -0.661881, -0.083567,
0.454832, -0.211835, 0.296218, 0.398109, 0.435224, 0.341387, -0.303221, 0.342437,
-0.066220, -0.644171, -0.131726, 0.070354, -0.082516, -0.636784, -0.151242, 0.055698,
0.294103, -0.323557, 0.379266, 0.264899, 0.296513, -0.377824, 0.337594, 0.312244,
-0.404460, -0.379104, 0.232434, 0.478179, 0.109102, -0.443548, -0.392391, 0.314261,
-0.264480, -0.661719, -0.195856, 0.052994, -0.740936, -0.272669, 0.041341, 0.006347,
0.250000, -0.357143, 0.419643, 0.633929, -0.294643, 0.366071, 0.491071, 0.491071,
-0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
-0.394563, -0.281898, 0.264223, 0.380989, -0.423154, -0.250966, 0.298287, 0.351176,
-0.214286, -0.758929, -0.250000, -0.866071, 0.000000, 0.000000, 0.008929, -0.044643,
0.544118, -0.176471, 0.323529, -0.441176, 0.411765, 0.441176, 0.441176, 0.485294,
-0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-0.441176, -0.426471, 0.470588, -0.367647, 0.514706, -0.441176, 0.455882, 0.264706,
-0.557543, -0.181999, 0.194674, -0.192354, -0.319889, 0.372014, 0.539553, 0.339337,
0.016050, 0.264470, 0.595633, 0.065781, 0.011757, 0.128939, -0.065192, -0.704994,
-0.126882, -0.709150, -0.716100, -0.135029, 0.021480, -0.124936, -0.075618, 0.106987,
0.267644, -0.235665, -0.248472, 0.272749, 0.410134, 0.449284, 0.402802, 0.396165,
-0.342235, -0.397064, -0.392842, 0.438025, 0.454159, 0.164735, -0.328430, 0.413017,
-0.292501, -0.517394, -0.368098, 0.354446, 0.117247, -0.217973, 0.233711, 0.556859,
-0.393123, -0.490403, -0.220234, 0.255904, -0.252091, 0.195717, 0.476137, 0.394016,
0.017449, 0.058298, 0.242880, 0.712243, -0.061741, 0.081466, -0.128676, -0.714869,
-0.374055, -0.407232, -0.415269, -0.377579, 0.366999, 0.398832, 0.398524, 0.368259,
0.083201, -0.052969, 0.036755, -0.081874, 0.627002, 0.164392, -0.188364, -0.676421,
-0.009979, 0.145107, 0.139497, -0.092581, 0.173605, 0.628035, 0.062896, -0.757793,
-0.092437, 0.108193, 0.252101, -0.007353, -0.074580, 0.200980, 0.830532, -0.819328,
-0.583612, -0.112201, 0.125997, -0.165333, 0.041623, 0.047326, -0.104709, -0.748241,
-0.232231, 0.225550, 0.523218, 0.382246, 0.396200, 0.527948, 0.261825, -0.217005,
};
static float Shell1SPCCodebook[120*8] = {
0.300311, 0.305642, 0.286499, 0.245676, 0.333963, 0.345504, 0.317094, 0.272354,
1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000,
0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000,
0.766667, 0.066667, -0.033333, 0.033333, -0.066667, 0.766667, -0.100000, -0.033333,
0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000,
0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000,
0.627990, 0.077001, -0.088991, 0.003380, 0.536395, 0.082643, -0.041324, -0.021453,
0.305604, -0.224357, -0.405687, -0.275406, 0.232704, -0.249608, -0.421886, -0.250200,
-0.045455, -0.125000, -0.056818, -0.045455, 0.818182, -0.022727, -0.772727, -0.238636,
0.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000,
0.769231, 0.076923, 0.000000, 0.769231, 0.211538, -0.057692, -0.019231, -0.019231,
0.259095, -0.223329, -0.232112, 0.279429, -0.400797, -0.449530, -0.448989, -0.332574,
-0.039773, -0.036276, -0.180507, 0.722028, 0.032343, -0.041958, -0.716783, -0.059003,
0.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
-0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000,
1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000,
0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000,
-0.423077, -0.384615, 0.307692, -0.442308, 0.269231, 0.384615, 0.384615, -0.423077,
0.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 0.000000,
-0.523810, -0.500000, 0.428571, 0.583333, -0.380952, 0.250000, 0.428571, -0.285714,
-0.383333, -0.416667, 0.483333, 0.350000, 0.150000, -0.416667, 0.350000, -0.450000,
-0.385989, -0.224838, 0.296495, 0.298826, 0.369651, 0.435710, -0.201195, -0.471487,
0.000000, -1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -1.000000,
0.545455, -0.136364, 0.511364, 0.511364, 0.534091, 0.613636, 0.397727, -0.397727,
0.839394, 0.643745, 0.015866, -0.000390, 0.003377, -0.036017, -0.107987, -0.058160,
0.293952, 0.147351, -0.070463, -0.135234, -0.421991, -0.474827, -0.429251, -0.375861,
0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000,
-0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000,
0.159615, 0.553205, 0.008974, -0.899359, -0.007051, 0.167308, 0.219872, 0.085897,
-0.363636, 0.397727, -0.443182, 0.147727, -0.556818, 0.454545, 0.431818, -0.488636,
-0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
-0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000,
0.141919, -0.023232, -0.723737, -0.187879, 0.060101, 0.052525, -0.261616, -0.781818,
0.465909, 0.284091, -0.511364, 0.318182, 0.250000, 0.454545, 0.397727, -0.318182,
0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
-0.244118, 0.477450, 0.510376, -0.199120, -0.258210, 0.396782, 0.378738, -0.276166,
-0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
-0.295455, 0.436364, 0.381818, -0.318182, 0.377273, 0.400000, -0.236364, -0.431818,
0.037230, 0.063939, -0.108771, -0.604259, 0.008203, 0.044581, -0.114903, -0.645172,
0.278718, 0.339032, 0.281384, -0.213222, 0.304859, 0.363534, 0.270381, -0.256955,
-0.210768, 0.344156, 0.516504, 0.420725, -0.500541, -0.233766, 0.246212, -0.276515,
-0.306381, 0.456294, 0.441871, 0.309003, -0.383304, 0.322115, -0.319930, -0.457605,
0.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000,
0.375132, 0.463901, 0.439394, 0.255820, -0.174579, 0.347403, 0.329702, -0.243218,
-0.386364, 0.250000, 0.409091, 0.511364, 0.272727, -0.500000, -0.659091, -0.397727,
0.019231, 0.076923, -0.115385, 0.019231, -0.019231, -0.884615, -0.211538, -0.769231,
0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
0.036831, 0.051993, -0.057890, -0.113798, 0.050147, -0.073543, -0.606962, -0.676754,
0.413972, 0.433530, 0.406859, 0.280218, 0.328041, 0.230879, -0.202220, -0.343526,
0.704545, -0.011364, -0.136364, -0.102273, 0.068182, 0.068182, -0.011364, -0.795455,
0.809524, 0.190476, -0.035714, 0.000000, 0.130952, -0.071429, -0.714286, -0.011905,
0.818182, 0.125000, -0.079545, -0.079545, -0.011364, -0.818182, -0.227273, 0.022727,
0.253739, 0.009985, -0.097468, 0.137919, 0.110504, -0.629016, -0.798593, -0.095796,
0.347619, 0.353968, 0.336508, 0.495238, 0.301587, -0.326984, -0.404762, 0.331746,
0.800000, 0.100000, 0.033333, 0.033333, -0.800000, -0.033333, 0.200000, 0.100000,
0.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
-0.059530, -0.001562, 0.048418, 0.071820, -0.794712, -0.615283, -0.298906, -0.060714,
0.341769, 0.444240, 0.391858, 0.357830, -0.321109, -0.109851, 0.293447, 0.326363,
-0.303977, 0.278247, 0.382062, 0.404600, -0.427029, -0.355384, -0.239123, 0.336499,
1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000, 0.000000,
0.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
0.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
-0.033333, 0.000000, -0.166667, -1.100000, -0.700000, -0.100000, 0.000000, -0.100000,
0.315244, 0.467984, 0.200692, -0.131725, -0.352398, 0.403133, 0.408782, 0.301080,
-0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
-0.404762, 0.345238, 0.511905, -0.321429, -0.583333, -0.464286, 0.369048, 0.369048,
0.769231, -0.057692, -0.788462, -0.019231, 0.230769, 0.076923, -0.038462, 0.000000,
0.199537, -0.076765, -0.624272, -0.163823, 0.141096, -0.173339, -0.612479, -0.092984,
0.348299, 0.266667, -0.394558, 0.346259, 0.412245, 0.306803, -0.392517, 0.316327,
0.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
0.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000,
0.416667, 0.416667, -0.202381, 0.321429, -0.369048, 0.511905, 0.488095, 0.500000,
-0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000,
0.118164, -0.077446, -0.553151, -0.656340, 0.030020, -0.020364, -0.075035, -0.097446,
0.344987, 0.198540, -0.253064, -0.325069, 0.342692, 0.443095, 0.354836, 0.238959,
-0.392857, 0.404762, -0.488095, -0.321429, 0.226190, 0.369048, -0.500000, 0.309524,
-0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 0.500000,
0.066667, 0.633333, 0.133333, 0.066667, 0.100000, 0.133333, -0.133333, -1.100000,
1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
0.011364, -0.738636, -0.215909, -0.022727, 0.102273, -0.147727, -0.772727, -0.011364,
0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-0.081002, -0.865967, -0.143357, -0.032051, -0.092657, -0.730186, 0.132867, 0.111305,
0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-0.305916, -0.510823, 0.187229, 0.463203, 0.323593, -0.454906, -0.453463, 0.336941,
-0.130952, -0.761905, 0.095238, 0.083333, -0.845238, -0.035714, 0.190476, 0.023810,
0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
-0.382173, -0.326164, 0.268326, 0.305981, -0.395241, -0.306729, 0.296618, 0.315522,
-0.104458, -0.722902, -0.317308, -0.711101, 0.041521, -0.181818, -0.104895, -0.177885,
0.228355, -0.027056, 0.077706, -0.163420, 0.519120, 0.425253, 0.472944, 0.357071,
-0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 0.500000,
0.106061, 0.231935, 0.736014, -0.016900, 0.005245, -0.023310, -0.204545, -0.810023,
-0.005066, -0.834241, -0.797129, -0.112433, 0.324976, -0.139338, -0.176239, 0.160309,
0.110439, -0.392611, -0.459022, 0.134445, 0.252410, 0.364128, 0.389856, 0.503148,
-0.397436, -0.397436, -0.500000, 0.307692, 0.333333, 0.371795, -0.102564, 0.423077,
-0.470238, -0.565476, -0.517857, 0.261905, 0.279762, -0.285714, 0.285714, 0.523810,
-0.488992, -0.474988, -0.264671, 0.192382, -0.192086, 0.293327, 0.407851, 0.351167,
0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
-0.325833, -0.334113, -0.310327, -0.276253, 0.372448, 0.378157, 0.395306, 0.382033,
0.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 0.000000, 0.166667, -0.100000, 0.100000, 0.733333, 0.033333, -0.800000,
0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -1.000000,
-0.173358, 0.265911, 0.459332, 0.406042, 0.398310, 0.448042, 0.222288, -0.295756,
};
static float Shell1TPYCodebook[120*8] = {
0.324170, 0.352237, 0.348966, 0.311818, 0.329613, 0.358559, 0.352943, 0.313183,
0.695881, 0.026245, 0.072749, 0.030867, -0.003951, 0.108357, 0.552490, 0.080005,
0.226533, -0.384419, -0.377661, -0.243614, -0.365794, -0.302576, 0.308908, -0.287569,
0.716227, 0.162955, -0.034953, -0.027085, 0.163425, 0.599232, 0.063518, -0.007141,
0.280885, -0.308472, -0.448233, -0.346509, -0.226628, 0.229630, -0.250106, -0.343721,
0.026166, 0.049388, -0.079268, 0.013644, 0.009088, 0.634637, -0.674890, 0.005700,
0.644344, 0.069192, -0.053442, 0.001220, 0.672314, 0.080843, -0.049746, 0.008442,
0.266408, -0.256311, -0.426533, -0.297267, 0.268684, -0.265566, -0.428529, -0.309752,
0.125022, 0.003973, -0.098528, -0.016556, 0.687631, -0.025786, -0.580492, -0.094523,
0.058665, -0.096508, 0.021528, 0.034593, 0.701919, -0.663212, -0.011007, -0.002073,
0.636076, 0.187750, 0.169318, 0.613128, 0.058792, -0.000454, -0.008943, 0.016798,
0.206705, -0.298555, -0.288497, 0.160197, -0.331627, -0.401167, -0.419183, -0.350819,
0.020389, -0.054100, -0.043626, 0.720555, 0.018187, -0.073257, -0.561838, 0.033985,
-0.029834, -0.099532, 0.138100, 0.718503, -0.048682, -0.632888, -0.074234, 0.135762,
-0.010260, -0.003640, 0.110941, 0.588037, -0.667603, -0.044253, 0.067582, 0.066752,
-0.390902, -0.390101, -0.209966, 0.232329, 0.369751, 0.426460, 0.265130, -0.194933,
0.682076, 0.188198, 0.630935, 0.135995, 0.004852, -0.015909, 0.022343, -0.006226,
0.291888, -0.172635, 0.183724, -0.259173, -0.474801, -0.408562, -0.354627, -0.422709,
-0.114033, 0.119013, 0.648851, 0.084100, 0.072222, -0.035584, -0.591619, -0.041188,
0.002003, -0.022930, 0.588384, 0.123679, -0.027255, -0.665767, 0.034192, 0.080779,
-0.117139, 0.066512, 0.559691, 0.073147, -0.718508, -0.042146, 0.092118, -0.023853,
-0.360318, -0.284053, 0.249472, -0.284185, 0.295449, 0.385949, 0.323259, -0.318734,
0.033168, 0.027947, 0.579671, -0.704774, 0.032060, 0.046484, 0.102979, -0.059406,
-0.389006, -0.224181, 0.362346, 0.299787, -0.275160, 0.267646, 0.344370, -0.199159,
-0.320478, -0.461585, 0.382537, 0.287003, 0.204830, -0.377092, 0.309740, -0.245211,
-0.363932, -0.215691, 0.313253, 0.418164, 0.362713, 0.220411, -0.251219, -0.362121,
-0.057556, -0.558897, -0.106109, -0.015815, -0.025798, -0.005534, -0.082801, -0.600085,
0.263889, -0.160770, 0.326808, 0.460638, 0.351772, 0.389248, 0.330639, -0.270354,
0.700392, 0.582359, 0.176144, 0.018546, 0.074294, 0.027840, -0.002755, -0.006518,
0.295988, 0.173259, -0.213604, -0.354681, -0.308511, -0.367053, -0.409130, -0.338719,
0.099036, 0.639063, -0.061041, -0.033264, 0.071433, 0.022060, -0.565569, -0.068240,
0.025005, 0.664701, 0.047489, -0.007310, -0.030298, -0.677758, -0.140452, 0.107381,
-0.035452, 0.544895, 0.077519, -0.014323, -0.691267, 0.037920, 0.061731, 0.012452,
-0.221059, 0.232485, -0.380166, -0.405925, 0.292214, 0.435140, 0.229680, -0.325226,
0.056833, 0.525649, 0.027352, -0.664071, 0.015612, 0.089899, -0.005608, -0.090922,
-0.287356, 0.354765, -0.192409, 0.242457, -0.381705, 0.347821, 0.307352, -0.315254,
-0.260536, 0.363186, -0.241060, 0.477490, 0.270115, -0.264527, 0.324074, -0.252075,
-0.188027, 0.293487, -0.378448, 0.204310, 0.314511, 0.383238, -0.433333, -0.308190,
0.010571, -0.100773, -0.592059, -0.130841, -0.009216, 0.048512, -0.103238, -0.690157,
0.448276, 0.323635, -0.230783, 0.257633, 0.287416, 0.397390, 0.325371, -0.321570,
0.007706, 0.680294, -0.646160, 0.004093, 0.061194, 0.130442, -0.048872, 0.039773,
-0.295317, 0.325534, 0.353442, -0.266467, -0.270321, 0.334342, 0.362646, -0.259547,
-0.300840, 0.354996, 0.339302, -0.364206, 0.270041, -0.333923, 0.404067, -0.301872,
-0.213708, 0.342412, 0.268497, -0.312857, 0.342146, 0.333770, -0.282141, -0.392688,
0.002091, 0.048456, -0.089093, -0.663426, -0.000663, 0.064949, -0.083105, -0.688196,
0.328686, 0.440878, 0.246247, -0.256417, 0.325734, 0.426012, 0.232209, -0.245305,
-0.287380, 0.340182, 0.448611, 0.294468, -0.389751, -0.255053, 0.220378, -0.171360,
-0.366229, 0.322250, 0.400383, 0.307909, -0.326929, 0.282841, -0.234729, -0.356623,
-0.027444, 0.042684, 0.026400, -0.040596, -0.616514, -0.171090, -0.154731, -0.660295,
0.354979, 0.433985, 0.375886, 0.311743, -0.180462, 0.301856, 0.268056, -0.202845,
-0.248668, 0.227460, 0.415110, 0.367577, 0.203798, -0.258456, -0.406909, -0.350186,
0.009753, -0.046238, -0.038184, -0.074038, -0.130725, -0.557254, -0.195968, -0.721003,
0.328610, 0.367189, 0.465848, 0.316059, 0.318966, -0.222619, 0.180506, -0.274475,
0.008525, 0.010438, -0.046069, -0.085632, -0.029274, -0.181791, -0.601086, -0.709592,
0.355819, 0.423721, 0.372847, 0.287143, 0.359871, 0.215441, -0.159176, -0.281236,
0.606983, 0.100255, -0.029420, -0.089423, 0.065294, -0.003261, -0.164956, -0.633826,
0.624990, 0.061445, -0.047404, -0.000448, 0.105099, -0.086125, -0.583272, -0.109420,
0.669361, 0.034483, -0.020504, -0.026431, -0.009354, -0.600156, -0.062919, -0.009728,
-0.005402, -0.061906, -0.061150, -0.002245, -0.137465, -0.656874, -0.658217, -0.146577,
0.411015, 0.382410, 0.363819, 0.380277, 0.214707, -0.223241, -0.211294, 0.219331,
0.650598, 0.058396, -0.029314, 0.003452, -0.663248, -0.042938, 0.005714, -0.009744,
-0.070592, -0.036354, -0.069478, 0.004901, -0.704446, -0.161989, -0.576227, -0.075982,
0.330416, 0.417712, 0.298720, 0.392894, -0.255442, 0.305512, -0.269462, 0.282828,
-0.073451, -0.047758, -0.002393, -0.006213, -0.709525, -0.592204, -0.176929, -0.033574,
0.316846, 0.384314, 0.425068, 0.347572, -0.303443, -0.155307, 0.224245, 0.347855,
-0.281573, 0.196635, 0.424012, 0.342363, -0.387736, -0.385417, -0.186617, 0.226999,
0.651909, 0.164414, -0.120583, -0.621222, 0.022510, -0.020221, -0.032957, -0.064389,
-0.000267, 0.030410, -0.154898, -0.660511, 0.028094, -0.094869, -0.609737, -0.132859,
0.361740, 0.449683, 0.268858, -0.244223, 0.395654, 0.295827, -0.259608, 0.204622,
0.007453, -0.004161, -0.119283, -0.683758, -0.079622, -0.604346, -0.171097, 0.049689,
0.346809, 0.336471, 0.300238, -0.242436, 0.318767, -0.211719, 0.275433, 0.331186,
-0.244572, 0.336925, 0.305635, -0.447398, 0.237867, -0.379869, -0.467912, 0.309547,
-0.046033, -0.005057, -0.123436, -0.593870, -0.615323, -0.102490, 0.022538, -0.037497,
0.333522, 0.449647, 0.245048, -0.171283, -0.170875, 0.248356, 0.455803, 0.320457,
-0.366304, 0.365598, 0.289322, -0.243194, -0.370186, 0.442529, -0.332023, 0.263460,
-0.301409, 0.317256, 0.363742, -0.167661, -0.411065, -0.222380, 0.396964, 0.351314,
0.660819, -0.014579, -0.578388, -0.134757, 0.065724, -0.040642, -0.049831, 0.010225,
0.044514, -0.064706, -0.643284, -0.073062, 0.057256, -0.049414, -0.651181, -0.064527,
0.330873, 0.281282, -0.336199, 0.289225, 0.339665, 0.278634, -0.357638, 0.273323,
0.042458, -0.147989, -0.635786, -0.027944, 0.013639, -0.676787, -0.104989, 0.050891,
0.293862, 0.271352, -0.365501, 0.308868, 0.329382, -0.403656, 0.205180, 0.376437,
-0.259259, 0.294444, -0.468519, 0.322222, 0.390741, -0.346296, -0.377778, 0.346296,
-0.003759, -0.100719, -0.530687, -0.099165, -0.675107, -0.067303, -0.021344, -0.045543,
0.378914, 0.356817, -0.195534, 0.252774, -0.270379, 0.402332, 0.350773, 0.329700,
-0.271019, 0.369587, -0.361870, 0.262416, -0.273169, 0.320737, -0.386847, 0.322128,
-0.359387, 0.292593, -0.243040, 0.392082, -0.396105, -0.315006, 0.237356, 0.353959,
-0.012832, -0.174089, -0.613883, -0.711659, -0.001572, 0.004888, -0.039719, -0.059331,
0.366050, 0.213085, -0.171929, -0.281701, 0.369259, 0.419092, 0.373752, 0.290110,
-0.281206, 0.405072, -0.325166, -0.355011, 0.372908, 0.406786, -0.409558, 0.210375,
-0.210728, 0.281536, -0.388373, -0.347259, 0.362364, -0.279104, 0.331786, 0.347701,
-0.278880, 0.274543, -0.221409, -0.324442, -0.276296, 0.335882, 0.352310, 0.231530,
0.093014, 0.546813, 0.092953, -0.072491, -0.032221, 0.083558, -0.071044, -0.700253,
0.721073, -0.621328, -0.064198, 0.023521, 0.095487, -0.134994, -0.019242, 0.033312,
-0.037961, -0.668767, -0.110456, 0.038079, 0.038146, -0.127882, -0.683606, -0.007713,
0.322576, -0.307840, 0.209623, 0.391026, 0.439803, 0.239022, -0.275862, 0.343722,
-0.015842, -0.657959, -0.081656, 0.050582, -0.028876, -0.675593, -0.071182, 0.038766,
0.272249, -0.335249, 0.309634, 0.337592, 0.278793, -0.361690, 0.305195, 0.316746,
-0.322306, -0.340374, 0.250659, 0.404107, 0.201497, -0.339535, -0.320390, 0.274437,
-0.145165, -0.583882, -0.066970, 0.028466, -0.671077, -0.133511, 0.069145, 0.037506,
0.219601, -0.206191, 0.344424, 0.372983, -0.277274, 0.297590, 0.396552, 0.281886,
-0.364583, -0.357938, 0.207256, 0.328065, -0.355125, 0.295079, -0.226952, 0.271013,
-0.370530, -0.278098, 0.269209, 0.342552, -0.372900, -0.274182, 0.260307, 0.341344,
-0.138585, -0.601649, -0.138819, -0.634567, -0.040487, -0.040464, 0.047823, -0.017685,
0.290868, -0.180848, 0.202081, -0.245557, 0.437420, 0.383727, 0.445855, 0.382051,
-0.338889, -0.263889, 0.316667, -0.338889, 0.344444, 0.319444, -0.252778, 0.277778,
-0.267800, -0.361830, 0.331338, -0.304119, 0.211845, -0.321679, 0.331657, 0.359355,
-0.428298, -0.204570, 0.199015, -0.225725, -0.285085, 0.283279, 0.403722, 0.311084,
-0.026295, 0.113197, 0.572117, 0.005438, -0.020130, 0.060129, 0.011355, -0.681946,
-0.137026, -0.663568, -0.648154, -0.124407, -0.000081, -0.059145, -0.071203, -0.012155,
0.260868, -0.226143, -0.192475, 0.228202, 0.422002, 0.376392, 0.358927, 0.389363,
-0.360483, -0.401670, -0.284243, 0.301994, 0.315374, 0.323904, -0.258082, 0.341505,
-0.341693, -0.375363, -0.277168, 0.289156, 0.247649, -0.227853, 0.266342, 0.369122,
-0.354556, -0.416836, -0.213725, 0.247016, -0.244891, 0.184859, 0.421906, 0.351129,
-0.007965, -0.023526, 0.057891, 0.624915, 0.016887, 0.023894, -0.064071, -0.642576,
-0.313131, -0.338952, -0.341400, -0.310086, 0.323781, 0.344029, 0.340533, 0.310172,
0.028038, 0.065508, -0.005211, -0.015748, 0.615965, 0.111858, -0.150481, -0.568154,
-0.002510, 0.089524, -0.001933, -0.096043, 0.065303, 0.542154, 0.006607, -0.705877,
0.035774, -0.010981, 0.089636, -0.062857, -0.002082, 0.040688, 0.583597, -0.713296,
-0.563352, -0.153582, 0.020364, -0.064100, -0.046571, 0.015479, -0.102912, -0.625460,
-0.209000, 0.238736, 0.474882, 0.322053, 0.317997, 0.471280, 0.253377, -0.158297,
};
static float Shell1TPCCodebook[120*8] = {
0.318324, 0.339451, 0.332074, 0.294385, 0.332873, 0.352534, 0.344915, 0.310328,
0.900000, 0.200000, 0.120000, 0.040000, -0.080000, 0.160000, 0.760000, 0.080000,
0.140000, -0.473333, -0.460000, -0.326667, -0.526667, -0.566667, 0.393333, -0.593333,
0.587415, 0.310049, 0.009951, -0.022439, 0.237951, 0.638927, 0.070341, 0.037073,
0.393333, -0.353333, -0.566667, -0.326667, -0.286667, 0.220000, -0.393333, -0.380000,
-0.140000, -0.040000, 0.120000, 0.070000, -0.010000, 0.630000, -0.750000, -0.110000,
0.632709, 0.141435, -0.005397, 0.001843, 0.660630, 0.135530, -0.021384, -0.008027,
0.211338, -0.283971, -0.426060, -0.285310, 0.231651, -0.270063, -0.458530, -0.336366,
0.040836, -0.009199, 0.010174, -0.060348, 0.729617, 0.046690, -0.542997, -0.085296,
0.060000, -0.100000, 0.010000, 0.140000, 0.820000, -0.710000, -0.120000, -0.030000,
0.647805, 0.132417, 0.115299, 0.651619, 0.148204, 0.011353, -0.078315, 0.028736,
0.183954, -0.260154, -0.232323, 0.220308, -0.288806, -0.470013, -0.493838, -0.254352,
0.111463, -0.139268, -0.079756, 0.903415, 0.026585, -0.108780, -0.618293, -0.010488,
-0.106667, -0.140000, 0.073333, 0.606667, 0.006667, -0.666667, -0.040000, 0.086667,
-0.114255, 0.051165, 0.149593, 0.737886, -0.554688, -0.178211, -0.094526, 0.026341,
-0.396000, -0.372000, -0.388000, 0.156000, 0.460000, 0.452000, 0.348000, -0.276000,
0.770000, 0.310000, 0.620000, 0.185000, 0.130000, 0.020000, 0.100000, -0.010000,
0.215122, -0.399233, 0.259721, -0.346272, -0.391568, -0.399791, -0.311986, -0.394495,
0.030000, 0.310000, 0.670000, 0.160000, -0.130000, -0.140000, -0.920000, -0.070000,
0.040000, 0.016000, 0.624000, 0.152000, -0.080000, -0.768000, -0.064000, 0.136000,
0.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000,
-0.230000, -0.470000, 0.510000, -0.390000, 0.330000, 0.470000, 0.470000, -0.490000,
-0.073756, 0.092878, 0.803317, -0.537561, 0.103805, 0.059512, 0.094244, -0.026732,
-0.505772, -0.255366, 0.431301, 0.463984, -0.427398, 0.326911, 0.390976, -0.236179,
-0.310000, -0.590000, 0.350000, 0.390000, 0.310000, -0.510000, 0.450000, -0.350000,
-0.417500, -0.392500, 0.242500, 0.437500, 0.187500, 0.262500, -0.237500, -0.407500,
-0.164460, -0.585923, 0.013101, -0.010453, 0.073868, 0.041254, -0.156098, -0.731847,
0.342846, -0.251138, 0.333577, 0.455041, 0.469512, 0.383171, 0.314390, -0.190650,
0.738605, 0.608810, 0.204254, 0.078059, 0.114293, 0.040576, -0.018761, -0.023444,
0.285915, 0.148987, -0.207880, -0.325338, -0.332649, -0.390883, -0.435321, -0.367716,
0.050000, 0.770000, -0.040000, -0.100000, -0.120000, 0.130000, -0.580000, -0.040000,
0.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000,
-0.046667, 0.753333, 0.146667, -0.040000, -0.753333, 0.126667, 0.186667, 0.006667,
-0.271646, 0.361646, -0.231890, -0.446280, 0.292378, 0.403963, 0.417622, -0.301890,
0.179024, 0.671707, 0.022829, -0.798146, -0.032780, 0.021073, 0.082732, 0.053951,
-0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
-0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
-0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000,
-0.047894, -0.047805, -0.625100, -0.248692, 0.019956, 0.032018, -0.169933, -0.795743,
0.506098, 0.310650, -0.323984, 0.108211, 0.463821, 0.473089, 0.198455, -0.346911,
0.093333, 0.786667, -0.680000, 0.053333, 0.080000, 0.133333, -0.133333, 0.026667,
-0.313293, 0.325569, 0.223130, -0.255244, -0.355000, 0.368902, 0.271667, -0.335976,
-0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
-0.127209, 0.417507, 0.215339, -0.341192, 0.302710, 0.246125, -0.426721, -0.395501,
-0.039524, -0.055592, -0.159036, -0.722011, -0.026109, -0.047948, -0.152029, -0.727983,
0.323379, 0.361217, 0.232706, -0.173253, 0.353165, 0.405671, 0.265748, -0.208645,
-0.339024, 0.381951, 0.427805, 0.410894, -0.274634, -0.557561, 0.166016, -0.356911,
-0.233333, 0.526667, 0.486667, 0.420000, -0.406667, 0.260000, -0.260000, -0.340000,
-0.074667, 0.029333, -0.043317, -0.110699, -0.655415, -0.236488, -0.244813, -0.633691,
0.358016, 0.396130, 0.449724, 0.409659, -0.195805, 0.259350, 0.318862, -0.255187,
-0.340000, 0.334286, 0.574286, 0.391429, 0.208571, -0.448571, -0.437143, -0.305714,
0.008000, 0.040000, -0.032000, -0.112000, -0.096000, -0.760000, -0.264000, -0.728000,
0.445000, 0.395000, 0.465000, 0.545000, 0.215000, -0.215000, 0.205000, -0.165000,
0.004484, -0.021993, -0.076399, -0.104857, -0.006072, -0.181484, -0.614603, -0.706238,
0.379845, 0.401185, 0.382710, 0.265141, 0.358196, 0.244359, -0.160457, -0.271614,
0.680000, 0.106667, 0.020000, -0.140000, 0.066667, -0.013333, -0.113333, -0.773333,
0.653333, -0.133333, -0.040000, 0.173333, -0.040000, -0.173333, -0.906667, -0.053333,
0.760244, 0.094390, -0.040976, -0.002195, 0.071463, -0.591951, -0.101707, -0.020732,
0.028122, -0.133025, -0.096602, 0.024972, -0.150244, -0.642653, -0.625691, -0.108943,
0.378443, 0.375929, 0.325797, 0.403771, 0.171689, -0.207786, -0.207523, 0.236642,
1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000,
-0.040000, 0.033333, -0.053333, 0.040000, -0.733333, -0.386667, -0.673333, -0.186667,
0.406667, 0.420000, 0.393333, 0.500000, -0.246667, 0.286667, -0.166667, 0.286667,
-0.121212, -0.082085, 0.006398, 0.064750, -0.714054, -0.628354, -0.230521, -0.050259,
0.308337, 0.374909, 0.450687, 0.368860, -0.259663, -0.189969, 0.249109, 0.349827,
-0.267294, 0.193426, 0.353937, 0.457166, -0.385389, -0.360906, -0.186039, 0.224506,
0.495749, 0.108850, -0.000279, -0.796934, 0.210453, 0.089477, 0.042509, -0.036794,
0.014049, 0.023805, -0.177756, -0.689886, 0.057756, -0.043967, -0.608976, -0.225366,
0.330000, 0.350000, 0.490000, -0.270000, 0.370000, 0.550000, -0.350000, 0.550000,
-0.035000, 0.000000, -0.070000, -0.675000, -0.085000, -0.635000, -0.145000, 0.040000,
0.340000, 0.326667, 0.433333, -0.193333, 0.553333, -0.220000, 0.273333, 0.473333,
-0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
-0.084098, -0.026244, -0.068585, -0.707122, -0.561073, -0.052390, 0.042049, 0.087610,
0.392122, 0.471927, 0.254756, -0.176805, -0.171683, 0.303927, 0.489488, 0.349585,
-0.350000, 0.530000, 0.410000, -0.490000, -0.450000, 0.330000, -0.410000, 0.310000,
-0.179085, 0.402134, 0.524573, -0.189939, -0.299939, -0.201646, 0.397134, 0.429329,
0.813463, -0.062732, -0.600390, -0.182927, 0.140683, -0.115512, -0.109073, -0.012585,
-0.008546, -0.109073, -0.676722, -0.069932, -0.015493, -0.097483, -0.686985, -0.119102,
0.433240, 0.343624, -0.397840, 0.357003, 0.355470, 0.341672, -0.295261, 0.292195,
0.013333, -0.186341, -0.795772, -0.268618, -0.051707, -0.807480, -0.174634, -0.012683,
0.310000, 0.330000, -0.250000, 0.390000, 0.470000, -0.430000, 0.330000, 0.510000,
-0.310000, 0.450000, -0.470000, 0.470000, 0.330000, -0.250000, -0.490000, 0.310000,
-0.130732, -0.116585, -0.545366, -0.189106, -0.756098, -0.049593, 0.025203, -0.071057,
0.443693, 0.298606, -0.186690, 0.297073, -0.341533, 0.346829, 0.477282, 0.429338,
-0.326667, 0.313333, -0.393333, 0.366667, -0.340000, 0.446667, -0.300000, 0.446667,
-0.250000, 0.490000, -0.430000, 0.310000, -0.530000, -0.430000, 0.350000, 0.290000,
-0.027676, -0.153208, -0.592812, -0.714275, 0.023470, 0.010723, -0.089084, -0.140230,
0.346424, 0.218769, -0.186754, -0.283114, 0.364826, 0.409899, 0.378559, 0.278447,
-0.510000, 0.390000, -0.550000, -0.430000, 0.570000, 0.470000, -0.450000, 0.590000,
-0.410000, 0.310000, -0.470000, -0.390000, 0.370000, -0.470000, 0.330000, 0.390000,
-0.332500, 0.137500, -0.262500, -0.252500, -0.387500, 0.392500, 0.412500, 0.407500,
0.131429, 0.628571, 0.080000, -0.228571, -0.005714, 0.222857, -0.142857, -0.828571,
0.973333, -1.013333, -0.426667, 0.053333, 0.120000, 0.013333, -0.013333, 0.066667,
0.080000, -0.760000, -0.200000, 0.080000, 0.020000, -0.040000, -0.920000, -0.240000,
0.310000, -0.250000, 0.410000, 0.410000, 0.470000, 0.410000, -0.550000, 0.670000,
-0.089859, -0.682157, -0.085956, 0.013813, -0.048370, -0.616072, -0.065494, 0.018331,
0.262561, -0.263439, 0.382561, 0.371049, 0.228561, -0.273976, 0.338122, 0.399585,
-0.360610, -0.301829, 0.358659, 0.480610, 0.252073, -0.331829, -0.187195, 0.411829,
-0.093519, -0.789686, -0.279024, -0.116516, -0.847108, -0.271359, -0.035261, 0.034286,
0.408571, -0.094286, 0.465714, 0.408571, -0.271429, 0.317143, 0.437143, 0.288571,
-0.505000, -0.435000, 0.565000, 0.385000, -0.485000, 0.385000, -0.195000, 0.505000,
-0.339430, -0.225719, 0.294717, 0.362199, -0.322754, -0.256608, 0.247812, 0.391467,
-0.218341, -0.664780, -0.288780, -0.653659, 0.042439, -0.027122, 0.002439, -0.094439,
0.230000, -0.130000, 0.290000, -0.370000, 0.603333, 0.436667, 0.470000, 0.390000,
-0.340000, -0.313333, 0.473333, -0.460000, 0.500000, 0.540000, -0.246667, 0.340000,
-0.414756, -0.348171, 0.147683, -0.247683, 0.327683, -0.399146, 0.279878, 0.602317,
-0.430000, -0.210000, 0.370000, -0.290000, -0.430000, 0.350000, 0.430000, 0.510000,
-0.019146, 0.157927, 0.604512, -0.116098, -0.017439, -0.014756, -0.040488, -0.731829,
-0.191109, -0.709557, -0.689468, -0.217073, 0.063104, -0.098537, -0.125965, 0.003415,
0.222663, -0.304492, -0.341850, 0.133232, 0.456362, 0.377581, 0.270102, 0.271280,
-0.370000, -0.430000, -0.350000, 0.390000, 0.590000, 0.330000, -0.270000, 0.350000,
-0.285000, -0.405000, -0.405000, 0.415000, 0.435000, -0.345000, 0.365000, 0.255000,
-0.404787, -0.402226, -0.194055, 0.361738, -0.211311, 0.154543, 0.385213, 0.366921,
0.011429, -0.045714, 0.080000, 0.702857, 0.000000, -0.005714, -0.120000, -0.657143,
-0.347648, -0.357933, -0.337087, -0.285648, 0.316650, 0.344689, 0.349749, 0.307869,
0.100390, -0.020683, -0.117756, -0.212585, 0.571024, 0.153073, -0.061561, -0.767610,
-0.042395, 0.058359, -0.030155, -0.046652, 0.104922, 0.719202, 0.015521, -0.716098,
0.080000, 0.136000, 0.056000, -0.016000, -0.152000, 0.112000, 0.584000, -0.816000,
-0.474286, -0.120000, -0.051429, -0.062857, 0.017143, 0.017143, -0.028571, -0.857143,
-0.133106, 0.306894, 0.431707, 0.305203, 0.286016, 0.466179, 0.282049, -0.238211,
};

/* Shell2 Centroids */

static float Shell2SPYCodebook[800*8] = {
1.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000, 0.500000,
0.335820, 0.526337, 0.674877, 0.621886, 0.314374, -0.214145, -0.664233, -1.167347,
-0.500000, -0.500000, 1.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
1.426471, -0.485294, -0.485294, -0.411765, 0.455882, -0.455882, 0.117647, -0.382353,
0.500000, 0.500000, 0.500000, 0.500000, 1.500000, 0.500000, -0.500000, 0.500000,
-0.521654, -0.530788, -0.385878, -0.258005, 0.581999, -0.412459, -1.029967, -0.581999,
0.602679, 0.486607, 0.383929, 0.471726, -0.714286, 0.428571, 0.136905, -1.244048,
-0.514823, -0.598214, -0.699463, -0.488854, 0.737979, 1.185574, 0.751225, -0.308707,
-0.500000, -0.500000, -0.500000, 1.500000, 0.500000, -0.500000, 0.500000, -0.500000,
-0.500000, -0.500000, 1.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
-0.500000, 1.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
1.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000,
0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -1.500000, -0.500000, -0.500000,
0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -1.500000,
-0.617647, -0.588235, -0.544118, -0.588235, 0.573529, 0.602941, 1.264706, -0.382353,
-0.500000, -0.500000, -0.500000, 1.500000, 0.500000, 0.500000, -0.500000, -0.500000,
-0.450000, -0.550000, 1.500000, -0.375000, 0.175000, 0.525000, -0.375000, -0.550000,
-0.500000, 1.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000,
1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000, 0.000000,
1.058824, -0.058824, 0.000000, -0.088235, 0.911765, -0.955882, 0.926471, -0.044118,
-1.107843, -0.372549, -0.098039, 0.029412, 1.019608, -0.950980, -0.725490, -0.009804,
0.325185, 0.722075, 0.952186, 0.900431, 0.218350, 0.017488, -0.335191, -0.755172,
0.531888, -0.202806, -0.748724, -0.500000, 0.692602, 0.192602, -1.303571, -0.897959,
0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -1.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000, 0.500000,
-0.207983, 0.295518, 0.500788, 0.467875, -0.427346, -0.491597, -0.732756, -1.087535,
1.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000,
0.553571, 0.556548, 0.630952, 1.223214, 0.395833, 0.214286, -0.169643, 0.389881,
-0.401273, -0.522578, -0.421798, 0.250205, -0.307677, -0.598522, -1.172003, -0.374589,
0.201299, 0.459091, 0.428247, -0.564286, 0.431494, 0.505519, -0.385714, -1.125325,
-0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 1.500000, 0.500000, -0.500000,
-0.500000, -0.500000, -0.500000, 0.500000, 1.500000, -0.500000, 0.500000, -0.500000,
-0.411765, -0.602941, 1.544118, 0.514706, -0.455882, -0.500000, 0.779412, -0.279412,
-0.500000, 1.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000,
1.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000,
0.500000, 0.500000, 0.500000, 1.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-0.411765, -0.514706, -0.455882, 0.323529, -0.544118, -1.279412, -0.764706, -0.441176,
0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -1.500000,
-0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 1.500000, -0.500000,
-0.160714, -0.625000, -0.379464, 0.236607, 1.205357, 0.397321, -0.508929, -0.526786,
-0.500000, -0.500000, 1.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000,
-0.500000, 1.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000,
1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000, 0.000000,
1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-0.860589, -0.217540, 0.408877, 0.674789, -0.044915, -0.851032, -0.858975, 0.056614,
-0.761905, -0.250000, 0.172619, 0.785714, 0.107143, 0.904762, 0.880952, 0.041667,
0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -1.500000, -0.500000,
0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -1.500000, 0.500000, -0.500000,
-0.330357, 0.375000, 0.446429, 1.330357, 0.526786, -0.232143, -0.455357, 0.401786,
-1.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
1.392974, -0.504669, -0.790966, 0.372432, 0.742530, -0.790616, -0.766573, -0.545752,
0.500000, 0.500000, 0.550000, 1.300000, -0.625000, 0.600000, 0.625000, 0.650000,
-0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000,
-0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000,
1.086905, 0.152381, -0.121429, 0.970238, 1.164286, -0.186905, -0.880952, -0.020238,
0.901786, -0.098214, -0.205357, 0.928571, -1.071429, 0.026786, 0.767857, -0.133929,
-1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000,
-0.241638, 0.878238, 0.900087, 0.031483, 0.081718, 0.806968, 0.052936, -0.999205,
-1.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 1.000000, 0.000000,
0.000000, -1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000,
0.370536, -0.366071, -0.535714, 0.267857, 0.379464, -0.388393, -1.214286, -0.642857,
0.511905, -0.196429, -0.642857, 0.422619, -1.488095, -0.565476, 0.303571, -0.440476,
-0.500000, 0.500000, 0.500000, 1.500000, -0.500000, 0.500000, -0.500000, 0.500000,
-0.348214, 0.450893, 0.392857, -0.558036, -0.303571, 0.330357, -0.218750, -1.200893,
-1.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 1.500000, 0.500000, -0.500000,
0.500000, -0.500000, 1.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
1.000000, -0.160714, 0.223214, 1.022321, 0.982143, -0.526786, -0.084821, -0.008929,
1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 1.000000, 0.000000, 0.000000,
-0.937500, -0.160714, 0.196429, 0.821429, -0.973214, -0.785714, -0.017857, -0.026786,
0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000,
-0.901786, -0.053571, 0.366071, 1.107143, 1.080357, 1.000000, 0.107143, -0.133929,
0.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000, -1.000000,
0.815051, -0.489796, -0.390306, 0.184949, 0.452806, -1.218112, -0.964286, -0.483418,
0.500000, -0.500000, -0.500000, 0.500000, -1.500000, 0.500000, -0.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000, 0.500000, 0.500000,
-0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -1.500000,
-1.367647, -0.485294, -0.558824, 0.235294, 0.485294, 0.367647, -0.382353, -0.588235,
0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000,
0.500000, -0.500000, 1.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000,
0.500000, 1.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000,
0.300595, 0.101190, 0.287202, 0.985119, 0.830357, -0.900298, -1.125000, 0.369048,
0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 1.000000, 0.000000,
-0.091032, 0.085457, 0.355260, 0.643751, 0.884299, 0.899896, 0.666147, 0.193069,
1.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000,
0.500000, 0.500000, 1.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -1.500000,
-0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 1.500000, 0.500000, -0.500000,
1.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000,
0.500000, 0.500000, 1.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-0.490196, -0.284314, 0.558824, -0.401961, -0.431373, 0.539216, 1.303922, -0.598039,
-0.500000, -0.500000, 0.500000, -0.500000, 1.500000, 0.500000, -0.500000, -0.500000,
1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000,
1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-0.907143, -0.046429, 0.746429, 0.342857, -0.296429, -0.928571, -0.735714, 0.125000,
0.000000, 1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
-0.737527, 0.117443, 0.767725, 0.227592, -0.149646, 0.808456, 0.716777, -0.084523,
0.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -1.500000, -0.500000,
0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -1.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 1.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -1.500000,
-1.369048, -0.101190, 0.482143, -0.273810, -0.535714, 0.464286, 0.410714, -0.261905,
0.500000, -0.500000, 0.500000, -0.500000, 1.500000, 0.500000, 0.500000, -0.500000,
0.500000, -0.500000, 0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000,
0.309524, 1.273810, 0.446429, -0.488095, -0.375000, 0.607143, 0.583333, -0.226190,
1.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000,
0.500000, 0.500000, 1.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, -1.500000, -0.500000, -0.500000, -0.500000,
0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -1.500000,
-0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 1.500000, -0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 1.500000, -0.500000, -0.500000,
-0.481034, -0.413177, 0.412808, 1.257020, 0.248768, -0.380049, -0.626232, -0.304187,
-0.500000, 1.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000,
1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000,
1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000,
0.000000, 1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.000000, -1.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -1.500000, -0.500000,
0.500000, -0.500000, 0.500000, -0.500000, -1.500000, -0.500000, 0.500000, -0.500000,
-0.482143, 0.428571, -0.250000, 0.267857, -0.491071, 0.392857, -0.491071, -1.330357,
0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 1.500000, 0.500000, -0.500000,
1.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000,
1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000,
-0.763547, 0.138424, 0.699877, 0.091502, -0.887562, -0.866872, -0.097783, 0.180911,
-0.868003, 0.170231, 0.693686, -0.082456, 0.963670, 0.702754, 0.121026, -0.009852,
0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -1.500000, -0.500000, -0.500000,
0.500000, -0.500000, 0.500000, -0.500000, -1.500000, 0.500000, -0.500000, -0.500000,
-0.515664, 0.336779, 1.137218, 0.516291, -0.625313, -0.597431, 0.407581, 0.547932,
-1.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000,
0.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 1.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000,
-0.062500, -0.178571, 1.008929, 0.142857, -0.857143, -0.839286, 0.919643, -0.133929,
-1.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
0.000965, 0.184363, 0.706081, 0.182432, 0.572876, 0.862934, 0.930019, 0.037162,
-0.772321, -0.732143, -0.505580, -1.264509, -0.001116, -0.008929, -0.010045, -0.956473,
1.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
0.823880, 0.821779, 0.135854, -1.019258, -0.038866, 0.106092, 0.015056, -0.795168,
1.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000,
0.254902, 0.617647, 1.401961, -0.480392, 0.303922, 0.549020, 0.696078, 0.323529,
-0.500000, -0.500000, 0.500000, -1.500000, -0.500000, -0.500000, -0.500000, -0.500000,
0.371849, 0.254552, -0.530812, -0.517857, 0.389706, 0.476891, 0.379552, -1.159314,
-0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 1.500000, -0.500000,
-0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000, -0.500000,
-0.500000, -0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000, -0.500000,
-0.617647, 1.323529, 0.617647, 0.279412, -0.529412, -0.588235, -0.617647, -0.441176,
1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
-0.008929, 0.883929, 0.214286, -0.250000, 0.973214, 1.026786, -0.089286, -0.812500,
0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -1.500000, -0.500000,
0.500000, -0.500000, 0.500000, -1.500000, -0.500000, -0.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -1.500000,
1.000000, 0.000000, 1.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000,
-1.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
-0.593888, -0.113722, 0.800460, 0.798030, 0.230263, 0.781534, 0.148043, -0.125972,
0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -1.500000, -0.500000, -0.500000,
0.500000, -0.500000, 0.500000, -1.500000, -0.500000, 0.500000, -0.500000, -0.500000,
-0.500000, 0.500000, 1.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-1.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000,
-0.325068, 0.299570, 0.934810, 1.070708, -0.233913, -0.725814, -0.840131, -0.179701,
0.000000, 0.000000, 1.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
-0.155525, 0.195634, 0.703043, 0.730404, 0.002982, 0.720924, 0.806522, 0.070103,
-1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, 1.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
1.000000, 0.000000, 1.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000,
-1.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
0.014706, 0.926471, 0.058824, -0.308824, 0.014706, 0.808824, 1.044118, -0.985294,
-0.830357, 0.071429, 0.937500, 1.116071, 0.991071, 0.241071, -0.098214, -0.160714,
0.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000,
0.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000,
0.189134, 0.839169, 0.315359, 0.157388, -0.150385, -0.531629, -0.878210, -0.934641,
0.500000, -0.500000, 0.500000, 0.500000, -1.500000, -0.500000, -0.500000, -0.500000,
0.500000, -0.500000, 0.500000, -1.500000, 0.500000, -0.500000, -0.500000, -0.500000,
-0.565476, 0.577381, 1.130952, -0.363095, -0.482143, 0.369048, 0.702381, 0.327381,
-0.275000, 0.575000, -0.525000, -0.575000, -0.425000, 0.625000, 0.475000, -1.325000,
-1.113891, -0.393969, 0.286999, 0.357644, 0.318503, -0.254734, -0.459800, -0.451973,
0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000,
0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000,
0.500000, 1.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000,
0.000000, 0.000000, 1.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.000000, 0.000000, 1.000000, -1.000000, 1.000000, 0.000000, -1.000000, 0.000000,
0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 1.000000, 0.000000,
0.000000, 0.000000, 1.000000, 1.000000, 1.000000, 0.000000, 1.000000, 0.000000,
-0.007653, 0.257653, 0.770408, 0.869898, -0.875000, -0.885204, -0.140306, -0.132653,
0.000000, 0.000000, 1.000000, -1.000000, 1.000000, -1.000000, 0.000000, 0.000000,
0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 1.000000, 0.000000, 0.000000,
-0.139781, 0.280744, 0.809752, 1.018908, 0.879417, 0.726713, 0.279871, -0.140081,
1.191176, 0.647059, -0.500000, -0.588235, -0.602941, -0.367647, 0.529412, -0.441176,
0.500000, 1.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 1.500000, 0.500000, -0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, 1.500000, -0.500000, 0.500000, -0.500000,
1.267857, 0.491071, -0.401786, -0.508929, -0.241071, 0.294643, -0.366071, -0.455357,
0.500000, 1.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -1.500000,
-0.267857, 0.482143, -0.410714, -0.446429, -0.714286, 0.508929, 1.330357, -0.285714,
1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000,
1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 1.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
-1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000,
0.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -1.500000, -0.500000,
0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -1.500000, 0.500000, -0.500000,
-0.500000, 1.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -1.500000,
-1.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
0.575000, 0.425000, -0.300000, -0.250000, 1.375000, 0.475000, 0.375000, -0.575000,
0.500000, 0.500000, -0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000,
0.382353, 0.470588, 1.279412, -0.367647, -0.279412, 0.485294, 0.441176, -0.588235,
1.306812, 0.517412, -0.487502, -0.309692, 0.566033, -0.503238, -0.619630, -0.088643,
0.656250, 1.035714, 0.500000, 0.415179, -0.343750, 0.441964, 0.553571, 0.325893,
-0.500000, 0.220588, -0.441176, -0.514706, -1.411765, -0.514706, -0.529412, -0.500000,
0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -1.500000,
-0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 1.500000, -0.500000,
-0.647059, 0.500000, -0.411765, -0.367647, 0.455882, 1.147059, -0.514706, -0.367647,
-0.500000, 0.500000, -0.500000, 1.500000, 0.500000, -0.500000, -0.500000, -0.500000,
-0.500000, 0.500000, 1.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000,
0.895798, 0.770273, 0.146639, -0.004412, 0.653151, -0.133403, -0.902311, -0.181303,
0.989102, 0.729517, 0.175551, 0.105699, -0.756040, 0.228072, 0.902442, 0.358193,
-1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000,
-1.102941, 1.000000, 0.176471, 0.014706, 0.735294, -0.058824, 0.779412, 0.117647,
0.645859, 0.469731, -0.384583, -0.519935, 0.571486, -0.462785, -1.201008, -0.322660,
0.500000, 0.500000, -0.500000, -0.500000, -1.500000, -0.500000, 0.500000, -0.500000,
-0.500000, 1.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
-1.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
1.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000,
0.821429, 0.741071, 0.098214, -0.125000, -0.803571, 0.741071, 0.553571, -0.035714,
-0.058824, 0.250000, 0.970588, 0.764706, -0.073529, 0.220588, 0.985294, -1.000000,
-0.102941, -0.161765, -0.838235, -0.838235, 0.088235, -0.088235, 1.102941, -0.794118,
0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -1.500000, -0.500000, -0.500000,
0.500000, 0.500000, -0.500000, -0.500000, -1.500000, 0.500000, -0.500000, -0.500000,
-0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -1.500000,
0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 1.500000, -0.500000,
0.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000,
0.000000, 1.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000,
0.000000, 1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
0.000000, 1.000000, 0.000000, 0.000000, 1.000000, 1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
1.511905, 0.601190, -0.270833, 0.389881, -0.303571, -0.470238, -0.437500, -0.464286,
0.485222, 1.127463, 0.728448, -0.557266, 0.431650, 0.333744, 0.499384, 0.644704,
-0.500000, 0.500000, -0.500000, -1.500000, -0.500000, -0.500000, -0.500000, -0.500000,
0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -1.500000,
-0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 1.500000, -0.500000,
-0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 1.500000, -0.500000, -0.500000,
-0.500000, 0.500000, -0.500000, 0.500000, 1.500000, -0.500000, -0.500000, -0.500000,
-0.350472, 0.457923, 1.080255, 0.580152, -0.340107, -0.423337, -0.358580, -0.285406,
1.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.687989, 0.745436, 0.009345, -0.954832, -0.043792, 0.332766, 0.812011, 0.273471,
-1.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
-1.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000,
0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -1.500000, -0.500000,
0.446429, 0.196429, -0.437500, -1.348214, -0.482143, -0.348214, 0.321429, -0.508929,
-0.500000, 1.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-1.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000,
1.000000, 1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
1.000000, 0.830357, -0.062500, -0.883929, 0.169643, 0.705357, 0.125000, 0.044643,
-1.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000,
0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -1.500000, -0.500000, -0.500000,
0.500000, 0.500000, -0.500000, -1.500000, -0.500000, 0.500000, -0.500000, -0.500000,
-0.500000, 1.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -1.500000,
0.000000, 1.000000, 0.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.000000, 1.117647, -0.014706, -0.897059, 0.191176, 1.176471, -1.235294, 0.044118,
0.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
0.870509, 0.775129, -0.112567, -0.688279, 0.826889, -0.022204, -0.226121, -0.011156,
-0.839286, 0.741071, -0.151786, -1.035714, -0.857143, 0.196429, 0.000000, 0.053571,
-0.002976, 0.382440, 0.950893, 0.312500, 0.075893, 0.763393, 0.747024, -0.866071,
-1.000000, 1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000,
-0.044118, -0.117647, -0.750000, -0.220588, -0.029412, -0.911765, 1.088235, -1.044118,
0.000000, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000,
0.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000, -1.000000, -1.000000,
0.500000, 0.500000, -0.500000, 0.500000, -1.500000, -0.500000, -0.500000, -0.500000,
0.470238, 0.529762, -0.452381, -1.208333, 0.523810, -0.214286, -0.541667, -0.529762,
-0.187500, 1.244048, 0.714286, -0.357143, -0.541667, 0.425595, 0.744048, 0.488095,
-0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -1.500000,
-1.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000,
0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000,
0.400000, 0.575000, -0.475000, 0.225000, 0.650000, 1.325000, -0.550000, -0.675000,
0.518207, 0.754202, 1.220938, 0.297269, 0.474790, -0.431022, -0.559874, -0.520308,
0.000000, 1.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.153511, 0.691176, -0.111645, -0.796068, 0.761255, -0.080132, -0.866146, -0.226741,
0.018935, 0.695967, 0.074815, -0.764624, -0.647167, 0.148553, 0.836207, 0.105911,
0.000000, 1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 1.000000, 0.000000,
0.000000, 1.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000,
0.000000, 1.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000, 0.000000,
0.000000, 1.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000, 0.000000,
0.000000, 1.000000, 0.000000, 1.000000, 1.000000, 1.000000, 0.000000, 0.000000,
1.266968, 0.883080, 0.335488, -0.203984, -0.525170, -0.538906, -0.476325, -0.307167,
0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -1.500000,
0.500000, 1.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000,
-0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 1.500000, -0.500000,
0.813025, 0.836835, 0.877101, 0.043417, 0.214286, 0.136905, -0.782913, -0.053922,
0.029412, 0.102941, 0.176471, 0.838235, 0.823529, 0.926471, 0.147059, -0.808824,
1.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000,
-1.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000,
-1.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000,
0.000000, 0.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000, -1.000000,
0.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000, -1.000000,
0.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, -1.000000,
0.452543, 0.518502, 0.343321, -0.385251, -0.530694, -0.549616, -1.071016, -0.520023,
-0.473214, -0.674107, -0.437500, 0.272321, 0.566964, 0.468750, -0.491071, -1.133929,
0.500000, 0.500000, -1.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000,
-0.500000, 1.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-1.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000,
0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 1.500000, 0.500000, -0.500000,
0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000, 0.500000, -0.500000,
0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000, 0.500000, -0.500000,
1.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 1.000000, -1.000000,
1.000000, 1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000,
-1.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000,
-0.654762, 0.869048, 0.815476, -0.157738, 0.127976, 0.764881, 0.244048, -0.130952,
0.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000, 1.000000, -1.000000,
0.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000, -1.000000, -1.000000,
0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000, -1.000000,
0.502941, 0.445378, 0.117157, -0.319468, -0.689916, -1.228782, -0.713165, -0.485924,
-0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -1.500000,
0.500000, 0.500000, -1.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000,
-0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-1.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000,
0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 1.500000, -0.500000,
0.433036, 0.593750, 0.352679, -0.544643, 1.129464, 0.245536, -0.500000, -0.419643,
0.500000, 0.500000, 0.500000, 1.500000, -0.500000, 0.500000, -0.500000, -0.500000,
0.196429, 0.812500, 0.848214, 0.125000, -0.062500, -0.946429, -0.991071, -0.142857,
-1.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.117647, 0.941176, -1.044118, 0.117647, 0.000000, 0.926471, -0.867647, -0.029412,
0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-0.008900, 0.798423, 0.778225, 0.084417, -0.056717, 0.815212, 0.843090, 0.119931,
-0.704649, -0.310331, 0.075813, -0.862897, -0.693277, -0.276900, 0.066999, -0.894638,
1.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
0.956873, 1.018194, 0.675539, 0.287399, -0.721361, -0.216307, 0.101752, 0.166105,
-0.013655, 0.078256, 0.338761, 0.965599, 0.098477, 0.769695, 0.872637, -0.956670,
1.000000, 1.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000,
-1.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000,
0.395501, 0.670349, 0.321791, -0.402528, -1.357722, -0.874058, -0.620436, -0.447950,
-0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -1.500000,
0.526786, 0.464286, -1.044643, -0.535714, 0.473214, -0.500000, -0.464286, -0.500000,
-0.500000, 1.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000,
0.000000, 1.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000,
0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000,
0.000000, 1.000000, 1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000,
-0.875000, 0.225000, -0.125000, -0.925000, 0.000000, -0.850000, -0.100000, -1.125000,
1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000,
0.066502, 0.952305, 0.768935, 0.112033, -0.974482, -0.798917, -0.097245, 0.047477,
-1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000,
0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000,
-0.113536, 0.872748, 0.683980, 0.043079, 0.840813, 0.747277, 0.103177, -0.071791,
-1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000, -1.000000,
1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000, -1.000000,
1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000, -1.000000,
0.147959, 0.107143, 0.034439, -0.302296, 1.149235, 1.381378, 0.895408, -0.647959,
1.000000, 1.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 0.000000,
-1.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 0.000000,
-1.000000, 1.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 0.000000,
-0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -1.500000,
0.500000, 0.500000, -1.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000,
-0.500000, 1.500000, -0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000,
-1.133666, 0.378676, 0.437763, 0.389181, -0.256565, -0.288866, -0.559611, -0.463235,
-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, -1.000000,
0.000000, 1.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, 1.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000,
0.000000, 1.000000, 1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000,
-0.836485, 0.005952, 0.045868, -0.031513, -0.875350, -0.785714, -0.353291, -0.771709,
1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000, -1.000000,
1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000,
0.000000, 1.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.000000, 1.000000, -1.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.015110, 0.589286, -0.553571, -1.000000, 0.168956, 0.868132, -0.199176, -0.425824,
0.000000, 0.828571, 0.971429, 0.682143, 0.185714, 0.710714, 0.182143, -0.153571,
-1.007353, -0.080882, 0.007353, -0.051471, -0.948529, -0.272059, -0.772059, -1.029412,
1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000, 1.000000, -1.000000,
1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000,
0.000000, 1.000000, -1.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
0.000000, 1.000000, -1.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000,
0.158246, 0.720903, 0.920378, 0.788393, 0.769459, 0.405515, 0.080357, -0.022295,
0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -1.500000,
-0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -1.500000, -0.500000,
-0.455882, 0.455882, 0.470588, 0.397059, 0.382353, -1.470588, 0.529412, -0.294118,
-0.413793, 0.603448, 0.448276, 0.215517, -1.327586, 0.594828, 0.482759, -0.293103,
1.590756, 0.218908, -0.194538, -0.031933, -0.136555, -0.185294, -0.117647, -0.035504,
0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -2.000000, 0.000000,
0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -2.000000, 0.000000, 0.000000,
0.163235, 0.083088, 0.033088, -1.893382, 0.042647, 0.008824, 0.074265, -0.249265,
1.250000, -0.500000, -0.529412, -0.367647, -0.294118, -0.426471, -0.470588, -0.352941,
0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -1.500000, 0.500000,
0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -1.500000, 0.500000, 0.500000,
0.364151, 0.695903, 0.293037, -1.253076, 0.058403, 0.353016, 0.726756, 0.401276,
1.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
0.183036, -0.245536, -0.486607, -0.549107, -0.330357, -0.611607, -1.174107, -0.450893,
-0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -1.500000, -0.500000, 0.500000,
-0.470588, 0.485294, 0.691176, 0.323529, -1.264706, 0.705882, -0.470588, 0.470588,
-0.500000, 0.500000, 0.500000, -1.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -1.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-0.500000, -1.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
0.176646, -0.411940, -0.581758, -0.504202, -0.572304, -0.384454, 0.384279, 1.310924,
1.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
0.416667, -0.375000, -0.404762, -0.464286, -0.750000, -1.166667, -0.523810, -0.404762,
-0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -1.500000, 0.500000,
-0.525921, 0.496533, 0.594455, 0.136551, -1.402604, -0.676846, 0.315574, 0.360396,
-0.500000, 0.500000, 0.500000, -1.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-0.500000, 0.500000, -1.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-0.529412, -1.264706, 0.529412, 0.338235, 0.544118, -0.588235, 0.441176, 0.294118,
0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 1.500000,
1.179602, 0.876071, 0.477961, 0.249152, -0.391605, 0.306339, 0.577933, 0.434874,
-0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -1.500000, 0.500000,
-0.529412, 0.602941, 0.588235, 0.485294, -0.382353, -1.176471, 0.352941, 0.397059,
-0.441176, 0.338235, 0.573529, -1.125000, -0.419118, 0.455882, 0.595588, 0.242647,
0.803571, 0.005952, -0.166667, 0.029762, 0.851190, -0.833333, -0.839286, 0.011905,
1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000,
1.000000, 0.000000, 0.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000,
-0.726824, -0.186837, 0.028422, 0.082082, -0.904649, -0.963031, -0.727128, -0.213003,
1.125000, 0.448661, 0.151786, -0.149554, 0.636161, 0.395089, 0.495536, 0.495536,
-0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -1.500000, 0.500000,
-0.517857, 0.479592, 0.556122, -0.204082, -1.270408, 0.364796, 0.900510, 0.405612,
-0.500000, 0.500000, -1.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000,
0.433580, -0.162808, -0.019458, 0.826314, 0.115148, -0.684113, -0.917406, 0.155911,
1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000,
1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000, -1.000000, 0.000000,
1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000,
1.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000, -1.000000, 0.000000,
1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000,
0.000000, -1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000,
1.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000,
1.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000, 0.000000,
1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000, 0.000000,
-0.827381, -0.029762, 0.136905, -0.821429, -1.023810, -0.845238, 0.053571, -0.095238,
0.108067, 0.782430, 0.841441, 0.036433, -0.155891, 0.000821, 0.640189, 0.829331,
0.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.101487, 0.893302, 0.748424, 0.297511, -0.017736, -0.117243, -0.884292, -0.998990,
-0.077146, 0.016417, 0.251606, 0.639856, -0.841882, -0.988595, -0.938610, -0.221068,
0.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 0.000000, -1.000000, -1.000000, 1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 0.000000, -1.000000, -1.000000, -1.000000, 1.000000, 0.000000,
0.400924, 0.442165, 0.641739, 1.121140, -0.308554, -0.518354, -0.536408, 0.362943,
0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000, -0.500000, 0.500000,
0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 1.500000, -0.500000, 0.500000,
0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 1.500000, 0.500000,
1.267857, 0.339286, -0.473214, 0.285714, 0.633929, 0.517857, 0.500000, 0.517857,
0.382353, -0.323529, -1.264706, -0.382353, -0.514706, -0.558824, -0.397059, -0.367647,
-0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -1.500000, 0.500000,
-0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -1.500000, 0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, 0.500000, -1.500000, 0.500000, 0.500000, 0.500000,
-0.392857, 0.357143, -0.366071, -1.446429, 0.241071, 0.473214, 0.651786, 0.651786,
-0.395798, -1.089496, -0.585924, 0.384664, 0.452311, 0.343697, 0.353782, 0.408824,
0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 1.500000,
1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.000000, -1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.720588, 0.000000, -0.838235, 0.029412, 0.147059, 1.088235, -0.897059, -0.088235,
1.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.000000, 1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 1.000000,
0.000000, 1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.058824, -0.970588, -0.117647, 0.823529, 0.161765, 0.852941, -0.058824, -1.102941,
0.813143, -0.065893, -0.783154, 0.006908, 0.909238, -0.073529, -0.846464, 0.001548,
-1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000,
1.000000, 0.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000,
-0.205882, -0.705882, -0.058824, 1.029412, -0.073529, -0.147059, 0.911765, -0.941176,
1.187500, -0.156250, -0.852679, -0.236607, 0.857143, -0.714286, -0.321429, -0.125000,
-0.800000, 0.100000, -1.200000, -0.100000, -1.000000, -0.875000, -0.075000, -0.125000,
0.000000, 0.000000, 1.000000, 0.000000, -1.000000, -1.000000, -1.000000, 0.000000,
-0.869871, -1.002472, 0.115793, 1.265818, -0.341634, 0.044118, -0.230969, -0.681105,
0.241071, -0.026786, -0.767857, -0.169643, 0.839286, -0.919643, -0.946429, 0.035714,
0.000000, 0.000000, -1.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000,
0.000000, 0.000000, -1.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000,
-1.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
1.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
0.306445, 0.627668, 1.130542, 0.616790, -0.416667, -0.551519, -0.331281, 0.383621,
-0.559217, -0.708311, 0.614168, 1.140165, 0.163143, 0.635439, 0.352547, -0.148241,
0.647059, 0.411765, -0.308824, 0.352941, 1.485294, -0.529412, -0.411765, 0.500000,
0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 1.500000, -0.500000, 0.500000,
0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 1.500000, 0.500000,
-1.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000,
-0.485294, 1.500000, 0.426471, -0.882353, 0.382353, 0.558824, 0.441176, -0.573529,
0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -1.500000,
-0.283403, -0.811134, -0.294538, 0.023950, 0.846849, 0.759034, -0.164496, -0.825000,
1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
-1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000,
1.000000, 0.000000, -1.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.943144, -0.039614, -1.196839, -1.139984, 0.215517, 0.748974, 0.129310, -0.191297,
-1.000000, 0.000000, -1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
-0.833333, -0.886905, -0.095238, -0.053571, 0.738095, 0.065476, -0.119048, -0.738095,
0.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.040179, -0.285714, -0.801339, 0.879464, 0.002232, -0.625000, -0.962054, 0.428571,
0.000000, 0.000000, -1.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000,
0.000000, 0.000000, -1.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000,
-1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
-0.580357, -0.276786, 0.419643, 0.508929, 1.455357, 0.607143, 0.321429, -0.303571,
0.500000, 0.500000, 1.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
0.500000, 0.500000, -0.500000, 1.500000, 0.500000, -0.500000, -0.500000, 0.500000,
0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 1.500000, -0.500000, 0.500000,
0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 1.500000, 0.500000,
-1.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, 1.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -1.500000,
0.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000,
1.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
0.946429, 0.008929, -0.866071, 0.741071, -1.080357, -0.098214, 0.142857, -0.142857,
1.000000, 0.011905, -1.333333, -0.815476, 1.095238, 0.273810, 0.011905, 0.196429,
-0.862185, 0.003571, -0.581408, -1.046744, -0.773845, 0.293277, 0.061029, -0.064391,
0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 1.000000,
0.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000,
0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000,
-1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.416667, 0.196429, -0.994048, -0.982143, 0.779762, -0.101190, -0.839286, -0.071429,
-0.733580, -0.337438, 0.500616, 0.566708, 0.424672, 1.096264, 0.564860, -0.254310,
0.558824, 0.426471, 1.235294, -0.602941, -0.352941, 0.352941, -0.323529, 0.426471,
0.500000, 0.500000, -0.500000, 1.500000, -0.500000, 0.500000, -0.500000, 0.500000,
0.579082, 0.547194, -0.358418, 0.003827, 1.631378, 0.714286, -0.704082, 0.113520,
-1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.000000, 0.000000, -1.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000,
0.000000, 0.000000, -1.000000, -1.000000, 1.000000, -1.000000, 0.000000, 0.000000,
0.000000, 0.000000, -1.000000, -1.000000, -1.000000, 1.000000, 0.000000, 0.000000,
-0.544643, -0.303571, 0.473214, 0.455357, 0.491071, 0.723214, 1.267857, -0.375000,
0.500000, 0.500000, -0.500000, 1.500000, -0.500000, -0.500000, 0.500000, 0.500000,
0.500000, 0.500000, -0.500000, -0.500000, 1.500000, -0.500000, 0.500000, 0.500000,
0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 1.500000, 0.500000, 0.500000,
-1.460108, -0.419540, 0.260987, 0.405680, 0.492224, 0.498986, 0.389452, -0.201149,
-0.500000, 0.500000, 1.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, 1.500000, -0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, 1.500000, -0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 1.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 1.500000, 0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -1.500000,
0.568978, 1.272059, 0.712535, 0.474440, 0.441877, 0.464986, 0.304972, -0.255952,
1.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000,
0.500000, -1.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000,
-0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -1.500000, 0.500000,
-0.426471, -0.455882, 0.323529, 0.367647, 0.485294, -1.323529, 0.367647, 0.294118,
-0.500000, -0.500000, 0.500000, 0.500000, -1.500000, 0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -1.500000, 0.500000, 0.500000, 0.500000, 0.500000,
-0.419643, -0.419643, -1.357143, 0.160714, 0.357143, 0.446429, 0.419643, 0.437500,
0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 1.500000,
0.845238, 0.952381, 0.190476, -0.059524, -0.071429, -0.833333, -0.851190, 0.089286,
0.000000, 0.000000, -1.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 0.000000, 1.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.017857, 0.214286, 0.955357, 0.964286, -0.758929, -0.098214, -0.196429, -0.883929,
1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000,
1.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-0.883110, -0.620734, -0.078451, 0.001866, 0.091267, -0.672411, -0.713031, -0.178991,
-0.133929, -0.026786, 0.875000, 0.821429, 0.830357, -0.169643, -0.008929, 0.866071,
1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.000000, 0.000000, -1.000000, 1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
-0.147059, 0.137255, 1.039216, -0.872549, -0.107843, 0.921569, 0.098039, -0.745098,
-0.926471, -0.794118, -0.102941, -0.029412, -0.985294, 0.000000, -0.823529, -0.250000,
0.980312, 0.805781, 0.281085, 0.003702, -0.983655, -0.843856, -0.293522, -0.019537,
0.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000,
-0.022940, 0.231460, 0.801969, -0.862037, -0.017642, 0.301273, 0.856768, -0.873026,
-1.045135, -0.794154, -0.164634, -0.046586, -0.984460, -0.855487, -0.198633, -0.069767,
-0.044118, 0.911765, 0.088235, -0.073529, -0.985294, -1.161765, -0.823529, -0.250000,
-1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
-1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
0.934524, 0.645833, 0.895833, 1.196429, -0.007440, -0.016369, -0.248512, -0.782738,
0.035560, -0.844982, -0.358220, 0.008775, 0.872691, -0.786484, -0.707512, 0.021552,
0.000000, -1.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000,
0.000000, -1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000,
-0.676339, 0.104911, 0.837054, 0.805804, 0.167411, -0.232143, 0.136161, 0.861607,
0.403466, 1.409454, 0.787605, 0.579359, -0.625420, -0.581670, -0.479937, 0.420326,
-0.500000, 0.500000, -0.500000, 1.500000, 0.500000, 0.500000, 0.500000, -0.500000,
-0.538534, 0.499060, 1.203947, -0.227444, 0.588346, 0.730263, 0.450188, -0.651316,
0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -1.500000,
0.500000, -0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000, 0.500000,
0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000, 0.500000,
0.235294, -0.661765, 0.455882, 0.470588, -0.485294, -0.455882, 1.397059, 0.279412,
-1.081349, -0.427579, 0.743056, 0.605159, -0.389881, -0.521825, -0.288690, 0.146825,
0.032870, -0.238066, -0.721646, -0.289526, 0.729768, 1.076736, 0.078994, -0.670889,
0.000000, 0.000000, 1.000000, 0.000000, -1.000000, 1.000000, 0.000000, -1.000000,
0.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000,
-1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000,
1.014031, 0.817602, 0.084184, -0.891582, -0.049745, -0.285714, -0.132653, 0.183673,
-0.184524, -0.023810, 0.869048, 0.130952, -0.952381, 0.083333, 0.851190, -0.559524,
-0.894503, -0.952906, -0.220343, -0.807108, 0.038305, -0.581653, 0.041702, -0.120203,
-1.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000, -1.000000, 0.000000,
-1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
-0.090278, -0.794643, -0.339286, 0.810516, -0.084325, -0.866071, -0.806548, 0.313492,
0.000000, -1.000000, 0.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000,
0.000000, -1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000,
-0.500000, 0.500000, -0.500000, 0.500000, 1.500000, 0.500000, 0.500000, -0.500000,
0.491071, 1.348214, 0.508929, -0.357143, 0.455357, -0.232143, -0.419643, 0.357143,
-0.623214, 0.876786, 1.075000, 0.675000, -0.589286, 0.632143, 0.425000, -0.228571,
0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -1.500000,
0.625000, -0.392857, 0.535714, 1.419643, 0.633929, -0.464286, -0.241071, 0.321429,
0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 1.500000, -0.500000, 0.500000,
0.500000, -0.500000, 0.397059, -0.558824, 0.691176, -0.352941, 1.617647, 0.279412,
-1.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
0.000000, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000,
1.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
0.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000,
0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000,
1.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
1.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000,
-1.000000, -1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, 1.000000, 1.000000,
-1.000000, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000,
-1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000,
1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000, -1.000000, 0.000000,
-0.632353, 0.455882, -0.367647, 0.250000, 0.367647, 1.470588, 0.308824, -0.514706,
-0.500000, 0.500000, 1.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -1.500000,
0.500000, -0.500000, 0.500000, -0.500000, 1.500000, 0.500000, -0.500000, 0.500000,
-1.000000, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.000000, 1.000000, 0.000000, -1.000000, -1.000000, -1.000000, 0.000000, 0.000000,
1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.000000, -1.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000,
-0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000,
0.227679, 1.174107, 0.549107, -0.625000, -0.517857, -0.334821, 0.575893, 0.544643,
0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -1.500000,
0.065051, -0.373724, 0.686224, 1.204082, -0.168367, -0.614796, 0.448980, 0.723214,
-1.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000,
-0.500000, 1.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -1.500000,
0.331281, 0.604988, 1.059267, 0.436268, 0.461207, 0.486299, 0.253079, -0.366071,
-0.521429, -0.407143, 0.237500, 1.237500, -0.275000, -0.408929, -0.375000, 0.826786,
-0.500000, -0.500000, 0.500000, -0.500000, 1.500000, -0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 1.500000, -0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 1.500000, 0.500000,
-0.129464, 0.227679, -0.071429, -0.816964, 0.812500, 1.071429, 0.017857, -0.883929,
0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 1.000000, 0.000000, -1.000000,
0.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000, 0.000000, -1.000000,
1.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000,
1.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.852941, -0.867647, -1.044118, -0.073529, 0.014706, -0.029412, 0.911765, -0.132353,
-0.715476, -0.977381, -0.973810, -0.044048, 0.089286, -0.192857, -0.617857, -0.053571,
0.086207, 0.060345, -0.068966, 0.887931, 0.827586, 0.784483, 0.155172, 1.008621,
0.017857, 0.044643, 0.169643, -0.910714, 0.723214, 0.223214, 1.035714, -0.910714,
0.151786, -0.098214, -0.080357, 0.928571, -1.205357, 0.017857, 0.794643, -0.821429,
0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, -1.000000, -1.000000,
0.897059, 0.926471, -1.058824, 0.073529, 0.000000, -0.926471, -0.058824, 0.058824,
1.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000,
1.000000, -1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000,
-1.075000, -0.975000, -0.825000, -0.200000, -0.050000, -0.750000, 0.200000, 0.050000,
0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 1.000000, 1.000000,
-1.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000,
-0.500000, 0.500000, 0.500000, -0.500000, 1.500000, 0.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000,
0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
0.500000, -0.500000, 1.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
-0.087372, 0.200893, 0.005102, -0.788265, -0.089286, 1.098852, 0.775510, -0.966837,
0.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000, 1.000000, -1.000000,
-0.026786, 0.125000, 0.044643, 0.955357, 0.080357, 0.732143, -0.892857, -0.803571,
-0.681613, -1.017840, -0.716259, -0.216546, -0.664610, -0.184672, 0.020243, 0.002655,
-1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000,
1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.000000, -1.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.207025, -0.774220, -0.860978, 0.082267, 0.831510, -0.199028, -0.850949, -0.153422,
0.071429, -0.901786, -0.839286, 0.008929, -0.910714, -0.071429, 1.142857, 0.267857,
-1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, 1.000000,
-0.167208, 0.563312, 0.357143, -0.542208, 0.613636, 1.251623, 0.485390, -0.719156,
-0.500000, 0.500000, 0.500000, 1.500000, 0.500000, -0.500000, 0.500000, -0.500000,
0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -1.500000,
0.500000, 1.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
0.500000, -0.500000, 1.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
0.391694, -0.483374, -0.375547, 0.361864, 1.228996, 0.308703, -0.245621, 0.232211,
0.264706, -0.485294, -0.617647, 0.367647, -0.573529, 0.382353, 1.250000, 0.514706,
-1.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
-1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000, -1.000000,
-0.825893, -0.359375, 0.180804, 0.763393, 0.082589, -0.321429, -0.859375, -0.839286,
1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000,
0.000000, -1.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000,
0.000000, -1.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000,
0.000000, -1.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000,
-1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, 1.000000,
-0.367647, 0.191176, 0.573529, -0.617647, 0.455882, 0.367647, 1.352941, -0.544118,
-0.392857, 0.482143, 0.758929, 1.321429, 0.687500, 0.464286, -0.375000, -0.517857,
0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -1.500000,
0.500000, 1.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000,
0.500000, -0.500000, 1.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000,
0.500000, -0.500000, -0.500000, 0.500000, 1.500000, -0.500000, 0.500000, 0.500000,
0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 1.500000, 0.500000, 0.500000,
-1.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000,
-1.190783, 0.502101, 0.735885, -0.710675, 0.421744, 0.931394, 0.533023, -0.730370,
-0.631006, -0.577435, -0.237175, 0.354383, -0.349351, -0.541721, -0.793669, -1.046591,
-0.500000, 1.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000,
-0.603729, -0.502626, 1.254464, 0.605305, -0.534139, -0.519433, -0.356092, 0.561187,
0.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, 1.000000, -1.000000,
0.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 1.000000, -1.000000,
0.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000, -1.000000,
-0.780036, -0.811736, -0.810584, -0.759319, 0.004773, 0.028719, 0.027908, 0.021883,
-1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000,
0.755952, 0.155378, -0.063218, -0.122947, 0.841544, 0.890599, 0.089696, -0.816297,
0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, -1.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, -1.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, -1.000000, -1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 1.000000,
-0.526786, 0.553571, 0.580357, 0.285714, -0.383929, 1.232143, 0.544643, -0.285714,
-0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000, 0.500000, -0.500000,
0.232143, -0.415179, -0.727679, -0.419643, 0.531250, 0.700893, -0.397321, -1.205357,
0.500000, 1.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
0.500000, -0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
0.500000, -0.500000, -0.500000, 1.500000, 0.500000, 0.500000, -0.500000, 0.500000,
0.517857, -0.312500, -0.562500, -0.616071, 0.500000, 0.660714, 1.214286, 0.401786,
-1.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-0.821429, 0.017857, 0.026786, -0.044643, -1.044643, -0.008929, 0.892857, -0.678571,
-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000, -1.000000,
1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000,
0.000000, 1.000000, -1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.000000, -1.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.029412, -0.823529, -0.897059, 0.735294, -0.102941, -0.838235, -0.102941, 0.029412,
0.029762, -0.809524, -0.994048, -0.922619, 0.202381, 0.678571, 0.297619, 0.005952,
-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, 1.000000,
-0.320903, 0.379727, 0.652574, 0.315651, -0.404149, 0.464548, 1.107405, -0.352416,
-0.201331, 0.399510, 0.570028, 0.713585, 1.372899, 0.463235, -0.393207, -0.651961,
0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -1.500000,
0.500000, 1.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
0.500000, -0.500000, 1.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
0.500000, -0.500000, -0.500000, 1.500000, 0.500000, -0.500000, 0.500000, 0.500000,
0.244048, -0.321429, -0.511905, -0.470238, 0.636905, 1.130952, 0.708333, 0.470238,
-1.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-1.333333, 0.327381, 0.666667, 0.327381, -0.505952, 0.470238, 0.482143, -0.184524,
-0.651601, -0.643672, -0.519314, -0.346957, 0.195083, -0.285127, -0.756797, -1.165290,
-0.500000, 1.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 1.500000, -0.500000, 0.500000,
-1.000000, 0.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000,
1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000,
-0.115868, -0.814227, -0.832804, -0.819135, 0.778191, 0.165663, 0.013361, 0.070109,
-0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000,
-0.426471, 0.323529, 0.573529, 0.661765, 0.367647, 1.205882, -0.470588, -0.485294,
0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -1.500000,
0.455876, -0.247943, -0.328115, -0.249047, 1.109276, 0.751498, 0.618741, 0.535559,
-1.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
-0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -1.500000,
0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 1.500000, 0.500000, -0.500000,
-0.500000, 1.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, 1.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
-0.441176, -0.411765, -0.500000, 1.573529, -0.323529, 0.220588, -0.411765, 0.588235,
-0.455882, -0.558824, -0.426471, -0.500000, 1.294118, 0.426471, -0.250000, 0.264706,
-0.437500, -0.470982, -0.430804, -0.357143, -0.359375, 0.491071, 1.145089, 0.725446,
-1.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000,
-0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -1.500000,
0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000,
-0.500000, 1.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, 1.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000,
-0.306723, -0.636204, -0.507353, 1.214986, -0.378501, -0.611695, 0.385854, 0.591387,
-0.500000, -0.500000, -0.500000, -0.500000, 1.500000, -0.500000, 0.500000, 0.500000,
-0.500000, -0.455882, -0.514706, -0.514706, -0.397059, 1.352941, 0.632353, 0.647059,
};
static float Shell2SPCCodebook[800*8] = {
1.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000, 0.500000,
0.476068, 0.546154, 0.568376, 0.520513, 0.456410, -0.395726, -0.657265, -1.159829,
-0.500000, -0.500000, 1.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
1.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
0.500000, 0.500000, 0.500000, 0.500000, 1.500000, 0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -1.500000, -0.500000,
0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -1.500000,
-0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 1.500000, 0.500000, -0.500000,
-0.500000, -0.500000, -0.500000, 1.500000, 0.500000, -0.500000, 0.500000, -0.500000,
-0.500000, -0.500000, 1.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
-0.500000, 1.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
1.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000,
0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -1.500000, -0.500000, -0.500000,
0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -1.500000,
-0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 1.500000, -0.500000,
-0.500000, -0.500000, -0.500000, 1.500000, 0.500000, 0.500000, -0.500000, -0.500000,
-0.500000, -0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000,
-0.500000, 1.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000,
1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000, 0.000000,
1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000,
0.000000, 1.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -1.500000, -0.500000,
0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -1.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -1.500000,
1.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000,
0.500000, 0.500000, 0.500000, 1.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -1.500000, -0.500000,
0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -1.500000,
-0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 1.500000, 0.500000, -0.500000,
-0.500000, -0.500000, -0.500000, 0.500000, 1.500000, -0.500000, 0.500000, -0.500000,
-0.500000, -0.500000, 1.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000,
-0.500000, 1.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000,
1.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000,
0.500000, 0.500000, 0.500000, 1.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -1.500000, -0.500000, -0.500000,
0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -1.500000,
-0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 1.500000, -0.500000,
-0.500000, -0.500000, -0.500000, 0.500000, 1.500000, 0.500000, -0.500000, -0.500000,
-0.500000, -0.500000, 1.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000,
-0.500000, 1.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000,
1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000, 0.000000,
1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, 1.000000, 0.000000,
0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -1.500000, -0.500000,
0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -1.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 1.500000, 0.500000, -0.500000, -0.500000, 0.500000,
-1.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
1.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000,
0.500000, 0.500000, 0.500000, 1.500000, -0.500000, 0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000,
-0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000,
1.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, -1.000000, 0.000000,
1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 1.000000, 0.000000,
0.000000, -1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000,
0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -1.500000, -0.500000,
0.500000, -0.500000, -0.500000, 0.500000, -1.500000, -0.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 1.500000, -0.500000, 0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -1.500000,
-1.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 1.500000, 0.500000, -0.500000,
0.500000, -0.500000, 1.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
1.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000, 0.000000, 0.000000,
1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 1.000000, 0.000000, 0.000000,
-1.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000,
0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 1.000000, 1.000000, 1.000000, 0.000000, 0.000000,
0.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.057692, -0.980769, 0.826923, -0.038462, 0.096154, 0.134615, -0.826923, -0.980769,
0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000, -1.000000,
0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -1.500000, -0.500000, -0.500000,
0.500000, -0.500000, -0.500000, 0.500000, -1.500000, 0.500000, -0.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000, 0.500000, 0.500000,
-0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -1.500000,
-1.500000, -0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000,
0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000,
0.500000, -0.500000, 1.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000,
0.500000, 1.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000,
0.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 1.000000, 0.000000,
0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 1.000000, 1.000000, 0.000000,
1.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000,
0.500000, 0.500000, 1.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -1.500000,
-0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 1.500000, 0.500000, -0.500000,
1.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000,
0.500000, 0.500000, 1.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 1.500000, -0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, 1.500000, 0.500000, -0.500000, -0.500000,
1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000,
1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.000000, 1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
-1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000,
0.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -1.500000, -0.500000,
0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -1.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 1.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -1.500000,
-1.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
0.500000, -0.500000, 0.500000, -0.500000, 1.500000, 0.500000, 0.500000, -0.500000,
0.500000, -0.500000, 0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000,
0.500000, 1.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
1.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000,
0.500000, 0.500000, 1.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, -1.500000, -0.500000, -0.500000, -0.500000,
0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -1.500000,
-0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 1.500000, -0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 1.500000, -0.500000, -0.500000,
-0.500000, -0.500000, 0.500000, 1.500000, 0.500000, -0.500000, -0.500000, -0.500000,
-0.500000, 1.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000,
1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000,
1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000,
0.000000, 1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.000000, -1.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -1.500000, -0.500000,
0.500000, -0.500000, 0.500000, -0.500000, -1.500000, -0.500000, 0.500000, -0.500000,
-0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -1.500000,
0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 1.500000, 0.500000, -0.500000,
1.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000,
1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000,
-1.000000, 0.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000,
-1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000,
0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -1.500000, -0.500000, -0.500000,
0.500000, -0.500000, 0.500000, -0.500000, -1.500000, 0.500000, -0.500000, -0.500000,
-0.383333, 0.616667, 1.550000, 0.483333, -0.416667, -0.350000, 0.416667, 0.216667,
-1.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000,
0.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 1.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000,
0.133333, -0.022222, 0.933333, 0.111111, -0.888889, -0.777778, 0.711111, -0.066667,
-1.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
-0.088889, 0.044444, 0.911111, 0.088889, 0.800000, 0.600000, 1.000000, 0.177778,
-1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
1.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
1.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
1.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000,
0.500000, 0.500000, 1.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -1.500000, -0.500000, -0.500000, -0.500000, -0.500000,
0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -1.500000,
-0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 1.500000, -0.500000,
-0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000, -0.500000,
-0.500000, -0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000, -0.500000,
-0.500000, 1.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000,
1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, 1.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, -1.000000,
0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -1.500000, -0.500000,
0.500000, -0.500000, 0.500000, -1.500000, -0.500000, -0.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -1.500000,
1.000000, 0.000000, 1.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000,
-1.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
-1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000,
0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -1.500000, -0.500000, -0.500000,
0.500000, -0.500000, 0.500000, -1.500000, -0.500000, 0.500000, -0.500000, -0.500000,
-0.500000, 0.500000, 1.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-1.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000,
0.000000, 0.000000, 1.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 1.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 1.000000, 1.000000, 0.000000,
-1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, 1.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
1.000000, 0.000000, 1.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000,
-1.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000,
-1.000000, 0.000000, 1.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000,
0.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000,
0.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000,
0.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, -1.000000, -1.000000,
0.500000, -0.500000, 0.500000, 0.500000, -1.500000, -0.500000, -0.500000, -0.500000,
0.500000, -0.500000, 0.500000, -1.500000, 0.500000, -0.500000, -0.500000, -0.500000,
-0.500000, 0.500000, 1.500000, -0.500000, -0.500000, 0.500000, 0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -1.500000,
-1.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000,
0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000,
0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000,
0.500000, 1.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000,
0.000000, 0.000000, 1.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.000000, 0.000000, 1.000000, -1.000000, 1.000000, 0.000000, -1.000000, 0.000000,
0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 1.000000, 0.000000,
0.000000, 0.000000, 1.000000, 1.000000, 1.000000, 0.000000, 1.000000, 0.000000,
0.000000, 0.000000, 1.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000,
0.000000, 0.000000, 1.000000, -1.000000, 1.000000, -1.000000, 0.000000, 0.000000,
0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 1.000000, 0.000000, 0.000000,
0.200000, 0.166667, 0.966667, 1.000000, 0.733333, 0.833333, 0.133333, 0.000000,
1.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000,
0.500000, 1.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 1.500000, 0.500000, -0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, 1.500000, -0.500000, 0.500000, -0.500000,
1.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000,
0.500000, 1.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -1.500000,
-0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 1.500000, -0.500000,
1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000,
1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 1.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
-1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000,
0.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -1.500000, -0.500000,
0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -1.500000, 0.500000, -0.500000,
-0.500000, 1.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -1.500000,
-1.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
0.500000, 0.500000, -0.500000, -0.500000, 1.500000, 0.500000, 0.500000, -0.500000,
0.500000, 0.500000, -0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000,
0.500000, 0.500000, 1.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
1.147727, 0.363636, -0.397727, -0.443182, 0.352273, -0.420455, -0.420455, -0.363636,
0.500000, 1.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, -1.500000, -0.500000, -0.500000, -0.500000,
0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -1.500000,
-0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 1.500000, -0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 1.500000, -0.500000, -0.500000,
-0.500000, 0.500000, -0.500000, 1.500000, 0.500000, -0.500000, -0.500000, -0.500000,
-0.500000, 0.500000, 1.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000,
1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000,
1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000,
-1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000,
-1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000,
0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -1.500000, -0.500000,
0.500000, 0.500000, -0.500000, -0.500000, -1.500000, -0.500000, 0.500000, -0.500000,
-0.500000, 1.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
-1.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
1.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000,
1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000,
0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -1.500000, -0.500000, -0.500000,
0.500000, 0.500000, -0.500000, -0.500000, -1.500000, 0.500000, -0.500000, -0.500000,
-0.483333, -0.483333, 0.683333, 0.283333, -0.416667, -0.450000, 0.616667, -1.216667,
0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 1.500000, -0.500000,
0.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000,
0.000000, 1.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000,
0.000000, 1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
0.000000, 1.000000, 0.000000, 0.000000, 1.000000, 1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
1.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000,
0.316667, 1.250000, 0.416667, -0.616667, 0.583333, 0.416667, 0.616667, 0.683333,
-0.500000, 0.500000, -0.500000, -1.500000, -0.500000, -0.500000, -0.500000, -0.500000,
0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -1.500000,
-0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 1.500000, -0.500000,
-0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 1.500000, -0.500000, -0.500000,
-0.500000, 0.500000, -0.500000, 0.500000, 1.500000, -0.500000, -0.500000, -0.500000,
-0.500000, 0.250000, 1.384615, 0.557692, -0.519231, -0.461538, -0.403846, -0.673077,
1.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
1.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000,
-1.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
-1.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000,
0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -1.500000, -0.500000,
0.500000, 0.500000, -0.500000, -1.500000, -0.500000, -0.500000, 0.500000, -0.500000,
-0.500000, 1.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-1.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000,
1.000000, 1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
1.000000, 1.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000,
-1.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000,
0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -1.500000, -0.500000, -0.500000,
0.500000, 0.500000, -0.500000, -1.500000, -0.500000, 0.500000, -0.500000, -0.500000,
-0.500000, 1.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -1.500000,
0.000000, 1.000000, 0.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.000000, 1.000000, 0.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000,
0.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
0.933333, 0.800000, 0.166667, -0.966667, 0.866667, 0.266667, 0.066667, 0.033333,
-1.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000,
-1.000000, 1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000,
0.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000,
0.000000, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000,
0.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000, -1.000000, -1.000000,
0.500000, 0.500000, -0.500000, 0.500000, -1.500000, -0.500000, -0.500000, -0.500000,
0.500000, 0.500000, -0.500000, -1.500000, 0.500000, -0.500000, -0.500000, -0.500000,
-0.500000, 1.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -1.500000,
-1.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000,
0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000,
0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000,
0.500000, 0.500000, 1.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000,
0.000000, 1.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.000000, 1.000000, 0.000000, -1.000000, 1.000000, 0.000000, -1.000000, 0.000000,
0.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 1.000000, 0.000000,
0.000000, 1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 1.000000, 0.000000,
0.000000, 1.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000,
0.000000, 1.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000, 0.000000,
0.000000, 1.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000, 0.000000,
0.000000, 1.000000, 0.000000, 1.000000, 1.000000, 1.000000, 0.000000, 0.000000,
1.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000,
0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -1.500000,
0.500000, 1.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000,
-0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 1.500000, -0.500000,
1.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 1.000000, 0.000000, -1.000000,
1.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000,
-1.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000,
-1.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000,
0.000000, 0.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000, -1.000000,
0.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000, -1.000000,
0.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, -1.000000,
0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -1.500000, -0.500000,
-0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -1.500000,
0.500000, 0.500000, -1.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000,
-0.500000, 1.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-1.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000,
0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 1.500000, 0.500000, -0.500000,
0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000, 0.500000, -0.500000,
0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000, 0.500000, -0.500000,
1.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 1.000000, -1.000000,
1.000000, 1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000,
-1.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000,
-1.000000, 1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000,
0.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000, 1.000000, -1.000000,
0.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000, -1.000000, -1.000000,
0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000, -1.000000,
0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -1.500000, -0.500000, -0.500000,
-0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -1.500000,
0.500000, 0.500000, -1.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000,
-0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-1.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000,
0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 1.500000, -0.500000,
0.500000, 0.500000, 0.500000, -0.500000, 1.500000, 0.500000, -0.500000, -0.500000,
0.500000, 0.500000, 0.500000, 1.500000, -0.500000, 0.500000, -0.500000, -0.500000,
0.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000,
0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000,
0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
0.884615, 0.961538, 1.096154, -0.019231, -0.692308, 0.153846, -0.076923, -0.019231,
0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, 1.000000, -1.000000,
1.000000, 1.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000,
-1.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000,
0.500000, 0.500000, 0.500000, -0.500000, -1.500000, -0.500000, -0.500000, -0.500000,
-0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -1.500000,
0.500000, 0.500000, -1.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000,
-0.500000, 1.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000,
0.000000, 1.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000,
0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000,
0.000000, 1.000000, 1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000, -1.000000,
1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.866667, 0.033333, 0.133333, 0.866667, -0.033333, -0.933333, -0.266667, -0.833333,
0.000000, 1.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000,
-1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000,
0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000,
0.000000, 1.000000, 1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000,
-1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000, -1.000000,
1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000, -1.000000,
1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000, -1.000000,
0.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 1.000000, -1.000000,
1.000000, 1.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 0.000000,
-1.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 0.000000,
-1.000000, 1.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 0.000000,
-0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -1.500000,
0.500000, 0.500000, -1.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000,
-0.500000, 1.500000, -0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000,
-1.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000,
-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, -1.000000,
0.000000, 1.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, 1.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000,
0.000000, 1.000000, 1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000, -1.000000,
1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000, -1.000000,
1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000,
0.000000, 1.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.000000, 1.000000, -1.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000,
0.000000, 1.000000, 1.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000,
-1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000, -1.000000,
1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000, 1.000000, -1.000000,
1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000,
0.000000, 1.000000, -1.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
0.000000, 1.000000, -1.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000,
0.000000, 1.000000, 1.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000,
0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -1.500000,
-0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -1.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -1.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 0.500000, -1.500000, 0.500000, 0.500000, -0.500000,
2.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -2.000000, 0.000000,
0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -2.000000, 0.000000, 0.000000,
0.000000, 0.000000, 0.000000, -2.000000, 0.000000, 0.000000, 0.000000, 0.000000,
1.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000,
0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -1.500000, 0.500000,
0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -1.500000, 0.500000, 0.500000,
0.416667, 0.483333, 0.216667, -1.350000, 0.383333, 0.416667, 0.450000, 0.383333,
1.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -1.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -1.500000, -0.500000, 0.500000,
-0.500000, 0.500000, 0.500000, 0.500000, -1.500000, 0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, 0.500000, -1.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -1.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-0.500000, -1.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 1.500000,
1.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -1.500000, -0.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -1.500000, 0.500000,
-0.500000, 0.500000, 0.500000, 0.500000, -1.500000, -0.500000, 0.500000, 0.500000,
-0.500000, 0.500000, 0.500000, -1.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-0.500000, 0.500000, -1.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-0.500000, -1.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 1.500000,
1.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000,
-0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -1.500000, 0.500000,
-0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -1.500000, 0.500000, 0.500000,
-0.500000, 0.500000, 0.500000, -1.500000, -0.500000, 0.500000, 0.500000, 0.500000,
1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000,
1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000,
1.000000, 0.000000, 0.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, 0.000000, -1.000000, -1.000000, -1.000000, 0.000000,
1.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000,
-0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -1.500000, 0.500000,
-0.500000, 0.500000, 0.500000, -0.500000, -1.500000, 0.500000, 0.500000, 0.500000,
-0.500000, 0.500000, -1.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000,
1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000,
1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000,
1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000, -1.000000, 0.000000,
1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000,
1.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000, -1.000000, 0.000000,
1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000,
0.000000, -1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000,
1.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000,
1.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000, 0.000000,
1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000, 0.000000,
-1.000000, 0.000000, 0.000000, -1.000000, -1.000000, -1.000000, 0.000000, 0.000000,
0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000,
0.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, -1.000000,
0.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 0.000000, -1.000000, -1.000000, 1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 0.000000, -1.000000, -1.000000, -1.000000, 1.000000, 0.000000,
0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000, -0.500000, 0.500000,
0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000, -0.500000, 0.500000,
0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 1.500000, -0.500000, 0.500000,
0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 1.500000, 0.500000,
1.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000,
0.500000, -0.500000, -1.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000,
-0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -1.500000, 0.500000,
-0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -1.500000, 0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, 0.500000, -1.500000, 0.500000, 0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, -1.500000, 0.500000, 0.500000, 0.500000, 0.500000,
-0.500000, -1.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000,
0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 1.500000,
1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.000000, -1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000,
1.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.000000, 1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 1.000000,
0.000000, 1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.000000, -1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
1.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000,
-1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000,
1.000000, 0.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000,
0.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.833333, -0.230769, -0.730769, -0.128205, 1.038462, -0.756410, -0.102564, 0.025641,
-1.000000, 0.000000, -1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000,
0.000000, 0.000000, 1.000000, 0.000000, -1.000000, -1.000000, -1.000000, 0.000000,
-1.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
0.000000, 0.000000, -1.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000,
0.000000, 0.000000, -1.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000,
0.000000, 0.000000, -1.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000,
-1.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
1.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
0.500000, 0.500000, 1.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, 1.500000, 0.500000, 0.500000, 0.500000, -0.500000,
0.500000, 0.500000, -0.500000, 0.500000, 1.500000, -0.500000, -0.500000, 0.500000,
0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 1.500000, -0.500000, 0.500000,
0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 1.500000, 0.500000,
-1.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, 1.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000,
0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -1.500000,
0.000000, -1.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, -1.000000,
1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
-1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000,
1.000000, 0.000000, -1.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000,
-1.000000, 0.000000, -1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
-1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.000000, 0.000000, -1.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.000000, 0.000000, -1.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000,
0.000000, 0.000000, -1.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000,
-1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
-0.500000, -0.500000, 0.500000, 0.500000, 1.500000, 0.500000, 0.500000, -0.500000,
0.500000, 0.500000, 1.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
0.500000, 0.500000, -0.500000, 1.500000, 0.500000, -0.500000, -0.500000, 0.500000,
0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 1.500000, -0.500000, 0.500000,
0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 1.500000, 0.500000,
-1.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, 1.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -1.500000,
0.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000,
1.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
1.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
1.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000,
-1.000000, 0.000000, -1.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 1.000000,
0.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000,
0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000,
-1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000, -1.000000, 0.000000,
-0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 1.500000, 0.500000, -0.500000,
0.500000, 0.500000, 1.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
0.500000, 0.500000, -0.500000, 1.500000, -0.500000, 0.500000, -0.500000, 0.500000,
0.500000, 0.500000, -0.500000, -0.500000, 1.500000, 0.500000, -0.500000, 0.500000,
-1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.000000, 0.000000, -1.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000,
0.000000, 0.000000, -1.000000, -1.000000, 1.000000, -1.000000, 0.000000, 0.000000,
0.000000, 0.000000, -1.000000, -1.000000, -1.000000, 1.000000, 0.000000, 0.000000,
-0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000,
0.500000, 0.500000, -0.500000, 1.500000, -0.500000, -0.500000, 0.500000, 0.500000,
0.500000, 0.500000, -0.500000, -0.500000, 1.500000, -0.500000, 0.500000, 0.500000,
0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 1.500000, 0.500000, 0.500000,
-1.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 1.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, 1.500000, -0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, 1.500000, -0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 1.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 1.500000, 0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -1.500000,
0.500000, 1.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000,
1.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000,
0.500000, -1.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000,
-0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -1.500000, 0.500000,
-0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -1.500000, 0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, 0.500000, -1.500000, 0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -1.500000, 0.500000, 0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, -1.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000,
0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 1.500000,
1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.000000, 0.000000, -1.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 0.000000, 1.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 0.000000, 1.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000,
1.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 1.000000, 1.000000, 1.000000, 0.000000, 0.000000, 1.000000,
1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.000000, 0.000000, -1.000000, 1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.000000, 0.000000, 1.000000, -1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
-1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.788462, 0.826923, 0.115385, 0.019231, -0.961538, -1.115385, -0.173077, 0.057692,
0.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000,
-0.051282, 0.243590, 0.820513, -1.128205, -0.038462, 0.294872, 0.884615, -1.038462,
-0.829630, -0.725926, -0.081481, 0.022222, -1.007407, -0.896296, -0.111111, 0.044444,
0.000000, 1.000000, 0.000000, 0.000000, -1.000000, -1.000000, -1.000000, 0.000000,
-1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
-1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
0.000000, -1.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000,
0.000000, -1.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000,
0.000000, -1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000,
0.500000, 1.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, 1.500000, 0.500000, 0.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 1.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000,
0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -1.500000,
0.500000, -0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000, 0.500000,
0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000, 0.500000,
0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 1.500000, 0.500000,
-1.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000,
0.000000, 0.000000, -1.000000, 0.000000, 1.000000, 1.000000, 0.000000, -1.000000,
0.000000, 0.000000, 1.000000, 0.000000, -1.000000, 1.000000, 0.000000, -1.000000,
0.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000,
-1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000,
1.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000, 1.000000, -1.000000,
-1.000000, -1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
-1.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000, -1.000000, 0.000000,
-1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, -1.000000, 0.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.000000, -1.000000, 0.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000,
0.000000, -1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000,
-0.500000, 0.500000, -0.500000, 0.500000, 1.500000, 0.500000, 0.500000, -0.500000,
0.500000, 1.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, 1.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -1.500000,
0.500000, -0.500000, 0.500000, 1.500000, 0.500000, -0.500000, -0.500000, 0.500000,
0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 1.500000, -0.500000, 0.500000,
0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 1.500000, 0.500000,
-1.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
0.000000, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000,
1.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
0.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000,
0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000,
1.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
1.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000,
-1.000000, -1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, 1.000000, 1.000000,
-1.000000, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000,
-1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000,
1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000, -1.000000, 0.000000,
-0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 1.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 1.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -1.500000,
0.500000, -0.500000, 0.500000, -0.500000, 1.500000, 0.500000, -0.500000, 0.500000,
-1.000000, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.000000, 1.000000, 0.000000, -1.000000, -1.000000, -1.000000, 0.000000, 0.000000,
1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.000000, -1.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000,
-0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000,
0.500000, 1.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000,
0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -1.500000,
0.500000, -0.500000, 0.500000, 1.500000, -0.500000, -0.500000, 0.500000, 0.500000,
-1.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000,
-0.500000, 1.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -1.500000,
0.500000, 0.500000, 1.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000,
-0.500000, -0.500000, 0.500000, 1.500000, -0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, 1.500000, -0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 1.500000, -0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 1.500000, 0.500000,
0.000000, 0.000000, 0.000000, -1.000000, 1.000000, 1.000000, 0.000000, -1.000000,
0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 1.000000, 0.000000, -1.000000,
0.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000, 0.000000, -1.000000,
1.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000,
1.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000,
1.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000,
-1.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 1.000000, 0.000000, 1.000000,
0.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000, 1.000000, -1.000000,
0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, 1.000000, -1.000000,
0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, -1.000000, -1.000000,
1.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000,
1.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000,
1.000000, -1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000,
-1.000000, -1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 1.000000, 1.000000,
-1.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000,
-0.500000, 0.500000, 0.500000, -0.500000, 1.500000, 0.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000,
0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
0.500000, -0.500000, 1.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
0.000000, 0.000000, 0.000000, -1.000000, 0.000000, 1.000000, 1.000000, -1.000000,
0.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000, 1.000000, -1.000000,
0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000, -1.000000,
-1.000000, -1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000,
-1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000,
1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.000000, -1.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.000000, -1.000000, -1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000,
0.000000, -1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, 1.000000,
-0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 1.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 1.500000, 0.500000, -0.500000, 0.500000, -0.500000,
0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -1.500000,
0.500000, 1.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
0.500000, -0.500000, 1.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
0.500000, -0.500000, -0.500000, 0.500000, 1.500000, 0.500000, -0.500000, 0.500000,
0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 1.500000, 0.500000,
-1.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
-1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000, -1.000000,
1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000,
0.000000, -1.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000,
0.000000, -1.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000,
0.000000, -1.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000,
-1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, 1.000000,
-0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 1.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 1.500000, 0.500000, 0.500000, -0.500000, -0.500000,
0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -1.500000,
0.500000, 1.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000,
0.500000, -0.500000, 1.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000,
0.500000, -0.500000, -0.500000, 0.500000, 1.500000, -0.500000, 0.500000, 0.500000,
0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 1.500000, 0.500000, 0.500000,
-1.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000,
-1.346154, 0.461538, 0.403846, -0.250000, 0.500000, 0.615385, 0.365385, -0.307692,
-0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -1.500000,
-0.500000, 1.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, 1.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000,
0.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, 1.000000, -1.000000,
0.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 1.000000, -1.000000,
0.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000, -1.000000,
-0.723928, -0.818584, -0.787956, -0.769972, 0.221164, 0.143519, 0.128470, 0.095906,
-1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000,
1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, -1.000000,
0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, -1.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, -1.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, -1.000000, -1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 1.000000,
-0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 1.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000, 0.500000, -0.500000,
0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -1.500000,
0.500000, 1.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
0.500000, -0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
0.500000, -0.500000, -0.500000, 1.500000, 0.500000, 0.500000, -0.500000, 0.500000,
0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 1.500000, 0.500000,
-1.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000, 1.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000, -1.000000,
1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000,
0.000000, 1.000000, -1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.000000, -1.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.000000, -1.000000, -1.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.000000, -1.000000, -1.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000,
-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, 1.000000,
-0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 1.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 0.500000, 1.500000, 0.500000, -0.500000, -0.500000,
0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -1.500000,
0.500000, 1.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
0.500000, -0.500000, 1.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
0.500000, -0.500000, -0.500000, 1.500000, 0.500000, -0.500000, 0.500000, 0.500000,
0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 1.500000, 0.500000, 0.500000,
-1.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-1.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
-0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -1.500000,
-0.500000, 1.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 1.500000, -0.500000, 0.500000,
-1.000000, 0.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000,
1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000,
0.000000, -1.000000, -1.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000,
-0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000,
0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -1.500000,
0.183333, -0.416667, -0.450000, -0.550000, 1.550000, 0.650000, 0.516667, 0.350000,
-1.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
-0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -1.500000,
0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 1.500000, 0.500000, -0.500000,
-0.500000, 1.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, 1.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, -0.500000, 1.500000, -0.500000, 0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, -0.500000, -0.500000, 1.500000, 0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 1.500000, 0.500000,
-1.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000,
-0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -1.500000,
0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000,
-0.500000, 1.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, 1.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, -0.500000, 1.500000, -0.500000, -0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, -0.500000, -0.500000, 1.500000, -0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 1.500000, 0.500000, 0.500000,

};
static float Shell2TPYCodebook[800*8] = {
1.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
0.250000, 0.518519, 0.518519, 0.416667, 0.212963, 1.657407, -0.444444, 0.425926,
0.574074, 0.476852, 0.425926, 0.347222, 0.152778, -0.439815, -0.453704, -1.217593,
-0.259259, -0.365741, 1.203704, -0.333333, -0.337963, 0.356481, 0.416667, -0.342593,
1.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
0.653257, 0.397510, 0.377155, 0.342672, 1.317050, 0.420019, -0.266523, 0.285441,
-0.319749, -0.479624, -0.487461, -0.476489, 0.341519, -0.465430, -1.201672, -0.596743,
0.379630, 0.583333, 0.287037, 0.388889, -0.259259, 0.490741, -0.555556, -1.305556,
-0.362787, -0.359674, -0.414990, -0.387213, 0.534962, 1.198755, 0.619732, -0.259100,
-0.500000, -0.500000, -0.500000, 1.500000, 0.500000, -0.500000, 0.500000, -0.500000,
-0.388889, -0.666667, 1.277778, -0.375000, 0.291667, -0.430556, 0.569444, -0.361111,
-0.500000, 1.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
1.256705, -0.160920, -0.651980, -0.477969, 0.680715, 0.425607, -0.364623, -0.468710,
0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000, 0.500000, 0.500000,
-0.333333, -0.564815, -0.555556, -0.564815, 0.268519, -1.231481, -0.416667, -0.333333,
0.305556, 0.625000, 0.597222, 0.444444, -0.402778, -0.416667, 0.361111, -1.486111,
-0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 1.500000, -0.500000,
-0.500000, -0.500000, -0.500000, 1.500000, 0.500000, 0.500000, -0.500000, -0.500000,
-0.500000, -0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000,
-0.458333, 1.625000, -0.263889, -0.472222, 0.597222, 0.569444, -0.416667, -0.611111,
0.796296, 0.111111, -0.138889, 0.000000, 0.944444, 0.935185, -0.870370, -0.111111,
1.041667, 0.069444, 0.097222, 0.013889, 1.125000, -1.013889, 0.638889, 0.069444,
-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000,
0.152778, 0.847222, 0.979167, 0.871528, -0.048611, -0.034722, -0.031250, -0.746528,
0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -1.500000, -0.500000,
0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -1.500000, 0.500000, -0.500000,
-0.347222, 0.319444, 0.444444, 0.513889, 1.277778, -0.555556, -0.333333, 0.347222,
-0.550000, 0.250000, 0.405556, 0.561111, -0.488889, -0.200000, -0.416667, -1.372222,
1.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000,
0.450383, 0.479693, 0.582567, 1.410345, 0.428352, 0.330460, -0.095211, 0.494253,
-0.361111, -0.516667, -0.300000, 0.327778, -0.355556, -0.550000, -1.244444, -0.494444,
0.331623, 0.442255, 0.306856, -0.381500, 0.369253, 0.361111, -0.456144, -1.309250,
-0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 1.500000, 0.500000, -0.500000,
-0.555556, -0.472222, -0.458333, 0.222222, 1.375000, -0.416667, 0.458333, -0.291667,
-0.500000, -0.500000, 1.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000,
-0.500000, 1.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000,
1.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000,
0.403065, 0.393678, 0.600766, 1.214176, 0.404406, -0.195785, 0.281034, 0.455939,
-0.515134, -0.676054, -0.413218, 0.331226, -0.565900, -1.277778, -0.836782, -0.421648,
0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -1.500000,
-0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 1.500000, -0.500000,
-0.472222, -0.513889, -0.361111, 0.375000, 1.180556, 0.458333, -0.333333, -0.388889,
-0.500000, -0.500000, 1.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000,
-0.347222, 1.416667, -0.569444, 0.222222, -0.277778, 0.583333, -0.416667, -0.472222,
1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000, 0.000000,
1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.055556, -0.083333, 0.296296, 0.953704, -0.083333, -0.935185, -0.814815, -0.129630,
-0.708333, -0.069444, 0.166667, 0.930556, 0.027778, 0.958333, 1.027778, 0.152778,
0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -1.500000, -0.500000,
0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -1.500000, 0.500000, -0.500000,
-0.333333, 0.458333, 0.458333, 1.319444, 0.333333, -0.250000, -0.361111, 0.416667,
-1.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
1.248803, -0.309866, -0.403017, 0.310345, 0.425766, -0.391284, -0.435824, -0.413554,
0.460089, 0.514847, 0.645913, 1.313857, -0.009419, 0.369413, 0.521392, 0.489943,
-0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000,
-0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000,
1.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, -1.000000, 0.000000,
0.861111, 0.069444, -0.055556, 0.708333, -0.944444, -0.083333, 0.791667, 0.013889,
-1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.008429, 0.765900, 1.015326, -0.001533, 0.075670, 0.713985, 0.050000, -1.042529,
-1.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 1.000000, 0.000000,
-0.046296, -1.064815, -0.990741, -0.064815, 0.074074, 0.824074, 0.148148, -0.824074,
0.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000,
0.224412, -0.478927, -0.480296, 0.270252, 0.326492, -0.582649, -1.315955, -0.460591,
0.500000, -0.500000, -0.500000, 0.500000, -1.500000, -0.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 1.500000, -0.500000, 0.500000, -0.500000, 0.500000,
-0.319923, 0.280651, 0.457535, -0.512771, -0.417944, 0.287037, -0.346105, -1.350894,
-1.291667, -0.611111, -0.472222, 0.333333, 0.375000, -0.486111, 0.416667, -0.583333,
0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 1.500000, 0.500000, -0.500000,
0.458333, -0.708333, 1.388889, 0.458333, 0.513889, -0.611111, 0.555556, -0.333333,
0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
1.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000, 0.000000, 0.000000,
1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 1.000000, 0.000000, 0.000000,
-0.833333, -0.235824, 0.128927, 0.640805, -1.055556, -0.853831, 0.058621, 0.133525,
0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 1.000000, 1.000000, 1.000000, 0.000000, 0.000000,
0.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, -1.000000,
0.055556, 0.875000, -1.055556, -0.180556, -0.041667, 0.027778, -0.777778, -0.736111,
0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -1.500000, -0.500000, -0.500000,
0.500000, -0.500000, -0.500000, 0.500000, -1.500000, 0.500000, -0.500000, -0.500000,
-0.448276, 0.275862, 0.500000, 1.301724, -0.568966, -0.353448, 0.448276, 0.663793,
-0.583333, 0.333333, 0.444444, -0.513889, -0.388889, -0.388889, 0.333333, -1.208333,
-1.223499, -0.482759, -0.243295, 0.463921, 0.372925, 0.523946, -0.456897, -0.446041,
0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000,
0.500000, -0.500000, 1.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000,
0.416667, 1.402778, -0.388889, 0.138889, 0.388889, 0.444444, -0.402778, -0.402778,
0.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 1.000000, 0.000000,
-0.072677, -0.061123, 0.088661, 0.714619, 0.743594, 0.896492, 0.795618, 0.140326,
1.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000,
0.268519, 0.527778, 1.212963, 0.472222, 0.611111, 0.398148, -0.453704, 0.388889,
0.597222, 0.472222, -0.569444, 0.722222, 0.430556, 0.361111, -0.319444, -1.388889,
-0.425926, -0.740741, 0.564815, -0.490741, -0.509259, 1.194444, 0.518519, -0.370370,
1.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000,
0.325670, 0.563963, 1.242018, 0.436888, 0.251809, -0.273308, 0.415283, 0.443167,
-0.375000, -0.291667, 0.541667, -0.340278, -0.458333, 0.583333, 1.409722, -0.291667,
-0.500000, -0.500000, 0.500000, -0.500000, 1.500000, 0.500000, -0.500000, -0.500000,
1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000,
1.027778, -0.041667, 0.875000, -0.180556, 0.041667, -0.958333, 1.041667, -0.097222,
-0.870690, 0.000000, 0.698276, 0.146552, -0.008621, -0.879310, -0.905172, -0.103448,
0.000000, 1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
-0.806034, 0.064655, 0.857759, 0.077586, -0.012931, 0.771552, 0.862069, 0.086207,
-0.027778, -0.902778, -0.097222, -0.805556, 0.694444, 0.138889, 0.069444, -1.013889,
0.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -1.500000, -0.500000,
0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -1.500000, 0.500000, -0.500000,
-0.388889, 0.490741, 1.324074, 0.361111, 0.296296, -0.222222, -0.509259, 0.574074,
-0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -1.500000,
-1.444444, -0.444444, 0.291667, -0.388889, -0.583333, 0.444444, 0.250000, -0.361111,
0.500000, -0.694444, 0.305556, -0.500000, 1.513889, 0.736111, 0.666667, -0.347222,
0.500000, -0.500000, 0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000,
0.379470, 1.239783, 0.336686, -0.297254, -0.414272, 0.530492, 0.466315, -0.320722,
1.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000,
0.383860, 0.733716, 1.335728, 0.690613, -0.395115, 0.454262, 0.690613, 0.522510,
-0.388889, -0.250000, 0.409722, -0.270833, -1.444444, -0.361111, -0.263889, -0.437500,
0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -1.500000,
-0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 1.500000, -0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 1.500000, -0.500000, -0.500000,
-0.500000, -0.500000, 0.500000, 1.500000, 0.500000, -0.500000, -0.500000, -0.500000,
-0.500000, 1.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000,
0.842593, 0.231481, 1.055556, -0.074074, 0.944444, 0.055556, -0.898148, 0.083333,
1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000,
0.055556, 0.944444, -0.097222, 0.763889, 0.069444, 0.916667, -0.027778, -0.902778,
0.000000, -1.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.430556, -0.388889, 0.277778, -0.347222, 0.541667, -0.583333, -1.388889, -0.222222,
0.500000, -0.500000, 0.500000, -0.500000, -1.500000, -0.500000, 0.500000, -0.500000,
-0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -1.500000,
0.388889, -0.472222, 0.277778, -0.333333, 0.500000, 1.486111, 0.388889, -0.277778,
1.000000, 0.027778, 0.972222, 0.194444, 0.833333, -0.833333, -0.166667, 0.013889,
1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000,
-0.879310, -0.048276, 0.779310, 0.175862, -1.044828, -0.817241, 0.006897, 0.020690,
-1.069444, 0.083333, 0.930556, 0.111111, 0.986111, 0.652778, 0.027778, 0.097222,
0.472222, -0.500000, 0.291667, -0.611111, 0.486111, -1.277778, -0.458333, -0.416667,
0.500000, -0.500000, 0.500000, -0.500000, -1.500000, 0.500000, -0.500000, -0.500000,
-0.331565, 0.509947, 1.112364, 0.466107, -0.349396, -0.246463, 0.496758, 0.579649,
-1.287037, -0.481481, 0.370370, -0.421296, 0.546296, 0.439815, -0.166667, -0.384259,
0.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 1.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 1.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
-0.052682, 0.239224, 0.722941, 0.134100, 0.770833, 1.010297, 0.971743, 0.126916,
-0.870370, -1.101852, -0.194444, -0.870370, -0.037037, 0.018519, -0.037037, -0.981481,
1.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
0.948914, 0.917146, 0.051245, -0.985313, 0.157088, 0.090837, -0.229406, -0.689815,
1.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000,
0.505508, 0.602011, 1.271791, -0.385536, 0.343870, 0.316810, 0.485153, 0.242816,
-0.500000, -0.500000, 0.500000, -1.500000, -0.500000, -0.500000, -0.500000, -0.500000,
0.444444, 0.194444, -0.361111, -0.611111, 0.430556, 0.388889, 0.472222, -1.361111,
-0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 1.500000, -0.500000,
-0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000, -0.500000,
-0.500000, -0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000, -0.500000,
-0.500000, 1.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000,
1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.188937, 0.710249, 0.232998, -0.143439, 0.856801, 0.839080, 0.049808, -1.006944,
0.458333, -0.430556, 0.416667, 0.236111, -0.486111, -0.416667, -1.361111, -0.555556,
0.416667, -0.375000, 0.361111, -1.430556, -0.347222, -0.416667, 0.375000, -0.708333,
-0.402778, 0.583333, 1.388889, -0.375000, 0.361111, 0.319444, -0.291667, 0.472222,
-0.339080, 0.337803, -0.415070, -0.399106, 0.403895, 0.406130, -0.429757, -1.411877,
0.902874, 0.143487, 0.802107, 0.860536, 0.005939, -0.912835, 0.001149, 0.016284,
1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000,
-1.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
-0.896743, 0.066858, 0.869157, 0.752490, -0.014943, 0.684866, 0.316284, -0.004789,
0.592593, -0.287037, 0.537037, 0.425926, -0.583333, -1.416667, -0.444444, -0.416667,
0.305556, -0.305556, 0.444444, -1.402778, -0.375000, 0.416667, -0.402778, -0.416667,
-0.361111, 0.569444, 1.291667, -0.388889, 0.361111, -0.375000, 0.291667, 0.555556,
-1.402107, -0.359579, 0.426820, 0.531609, -0.245402, 0.358429, -0.329502, -0.365517,
-0.072797, 0.129630, 1.026820, 1.058748, -0.089400, -0.758621, -0.704662, 0.022031,
-0.092593, 0.018519, 0.768519, -0.842593, -0.120370, 0.851852, -0.879630, 0.064815,
-0.185185, -0.027778, 0.925926, -0.805556, -0.064815, -0.768519, 0.870370, -0.194444,
-1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
-0.117300, 0.225906, 0.887415, 0.804524, 0.116416, 0.804671, 0.835765, 0.133215,
-1.041667, -0.791667, -0.111111, 0.013889, -0.763889, 0.208333, -0.083333, -0.902778,
1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, 1.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
1.000000, 0.000000, 1.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000,
-1.008621, -0.120690, 0.767241, -0.810345, -1.025862, -0.025862, 0.155172, -0.181034,
0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000,
-1.041667, -0.090278, 0.784722, 1.083333, 0.965278, 0.138889, -0.180556, -0.062500,
0.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000,
0.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000,
-0.115709, 0.885824, 0.056322, -0.051533, -0.125670, -0.961111, -1.035441, -0.864368,
0.500000, -0.500000, 0.500000, 0.500000, -1.500000, -0.500000, -0.500000, -0.500000,
0.500000, -0.500000, 0.500000, -1.500000, 0.500000, -0.500000, -0.500000, -0.500000,
-0.500000, 0.500000, 1.500000, -0.500000, -0.500000, 0.500000, 0.500000, 0.500000,
-0.296296, 0.351852, -0.564815, -0.638889, -0.481481, 0.398148, 0.296296, -1.268519,
-1.478289, -0.655811, 0.398787, 0.561941, 0.223499, -0.424968, -0.672414, -0.534483,
0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000,
0.416667, -0.453704, 0.351852, 0.388889, 0.379630, 1.212963, -0.425926, -0.296296,
0.541667, 1.333333, 0.625000, 0.583333, 0.208333, -0.458333, -0.402778, -0.347222,
0.064815, 0.259259, 0.833333, 0.898148, -0.796296, 0.027778, -0.759259, -0.064815,
0.000000, 0.000000, 1.000000, -1.000000, 1.000000, 0.000000, -1.000000, 0.000000,
0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 1.000000, 0.000000,
-0.083333, 0.120370, 0.953704, 0.888889, 0.731481, 0.240741, 0.814815, 0.120370,
-0.116785, 0.097554, 0.845049, 0.846817, -0.925508, -0.793472, -0.114574, 0.069187,
-0.208333, 0.138889, 1.000000, -0.972222, 0.875000, -0.875000, 0.069444, -0.138889,
0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 1.000000, 0.000000, 0.000000,
-0.057545, 0.189287, 0.861406, 0.896773, 0.929192, 0.804966, 0.151636, -0.027999,
1.388889, 0.444444, -0.416667, -0.458333, -0.430556, -0.416667, 0.263889, -0.361111,
0.629630, 1.472222, 0.472222, 0.472222, 0.527778, 0.388889, -0.314815, 0.268519,
-0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 1.500000, 0.500000, -0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, 1.500000, -0.500000, 0.500000, -0.500000,
1.325192, 0.339559, -0.389847, -0.356561, -0.401102, 0.262931, -0.366858, -0.457854,
0.662516, 1.400702, 0.582375, 0.387931, 0.370370, -0.203704, 0.303001, 0.383461,
0.361111, -0.250000, 0.458333, 0.458333, 0.333333, -0.361111, 0.388889, -1.486111,
-0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 1.500000, -0.500000,
1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000,
1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.092593, 0.138889, 0.870370, 0.879630, 0.666667, -0.120370, -0.046296, -0.750000,
-0.916667, 1.041667, 0.069444, -0.027778, -0.152778, 0.777778, 0.763889, -0.111111,
0.104981, -0.113985, -0.696360, -0.848276, 0.765326, 0.063602, -0.134291, -0.788506,
0.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -1.500000, -0.500000,
0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -1.500000, 0.500000, -0.500000,
-0.500000, 1.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
-0.666667, -0.416667, 0.458333, 0.458333, 0.263889, -0.402778, -0.736111, -1.347222,
-1.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
0.540868, 0.194125, -0.405492, -0.521073, 1.412516, 0.745211, 0.344189, -0.347382,
0.472222, 0.416667, -0.416667, 1.291667, -0.305556, 0.486111, 0.430556, -0.291667,
0.638889, 0.791667, 1.430556, -0.569444, -0.402778, 0.402778, 0.486111, -0.444444,
1.484674, 0.471145, -0.446240, -0.313937, 0.629909, -0.220067, -0.373563, -0.231920,
0.495895, 1.064176, 0.609743, 0.324165, -0.389299, 0.572250, 0.730706, 0.449918,
-0.597222, 0.263889, -0.458333, -0.326389, -1.416667, -0.472222, -0.555556, -0.590278,
0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -1.500000,
-0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 1.500000, -0.500000,
-0.316667, 0.455556, -0.361111, -0.544444, 0.416667, 1.177778, -0.500000, -0.522222,
-0.500000, 0.500000, -0.500000, 1.500000, 0.500000, -0.500000, -0.500000, -0.500000,
-0.500000, 0.500000, 1.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000,
0.970033, 0.773604, -0.026136, -0.129995, 0.850848, -0.091680, -0.726669, -0.081076,
0.938889, 0.750000, -0.011111, -0.044444, -0.838889, -0.144444, 0.655556, 0.111111,
-1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000,
-1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000,
0.513410, 0.366416, -0.421972, -0.538093, 0.373932, -0.423814, -1.115458, -0.526746,
0.435185, 0.333333, -0.370370, -0.416667, -1.324074, -0.611111, 0.287037, -0.351852,
-0.500000, 1.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
-1.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
1.005556, 0.727778, -0.127778, -0.072222, 0.844444, -0.833333, -0.111111, 0.077778,
0.782407, 0.675926, -0.032407, 0.023148, -0.856481, 0.782407, 0.069444, -0.046296,
-0.138889, -0.083333, 1.018519, 1.009259, 0.009259, 0.111111, 0.833333, -0.629630,
0.097222, 0.118056, -0.895833, -1.145833, 0.173611, 0.104167, 0.736111, -0.972222,
0.388889, 0.375000, -0.500000, -0.361111, 0.416667, -1.458333, -0.291667, -0.263889,
0.500000, 0.500000, -0.500000, -0.500000, -1.500000, 0.500000, -0.500000, -0.500000,
-0.291667, -0.402778, 0.444444, 0.638889, -0.250000, -0.361111, 0.430556, -1.513889,
0.416667, 0.379630, -0.222222, -0.592593, 0.518519, 0.564815, 1.240741, -0.527778,
0.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000,
-0.097222, 1.125000, 0.125000, 0.083333, -0.958333, 0.875000, -0.652778, -0.041667,
0.000000, 1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
0.117119, 0.703065, 0.132358, -0.067834, 0.875740, 1.064176, 0.743730, 0.007837,
-0.675926, -0.203704, -0.907407, -0.981481, 0.055556, 0.092593, 0.009259, -1.046296,
1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
1.305556, 0.444444, -0.291667, 0.256944, -0.555556, -0.416667, -0.395833, -0.361111,
0.503352, 1.271671, 0.461087, -0.405053, 0.300766, 0.508022, 0.571719, 0.370091,
-0.422414, 0.339719, -0.719668, -1.477331, -0.502874, -0.462644, -0.501916, -0.565134,
0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -1.500000,
-0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 1.500000, -0.500000,
-0.569444, 0.513889, -0.486111, 0.291667, -0.305556, 1.263889, -0.319444, -0.541667,
-0.500000, 0.500000, -0.500000, 0.500000, 1.500000, -0.500000, -0.500000, -0.500000,
-0.220067, 0.444684, 1.387452, 0.546456, -0.422174, -0.443726, -0.348898, -0.431992,
0.861111, 0.902778, -0.027778, 0.805556, -0.013889, 0.055556, -0.750000, 0.125000,
1.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000,
-1.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
-1.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000,
0.377395, 0.401660, -0.203704, 0.381545, -0.475415, -0.717752, -1.220945, -0.597063,
0.524425, 0.377395, -0.583573, -1.397031, -0.552682, -0.289990, 0.256466, -0.323994,
-0.500000, 1.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-1.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000,
1.074074, 0.916667, 0.157407, 0.833333, 0.064815, -0.750000, -0.129630, -0.194444,
0.905556, 0.842337, 0.045211, -0.685441, 0.134483, 0.670115, 0.219923, -0.141188,
-1.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.011494, -0.009259, 0.922414, -0.133142, 0.645913, 0.004151, 0.783206, -0.841954,
0.527778, 0.236111, -0.402778, 0.402778, -0.333333, -1.486111, -0.375000, -0.305556,
0.370690, 0.482759, -0.543103, -1.224138, -0.508621, 0.336207, -0.284483, -0.637931,
-0.500000, 1.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -1.500000,
0.000000, 1.000000, 0.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.000000, 1.000000, 0.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000,
0.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
0.990613, 0.969732, 0.023755, -0.751724, 1.052299, 0.099234, -0.090038, 0.020115,
-1.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
-0.012771, 0.166347, 0.821520, -0.139527, 0.055556, 0.674649, 0.803001, -0.844189,
-1.000000, 1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000,
0.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000,
0.055556, 0.013889, -1.152778, 0.166667, 0.222222, 1.013889, -0.875000, -1.027778,
-0.166667, -0.055556, 0.777778, 0.097222, -0.069444, -1.013889, -0.888889, -0.902778,
0.500000, 0.500000, -0.500000, 0.500000, -1.500000, -0.500000, -0.500000, -0.500000,
0.417864, 0.400862, -0.488985, -1.260057, 0.500718, -0.300287, -0.745211, -0.444923,
-0.500000, 1.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 0.500000,
-0.500000, -0.305556, 0.402778, -0.444444, -0.444444, 0.430556, 0.305556, -1.444444,
-1.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000,
0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000,
0.527778, 0.513889, -0.458333, 0.333333, 0.236111, 1.375000, -0.347222, -0.361111,
0.319444, 0.590278, 1.208333, 0.472222, 0.402778, -0.361111, -0.368056, -0.312500,
0.000000, 1.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.129310, 0.949234, 0.065773, -0.754470, 0.863346, 0.057791, -0.855683, -0.204981,
0.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 1.000000, 0.000000,
0.000000, 1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 1.000000, 0.000000,
0.000000, 1.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000,
0.000000, 1.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000, 0.000000,
0.000000, 1.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000, 0.000000,
-0.013889, 0.958333, 0.194444, 0.777778, 0.972222, 0.736111, 0.111111, 0.027778,
1.177363, 0.664911, 0.270514, -0.257423, -0.352331, -0.413873, -0.404374, -0.418263,
0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -1.500000,
0.564815, 1.333333, -0.370370, 0.444444, 0.379630, 0.518519, 0.564815, 0.481481,
-0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 1.500000, -0.500000,
0.956897, 1.043103, 0.870690, -0.068966, -0.025862, -0.051724, -0.637931, -0.103448,
-0.046296, 0.055556, 0.231481, 0.990741, 1.009259, 0.842593, 0.166667, -0.898148,
1.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000,
-0.944444, 0.833333, -1.291667, 0.125000, 0.083333, 0.152778, -1.041667, 0.027778,
-1.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000,
0.009259, 0.046296, -0.037037, -0.833333, -0.768519, 0.916667, -0.055556, -0.824074,
0.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000, -1.000000,
0.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, -1.000000,
0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -1.500000, -0.500000,
-0.322605, -0.470881, -0.204789, 0.329885, 0.352682, 0.369732, -0.427969, -1.328161,
0.500000, 0.500000, -1.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000,
-0.500000, 1.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-1.413793, 0.439655, 0.500000, -0.362069, -0.560345, -0.301724, 0.353448, -0.275862,
0.416667, 0.541667, 0.263889, -0.500000, -0.500000, 1.250000, 0.361111, -0.472222,
0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000, 0.500000, -0.500000,
0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000, 0.500000, -0.500000,
0.917146, 0.856561, 0.757902, 0.008621, -0.175287, -0.727730, -0.069923, 0.052443,
0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 1.000000, -1.000000,
1.000000, 1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000,
-1.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000,
-0.796296, 0.722222, 0.768519, -0.009259, -0.120370, 0.796296, 0.083333, 0.074074,
0.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000, 1.000000, -1.000000,
0.146743, -0.066284, -0.312261, -0.841379, 0.751341, -0.029502, -0.845019, -0.863027,
0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000, -1.000000,
0.611111, 0.555556, 0.722222, -0.444444, -0.666667, -1.416667, -0.611111, -0.444444,
-0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -1.500000,
0.486111, 0.250000, -1.277778, -0.319444, -0.333333, 0.458333, -0.388889, -0.486111,
-0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-1.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000,
0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 1.500000, -0.500000,
0.412596, 0.567768, 0.300048, -0.296216, 1.231561, 0.503831, -0.373803, -0.424090,
0.527778, 0.388889, 0.569444, 1.208333, -0.319444, 0.402778, -0.472222, -0.652778,
0.115741, 0.759259, 0.800926, 0.027778, -0.074074, -0.893519, -0.953704, 0.078704,
-1.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
-0.055556, 0.852941, -0.790850, -0.001634, -0.116013, 0.794118, -0.830065, 0.001634,
0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000,
0.089749, 0.825359, 0.777956, 0.032723, 0.111713, 0.783525, 0.751381, 0.024637,
-0.842792, -0.002514, 0.029574, -0.794181, -0.901341, 0.009818, 0.002275, -0.857759,
0.779119, -0.005939, -0.214751, -0.869349, 0.812452, 0.116284, -0.177011, -0.977203,
1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
0.871887, 0.914511, 0.767960, 0.136853, -0.644995, -0.150742, 0.009459, -0.013889,
-0.013889, 0.027778, 0.208333, 0.902778, 0.041667, 0.902778, 0.833333, -0.916667,
0.916667, 0.916667, -0.902778, -0.208333, 0.875000, 0.125000, 0.027778, -0.125000,
-0.930556, 0.805556, -0.819444, 0.041667, -0.694444, -0.041667, 0.097222, 0.013889,
0.377395, 0.541188, 0.265326, -0.226772, -1.334291, -0.422893, -0.362787, -0.490900,
-0.652778, -0.486111, -0.347222, 0.347222, -0.472222, 0.277778, 0.472222, -1.319444,
0.500000, 0.500000, -1.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000,
-0.388889, 1.368056, -0.388889, 0.326389, -0.381944, 0.472222, 0.347222, 0.305556,
0.000000, 1.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000,
-0.958333, -0.222222, 0.166667, 0.972222, 0.166667, 0.986111, 0.138889, -0.875000,
0.013889, 0.805556, -0.902778, -0.027778, 0.722222, 0.027778, -0.833333, -0.083333,
0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000,
0.013889, 0.847222, 1.097222, 0.013889, 0.902778, -0.152778, 0.777778, 0.041667,
-0.805556, 0.000000, 0.000000, -0.916667, -0.208333, -0.791667, -0.027778, -0.736111,
1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.888889, 0.111111, -0.027778, 0.722222, 0.027778, -1.055556, 0.013889, -0.805556,
-0.059962, 0.825287, 0.811877, 0.209195, -0.873180, -0.883908, -0.033716, 0.102874,
-1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.041667, 0.847222, -0.805556, -0.125000, 1.152778, -0.750000, 0.000000, -0.069444,
0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000,
0.134499, 0.830500, 0.764248, 0.041387, 0.816810, 0.818048, 0.086486, -0.054797,
-1.000000, -0.111111, -0.083333, -1.138889, -0.083333, -0.152778, -0.833333, -1.000000,
1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000, -1.000000,
1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000, -1.000000,
0.030460, 0.144444, 0.114464, 0.011782, 1.072605, 1.046839, 0.768008, -0.794349,
0.861111, 1.069444, -0.833333, 0.902778, -0.055556, 0.083333, -0.027778, 0.208333,
-1.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 0.000000,
-0.539683, 0.805556, 1.000000, 1.079365, -0.075397, 0.011905, -0.007937, -0.031746,
-0.388889, -0.506944, -0.423611, -0.368056, 0.298611, 0.506944, 0.486111, -1.402778,
0.500000, 0.500000, -1.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000,
-0.222222, 1.416667, -0.388889, -0.324074, 0.472222, 0.527778, 0.259259, 0.222222,
-1.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000,
-0.888889, -0.166667, -0.069444, 0.166667, 1.083333, 1.055556, 0.083333, -0.819444,
0.000000, 1.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, 1.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000,
0.073036, 0.795099, 1.081019, 0.956657, -0.031689, 0.168024, 0.650383, 0.169221,
-0.882759, -0.210536, 0.076820, 0.089464, -0.951149, -0.848851, -0.240230, -0.831992,
1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000, -1.000000,
1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000,
0.000000, 1.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.000000, 1.000000, -1.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000,
0.138889, 0.816667, 0.994444, 0.761111, 0.050000, 0.733333, 0.016667, -0.038889,
-0.875000, 0.138889, 0.125000, -0.111111, -0.916667, -0.027778, -0.777778, -0.930556,
1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000, 1.000000, -1.000000,
1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000,
-0.097222, 0.805556, -0.902778, 0.888889, -0.722222, -0.041667, 0.000000, -0.138889,
0.000000, 1.000000, -1.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000,
0.107120, 0.746049, 0.927363, 0.840517, 0.793143, 0.282846, -0.017880, -0.022869,
0.244672, -0.275862, -0.462225, -0.595127, -0.348898, -0.496887, -0.590278, -1.228209,
-0.342593, 0.240741, 0.537037, 0.518519, 0.231481, 0.333333, -1.240741, -0.370370,
-0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -1.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 0.500000, -1.500000, 0.500000, 0.500000, -0.500000,
1.690673, 0.044061, -0.088242, 0.003472, 0.135327, -0.031879, -0.011345, 0.018109,
0.090278, -0.020833, -0.152778, 0.097222, 0.062500, -0.034722, -1.659722, -0.069444,
0.040404, -0.209596, -0.113636, -0.035354, -0.022727, -1.676768, -0.065657, 0.058081,
0.007471, 0.000876, -0.080241, -1.608539, 0.049152, -0.031910, 0.015873, -0.025205,
1.366667, -0.494444, -0.361111, -0.205556, -0.233333, -0.555556, -0.527778, -0.461111,
0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -1.500000, 0.500000,
0.236111, 0.388889, 0.625000, 0.375000, 0.541667, -1.333333, 0.569444, 0.416667,
0.277778, 0.416667, 0.472222, -1.423611, 0.500000, 0.416667, 0.312500, 0.395833,
1.319444, 0.513889, 0.555556, 0.430556, 0.458333, 0.333333, -0.333333, 0.444444,
0.313027, -0.271264, -0.438123, -0.500958, -0.411686, -0.618582, -1.196360, -0.689655,
-0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -1.500000, -0.500000, 0.500000,
-0.319444, 0.527778, 0.569444, 0.527778, -1.694444, 0.472222, -0.305556, 0.347222,
-0.500000, 0.500000, 0.500000, -1.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-0.347222, 0.541667, -1.333333, 0.444444, 0.236111, 0.319444, -0.541667, 0.347222,
-0.500000, -1.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
0.148148, -0.333333, -0.425926, -0.398148, -0.407407, -0.546296, 0.481481, 1.444444,
1.483333, 0.594444, 0.472222, 0.427778, 0.594444, -0.127778, 0.305556, 0.344444,
0.301724, -0.538793, -0.612069, -0.435345, -0.551724, -1.280172, -0.681034, -0.379310,
-0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -1.500000, 0.500000,
-0.396141, 0.275862, 0.551998, 0.311576, -1.356185, -0.486590, 0.454707, 0.633552,
-0.500000, 0.500000, 0.500000, -1.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-0.500000, 0.500000, -1.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-0.500000, -1.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 1.500000,
1.258908, 0.484770, 0.433333, 0.456705, -0.229885, 0.348755, 0.404215, 0.404598,
-0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -1.500000, 0.500000,
-0.333333, 0.402778, 0.458333, 0.319444, -0.236111, -1.430556, 0.388889, 0.402778,
-0.500000, 0.500000, 0.500000, -1.500000, -0.500000, 0.500000, 0.500000, 0.500000,
0.903804, -0.093186, -0.259031, -0.089080, 0.892447, -0.874247, -0.732074, -0.003421,
1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000,
1.000000, 0.055556, -0.027778, -0.013889, -0.888889, -0.819444, 1.194444, -0.166667,
-0.795797, -0.258641, 0.011754, 0.055456, -0.894157, -1.013310, -0.697178, -0.131605,
1.119056, 0.528116, 0.259860, -0.333164, 0.509015, 0.509410, 0.473293, 0.294174,
-0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -1.500000, 0.500000,
-0.500000, 0.444444, 0.375000, -0.305556, -1.291667, 0.486111, 0.486111, 0.333333,
-0.458333, 0.277778, -1.277778, -0.513889, 0.472222, 0.569444, 0.458333, 0.444444,
1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000,
1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000,
1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.048611, 0.187500, 0.013889, -0.784722, -0.090278, -0.965278, -0.965278, -0.159722,
1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.916667, -0.013889, -0.152778, -0.833333, 0.777778, 0.083333, -0.736111, 0.000000,
1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000,
0.000000, -1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.083333, 0.868056, -0.784722, -0.118056, 0.000000, 0.993056, -0.201389, -0.791667,
0.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000,
0.791667, 0.069444, -0.013889, 1.000000, -1.013889, -1.166667, -0.152778, 0.069444,
1.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000, 0.000000,
1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000, 0.000000,
-0.781609, -0.137931, -0.178161, -0.919540, -0.994253, -0.816092, -0.068966, 0.097701,
0.044148, 0.776428, 0.864681, 0.182907, -0.100488, 0.136668, 0.859718, 0.865465,
-0.006944, -0.687500, 0.868056, -0.111111, -0.062500, -0.097222, 0.784722, -0.736111,
0.305556, 0.750000, -0.962963, 0.064815, -0.046296, 0.231481, 0.944444, -0.824074,
0.110632, 0.811462, 0.757663, 0.095307, 0.241379, -0.241539, -0.963123, -0.940932,
0.039707, 0.052072, 0.111459, 0.741379, -0.817398, -0.917799, -0.770812, -0.140543,
0.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 0.000000, -1.000000, -1.000000, 1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 0.000000, -1.000000, -1.000000, -1.000000, 1.000000, 0.000000,
0.530651, 0.520881, 0.597318, 1.213218, -0.252682, -0.368391, -0.314751, 0.281226,
0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000, -0.500000, 0.500000,
0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 1.500000, -0.500000, 0.500000,
0.185185, 0.527778, 0.537037, -0.314815, -0.518519, -0.222222, 1.435185, 0.333333,
1.307152, 0.463442, -0.306992, 0.220945, 0.621648, 0.513410, 0.385057, 0.361271,
0.331258, -0.529773, -1.183509, -0.623084, -0.360473, -0.366938, -0.554278, -0.399186,
-0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -1.500000, 0.500000,
-0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -1.500000, 0.500000, 0.500000,
-0.402778, 0.541667, -0.277778, 0.333333, -1.416667, 0.708333, 0.430556, 0.472222,
-0.437500, 0.409722, -0.305556, -1.326389, 0.277778, 0.409722, 0.437500, 0.361111,
-0.537037, -1.185185, -0.416667, 0.481481, 0.324074, 0.648148, 0.601852, 0.305556,
0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 1.500000,
0.986111, 0.208333, 0.722222, -0.083333, 0.041667, -0.819444, -0.916667, -0.013889,
0.000000, -1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.534722, 0.222222, -0.861111, -0.027778, -0.118056, 0.861111, -0.881944, -0.076389,
1.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.000000, 1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 1.000000,
0.222222, 0.958333, 0.027778, -1.027778, 0.972222, 0.041667, -0.236111, -1.069444,
0.000000, 1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.000000, -1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.770417, 0.013965, -0.873967, -0.045675, 0.828645, -0.049355, -0.899022, -0.110456,
-0.759259, 0.046296, -0.851852, 0.027778, -0.675926, 0.064815, -0.842593, -0.074074,
1.000000, 0.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000,
0.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.705556, -0.033333, -0.855556, 0.066667, 0.777778, -0.850000, -0.161111, 0.055556,
-0.875000, -0.138889, -0.819444, 0.097222, -0.819444, -0.763889, -0.097222, -0.069444,
0.000000, 0.000000, 1.000000, 0.000000, -1.000000, -1.000000, -1.000000, 0.000000,
-0.777778, -0.958333, -0.097222, 0.944444, -0.083333, -0.097222, -0.194444, -0.819444,
-0.046296, 0.092593, -0.796296, -0.101852, 0.750000, -1.120370, -1.074074, -0.037037,
0.000000, 0.000000, -1.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000,
0.000000, 0.000000, -1.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000,
-1.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
1.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
0.416667, 0.537037, 1.231481, 0.370370, -0.361111, -0.416667, -0.481481, 0.537037,
-0.462963, -0.324074, 0.425926, 1.240741, 0.564815, 0.509259, 0.388889, -0.546296,
0.694444, 0.319444, -0.347222, 0.513889, 1.208333, -0.458333, -0.527778, 0.500000,
0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 1.500000, -0.500000, 0.500000,
0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 1.500000, 0.500000,
-1.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000,
-0.490741, 1.407407, 0.388889, -0.555556, 0.398148, 0.564815, 0.444444, -0.166667,
0.430556, 0.361111, -0.402778, 0.541667, -0.638889, -0.638889, -0.611111, -1.166667,
-0.166667, -0.798611, -0.187500, -0.013889, 0.923611, 0.923611, 0.055556, -0.590278,
1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
-0.683333, -0.194444, -0.872222, -0.916667, -0.044444, 0.094444, -0.811111, -0.022222,
0.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000,
1.000000, 0.152778, -0.972222, 1.055556, -0.208333, -1.055556, -0.125000, -0.027778,
0.864176, -0.100192, -0.922605, -1.000000, 0.105939, 0.636398, 0.033142, -0.178927,
-1.041667, -0.027778, -0.888889, -1.041667, 0.069444, -0.694444, -0.041667, 0.166667,
-1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.027778, -0.083333, -0.805556, 0.708333, -0.069444, -1.055556, -1.055556, 0.041667,
0.000000, 0.000000, -1.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000,
0.000000, 0.000000, -1.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000,
-1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000,
0.965517, 0.801724, 0.043103, -0.008621, 0.896552, 0.155172, -0.103448, -0.715517,
-0.500000, -0.500000, 0.500000, 0.500000, 1.500000, 0.500000, 0.500000, -0.500000,
0.500000, 0.500000, 1.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
0.231481, 0.324074, -0.537037, 1.472222, 0.277778, -0.398148, -0.398148, 0.287037,
0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 1.500000, -0.500000, 0.500000,
0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 1.500000, 0.500000,
-1.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, 1.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
0.517241, 0.465517, -0.301724, -0.508621, 0.379310, -0.405172, -0.655172, -1.275862,
0.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000,
1.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
1.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
0.847222, 0.152778, -0.972222, -1.013889, 0.847222, 0.291667, -0.041667, 0.055556,
-0.962963, -0.138889, -0.842593, -1.018519, -0.768519, -0.203704, 0.027778, -0.111111,
-0.009770, 0.665134, 0.029310, 0.013218, 0.117241, 0.857280, 0.905556, 0.719157,
0.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000,
0.055556, 0.944444, 0.027778, 0.000000, 0.037037, 0.824074, -0.981481, -0.824074,
-1.055556, -1.125000, 0.180556, 0.138889, -0.125000, 0.750000, 0.069444, -1.041667,
0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, -1.000000, 0.000000,
-0.291667, -0.062500, -0.840278, 0.909722, -0.895833, -0.020833, -0.888889, 0.069444,
0.203544, 0.070881, -0.835728, -0.851293, 0.779933, -0.033285, -0.701149, -0.158764,
-0.319444, -0.333333, 0.263889, 0.513889, 0.430556, 1.486111, 0.611111, -0.263889,
0.361111, 0.407407, 1.648148, -0.425926, -0.268519, 0.370370, -0.425926, 0.361111,
0.236111, 0.430556, -0.479167, 1.270833, -0.270833, 0.520833, -0.562500, 0.486111,
0.388889, 0.291667, -0.375000, -0.277778, 1.277778, 0.541667, -0.458333, 0.541667,
-1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.069444, -0.027778, -0.861111, 0.680556, -1.027778, -0.833333, -0.013889, 0.111111,
0.000000, 0.000000, -1.000000, -1.000000, 1.000000, -1.000000, 0.000000, 0.000000,
0.000000, 0.000000, -1.000000, -1.000000, -1.000000, 1.000000, 0.000000, 0.000000,
-0.601852, -0.342593, 0.564815, 0.583333, 0.185185, 0.388889, 1.212963, -0.601852,
0.500000, 0.500000, -0.500000, 1.500000, -0.500000, -0.500000, 0.500000, 0.500000,
0.500000, 0.430556, -0.472222, -0.222222, 1.291667, -0.472222, 0.347222, 0.388889,
0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 1.500000, 0.500000, 0.500000,
-1.370370, -0.472222, 0.555556, 0.398148, 0.370370, 0.574074, 0.324074, -0.453704,
-0.500000, 0.500000, 1.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, 1.500000, -0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, 1.500000, -0.500000, -0.500000, 0.500000,
-0.444444, 0.657407, -0.407407, -0.259259, -0.444444, 1.268519, -0.509259, 0.324074,
-0.694444, 0.500000, -0.444444, -0.430556, -0.333333, -0.638889, 1.430556, 0.777778,
-0.416667, 0.172095, -0.266284, -0.533844, -0.587484, -0.479246, -0.571201, -1.335568,
0.430556, 1.187500, 0.479167, 0.361111, 0.416667, 0.534722, 0.291667, -0.194444,
1.444444, -0.361111, 0.333333, 0.277778, 0.250000, 0.430556, 0.416667, 0.402778,
0.152490, -1.283525, -0.531992, -0.397318, -0.539272, -0.509770, -0.491954, -0.548084,
-0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -1.500000, 0.500000,
-0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -1.500000, 0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, 0.500000, -1.500000, 0.500000, 0.500000, 0.500000,
-0.342593, -0.194444, 0.648148, -1.333333, 0.425926, 0.481481, 0.472222, 0.500000,
-0.319444, -0.618056, -1.229167, 0.479167, 0.618056, 0.625000, 0.513889, 0.409722,
0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 1.500000,
0.845019, 0.636207, 0.043103, -0.107854, -0.074330, -0.818582, -0.860536, -0.168199,
0.000000, 0.000000, -1.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 0.000000, 1.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 0.000000, 1.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.013889, -0.791667, -0.097222, 0.152778, 0.111111, 1.027778, -0.736111, 0.138889,
0.909722, -0.875000, 0.236111, 0.020833, 0.069444, -0.812500, 0.680556, 0.236111,
-0.816997, -0.913687, -0.190347, 0.149691, -0.147244, -0.884685, -0.839559, -0.079555,
0.060345, 0.051724, 0.844828, 1.206897, 0.905172, 0.250000, 0.137931, 0.853448,
0.875000, 1.055556, 0.083333, -0.083333, -0.680556, 0.055556, -0.916667, 0.097222,
0.000000, 0.000000, -1.000000, 1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
-0.027778, 0.261111, 0.788889, -1.044444, -0.005556, 0.833333, 0.000000, -0.838889,
-0.888889, -1.013889, -0.291667, -0.138889, -0.930556, -0.027778, -0.916667, -0.097222,
1.000000, 0.777778, -0.027778, -0.009259, -0.898148, -0.666667, -0.217593, -0.106481,
0.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.013021, -0.019965, 0.796875, -0.752604, -0.031250, -0.056424, 0.778646, -0.856771,
-0.900648, -0.756911, -0.124273, 0.044393, -0.936252, -0.795028, -0.147997, 0.050972,
0.231481, 0.731481, 0.092593, -0.074074, -0.907407, -1.175926, -0.907407, 0.027778,
-0.694444, -0.083333, -1.111111, 1.055556, 0.000000, -0.097222, -0.152778, -1.125000,
-1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
0.152778, -0.986111, -0.069444, 0.055556, 1.000000, -0.875000, -0.805556, -0.055556,
0.000000, -1.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000,
-0.208333, -0.916667, -0.097222, -0.236111, -1.236111, -1.055556, 1.000000, 0.055556,
-0.726054, -0.084674, 0.790996, 0.968582, -0.136782, -0.072414, 0.014943, 1.016092,
0.534483, 1.241379, 0.706897, 0.327586, -0.474138, -0.568966, -0.431034, 0.362069,
-0.500000, 0.500000, -0.500000, 1.500000, 0.500000, 0.500000, 0.500000, -0.500000,
-0.430556, 0.444444, 1.222222, -0.388889, 0.361111, 0.347222, 0.444444, -0.347222,
0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -1.500000,
0.500000, -0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000, 0.500000,
0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000, 0.500000,
0.263889, -0.541667, 0.569444, 0.500000, -0.277778, -0.541667, 1.416667, 0.319444,
-1.216562, -0.563305, 0.238680, 0.428248, -0.598137, -0.625827, -0.264020, 0.238419,
-0.017241, -0.155172, -0.758621, -0.232759, 0.922414, 1.043103, -0.077586, -0.827586,
0.000000, 0.000000, 1.000000, 0.000000, -1.000000, 1.000000, 0.000000, -1.000000,
0.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000,
-1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000,
1.069444, 1.013889, 0.097222, -0.777778, -0.125000, -0.833333, 0.041667, 0.138889,
-0.037037, 0.074074, 0.842593, -0.212963, -1.000000, 0.027778, 0.898148, -0.629630,
-0.854167, -0.798611, -0.208333, -0.930556, 0.006944, -0.847222, -0.076389, 0.020833,
-1.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.194444, 0.875000, 0.000000, -0.888889, -0.097222, -1.000000, -0.861111, -0.069444,
-0.916667, -0.194444, 0.888889, -0.097222, -0.916667, -0.055556, 0.097222, -0.777778,
0.861111, 0.013889, 1.013889, -0.041667, 0.972222, 0.222222, -0.125000, -0.875000,
-0.040038, -1.049617, -0.159004, 0.864176, 0.047893, -0.975287, -0.727778, 0.171648,
-0.041667, -1.000000, -0.138889, -0.930556, 0.138889, 0.833333, -0.750000, 0.069444,
0.000000, -1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000,
-0.500000, 0.500000, -0.500000, 0.500000, 1.500000, 0.500000, 0.500000, -0.500000,
0.490741, 1.250000, 0.333333, -0.444444, 0.611111, -0.481481, -0.250000, 0.472222,
-0.364176, 0.644636, 1.256705, 0.457088, -0.334674, 0.534866, 0.505747, -0.255556,
0.569444, -0.444444, 0.513889, -0.444444, 0.388889, -0.305556, -0.291667, -1.236111,
0.500000, -0.250000, 0.486111, 1.611111, 0.472222, -0.291667, -0.625000, 0.638889,
0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 1.500000, -0.500000, 0.500000,
0.444444, -0.652778, 0.472222, -0.305556, 0.583333, -0.513889, 1.347222, 0.666667,
-1.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
0.000000, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000,
1.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
-0.041667, -0.125000, 0.861111, -0.027778, 0.069444, -0.930556, 0.958333, -0.805556,
0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000,
1.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
1.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000,
-1.038633, -0.657727, -0.178001, -0.679119, -0.987548, -0.062101, 0.089400, -0.093550,
-0.019875, 0.173491, 0.734195, 0.271312, 0.048851, 0.818487, 1.008621, 0.796576,
-1.000000, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000,
-1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000,
1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000, -1.000000, 0.000000,
-0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 1.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 1.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -1.500000,
0.736111, -0.319444, 0.444444, -0.361111, 1.500000, 0.388889, -0.375000, 0.500000,
-1.000000, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.055556, 0.680556, -0.111111, -0.847222, -1.055556, -1.000000, 0.027778, 0.138889,
0.833333, 0.152778, 0.944444, -0.208333, 0.069444, 0.236111, 1.000000, -1.069444,
-0.088697, -0.863410, 0.017816, 0.772605, -0.800192, -0.856513, -0.131801, 0.078736,
-0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000,
0.475287, 1.317816, 0.559387, -0.369923, -0.398851, -0.331418, 0.313985, 0.686782,
0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -1.500000,
0.361111, -0.333333, 0.376054, 1.295211, -0.389272, -0.508429, 0.375862, 0.424904,
-1.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000,
-0.500000, 1.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000,
-0.319444, -0.513889, 0.402778, -0.541667, -0.388889, -0.444444, -0.319444, -1.236111,
0.133716, 0.485249, 1.189080, 0.526437, 0.392146, 0.464559, 0.396360, -0.270307,
-0.377714, -0.419860, 0.400383, 1.254949, -0.370370, -0.582216, -0.249361, 0.478608,
-0.500000, -0.500000, 0.500000, -0.500000, 1.500000, -0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 1.500000, -0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 1.500000, 0.500000,
0.036159, -0.085010, -0.156370, -0.605843, 1.021312, 0.870211, -0.008621, -0.822797,
0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 1.000000, 0.000000, -1.000000,
0.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000, 0.000000, -1.000000,
1.052363, 0.882184, -0.740421, -0.039272, 0.064176, 0.101852, -0.873244, -0.179438,
1.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000,
1.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000,
-0.992417, -0.970227, -0.785760, -0.135457, -0.069205, -0.152778, -0.784163, -0.159722,
0.006944, 0.021073, 0.128352, 0.910920, 0.728688, 0.833333, 0.314655, 0.903736,
0.125000, -0.083333, 0.027778, -0.875000, 0.791667, 0.013889, 0.763889, -0.791667,
0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, 1.000000, -1.000000,
0.152778, -0.041667, 0.055556, 1.013889, 0.833333, -0.041667, -1.069444, -1.013889,
1.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.750000, -0.916667, 1.013889, 0.097222, 0.111111, -1.097222, 0.166667, -0.125000,
1.069444, -0.944444, -0.944444, 0.083333, -0.208333, 0.861111, -0.208333, 0.013889,
-0.830779, -1.002395, -0.800447, -0.079821, -0.228289, -0.673851, -0.161558, 0.049170,
0.138889, 0.055556, -0.013889, 0.875000, 0.861111, 0.083333, 0.750000, 0.819444,
-0.902778, 0.138889, 0.055556, -0.958333, 1.194444, -0.055556, -0.111111, -0.750000,
-1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 0.722222, -1.013889, -0.152778, -0.013889, -1.208333, -0.819444, 0.000000,
0.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000,
-0.296296, 0.398148, 0.462963, -0.444444, 1.370370, 0.509259, 0.379630, -0.296296,
-0.500000, 0.500000, 0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000,
0.472222, 1.375000, -0.736111, 0.333333, 0.388889, -0.583333, -0.527778, 0.458333,
0.500000, -0.500000, 1.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
-0.092593, 0.138889, 0.120370, -0.685185, -0.074074, 1.037037, 0.842593, -0.787037,
0.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000, 1.000000, -1.000000,
0.083333, -0.097222, 0.069444, 0.972222, 0.152778, 0.666667, -0.958333, -1.097222,
-0.917800, -0.978693, -0.708069, -0.086774, -0.757858, -0.234186, 0.017926, 0.049672,
-1.111111, 0.041667, -0.027778, -0.916667, -0.055556, 0.708333, -0.194444, -0.819444,
-1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000,
1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.000000, -1.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000,
-0.004789, -0.977586, -1.049808, -0.103448, 1.151724, -0.125096, -0.871648, 0.052107,
0.000000, -1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, 1.000000,
-0.506386, 0.378991, 0.443806, -0.341635, 0.392082, 1.238506, 0.414432, -0.385696,
-0.500000, 0.500000, 0.500000, 1.500000, 0.500000, -0.500000, 0.500000, -0.500000,
0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -1.500000,
0.500000, 1.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
0.500000, -0.500000, 1.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
0.527778, -0.453704, -0.564815, 0.342593, 1.518519, 0.370370, -0.537037, 0.370370,
0.611111, -0.435185, -0.361111, 0.351852, -0.472222, 0.481481, 1.185185, 0.527778,
-1.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
-0.958333, -0.111111, 0.152778, -1.027778, -0.097222, 0.027778, 0.791667, -0.958333,
-1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000, -1.000000,
1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000,
-0.129630, -0.722222, 0.907407, 0.203704, -0.888889, -1.092593, 0.000000, 0.064815,
0.000000, -1.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000,
0.000000, -1.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000,
-0.651660, -0.078225, 0.193806, 0.925607, -0.035441, 0.170817, 0.830460, 1.022350,
-0.375000, 0.555556, 0.694444, -0.416667, 0.208333, 0.402778, 1.541667, -0.430556,
-0.231481, 0.555556, 0.555556, 1.370370, 0.685185, 0.444444, -0.370370, -0.379630,
0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -1.500000,
0.500000, 1.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000,
0.500000, -0.500000, 1.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000,
0.500000, -0.500000, -0.500000, 0.500000, 1.500000, -0.500000, 0.500000, 0.500000,
0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 1.500000, 0.500000, 0.500000,
-1.546296, -0.583333, -0.250000, 0.222222, -0.648148, -0.444444, 0.361111, 0.527778,
-1.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000,
-0.553448, -0.527874, -0.434579, 0.189943, -0.377107, -0.348563, -0.597989, -1.305077,
-0.500000, 1.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000,
-0.388889, -0.416667, 1.458333, 0.722222, -0.319444, -0.361111, -0.347222, 0.527778,
-0.082695, 0.143040, -0.040230, -0.128033, -0.912197, 0.710728, 0.781609, -0.757663,
0.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 1.000000, -1.000000,
-0.021871, -0.015805, 0.005907, -0.019955, 0.901341, 0.789432, -0.896711, -0.861750,
-0.765509, -0.812366, -0.830073, -0.770710, -0.039182, -0.036180, -0.023896, -0.034498,
-1.009259, 0.037037, -0.138889, -0.222222, -1.018519, 0.916667, 0.055556, -1.018519,
-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000,
0.845307, 0.098060, -0.081058, -0.079143, 0.954143, 0.878592, -0.068846, -0.686303,
0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, -1.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.063937, -0.905172, -0.776580, 0.785920, 0.149904, -0.220307, -0.678640, 0.098659,
-0.065773, -0.897510, -0.912197, -0.813538, 0.020754, 0.091954, 0.605364, 0.174010,
-0.805556, -0.111111, 0.000000, -0.069444, 0.805556, 0.930556, 0.166667, 0.833333,
-0.410920, 0.579183, 0.499042, 0.298851, -0.621009, 1.323436, 0.676245, -0.480843,
-0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000, 0.500000, -0.500000,
0.347914, -0.223712, -0.607812, -0.566411, 0.525436, 0.369838, -0.480949, -1.321094,
0.500000, 1.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
0.500000, -0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
0.388889, -0.398148, -0.231481, 1.259259, 0.416667, 0.388889, -0.444444, 0.657407,
0.416667, -0.250000, -0.509259, -0.444444, 0.259259, 0.583333, 1.277778, 0.435185,
-1.402778, -0.375000, -0.444444, -0.277778, 0.416667, 0.486111, -0.472222, 0.305556,
-1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000, 1.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000, -1.000000,
1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000,
0.000000, 1.000000, -1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.000000, -1.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.027778, -0.875000, -0.888889, 0.708333, 0.027778, -0.986111, -0.097222, 0.166667,
-0.083333, -1.069444, -0.986111, -0.986111, -0.027778, 0.597222, 0.041667, -0.041667,
-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, 1.000000,
-0.458333, 0.319444, 0.430556, 0.513889, -0.402778, 0.388889, 1.305556, -0.236111,
-0.208333, 0.402778, 0.527778, 0.486111, 1.458333, 0.513889, -0.638889, -0.625000,
0.347222, -0.541667, -0.444444, -0.416667, 0.486111, -0.388889, 0.180556, -1.333333,
0.500000, 1.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
0.268519, -0.435185, 1.370370, -0.407407, 0.379630, -0.490741, 0.694444, 0.314815,
0.324074, -0.444444, -0.453704, 1.388889, 0.259259, -0.481481, 0.462963, 0.490741,
0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 1.500000, 0.500000, 0.500000,
-1.611111, -0.666667, -0.500000, -0.416667, 0.291667, -0.263889, 0.347222, 0.500000,
-1.537037, 0.416667, 0.333333, 0.287037, -0.462963, 0.462963, 0.351852, -0.361111,
-0.289272, -0.583493, -0.500160, -0.408206, 0.213522, -0.277538, -0.609914, -1.289272,
-0.500000, 1.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 1.500000, -0.500000, 0.500000,
-1.000000, 0.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000,
1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000,
-0.090198, -0.868614, -1.021153, -0.949952, 0.688218, 0.078225, -0.000399, 0.032088,
-0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000,
-0.486111, 0.486111, 0.250000, 0.361111, 0.430556, 1.361111, -0.361111, -0.319444,
0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -1.500000,
0.327331, -0.406833, -0.490805, -0.414751, 1.283589, 0.596807, 0.421201, 0.386398,
-1.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
-0.337165, -0.320881, -0.527778, -0.527538, -0.383621, 0.155172, -0.489224, -1.353927,
0.423052, 0.626756, 0.625160, 0.259579, 0.551937, 1.186143, 0.637931, -0.212857,
-0.351852, 1.111111, -0.462963, -0.324074, -0.361111, 0.611111, -0.453704, 0.333333,
-0.500000, -0.500000, 1.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
-0.458333, -0.388889, -0.486111, 1.527778, -0.458333, 0.138889, -0.388889, 0.583333,
-0.543103, -0.491379, -0.344828, -0.370690, 1.258621, 0.491379, -0.284483, 0.396552,
-0.305556, -0.444444, -0.361111, -0.569444, -0.458333, 0.347222, 1.402778, 0.569444,
-1.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000,
-0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -1.500000,
0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000,
-0.500000, 1.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000,
-0.305556, -0.500000, 1.277778, -0.569444, -0.375000, -0.347222, 0.333333, 0.500000,
-0.466954, -0.598180, -0.324473, 1.325192, -0.538793, -0.579981, 0.397031, 0.516284,
-0.500000, -0.500000, -0.500000, -0.500000, 1.500000, -0.500000, 0.500000, 0.500000,
-0.638889, -0.541667, -0.305556, -0.430556, -0.513889, 1.388889, 0.611111, 0.375000,

};
static float Shell2TPCCodebook[800*8] = {
1.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000, 0.500000,
0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -1.500000,
-0.500000, -0.500000, 1.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
1.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
0.550000, 0.570000, 0.490000, 0.350000, 1.610000, 0.370000, -0.350000, 0.190000,
-0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -1.500000, -0.500000,
0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -1.500000,
-0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 1.500000, 0.500000, -0.500000,
-0.500000, -0.500000, -0.500000, 1.500000, 0.500000, -0.500000, 0.500000, -0.500000,
-0.500000, -0.500000, 1.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
-0.500000, 1.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
1.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000,
0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -1.500000, -0.500000, -0.500000,
0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -1.500000,
-0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 1.500000, -0.500000,
-0.500000, -0.500000, -0.500000, 1.500000, 0.500000, 0.500000, -0.500000, -0.500000,
-0.500000, -0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000,
-0.500000, 1.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000,
1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000, 0.000000,
1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000,
0.109756, 0.792683, 0.865854, 0.890244, -0.121951, 0.024390, -0.036585, -0.841463,
0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -1.500000, -0.500000,
0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -1.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -1.500000,
1.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000,
0.500000, 0.500000, 0.500000, 1.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -1.500000, -0.500000,
0.538049, 0.572846, 0.408618, -0.401138, 0.407967, 0.309431, -0.522764, -1.207317,
-0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 1.500000, 0.500000, -0.500000,
-0.500000, -0.500000, -0.500000, 0.500000, 1.500000, -0.500000, 0.500000, -0.500000,
-0.500000, -0.500000, 1.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000,
-0.500000, 1.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000,
1.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000,
0.500000, 0.500000, 0.500000, 1.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -1.500000, -0.500000, -0.500000,
0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -1.500000,
-0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 1.500000, -0.500000,
-0.500000, -0.500000, -0.500000, 0.500000, 1.500000, 0.500000, -0.500000, -0.500000,
-0.500000, -0.500000, 1.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000,
-0.500000, 1.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000,
1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000, 0.000000,
1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, 1.000000, 0.000000,
0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -1.500000, -0.500000,
0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -1.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 1.500000, 0.500000, -0.500000, -0.500000, 0.500000,
-1.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
1.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000,
0.257195, 0.502805, 0.666463, 1.115000, -0.311341, 0.224268, 0.512317, 0.561585,
-0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000,
-0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000,
1.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, -1.000000, 0.000000,
1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 1.000000, 0.000000,
0.000000, -1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000,
0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -1.500000, -0.500000,
0.500000, -0.500000, -0.500000, 0.500000, -1.500000, -0.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 1.500000, -0.500000, 0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -1.500000,
-1.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
0.310000, -0.410000, -0.530000, 0.470000, 0.550000, 1.470000, 0.210000, -0.530000,
0.500000, -0.500000, 1.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
1.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000, 0.000000, 0.000000,
1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 1.000000, 0.000000, 0.000000,
-0.982114, -0.249431, 0.021463, 0.737561, -0.820813, -0.935610, -0.011707, 0.091057,
0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 1.000000, 1.000000, 1.000000, 0.000000, 0.000000,
0.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000, -1.000000,
0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -1.500000, -0.500000, -0.500000,
0.500000, -0.500000, -0.500000, 0.500000, -1.500000, 0.500000, -0.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000, 0.500000, 0.500000,
-0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -1.500000,
-1.500000, -0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000,
0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000,
0.500000, -0.500000, 1.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000,
0.500000, 1.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000,
0.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 1.000000, 0.000000,
0.130000, -0.030000, 0.130000, 0.730000, 0.930000, 0.920000, 0.690000, 0.240000,
1.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000,
0.500000, 0.500000, 1.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -1.500000,
-0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 1.500000, 0.500000, -0.500000,
1.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000,
0.500000, 0.500000, 1.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 1.500000, -0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, 1.500000, 0.500000, -0.500000, -0.500000,
1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000,
1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.000000, 1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
-1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000,
0.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -1.500000, -0.500000,
0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -1.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 1.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -1.500000,
-1.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
0.500000, -0.500000, 0.500000, -0.500000, 1.500000, 0.500000, 0.500000, -0.500000,
0.500000, -0.500000, 0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000,
0.500000, 1.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
1.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000,
0.286667, 0.673333, 1.446667, 0.513333, -0.300000, 0.420000, 0.700000, 0.366667,
-0.500000, -0.500000, 0.500000, -0.500000, -1.500000, -0.500000, -0.500000, -0.500000,
0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -1.500000,
-0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 1.500000, -0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 1.500000, -0.500000, -0.500000,
-0.500000, -0.500000, 0.500000, 1.500000, 0.500000, -0.500000, -0.500000, -0.500000,
-0.500000, 1.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000,
1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000,
1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000,
0.000000, 1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.000000, -1.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -1.500000, -0.500000,
0.500000, -0.500000, 0.500000, -0.500000, -1.500000, -0.500000, 0.500000, -0.500000,
-0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -1.500000,
0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 1.500000, 0.500000, -0.500000,
1.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000,
1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000,
-0.840000, -0.100000, 0.700000, -0.040000, -1.160000, -0.960000, -0.040000, -0.020000,
-1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000,
0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -1.500000, -0.500000, -0.500000,
0.500000, -0.500000, 0.500000, -0.500000, -1.500000, 0.500000, -0.500000, -0.500000,
-0.373821, 0.435285, 1.230407, 0.440163, -0.455122, -0.341301, 0.650569, 0.703902,
-1.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000,
0.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 1.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 1.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
-0.090000, 0.070000, 0.520000, 0.060000, 0.980000, 1.030000, 0.910000, 0.090000,
-1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
1.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
0.892033, 1.010407, -0.017886, -0.858537, 0.212358, 0.163577, -0.053008, -0.958699,
1.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000,
0.500000, 0.500000, 1.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -1.500000, -0.500000, -0.500000, -0.500000, -0.500000,
0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -1.500000,
-0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 1.500000, -0.500000,
-0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000, -0.500000,
-0.500000, -0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000, -0.500000,
-0.500000, 1.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000,
1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, 1.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, -1.000000,
0.330000, -0.430000, 0.630000, 0.530000, -0.650000, -0.750000, -1.470000, -0.610000,
0.500000, -0.500000, 0.500000, -1.500000, -0.500000, -0.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -1.500000,
1.000000, 0.000000, 1.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000,
-1.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
-1.100000, -0.060000, 0.940000, 0.760000, -0.040000, 0.760000, 0.080000, 0.020000,
0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -1.500000, -0.500000, -0.500000,
0.500000, -0.500000, 0.500000, -1.500000, -0.500000, 0.500000, -0.500000, -0.500000,
-0.500000, 0.500000, 1.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-1.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000,
-0.200000, 0.020000, 1.060000, 0.860000, -0.100000, -1.060000, -0.860000, -0.020000,
0.000000, 0.000000, 1.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
-0.050732, 0.122927, 0.843089, 0.997886, 0.192520, 0.894959, 0.906016, 0.229919,
-1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, 1.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
1.000000, 0.000000, 1.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000,
-1.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000,
-1.000000, 0.000000, 1.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000,
0.060000, -0.940000, 0.120000, 0.100000, 0.100000, -1.020000, 0.840000, -0.760000,
0.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000,
0.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, -1.000000, -1.000000,
0.500000, -0.500000, 0.500000, 0.500000, -1.500000, -0.500000, -0.500000, -0.500000,
0.500000, -0.500000, 0.500000, -1.500000, 0.500000, -0.500000, -0.500000, -0.500000,
-0.500000, 0.500000, 1.500000, -0.500000, -0.500000, 0.500000, 0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -1.500000,
-1.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000,
0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000,
0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000,
0.500000, 1.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000,
0.000000, 0.000000, 1.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.000000, 0.000000, 1.000000, -1.000000, 1.000000, 0.000000, -1.000000, 0.000000,
0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 1.000000, 0.000000,
0.000000, 0.000000, 1.000000, 1.000000, 1.000000, 0.000000, 1.000000, 0.000000,
0.000000, -0.040000, 0.880000, 0.680000, -0.820000, -1.060000, -0.040000, -0.060000,
0.000000, 0.000000, 1.000000, -1.000000, 1.000000, -1.000000, 0.000000, 0.000000,
0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 1.000000, 0.000000, 0.000000,
0.173333, 0.200000, 0.826667, 0.760000, 0.800000, 0.880000, 0.053333, -0.080000,
1.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000,
0.500000, 1.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 1.500000, 0.500000, -0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, 1.500000, -0.500000, 0.500000, -0.500000,
1.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000,
0.500000, 1.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -1.500000,
-0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 1.500000, -0.500000,
1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000,
1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 1.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
-0.860000, 0.920000, 0.200000, -0.020000, 0.060000, 1.080000, 1.000000, 0.180000,
0.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -1.500000, -0.500000,
0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -1.500000, 0.500000, -0.500000,
-0.500000, 1.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -1.500000,
-1.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
0.500000, 0.500000, -0.500000, -0.500000, 1.500000, 0.500000, 0.500000, -0.500000,
0.500000, 0.500000, -0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000,
0.500000, 0.500000, 1.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
1.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000,
0.553333, 1.273333, 0.620000, 0.380000, -0.433333, 0.486667, 0.753333, 0.566667,
-0.270000, 0.290000, -0.410000, -0.490000, -1.490000, -0.690000, -0.450000, -0.730000,
0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -1.500000,
-0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 1.500000, -0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 1.500000, -0.500000, -0.500000,
-0.500000, 0.500000, -0.500000, 1.500000, 0.500000, -0.500000, -0.500000, -0.500000,
-0.500000, 0.500000, 1.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000,
0.960000, 0.720000, 0.060000, 0.080000, 0.840000, -0.040000, -0.840000, -0.080000,
0.800000, 0.900000, 0.260000, -0.020000, -1.000000, -0.040000, 0.820000, 0.060000,
-1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000,
-1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000,
0.559634, 0.356951, -0.463780, -0.418171, 0.435976, -0.340366, -1.256707, -0.665732,
0.500000, 0.500000, -0.500000, -0.500000, -1.500000, -0.500000, 0.500000, -0.500000,
-0.500000, 1.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
-1.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
1.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000,
1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000,
0.040000, 0.080000, 0.826667, 0.946667, 0.000000, 0.093333, 0.760000, -0.906667,
0.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -1.500000, -0.500000, -0.500000,
0.500000, 0.500000, -0.500000, -0.500000, -1.500000, 0.500000, -0.500000, -0.500000,
-0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -1.500000,
0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 1.500000, -0.500000,
0.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000,
0.000000, 1.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000,
0.000000, 1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
0.000000, 1.000000, 0.000000, 0.000000, 1.000000, 1.000000, 1.000000, 0.000000,
-0.764553, 0.031220, -0.714472, -0.880976, -0.013333, 0.113171, 0.016260, -0.746992,
1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
1.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000,
0.500000, 1.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000,
-0.257724, 0.426504, -0.524065, -1.264228, -0.638537, -0.470732, -0.427154, -0.522439,
0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -1.500000,
-0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 1.500000, -0.500000,
-0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 1.500000, -0.500000, -0.500000,
-0.500000, 0.500000, -0.500000, 0.500000, 1.500000, -0.500000, -0.500000, -0.500000,
-0.500000, 0.500000, 1.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000,
1.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
1.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000,
-1.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
-1.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000,
0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -1.500000, -0.500000,
0.500000, 0.500000, -0.500000, -1.500000, -0.500000, -0.500000, 0.500000, -0.500000,
-0.500000, 1.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-1.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000,
1.000000, 1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
1.000000, 1.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000,
-1.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000,
0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -1.500000, -0.500000, -0.500000,
0.500000, 0.500000, -0.500000, -1.500000, -0.500000, 0.500000, -0.500000, -0.500000,
-0.500000, 1.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -1.500000,
0.000000, 1.000000, 0.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.000000, 1.000000, 0.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000,
0.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
1.000000, 1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000,
-1.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000,
-1.000000, 1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000,
0.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000,
0.000000, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000,
-0.013333, 0.226667, 0.853333, 0.093333, -0.026667, -0.826667, -0.906667, -0.906667,
0.500000, 0.500000, -0.500000, 0.500000, -1.500000, -0.500000, -0.500000, -0.500000,
0.330000, 0.510000, -0.390000, -1.410000, 0.470000, -0.210000, -0.310000, -0.490000,
-0.500000, 1.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -1.500000,
-1.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000,
0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000,
0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000,
0.500000, 0.500000, 1.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000,
0.000000, 1.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.000000, 1.000000, 0.000000, -1.000000, 1.000000, 0.000000, -1.000000, 0.000000,
0.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 1.000000, 0.000000,
0.000000, 1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 1.000000, 0.000000,
0.000000, 1.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000,
0.000000, 1.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000, 0.000000,
0.000000, 1.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000, 0.000000,
0.000000, 1.000000, 0.000000, 1.000000, 1.000000, 1.000000, 0.000000, 0.000000,
1.255000, 0.695000, 0.225000, -0.345000, -0.545000, -0.435000, -0.485000, -0.515000,
0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -1.500000,
0.500000, 1.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000,
-0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 1.500000, -0.500000,
1.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 1.000000, 0.000000, -1.000000,
1.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000,
-1.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000,
-0.740000, 0.920000, 0.800000, -0.100000, 0.040000, 0.040000, 0.820000, 0.000000,
0.000000, 0.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000, -1.000000,
0.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000, -1.000000,
0.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, -1.000000,
0.550000, 0.470000, 0.430000, -0.190000, -0.650000, -0.470000, -1.350000, -0.490000,
-0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -1.500000,
0.500000, 0.500000, -1.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000,
-0.500000, 1.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-1.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000,
0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 1.500000, 0.500000, -0.500000,
0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000, 0.500000, -0.500000,
0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000, 0.500000, -0.500000,
1.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 1.000000, -1.000000,
1.000000, 1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000,
-1.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000,
-1.000000, 1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000,
0.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000, 1.000000, -1.000000,
0.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000, -1.000000, -1.000000,
0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000, -1.000000,
0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -1.500000, -0.500000, -0.500000,
-0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -1.500000,
0.500000, 0.500000, -1.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000,
-0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-1.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000,
0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 1.500000, -0.500000,
0.500000, 0.500000, 0.500000, -0.500000, 1.500000, 0.500000, -0.500000, -0.500000,
0.500000, 0.500000, 0.500000, 1.500000, -0.500000, 0.500000, -0.500000, -0.500000,
0.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000,
0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000,
0.024390, 0.768293, 0.987805, 0.158537, 0.093496, 0.800813, 0.829268, 0.130081,
-1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 1.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000,
0.080000, 0.040000, 0.240000, 0.980000, 0.240000, 1.000000, 1.080000, -0.840000,
1.000000, 1.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000,
-1.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000,
0.500000, 0.500000, 0.500000, -0.500000, -1.500000, -0.500000, -0.500000, -0.500000,
-0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -1.500000,
0.500000, 0.500000, -1.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000,
-0.500000, 1.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000,
0.000000, 1.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000,
0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000,
0.000000, 1.000000, 1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000, -1.000000,
1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000,
0.000000, 1.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000,
-1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000,
0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000,
0.256098, 0.951220, 0.731707, 0.140244, 1.030488, 0.926829, 0.158537, -0.024390,
-1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000, -1.000000,
1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000, -1.000000,
1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000, -1.000000,
0.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 1.000000, -1.000000,
1.000000, 1.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 0.000000,
-1.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 0.000000,
-1.000000, 1.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 0.000000,
-0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -1.500000,
0.500000, 0.500000, -1.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000,
-0.410000, 1.210000, -0.650000, -0.670000, 0.450000, 0.370000, 0.370000, 0.490000,
-1.410000, 0.650000, 0.490000, 0.550000, -0.430000, -0.210000, -0.390000, -0.330000,
-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, -1.000000,
0.000000, 1.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, 1.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000,
0.050000, 0.730000, 0.990000, 0.960000, 0.000000, 0.050000, 0.660000, 0.150000,
-1.000000, 0.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000, -1.000000,
1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000, -1.000000,
1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000,
0.000000, 1.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.000000, 1.000000, -1.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000,
0.079268, 0.922927, 0.986585, 0.853415, -0.020488, 0.637317, 0.266341, 0.106098,
-0.826667, -0.146667, -0.133333, -0.026667, -0.866667, -0.093333, -0.853333, -0.706667,
1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000, 1.000000, -1.000000,
1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000,
0.000000, 1.000000, -1.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
0.000000, 1.000000, -1.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000,
0.160000, 0.900000, 1.000000, 0.880000, 0.720000, -0.160000, 0.100000, -0.020000,
0.250000, -0.350000, -0.510000, -0.730000, -0.670000, -0.430000, -0.570000, -1.430000,
-0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -1.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -1.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 0.500000, -1.500000, 0.500000, 0.500000, -0.500000,
1.680000, 0.080000, -0.040000, -0.020000, 0.180000, 0.080000, 0.000000, 0.060000,
0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -2.000000, 0.000000,
0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -2.000000, 0.000000, 0.000000,
-0.053333, 0.040000, -0.240000, -1.760000, -0.026667, -0.026667, -0.106667, -0.146667,
1.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000,
0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -1.500000, 0.500000,
0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -1.500000, 0.500000, 0.500000,
0.500000, 0.500000, 0.500000, -1.500000, 0.500000, 0.500000, 0.500000, 0.500000,
1.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
0.190000, -0.390000, -0.470000, -0.410000, -0.430000, -0.610000, -1.310000, -0.610000,
-0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -1.500000, -0.500000, 0.500000,
-0.500000, 0.500000, 0.500000, 0.500000, -1.500000, 0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, 0.500000, -1.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -1.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-0.500000, -1.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 1.500000,
1.330000, 0.690000, 0.610000, 0.470000, 0.450000, -0.230000, 0.430000, 0.390000,
0.590000, -0.450000, -0.370000, -0.330000, -0.450000, -1.270000, -0.630000, -0.430000,
-0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -1.500000, 0.500000,
-0.500000, 0.500000, 0.500000, 0.500000, -1.500000, -0.500000, 0.500000, 0.500000,
-0.500000, 0.500000, 0.500000, -1.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-0.500000, 0.500000, -1.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
-0.500000, -1.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 1.500000,
1.313333, 0.620000, 0.353333, 0.446667, -0.246667, 0.593333, 0.553333, 0.540000,
-0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -1.500000, 0.500000,
-0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -1.500000, 0.500000, 0.500000,
-0.500000, 0.500000, 0.500000, -1.500000, -0.500000, 0.500000, 0.500000, 0.500000,
0.880000, -0.220000, -0.100000, -0.200000, 0.920000, -0.940000, -0.840000, 0.000000,
1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000,
1.000000, 0.000000, 0.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000,
-0.739593, -0.333984, -0.024228, 0.015122, -0.847073, -0.906748, -0.678537, -0.137805,
1.273333, 0.484065, 0.212520, -0.318211, 0.346504, 0.336098, 0.403415, 0.370894,
-0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -1.500000, 0.500000,
-0.500000, 0.500000, 0.500000, -0.500000, -1.500000, 0.500000, 0.500000, 0.500000,
-0.500000, 0.500000, -1.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000,
1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000,
1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000,
1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000, -1.000000, 0.000000,
1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000,
1.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000, -1.000000, 0.000000,
1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000,
0.000000, -1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000,
1.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000,
1.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000, 0.000000,
1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000, 0.000000,
-0.840000, -0.100000, 0.080000, -0.680000, -1.000000, -0.820000, 0.040000, 0.040000,
0.032000, 0.880000, 1.008000, 0.064000, -0.272000, 0.280000, 1.008000, 0.952000,
0.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, -1.000000,
-0.025203, -0.006179, 0.102114, 0.470407, -0.972683, -0.997398, -0.887967, -0.051382,
0.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 0.000000, -1.000000, -1.000000, 1.000000, -1.000000, 0.000000,
0.000000, 0.000000, 0.000000, -1.000000, -1.000000, -1.000000, 1.000000, 0.000000,
0.625000, 0.525000, 0.515000, 1.115000, -0.505000, -0.515000, -0.355000, 0.255000,
0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000, -0.500000, 0.500000,
0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 1.500000, -0.500000, 0.500000,
0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 1.500000, 0.500000,
1.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000,
0.500000, -0.500000, -1.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000,
-0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -1.500000, 0.500000,
-0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -1.500000, 0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, 0.500000, -1.500000, 0.500000, 0.500000, 0.500000,
-0.550000, 0.210000, -0.470000, -1.330000, 0.570000, 0.590000, 0.430000, 0.350000,
-0.371951, -1.250000, -0.554878, 0.493902, 0.396341, 0.274390, 0.298780, 0.542683,
0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 1.500000,
1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.000000, -1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000,
1.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.000000, 1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 1.000000,
0.000000, 1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.000000, -1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
1.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000,
-1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000,
1.000000, 0.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000,
0.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000,
1.000000, 0.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000,
-1.000000, 0.000000, -1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000,
0.000000, 0.100000, 0.880000, 0.020000, -0.860000, -0.940000, -0.740000, -0.120000,
-1.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
0.000000, 0.000000, -1.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000,
0.000000, 0.000000, -1.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000,
0.000000, 0.000000, -1.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000,
-1.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
1.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
0.500000, 0.500000, 1.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, 1.500000, 0.500000, 0.500000, 0.500000, -0.500000,
0.500000, 0.500000, -0.500000, 0.500000, 1.500000, -0.500000, -0.500000, 0.500000,
0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 1.500000, -0.500000, 0.500000,
0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 1.500000, 0.500000,
-1.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, 1.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000,
0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -1.500000,
0.000000, -1.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, -1.000000,
1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
-1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000,
1.000000, 0.000000, -1.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.920000, 0.040000, -1.000000, -1.000000, 0.100000, 0.760000, 0.220000, 0.240000,
-1.000000, 0.000000, -1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
-1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.000000, 0.000000, -1.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.000000, 0.000000, -1.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000,
0.000000, 0.000000, -1.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000,
-1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
-0.500000, -0.500000, 0.500000, 0.500000, 1.500000, 0.500000, 0.500000, -0.500000,
0.500000, 0.500000, 1.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
0.500000, 0.500000, -0.500000, 1.500000, 0.500000, -0.500000, -0.500000, 0.500000,
0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 1.500000, -0.500000, 0.500000,
0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 1.500000, 0.500000,
-1.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, 1.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -1.500000,
0.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000,
1.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
1.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
0.776585, 0.050407, -0.806829, -0.968130, 0.905366, 0.057561, -0.193171, -0.138211,
-1.000000, 0.000000, -1.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 1.000000,
0.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000,
0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000,
-0.960000, -0.880000, -0.040000, 0.060000, 0.000000, 0.880000, -0.180000, -0.740000,
0.000000, 0.000000, 1.000000, -1.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.080000, 0.000000, -0.760000, -1.220000, 0.900000, -0.140000, -0.920000, -0.020000,
-0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 1.500000, 0.500000, -0.500000,
0.500000, 0.500000, 1.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
0.500000, 0.500000, -0.500000, 1.500000, -0.500000, 0.500000, -0.500000, 0.500000,
0.500000, 0.500000, -0.500000, -0.500000, 1.500000, 0.500000, -0.500000, 0.500000,
-1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.000000, 0.000000, -1.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000,
0.000000, 0.000000, -1.000000, -1.000000, 1.000000, -1.000000, 0.000000, 0.000000,
0.000000, 0.000000, -1.000000, -1.000000, -1.000000, 1.000000, 0.000000, 0.000000,
-0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000,
0.500000, 0.500000, -0.500000, 1.500000, -0.500000, -0.500000, 0.500000, 0.500000,
0.500000, 0.500000, -0.500000, -0.500000, 1.500000, -0.500000, 0.500000, 0.500000,
0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 1.500000, 0.500000, 0.500000,
-1.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 1.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, 1.500000, -0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, 1.500000, -0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 1.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 1.500000, 0.500000,
-0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -1.500000,
0.500000, 1.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000,
1.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000,
0.500000, -1.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000,
-0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -1.500000, 0.500000,
-0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -1.500000, 0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, 0.500000, -1.500000, 0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -1.500000, 0.500000, 0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, -1.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000,
0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 1.500000,
1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.000000, 0.000000, -1.000000, 1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 0.000000, 1.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 0.000000, 1.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000,
1.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-0.800000, -0.830000, -0.230000, 0.020000, -0.150000, -0.910000, -0.980000, -0.120000,
0.000000, 0.000000, 1.000000, 1.000000, 1.000000, 0.000000, 0.000000, 1.000000,
1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.000000, 0.000000, -1.000000, 1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.000000, 0.000000, 1.000000, -1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
-1.013333, -1.040000, -0.186667, -0.066667, -0.920000, -0.333333, -0.973333, -0.133333,
1.000000, 1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000,
0.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.160000, -0.060000, 0.940000, -0.760000, 0.040000, 0.200000, 0.780000, -0.940000,
-0.894098, -0.680195, -0.091951, 0.006780, -0.842195, -0.859805, -0.163610, -0.030976,
0.000000, 1.000000, 0.000000, 0.000000, -1.000000, -1.000000, -1.000000, 0.000000,
-1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
-1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000,
0.080000, -0.860000, 0.000000, -0.040000, 0.800000, -1.000000, -0.880000, 0.020000,
0.000000, -1.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000, 0.000000,
0.000000, -1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000,
0.500000, 1.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, 0.500000, -0.500000, 1.500000, 0.500000, 0.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 1.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000,
0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -1.500000,
0.500000, -0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000, 0.500000,
0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000, 0.500000,
0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 1.500000, 0.500000,
-1.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000,
0.000000, 0.000000, -1.000000, 0.000000, 1.000000, 1.000000, 0.000000, -1.000000,
0.000000, 0.000000, 1.000000, 0.000000, -1.000000, 1.000000, 0.000000, -1.000000,
0.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000,
-1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000,
1.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
0.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000, 1.000000, -1.000000,
-1.140000, -0.900000, -0.240000, -0.960000, -0.060000, -0.740000, 0.000000, 0.000000,
-1.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000, -1.000000, 0.000000,
-1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000, 0.000000, -1.000000,
1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000,
0.040000, -0.800000, -0.080000, 0.840000, -0.020000, -0.900000, -0.820000, 0.020000,
0.000000, -1.000000, 0.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000,
0.000000, -1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000,
-0.500000, 0.500000, -0.500000, 0.500000, 1.500000, 0.500000, 0.500000, -0.500000,
0.510000, 1.310000, 0.530000, -0.710000, 0.570000, -0.390000, -0.550000, 0.410000,
-0.500000, 0.500000, 1.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -1.500000,
0.500000, -0.500000, 0.500000, 1.500000, 0.500000, -0.500000, -0.500000, 0.500000,
0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 1.500000, -0.500000, 0.500000,
0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 1.500000, 0.500000,
-1.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
0.000000, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000,
1.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
0.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000,
0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000,
1.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
1.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000,
-1.000000, -1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000,
0.012195, 0.121951, 0.841463, 0.256098, 0.036585, 0.902439, 1.134146, 0.951220,
-1.000000, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000,
-1.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, -1.000000,
1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000, -1.000000, 0.000000,
-0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 1.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 1.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -1.500000,
0.500000, -0.500000, 0.500000, -0.500000, 1.500000, 0.500000, -0.500000, 0.500000,
-1.000000, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.000000, 1.000000, 0.000000, -1.000000, -1.000000, -1.000000, 0.000000, 0.000000,
1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.160000, -1.020000, -0.100000, 0.800000, -0.940000, -0.840000, 0.160000, 0.120000,
-0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000,
0.500000, 1.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000,
0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -1.500000,
0.250000, -0.610000, 0.430000, 1.510000, -0.510000, -0.350000, 0.310000, 0.650000,
-1.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000,
-0.500000, 1.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -1.500000,
0.500000, 0.500000, 1.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000,
-0.500000, -0.500000, 0.500000, 1.500000, -0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, 1.500000, -0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 1.500000, -0.500000, 0.500000,
-0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 1.500000, 0.500000,
0.060000, 0.060000, -0.200000, -0.840000, 0.960000, 0.740000, -0.080000, -1.020000,
0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 1.000000, 0.000000, -1.000000,
0.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000, 0.000000, -1.000000,
1.000000, 1.000000, -1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000,
1.000000, -1.000000, 1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000,
1.000000, -1.000000, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000,
-0.920000, -0.820000, -1.080000, -0.160000, -0.040000, -0.060000, -0.720000, 0.100000,
0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 1.000000, 0.000000, 1.000000,
0.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000, 1.000000, -1.000000,
0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, 1.000000, -1.000000,
0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, -1.000000, -1.000000,
1.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000,
1.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000,
1.000000, -1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000,
-0.878049, -0.914634, -0.804878, -0.048780, -0.134146, -0.707317, -0.109756, 0.060976,
0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 1.000000, 1.000000,
-1.000000, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, -1.000000, 0.000000,
0.120000, -0.940000, 0.820000, -0.080000, -0.020000, -0.760000, -0.940000, -0.120000,
-0.500000, 0.500000, 0.500000, -0.500000, 1.500000, 0.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000,
0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
0.500000, -0.500000, 1.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
-0.080000, -0.060000, -0.140000, -0.980000, 0.140000, 1.020000, 0.920000, -0.880000,
0.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000, 1.000000, -1.000000,
0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000, -1.000000,
-1.089106, -0.942927, -0.657724, -0.106667, -0.877073, -0.271870, -0.120000, 0.012846,
-1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000,
1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, -1.000000,
0.000000, 1.000000, -1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.000000, -1.000000, 1.000000, 0.000000, -1.000000, 0.000000, -1.000000, 0.000000,
0.000000, -1.000000, -1.000000, 0.000000, 1.000000, 0.000000, -1.000000, 0.000000,
0.000000, -1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, 1.000000,
-0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 1.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 1.500000, 0.500000, -0.500000, 0.500000, -0.500000,
0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -1.500000,
0.500000, 1.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
0.500000, -0.500000, 1.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
0.500000, -0.500000, -0.500000, 0.500000, 1.500000, 0.500000, -0.500000, 0.500000,
0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 1.500000, 0.500000,
-1.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
-1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, -1.000000, -1.000000,
1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, -1.000000,
0.226667, 0.680000, -0.946667, -0.080000, -1.000000, -1.146667, 0.120000, 0.080000,
0.000000, -1.000000, 1.000000, 0.000000, -1.000000, -1.000000, 0.000000, 0.000000,
0.000000, -1.000000, -1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000,
0.000000, -1.000000, -1.000000, 0.000000, -1.000000, 1.000000, 0.000000, 0.000000,
-1.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000, 1.000000,
-0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 1.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 1.500000, 0.500000, 0.500000, -0.500000, -0.500000,
0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -1.500000,
0.500000, 1.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000,
0.500000, -0.500000, 1.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000,
0.500000, -0.500000, -0.500000, 0.500000, 1.500000, -0.500000, 0.500000, 0.500000,
0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 1.500000, 0.500000, 0.500000,
-1.513333, -0.366667, -0.073333, 0.526667, -0.340000, -0.673333, 0.313333, 0.566667,
-1.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000, -0.500000,
-0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -1.500000,
-0.500000, 1.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, 1.500000, 0.500000, -0.500000, -0.500000, -0.500000, 0.500000,
0.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, 1.000000, -1.000000,
0.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 1.000000, -1.000000,
0.040000, 0.120000, 0.100000, -0.080000, 0.860000, 0.740000, -0.920000, -0.960000,
-0.814344, -0.836202, -0.840343, -0.757453, -0.066796, -0.036984, -0.061955, -0.064003,
-1.100000, -0.040000, 0.060000, -0.080000, -0.900000, 0.840000, -0.100000, -0.820000,
-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, 0.000000, -1.000000,
1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, -1.000000,
0.000000, 1.000000, -1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, -1.000000, 1.000000, -1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, -1.000000, -1.000000, 1.000000, 0.000000, 0.000000, -1.000000, 0.000000,
0.000000, -1.000000, -1.000000, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000,
-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 1.000000,
-0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 1.500000, 0.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000, 0.500000, -0.500000,
0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -1.500000,
0.500000, 1.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
0.500000, -0.500000, 1.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
0.500000, -0.500000, -0.500000, 1.500000, 0.500000, 0.500000, -0.500000, 0.500000,
0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, 1.500000, 0.500000,
-1.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000,
-1.000000, 0.000000, 0.000000, 0.000000, -1.000000, 0.000000, 1.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, -1.000000, -1.000000,
1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, -1.000000,
0.000000, 1.000000, -1.000000, -1.000000, 0.000000, -1.000000, 0.000000, 0.000000,
-0.060000, -1.120000, 0.860000, -0.880000, 0.140000, -0.680000, 0.020000, -0.060000,
0.020000, -1.060000, -0.760000, 0.900000, -0.080000, -0.920000, -0.180000, 0.140000,
0.020000, -0.740000, -1.020000, -0.980000, -0.100000, 0.780000, 0.100000, -0.080000,
-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, 1.000000,
-0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 1.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 0.500000, 1.500000, 0.500000, -0.500000, -0.500000,
0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, -1.500000,
0.500000, 1.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
0.500000, -0.500000, 1.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000,
0.500000, -0.500000, -0.500000, 1.500000, 0.500000, -0.500000, 0.500000, 0.500000,
0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 1.500000, 0.500000, 0.500000,
-1.353333, -0.460000, -0.580000, -0.313333, 0.273333, -0.406667, 0.460000, 0.300000,
-1.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000,
-0.310000, -0.390000, -0.450000, -0.590000, 0.210000, -0.310000, -0.510000, -1.470000,
-0.500000, 1.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 1.500000, -0.500000, 0.500000,
-1.000000, 0.000000, 0.000000, 0.000000, 0.000000, -1.000000, 1.000000, -1.000000,
-1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.000000, -1.000000, -1.000000,
1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, -1.000000,
-0.064000, -0.968000, -0.888000, -0.856000, 0.888000, 0.048000, -0.072000, 0.152000,
-0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 1.500000, -0.500000,
-0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000, -0.500000,
0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -1.500000,
0.165000, -0.395000, -0.515000, -0.565000, 1.185000, 0.505000, 0.395000, 0.315000,
-1.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000,
-0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -1.500000,
0.396341, 0.737805, 0.554878, 0.274390, 0.530488, 1.347561, 0.384146, -0.481707,
-0.500000, 1.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, 1.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, -0.500000, 1.500000, -0.500000, 0.500000, -0.500000, 0.500000,
-0.500000, -0.500000, -0.500000, -0.500000, 1.500000, 0.500000, -0.500000, 0.500000,
-0.290000, -0.370000, -0.430000, -0.410000, -0.430000, 0.370000, 1.410000, 0.290000,
-1.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, -0.500000,
-0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -1.500000,
0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 1.500000, -0.500000,
-0.500000, 1.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, 0.500000,
-0.490000, -0.230000, 1.330000, -0.330000, -0.330000, -0.350000, 0.530000, 0.490000,
-0.500000, -0.500000, -0.500000, 1.500000, -0.500000, -0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, -0.500000, -0.500000, 1.500000, -0.500000, 0.500000, 0.500000,
-0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 1.500000, 0.500000, 0.500000,

};
#endif


/* ========================================================================= */
static int GN2GroupIndex[255] = { 
  /* For Shell 2 points: GN2GroupIndex[gn] = Address of first codebook entry 
   * for gn
   */
  0, 1, 2, 3, 4, 5, 0, 6, 7, 8, 1, 9, 2, 3, 4, 10, 11, 12, 5, 13, 6, 7,
  8, 14, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 15, 19, 16, 17, 18, 20,
  19, 20, 21, 22, 23, 24, 21, 22, 25, 26, 27, 28, 29, 30, 23, 31, 32,
  33, 24, 34, 25, 26, 27, 28, 29, 30, 35, 31, 36, 37, 38, 32, 39, 40,
  41, 42, 43, 44, 33, 34, 45, 46, 47, 48, 49, 50, 35, 51, 52, 53, 36,
  54, 37, 38, 39, 40, 55, 56, 57, 58, 59, 60, 41, 61, 62, 63, 42, 64,
  43, 44, 45, 65, 66, 67, 46, 68, 47, 48, 49, 69, 50, 51, 52, 53, 54,
  55, 70, 71, 72, 56, 73, 57, 74, 58, 59, 60, 75, 61, 62, 63, 64, 76,
  65, 66, 77, 67, 68, 69, 70, 78, 71, 72, 73, 79, 74, 80, 75, 81, 82,
  76, 83, 77, 78, 79, 80, 84, 81, 82, 83, 85, 84, 86, 85, 87, 88, 86,
  87, 89, 88, 90, 89, 91, 92, 93, 90, 94, 95, 96, 97, 91, 98, 92, 99,
  93, 94, 95, 96, 100, 97, 98, 99, 101, 100, 102, 101, 103, 104, 102,
  103, 105, 104, 106, 105, 107, 108, 109, 106, 110, 111, 112, 113, 107,
  114, 108, 109, 115, 110, 116, 111, 117, 118, 119, 112, 120, 121, 122,
  123, 113, 124, 125, 114, 126, 127, 128, 129, 115, 130, 131, 132, 116,
  133, 117, 134, 118, 119
};
/* ========================================================================= */
typedef struct {
  int VMemAddress;
  int Symmetry;
  float AddressVector[8];
} GroupDescriptorStruct;

static GroupDescriptorStruct Shell2Groups[135] = {
  /*  Holds: 1. Address of first codebook entry
   *         2. Type of symmetrie (0 = none)
   *         3. 'Address vector' to address a vector within
   *            the group.
   */
  {0, 2, { 0.50, 4.00, 3.50, 1.00, -3.00, 1.50, 2.00, -2.50 } },
  {4, 0, { -2.50, 1.00, 0.50, 0.00, 4.00, -0.50, 1.50, -5.00 } },
  {12, 0, { -2.50, 1.00, 0.50, 0.00, 4.00, 1.50, -0.50, -5.00 } },
  {20, 3, { -2.25, 0.75, -0.25, 4.75, 4.25, 0.25, 1.25, -1.75 } },
  {24, 3, { -4.00, -1.00, -2.00, 3.00, 2.50, -1.50, -0.50, -3.50 } },
  {28, 0, { -2.50, 1.00, 0.50, 4.00, 0.00, -0.50, 1.50, -5.00 } },
  {36, 0, { -2.50, 1.00, 0.50, 4.00, 0.00, 1.50, -0.50, -5.00 } },
  {44, 1, { -2.00, 0.00, 1.00, 4.00, -2.00, 0.00, 1.00, 5.00 } },
  {48, 1, { -3.75, -1.75, -0.75, 2.25, -3.75, -1.75, -0.75, 3.25 } },
  {52, 3, { -2.25, 0.25, 1.25, 4.25, 4.75, 0.75, -0.25, -1.75 } },
  {56, 0, { -1.25, -0.25, -0.75, 2.75, 0.25, -1.25, 0.75, -6.25 } },
  {64, 0, { 0.25, 1.25, 0.75, 4.25, 1.75, 0.25, 2.25, -4.75 } },
  {72, 0, { -1.25, -0.25, -0.75, 2.75, 0.25, 0.75, -1.25, -6.25 } },
  {80, 0, { 0.25, 1.25, 0.75, 4.25, 1.75, 2.25, 0.25, -4.75 } },
  {88, 1, { 0.00, 1.00, 2.00, 4.00, 0.00, 1.00, 2.00, 5.00 } },
  {92, 1, { 0.50, 4.00, 1.50, -3.00, 1.00, 3.50, 2.00, -2.50 } },
  {96, 3, { -2.25, 0.25, 4.25, 1.25, 0.75, 4.75, -0.25, -1.75 } },
  {100, 0, { -1.25, -0.25, 2.75, -0.75, -1.25, 0.25, 0.75, -6.25 } },
  {108, 0, { 0.25, 1.25, 4.25, 0.75, 0.25, 1.75, 2.25, -4.75 } },
  {116, 0, { -2.50, 1.00, 4.00, 0.50, 1.50, 0.00, -0.50, -5.00 } },
  {124, 1, { 0.50, 3.00, 1.50, -4.00, 1.00, 2.50, 2.00, -3.50 } },
  {128, 1, { -0.25, 2.25, 0.75, -4.75, 0.25, 1.75, 1.25, -4.25 } },
  {132, 2, { -2.00, 5.00, 4.00, -2.00, 0.00, 1.00, 1.00, 0.00 } },
  {136, 2, { -3.75, 3.25, 2.25, -3.75, -1.75, -0.75, -0.75, -1.75 } },
  {140, 0, { 1.25, -0.25, 2.75, -0.75, 0.25, 0.75, 1.25, -6.25 } },
  {148, 0, { -2.50, 1.00, 4.00, 1.50, 0.50, 0.00, -0.50, -5.00 } },
  {156, 3, { -2.25, 0.75, 4.25, 0.25, -0.25, 4.75, 1.25, -1.75 } },
  {160, 3, { -4.00, -1.00, 2.50, -1.50, -2.00, 3.00, -0.50, -3.50 } },
  {164, 1, { -2.00, 1.00, 4.00, 0.00, -2.00, 1.00, 5.00, 0.00 } },
  {168, 1, { -3.75, -0.75, 2.25, -1.75, -3.75, -0.75, 3.25, -1.75 } },
  {172, 0, { 1.25, -0.25, 2.75, 0.25, -0.75, 0.75, 1.25, -6.25 } },
  {180, 0, { -1.25, -0.25, 2.75, 0.25, 0.75, -0.75, -1.25, -6.25 } },
  {188, 0, { 0.25, 1.25, 4.25, 1.75, 2.25, 0.75, 0.25, -4.75 } },
  {196, 2, { 0.00, 5.00, 4.00, 0.00, 1.00, 2.00, 2.00, 1.00 } },
  {200, 1, { 1.00, 2.00, 4.00, 0.00, 1.00, 2.00, 5.00, 0.00 } },
  {204, 3, { -2.25, 4.25, 0.25, 1.25, 0.75, -0.25, 4.75, -1.75 } },
  {208, 1, { 0.50, 1.50, 4.00, -3.00, 1.00, 2.00, 3.50, -2.50 } },
  {212, 0, { -1.25, 2.75, -0.25, -0.75, -1.25, 0.25, 0.75, -6.25 } },
  {220, 0, { 0.25, 4.25, 1.25, 0.75, 0.25, 1.75, 2.25, -4.75 } },
  {228, 0, { -2.50, 4.00, 1.00, 0.50, 1.50, 0.00, -0.50, -5.00 } },
  {236, 2, { -2.00, 4.00, 5.00, -2.00, 0.00, 1.00, 1.00, 0.00 } },
  {240, 2, { -3.75, 2.25, 3.25, -3.75, -1.75, -0.75, -0.75, -1.75 } },
  {244, 1, { 0.50, 1.50, 3.00, -4.00, 1.00, 2.00, 2.50, -3.50 } },
  {248, 1, { -0.25, 0.75, 2.25, -4.75, 0.25, 1.25, 1.75, -4.25 } },
  {252, 0, { 1.25, 2.75, -0.25, -0.75, 0.25, 0.75, 1.25, -6.25 } },
  {260, 0, { -2.50, 4.00, 1.00, 1.50, 0.50, 0.00, -0.50, -5.00 } },
  {268, 1, { -2.00, 4.00, 1.00, 0.00, -2.00, 5.00, 1.00, 0.00 } },
  {272, 1, { -3.75, 2.25, -0.75, -1.75, -3.75, 3.25, -0.75, -1.75 } },
  {276, 3, { -2.25, 4.25, 0.75, 0.25, -0.25, 1.25, 4.75, -1.75 } },
  {280, 3, { -4.00, 2.50, -1.00, -1.50, -2.00, -0.50, 3.00, -3.50 } },
  {284, 0, { 1.25, 2.75, -0.25, 0.25, -0.75, 0.75, 1.25, -6.25 } },
  {292, 0, { -1.25, 2.75, -0.25, 0.25, 0.75, -0.75, -1.25, -6.25 } },
  {300, 0, { 0.25, 4.25, 1.25, 1.75, 2.25, 0.75, 0.25, -4.75 } },
  {308, 1, { 1.00, 4.00, 2.00, 0.00, 1.00, 5.00, 2.00, 0.00 } },
  {312, 2, { 0.00, 4.00, 5.00, 0.00, 1.00, 2.00, 2.00, 1.00 } },
  {316, 2, { 0.50, 2.50, 3.00, 1.00, -2.00, 4.00, 3.50, -1.50 } },
  {320, 0, { -1.25, 3.25, -0.25, -0.75, -1.25, -1.75, 0.75, -5.75 } },
  {328, 0, { 0.50, 5.00, 1.50, 1.00, 0.50, 0.00, 2.50, -4.00 } },
  {336, 0, { -1.25, 3.25, -0.25, -0.75, -1.25, 0.75, -1.75, -5.75 } },
  {344, 0, { 0.50, 5.00, 1.50, 1.00, 0.50, 2.50, 0.00, -4.00 } },
  {352, 0, { 1.75, 3.25, -0.25, -0.75, -1.25, 0.75, 1.25, -5.75 } },
  {360, 3, { -1.25, 4.25, -1.75, -0.25, 0.25, -2.25, 4.75, -0.75 } },
  {364, 3, { -2.00, 3.50, -2.50, -1.00, -0.50, -3.00, 4.00, -1.50 } },
  {368, 0, { 1.75, 3.25, -0.25, -0.75, 0.75, -1.25, 1.25, -5.75 } },
  {376, 0, { 1.75, 3.25, -0.25, -0.75, 0.75, 1.25, -1.25, -5.75 } },
  {384, 1, { -1.75, 4.25, 0.25, 0.75, -2.25, 4.75, -0.25, 1.25 } },
  {388, 1, { -3.50, 2.50, -1.50, -1.00, -4.00, 3.00, -2.00, -0.50 } },
  {392, 0, { 2.00, 3.50, 0.00, 0.50, -1.00, -1.50, 1.00, -5.50 } },
  {400, 0, { 2.00, 3.50, 0.00, 0.50, -1.00, 1.00, -1.50, -5.50 } },
  {408, 1, { 2.25, 4.25, 0.25, 0.75, 1.75, 4.75, -0.25, 1.25 } },
  {412, 3, { -4.75, 1.75, 0.75, -0.25, 0.25, 1.25, 2.25, -4.25 } },
  {416, 1, { 0.50, -3.00, -2.00, -3.50, 1.00, -2.50, -1.50, -4.00 } },
  {420, 1, { 4.25, 0.75, 1.75, 0.25, 4.75, 1.25, 2.25, -0.25 } },
  {424, 0, { -1.50, -1.50, -1.00, -0.50, 0.00, 0.50, -3.00, 6.00 } },
  {432, 0, { -1.50, -1.50, -1.00, -0.50, 0.00, -3.00, 0.50, 6.00 } },
  {440, 1, { -4.00, 1.50, 2.50, 1.00, -3.50, 2.00, 3.00, 0.50 } },
  {444, 3, { 0.50, -2.00, -3.00, -4.00, -3.50, -2.50, -1.50, 1.00 } },
  {448, 2, { -4.00, 0.50, 1.00, -3.50, 2.00, 2.50, 3.00, 1.50 } },
  {452, 1, { 0.50, -3.00, -2.00, -3.50, 1.00, -2.50, -1.50, -4.00 } },
  {456, 0, { 0.50, 3.50, 3.00, -2.00, -1.50, 2.50, -1.00, -4.00 } },
  {464, 0, { 0.50, 3.50, 3.00, -2.00, -1.50, -1.00, 2.50, -4.00 } },
  {472, 1, { -3.00, -2.00, -1.00, -3.50, -2.50, -1.50, -0.50, -4.00 } },
  {476, 1, { 1.50, 2.50, 3.50, 1.00, 2.00, 3.00, 4.00, 0.50 } },
  {480, 0, { -1.50, -1.50, -3.00, -1.00, -0.50, 0.00, 0.50, 6.00 } },
  {488, 0, { 0.75, 4.75, -2.75, 2.25, 1.75, -1.75, -1.25, -2.75 } },
  {496, 2, { 0.75, -3.75, -3.75, 0.75, -1.75, -3.25, -2.25, -1.75 } },
  {500, 2, { 0.75, -3.75, -3.75, 0.75, -1.75, -2.25, -3.25, -1.75 } },
  {504, 0, { -1.75, 4.75, -2.75, 2.25, -1.75, -1.25, -0.75, -2.75 } },
  {512, 0, { -0.75, 5.75, -1.75, 3.25, -0.75, -0.25, 0.25, -1.75 } },
  {520, 3, { -0.25, -4.75, -1.75, -0.75, -1.25, -2.25, -4.25, 0.25 } },
  {524, 1, { 0.75, -1.75, -3.25, -2.75, 0.75, -1.75, -4.25, -2.75 } },
  {528, 0, { -1.50, 5.00, -2.50, -2.00, 2.00, -1.50, -1.00, -2.50 } },
  {536, 0, { -0.50, 6.00, -1.50, -1.00, 3.00, -0.50, 0.00, -1.50 } },
  {544, 0, { 1.00, 5.00, -2.50, -2.00, -1.50, 2.00, 1.50, -2.50 } },
  {552, 2, { -1.75, -2.75, -2.75, -1.75, -0.75, -4.25, -3.25, -0.75 } },
  {556, 2, { 2.75, 1.75, 1.75, 2.75, 3.75, 0.25, 1.25, 3.75 } },
  {560, 1, { -1.75, -0.75, -3.25, -2.75, -1.75, -0.75, -4.25, -2.75 } },
  {564, 1, { 2.75, 3.75, 1.25, 1.75, 2.75, 3.75, 0.25, 1.75 } },
  {568, 0, { -2.75, 6.25, -1.25, -0.75, -0.25, 0.25, 0.75, -1.25 } },
  {576, 0, { -1.50, -3.00, -1.50, -1.00, -0.50, 0.00, 0.50, 6.00 } },
  {584, 0, { 1.25, -4.25, 3.25, 2.75, 2.25, -2.25, -1.75, -0.25 } },
  {592, 2, { -2.00, -1.00, -1.00, -2.00, -4.50, -0.50, 0.50, -4.50 } },
  {596, 2, { -2.00, -1.00, -1.00, -2.00, -4.50, 0.50, -0.50, -4.50 } },
  {600, 0, { -2.25, -4.25, 3.25, 2.75, -2.25, -1.75, -1.25, -0.25 } },
  {608, 0, { -0.75, -2.75, 4.75, 4.25, -0.75, -0.25, 0.25, 1.25 } },
  {616, 1, { -0.75, -1.75, -0.25, -4.75, -1.25, -2.25, 0.25, -4.25 } },
  {620, 3, { -3.00, 1.00, -2.00, -3.50, -4.00, -1.50, 0.50, -2.50 } },
  {624, 0, { -2.00, -4.00, 3.50, -2.50, 2.50, -2.00, -1.50, 0.00 } },
  {632, 0, { -0.50, -2.50, 5.00, -1.00, 4.00, -0.50, 0.00, 1.50 } },
  {640, 0, { 1.50, -4.00, 3.50, -2.50, -2.00, 2.50, 2.00, 0.00 } },
  {648, 1, { 2.25, -0.75, -0.25, -4.75, 1.75, -1.25, 0.25, -4.25 } },
  {652, 1, { 4.00, 1.00, 1.50, -3.00, 3.50, 0.50, 2.00, -2.50 } },
  {656, 2, { 2.00, 0.00, 0.00, 2.00, -4.50, -0.50, -1.50, -4.50 } },
  {660, 2, { 3.75, 1.75, 1.75, 3.75, -2.75, 1.25, 0.25, -2.75 } },
  {664, 0, { -3.75, -2.25, 5.25, -0.75, -0.25, 0.25, 0.75, 1.75 } },
  {672, 0, { 2.00, -3.50, -3.00, 3.00, 2.50, 2.00, -2.50, 0.50 } },
  {680, 0, { 2.00, -3.50, -3.00, 3.00, 2.50, -2.50, 2.00, 0.50 } },
  {688, 1, { -1.50, -4.00, -3.00, -1.00, -2.00, -3.50, -2.50, -0.50 } },
  {692, 1, { 3.00, 0.50, 1.50, 3.50, 2.50, 1.00, 2.00, 4.00 } },
  {696, 3, { -4.75, -1.75, -0.75, -0.25, 0.25, -1.25, -2.25, -4.25 } },
  {700, 0, { -2.00, -3.50, -3.00, 3.00, -2.50, 2.50, -2.00, 0.50 } },
  {708, 0, { -0.25, -1.75, -1.25, 4.75, -0.75, 4.25, -0.25, 2.25 } },
  {716, 0, { -2.00, -3.50, -3.00, 3.00, -2.50, -2.00, 2.50, 0.50 } },
  {724, 0, { -0.25, -1.75, -1.25, 4.75, -0.75, -0.25, 4.25, 2.25 } },
  {732, 1, { -4.25, -1.25, -0.25, 1.75, -4.75, -0.75, 0.25, 2.25 } },
  {736, 1, { 0.25, -0.75, -1.75, -4.75, -0.25, -1.25, -2.25, -4.25 } },
  {740, 0, { -2.00, -3.50, -3.00, -2.50, 3.00, 2.50, -2.00, 0.50 } },
  {748, 0, { -0.25, -1.75, -1.25, -0.75, 4.75, 4.25, -0.25, 2.25 } },
  {756, 0, { -2.00, -3.50, -3.00, -2.50, 3.00, -2.00, 2.50, 0.50 } },
  {764, 0, { -0.25, -1.75, -1.25, -0.75, 4.75, -0.25, 4.25, 2.25 } },
  {772, 2, { -4.25, -1.25, -0.75, -4.75, 1.75, -0.25, 0.25, 2.25 } },
  {776, 1, { 2.25, 0.25, -0.75, -4.75, 1.75, -0.25, -1.25, -4.25 } },
  {780, 1, { 4.00, 2.00, 1.00, -3.00, 3.50, 1.50, 0.50, -2.50 } },
  {784, 0, { -4.00, -1.50, -1.00, -0.50, 0.00, 5.00, 0.50, 2.50 } },
  {792, 0, { -4.00, -1.50, -1.00, -0.50, 0.00, 0.50, 5.00, 2.50 } }
};
/* ========================================================================= */
static int Shell1SignTab[120] = {
  /* Holds the sign of the first non zero component
   * of each vector in Shell 1
   */
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,-1,1,-1,-1,-1,-1,1,1,1,1,1,1,
  -1,1,-1,-1,-1,-1,1,1,-1,-1,-1,-1,1,-1,-1,-1,1,-1,-1,1,-1,1,1,1,1,-1,1,1,
  -1,1,-1,1,-1,1,-1,1,-1,1,-1,-1,1,-1,-1,1,-1,1,-1,1,-1,-1,1,-1,-1,-1,1,-1,
  -1,-1,1,1,-1,1,-1,1,-1,-1,1,-1,-1,-1,1,-1,-1,-1,1,-1,1,-1,-1,-1,1,-1,1,1,1,-1,-1
};
/* ========================================================================= */
static int SymIndices[4][8] = {
  /* Index permutations to obtain the 
   * different symmetries
   */
  { 0, 1, 2, 3, 4, 5, 6, 7 },
  { 4, 5, 6, 7, 0, 1, 2, 3 },
  { 3, 2, 1, 0, 7, 6, 5, 4 },
  { 7, 6, 5, 4, 3, 2, 1, 0 }
};
/*=============================================================================
 * A number written in base r, represented by index is converted into decimal.
 *===========================================================================*/
static int index_to_decimal (INDEX index, int r) 
{
  int sum = (int) index[0];

  sum = (sum * r) + (int) index[1];
  sum = (sum * r) + (int) index[2];
  sum = (sum * r) + (int) index[3];
  sum = (sum * r) + (int) index[4];
  sum = (sum * r) + (int) index[5];
  sum = (sum * r) + (int) index[6];
  sum = (sum * r) + (int) index[7];

  return ( sum );
}

/*=============================================================================
 * Returns the L2 norm of a point.
 *===========================================================================*/
static int L2Norm (VECTOR x) 
     /* This one is for x containing 
      * fractional values */
{
  int i;
  double sum = 0.0;

  for (i=0; i<8; i++)
    sum += (double)(x[i]*x[i]);

  return ((int) sum);
}

static int L2Norm_int (int *x) 
     /* This one is faster if x already 
      * contains integral values */
{
  int i;
  int sum = 0;

  for (i=0; i<8; i++)
    sum += (x[i]*x[i]);

  return (sum);
}

/*=============================================================================
 * Takes every component modulo r
 *===========================================================================*/
static void take_mod (INDEX index, int r) 
{
  int in;

  in = (int) index[0] % r;
  index[0] = (in < 0) ? in+r:in;

  in = (int) index[1] % r;
  index[1] = (in < 0) ? in+r:in;

  in = (int) index[2] % r;
  index[2] = (in < 0) ? in+r:in;

  in = (int) index[3] % r;
  index[3] = (in < 0) ? in+r:in;

  in = (int) index[4] % r;
  index[4] = (in < 0) ? in+r:in;

  in = (int) index[5] % r;
  index[5] = (in < 0) ? in+r:in;

  in = (int) index[6] % r;
  index[6] = (in < 0) ? in+r:in;

  in = (int) index[7] % r;
  index[7] = (in < 0) ? in+r:in;

}

/*=============================================================================
 * Returns the group number between 0 and 255 of E8 lattice point.
 *===========================================================================*/
static int LatticePointGN (VECTOR x) 
{
  INDEX z;

  z[0] = 0.5*x[0] - 0.5*x[1] - 0.5*x[2] - 0.5*x[3] 
    - 0.5*x[4] - 0.5*x[5] - 0.5*x[6] + 2.5*x[7];
  z[1] = x[1] - x[7];
  z[2] = x[2] - x[7];
  z[3] = x[3] - x[7];
  z[4] = x[4] - x[7];
  z[5] = x[5] - x[7];
  z[6] = x[6] - x[7];
  z[7] = 2*x[7];

  take_mod (z, 2);

  return ( index_to_decimal (z, 2));

}

/*=============================================================================
 * For input x the nearest E8 lattice point is returned in z.
 *===========================================================================*/


static double NextD8LatticePoint(const float x[8], int f[8]) {

  int i, k;
  int fsum;
  double maxdist, se, e[8];
  int w[8];

  maxdist = 0; k = 0;
  fsum = 0; se = 0;

  for (i=0; i<8; i++) {

    /* First, perform the two ways of rounding described in the article.
     * The results are hold in f[i] and w[i], respectively.
     */

    if (x[i]==0) {
      f[i] = 0; w[i] = 1;
    } else if (x[i]>0) {
      if ((x[i] - ((int) x[i])) <= 0.5) {
	f[i] = (int) x[i]; w[i] = f[i] + 1;
      } else {
	w[i] = (int) x[i]; f[i] = w[i] + 1;
      }
    } else {
      if ((x[i] - ((int) x[i])) >= -0.5) {
	f[i] = (int) x[i]; w[i] = f[i] - 1;
      } else {
	w[i] = (int) x[i]; f[i] = w[i] - 1;
      }
    }
    /* Compute component sum */
    fsum += f[i];

    /* Compute rounding error and keep it in memory */
    e[i] = (double)(x[i]) - (double) f[i];

    /* Compute overall SE */
    se += (e[i]*e[i]);

    /* Remember the largest rounding error for f */
    if ( fabs(e[i]) > maxdist ) {
      maxdist = fabs(x[i] - f[i]);
      k = i;
    }
  }
  
  /* Now, if f has an odd sum, we replace the component f[k] having the 
   * largest rounding error with w[k] for rounding to the second best integer.
   */

  if (fsum & 1) {
    se -= (e[k]*e[k]); /* The error for f[k] is no longer valid */ 
    f[k] = w[k];       /* f[k] is replaced by w[k] */
    e[k] = (double)(x[k]) - (double) f[k];/* Recompute the rounding ... */
    se += (e[k]*e[k]); /* ... and the overall error  */
  }

  /* Return the overall SE */
  return(se);
}


/*=============================================================================
 * For input x the nearest E8 lattice point is returned in z.
 *===========================================================================*/

#if 0
static int NewNearestE8LatticePoint (VECTOR v, VECTOR z) 
{

  VECTOR r;
  VECTOR t;
  double tmp;

  int i;

  int ri, ti;
  int ts, rs;

  double rn, tn;
  double e, ee, maxre, maxte;
  double te, re;

  maxre = maxte = 0;
  ts = rs = 0;
  rn = tn = 0;
  re = te = 0;

  ri = ti = 0;

  for (i=0; i<8; i++) {

    tmp = ROUND((double)(v[i]));
    r[i] = tmp; 

    rn += tmp*tmp;

    rs = (int) (rs + tmp);
    e = (double)(v[i])-tmp;
    e = fabs(e);
    ee = e*e;
    re += ee;

    if (e>maxre) { maxre = e; ri = i; };

    tmp = TRUNC((double)(v[i]));
    ts = (int) (ts+tmp); 

    tmp += 0.5;
    t[i] = tmp;

    tn += tmp*tmp;

    e = (double)(v[i])-tmp;
    e = fabs(e);
    ee = e*e;
    te += ee;

    if (e>maxte) { maxte = e; ti = i; };

  }

  if (rs & 1) {
    tmp = r[ri];

    e = (double)(v[ri])-tmp;
    re -= (e*e);
    rn -= (tmp*tmp);

    tmp = NNI((double)(v[ri]),tmp);
    r[ri] = tmp;

    e = (double)(v[ri])-tmp;
    re += (e*e);
    rn += (tmp*tmp);

  }

  if (ts & 1) {
    tmp = t[ti];

    e = (double)(v[ti])-tmp;
    te -= (e*e);
    tn -= (tmp*tmp);

    tmp = NNI((double)(v[ti]),tmp);
    t[ti] = tmp;

    e = (double)(v[ti])-tmp;
    te += (e*e);
    tn += (tmp*tmp);

  }

  if (re==te) {
    if (rn<=tn) {
      z[0] = (float)(r[0]); z[1] = (float)(r[1]);
      z[2] = (float)(r[2]); z[3] = (float)(r[3]);
      z[4] = (float)(r[4]); z[5] = (float)(r[5]);
      z[6] = (float)(r[6]); z[7] = (float)(r[7]);
      return((int) rn);
    } else {
      z[0] = (float)(t[0]); z[1] = (float)(t[1]);
      z[2] = (float)(t[2]); z[3] = (float)(t[3]);
      z[4] = (float)(t[4]); z[5] = (float)(t[5]);
      z[6] = (float)(t[6]); z[7] = (float)(t[7]);
      return((int) tn);
    }
  } else if (te<re) {
    z[0] = (float)(t[0]); z[1] = (float)(t[1]);
    z[2] = (float)(t[2]); z[3] = (float)(t[3]);
    z[4] = (float)(t[4]); z[5] = (float)(t[5]);
    z[6] = (float)(t[6]); z[7] = (float)(t[7]);
    return((int) tn);
  } else {
    z[0] = (float)(r[0]); z[1] = (float)(r[1]);
    z[2] = (float)(r[2]); z[3] = (float)(r[3]);
    z[4] = (float)(r[4]); z[5] = (float)(r[5]);
    z[6] = (float)(r[6]); z[7] = (float)(r[7]);
    return((int) rn);
  }
}
#endif


static int NearestE8LatticePoint(float x[8], float y[8]) {

  /* Computes nearest E8 point for x and returns its norm */

  int i;
  int z1[8], z2[8];
  int l2[2];
  int used_vector;
  float xt[8];
  double se0, se1, se2;

  /* Compute lattice point on D8 lattice */
  se1 = NextD8LatticePoint(x, z1);

  /* Compute lattice point on translated D8 lattice */
  for (i=0; i<8; i++) xt[i] = x[i] + 0.5;
  NextD8LatticePoint(xt, z2);
  se2 = 0; se0 = 0; se1 = 0;
  for (i=0; i<8; i++) { 
    xt[i] = (float) z2[i] - 0.5;
    se1 += (x[i] - z1[i])*(x[i] - z1[i]);
    se2 += (x[i] - xt[i])*(x[i] - xt[i]);
    se0 += (x[i]*x[i]);
  }
  if (((se0 <= se1) && (se0 <= se2))) used_vector = 0;
  else {
    l2[0] = L2Norm_int(z1);
    l2[1] = L2Norm(xt);
    
    if (se2==se1) {
      if (l2[0]<l2[1]) used_vector = 1; else used_vector = 2;
    } else if (se1 < se2) used_vector = 1; else used_vector = 2;
  }

  switch (used_vector) {
  case 0: for (i=0; i<8; i++) y[i] = 0; return(0); break;
  case 1: for (i=0; i<8; i++) y[i] = (float) z1[i]; return(l2[0]); break;
  case 2: for (i=0; i<8; i++) y[i] = xt[i]; return(l2[1]); break;
  default: return(-1); /* hopefully not reached */
  }
}
/* ========================================================================= */
static void RecShell1Point(int index, VECTOR y, int sign, int mode) {
  int i;
  float *x;

  switch(mode) {
  case 0: x = Shell1SPYCodebook; break;
  case 1: x = Shell1SPCCodebook; break;
  case 2: x = Shell1TPYCodebook; break;
  case 3: x = Shell1TPCCodebook; break;
  }

  for (i=0; i<8; i++) y[i] = sign*(x[(8*index)+i]);
}

static void RecShell2Point(int index, VECTOR y, VECTOR z, int sy, int sign, int mode) {
  int i;
  float *x;

  switch(mode) {
  case 0: x = Shell2SPYCodebook; break;
  case 1: x = Shell2SPCCodebook; break;
  case 2: x = Shell2TPYCodebook; break;
  case 3: x = Shell2TPCCodebook; break;
  }
  
  for (i=0; i<8; i++) y[i] = sign*(x[ (8*index) + SymIndices[sy][i] ]);
}

static int RoundAndClip(float val) {
  int y;

  y = ROUND(val);

  if (y<0) return(0); 
  if (y>255) return(255);
  return(y);
}

void RecVect(int *dec, int *pre, float scale, LatticePointInfo *lpi, int mode) {
  float y[8];
  int n;

  if (lpi->l2norm==0) {
    for (n=0; n<8; n++) dec[n] = pre[n]; 
  } else if (lpi->l2norm<=4) {
    switch (lpi->l2norm) {
    case 2: RecShell1Point(lpi->index, y, lpi->sign ? -1 : 1, mode); break;
    case 4: RecShell2Point(lpi->index, y, lpi->point, lpi->sy, lpi->sign ? -1 : 1, mode); break;
    }
    for (n=0; n<8; n++) dec[n] = RoundAndClip(pre[n] + y[n]*scale); 
  } else
    for (n=0; n<8; n++) dec[n] = RoundAndClip(pre[n] + lpi->point[n]*scale);

#ifdef CODEBOOK_TRAINING
  AddVectorCodebookHist(mode+4, index, float v[8]);   ???????
#endif
}

/* ========================================================================= */
static float InnerProd(VECTOR x, VECTOR y) {
  /* Returns the inner product 
   * between two vectors */
  int i;
  double sum;

  sum = 0;

  for (i=0; i<8; i++) {
    sum += (double)(x[i]*y[i]);
  }
  return((float)sum);
}

/* ========================================================================= */

static int SignOfFirstNonZero(float x[8]) {
  /* Returns the sign of the first none-zero component */
  int i;

  i = 0;
  while (x[i]==0.0) i++;

  return((x[i] < 0.0) ? -1 : 1);
}

/* ========================================================================= */

static void Shell1Info(LatticePointInfo *lpi) {
  int gn;
  gn = LatticePointGN(lpi->point);   /* a group number between 1 and 256 */
  lpi->index = GN2GroupIndex[gn-1];  /* maps gn to indices suitable for Shell1 codebook */
  lpi->sign = (SignOfFirstNonZero(lpi->point)==Shell1SignTab[lpi->index]) ? 0 : 1;
}

/* ========================================================================= */

static void Shell2Info(LatticePointInfo *lpi) {
  int gn, gi, ci, si, symtype;

  gn = LatticePointGN(lpi->point);    /* a group number between 1 and 256 */
  ci = GN2GroupIndex[gn-1];           /* Class index between 0 and 134 */
  si = Shell2Groups[ci].VMemAddress;  /* maps ci to the start index of ci */

  /* ABS(gi) is the row index WITHIN the matrix of 
   * 8 orthogonal vectors spanning one Shell2 group 
   */
  gi = (int) InnerProd(lpi->point, Shell2Groups[ci].AddressVector);
  lpi->sign = (gi < 0) ? 1 : 0;
  gi = labs(gi);

  symtype = Shell2Groups[ci].Symmetry; /* type of symmetry */

  if (symtype == 0) {
    gi = gi - 1; lpi->trans = -1;  lpi->sy = 0; /* trans=-1: no t bit need to be sent, 
						 * no symmetry appliable */
  } else {
    if ((gi & 1) == 0) { gi = (gi >> 1) - 1; lpi->trans = 1; lpi->sy = symtype; } 
    else { gi = (gi >> 1); lpi->trans = 0; lpi->sy = 0; }
  }

  lpi->index = si + gi;
}
/* ========================================================================= */
int QuantizeVect(int *orig, int *pred, float scale, LatticePointInfo *lpi) {

  /* orig contains the original, pred the predicted signal vector.
   * QuantizeVect forms the scaled difference between orig and pred
   * (the prediction error) and quantizes the scaled difference to
   * the next E8 lattice point.
   * For this lattice point the needed information to encode is computed:
   * Shell 0: nothing else to do
   * Shell 1: compute index and sign
   * Shell 2: compute index, sign, transform bit and symmetrie type
   *
   */

  int i;
  int diff;
  float x[8];

  for (i=0; i<8; i++) {
    diff = orig[i] - pred[i];
    x[i] = (float) diff / scale;
    
    /*    x[i] = (float) (ROUND(2*diff / scale)/2.0); */
  }
  lpi->l2norm = NearestE8LatticePoint (x, lpi->point);

  switch(lpi->l2norm) {
  case 0:
    return(0);
    break;
  case 2:
    Shell1Info(lpi);
    return(1);
    break;
  case 4:
    Shell2Info(lpi);
    return(2);
    break;
  default:
    /* An L2-norm greater than two means that we have an vector not
     * covered by the codebook. */
    return(3);
    break;
  }
}

/* ========================================================================= */

