/*
 * main.c - 
 *
 * 15.10.97, jw.
 */
/* #include <stdio.h> */
#include <stdlib.h>
#include <string.h>

#include <stdio.h>
#include <assert.h>
#include <bitIn.h>

#include "rtp_defs.h"

#include "rtp.h"
#include "pyra.h"
#include "h263.h"
/*#include "readpack.h"*/

#define MAX_FILENAME_LENGTH 80
/***************** Funktionen ************************************************
  readpacket
*****************************************************************************/


/***************** Anmerkung ************************************************/

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- readpacket -- Liest ein RTP-Paket aus einem File    
 *
 * Author:           Markus Sebeck
 *
 * Created:          7-May-98
 *
 * Purpose:          Liest ein RTP-Paket aus einem File und stellt jeweils
 *                   die Gesamtlaenge in Bytes als Int voran.
 *
 * Arguments in:     FILE*      fileptr         Ausgabefile
 *                   
 * Arguments in/out: int*       packetlen       Laenge des Pakets in Byte
 *                   u_char*    packetptr       Zeiger auf Bitstream
 *
 * Arguments out:    
 *
 * Return values:    int        EOF: Fileende erreicht, 0: sonst
 *
 * Example:          -
 *
 * Side effects:     -
 *
 * Description:      -
 *
 * See also:         -
 *
 * Modified:         -
 *
 *****************************************************************************/
int readpacket(FILE* fileptr, unsigned char* packetptr, int *packetlen)
/***********************************************************CommentEnd********/
{
    int ii, byte, readbytes=0;
    unsigned long int len=0;

    /*!!
    if (feof(fileptr+1))
    {
        *packetlen = 0;
	return EOF;
    }
    */

    /* read integer packetlen */
    for (ii=1;ii<=BYTES_FOR_PACKLEN;ii++)
    {
        byte = fgetc(fileptr);
	if(byte == EOF)
	{

	  /*!!	    fprintf(stderr,"Error in reading packetlength: %d instead of %d bytes read(fptr = %lu, byte = %d, EOF = %d.", ii-1, BYTES_FOR_PACKLEN, ftell(fileptr), byte, EOF);
	    printf("\nfeof = %d", feof(fileptr));
	    assert(0); */
	    *packetlen = 0;
	    return EOF;
	}
	len |= (byte << (BYTES_FOR_PACKLEN-ii)*8);
	/* *packetlen |= (byte << (ii-1)*8); */
    }
    *packetlen = len;

    if( (0 >= *packetlen) || (*packetlen > MAX_PACKETSIZE) )
    {
        fprintf(stderr,"Size of packet (%d) exceeds maximum packetsize.", *packetlen);
	assert(0);
    }
    /* read packetlen bytes */
    readbytes = fread(packetptr, sizeof(char), *packetlen, fileptr);

    if (readbytes != *packetlen)
    {
        fprintf(stderr,"Error in reading packet from file. Only %d bytes read instead of %d.",
		readbytes,*packetlen );
	/*return 1;*/
	exit(1);
    }
    /*!! printf("L:%4d ",*packetlen); */
    return 0;
    /* return feof(fileptr); */
};


/* *************************************************************************/
/* *************************************************************************/
void ShowUsage()
{
    printf("\nShows all (or specified) packets of a RTP-packet file\n");
    printf("by displaying characteristic header values.\n");
    printf("Input file format: concatenated packets\n");
    printf("Packet format:\n");
    printf("\t> RTP-header \n\t> payload header (h.263/pyra) \n\t> bitstream header + data \n");
    printf("\nOPTIONS:\n");
    printf("\t-h  show this help\n");
    printf("\t-i <filename> input filename\n");
    printf("\t-H  H.263 layer\n");
    printf("\t-P  PYRA layer\n");
    printf("\t-s <num> start sequence nr\n");
    printf("\t-l <num> length of sequence to display\n");
    printf("\t-t <num> start display at time\n\n");
    exit(0);
}


/*
 *
 */
void main(int argc, char *argv[])
{
    int i;
    int show = 1;
    char inputFile[MAX_FILENAME_LENGTH];
    unsigned char packet[1200], *datastart; 
    int packetlen, datalen;
    FILE *infile;
    int layertype=1, packetctr=0, shownPackets=0, layerheadersize, modeb=0;
    RtpHeader *rh;
    h263rtpheader_A *h263rha;
    h263rtpheader_B *h263rhb;
    PyraLayerRtpHeader *prh;
    h263streamheader *h263sh;
    PyraStreamHeader *psh;
    unsigned long int startseqno=0xffffffff;
    unsigned long int seqlen=0xffffffff;
    unsigned long int starttime=0xffffffff;

    /***************** Kommandozeilenargumente verarbeiten *************/
    if(argc == 1)
    {   
        ShowUsage();
    }
    else
    {
        for ( i=1 ; i<argc ; i++ )
	{
	    if ( argv[i][0]=='-' ) 
	    {
	        switch ( argv[i][1] ) 
		{
		case 'h':    /* show help */

		  ShowUsage();
		  break;

		case 'i' :  /* input filenames */ 				  
		
		  i++;
		  if ( (i>=argc) || (argv[i][0]=='-') ) 
		  {
		    fprintf(stderr,"Error in %s: specify input filename!\n", argv[0]);
		    exit(1);
		  }

		  strcpy(inputFile,argv[i]);
		  if(strlen(inputFile) > (MAX_FILENAME_LENGTH))
		  {
		      printf("Inputfile name is too long (limit: %d characters).\n",MAX_FILENAME_LENGTH);
		  }		  
		  break;
		
		case 'H':    /* H.263 */

		  layertype = 1;
		  break;

		case 'P':    /* PYRA */

		  layertype = 2;
		  break;

		case 's':    /* start sequence nr */

                  i++;
                  startseqno = atoi(argv[i]);
                  show = 0;
		  break;

		case 'l':    /* length of sequence to display */

                  i++;
                  seqlen = atoi(argv[i]);
		  break;

		case 't':    /* start display at time */

                  i++;
                  starttime = atoi(argv[i]);
                  show = 0;
		  break;

		
		default  : 

		  fprintf(stderr,"Wrong command line argument: %s! \n\n", argv[i]);
		  break;		   		  
		}
	    }
        }
    }

    if( (infile = fopen(inputFile, "r")) == NULL)
        printf("Can't open file %s.", inputFile);

    printf("\nsizeof:\n"); 
    printf("RtpHeader:\t\t %d\n", sizeof(RtpHeader)); 
    printf("h263rtpheader_A:\t %d\n", sizeof(h263rtpheader_A)); 
    printf("h263rtpheader_B:\t %d\n", sizeof(h263rtpheader_B)); 
    printf("PyraLayerRtpHeader:\t %d\n", sizeof(PyraLayerRtpHeader)); 
    printf("h263streamheader:\t %d\n", sizeof(h263streamheader)); 
    printf("PyraStreamHeader:\t %d\n", sizeof(PyraStreamHeader)); 

    while(readpacket(infile, packet, &packetlen) != EOF)
    {
        packetctr++;

	rh = (RtpHeader *) packet;
	if (layertype == 1)
	{
	    h263rha = (h263rtpheader_A*)(packet + sizeof(RtpHeader));
	    if (!h263rha->ftype) 
	      layerheadersize = sizeof(h263rtpheader_A);
	    else 
	    {
	      h263rhb = (h263rtpheader_B *) (packet + sizeof(RtpHeader));
	      layerheadersize = sizeof(h263rtpheader_B);
	      modeb = 1;
	    }
	    /* assert(rh->rh_ts % 256 == ShowH263TempRef(curpacket + sizeof(RtpHeader) + layerheadersize)); */
	}
	else
	{
	    prh = (PyraLayerRtpHeader*) (packet + sizeof(RtpHeader));
	    layerheadersize = sizeof(PyraLayerRtpHeader);
	    /* assert(rh->rh_ts % 256 == ShowPyraTempRef(curpacket + sizeof(RtpHeader) + layerheadersize)); */
	}


	datastart = (unsigned char*)(packet + sizeof(RtpHeader) + layerheadersize);
	datalen = packetlen - sizeof(RtpHeader) - layerheadersize;

        
        /* decision: display or not */
        if (!show)
            if ((rh->rh_ts == starttime) || (rh->rh_seqno == startseqno))
                show = 1;
           
        /* show data if desired */
        if (show)
        {
            if (!(seqlen--))
                break;

            shownPackets++;
            printf("\n************* Packet %4d(%4d) (Bytes: %4d)*************\n",
                   shownPackets, packetctr, packetlen);
            printf("RTP: TS: %6lu, flags: %x.\n", rh->rh_ts, rh->rh_flags);
            
            if (layertype == 1)
            {
                h263sh = (h263streamheader *)datastart;
                if (ShowH263GOBnumber(datastart) == 0)
                    printf("tr:%3u(%u), gobnr:%u, srcformat:%u.\n", ShowH263TempRef(datastart), 
                           rh->rh_ts % 256, ShowH263GOBnumber(datastart),ShowH263PicSize(datastart));
                else
                    printf("gobnr:%u.\n", ShowH263GOBnumber(datastart));
                /* printf("Layer:%d, bl:%d, td:%d, sd:%d, b:%d, s:%d, e:%d, sf:%d.\n",
                   layernr, isbaselayer, tempdist,
                   spatialdist, modeb, sbit, ebit, srcformat); */
            }
            else
            {
                psh = (PyraStreamHeader *)datastart;
                printf("Layer:%u, bl:%u, td:%u, sd:%u, b:%u, s:%u, e:%u, sf:%u.\n",
                       prh->layernr, prh->isbaselayer, 
                       prh->tempdist, prh->spatialdist, prh->modeb, prh->sbit, prh->ebit, prh->srcformat);
                /*if (psh->gobnr == 0)*/
                if (ShowPyraGOBnumber(datastart) == 0)
                    printf("tr:%3u(%u), gobnr:%u, srcformat:%u, pct:%u.\n", ShowPyraTempRef(datastart), 
                           rh->rh_ts % 256, ShowPyraGOBnumber(datastart),ShowPyraPicSize(datastart), 
                           ShowPyraCodingType(datastart)/*,psh->scaltype, psh->q*/);
                else
                    printf("gobnr:%u.\n", ShowPyraGOBnumber(datastart));
            }
        }        
    }
    printf("Angezeigte Pakete: %d.\n\n", shownPackets);
    fclose(infile);
}

    
