/* H263 Packetizer 
 * Copyright 1998 Markus Sebeck
 */
/* #include "h263decoder.p " */
#include "sendpacket.h"
#include "h263rtp.h"

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- findH263MBindices --    
 *
 * Author:           Markus Sebeck
 *
 * Created:          16-Apr-98
 *
 * Purpose:          Schreibt ein RTP-Paket in ein File und stellt jeweils
 *                   die Gesamtlaenge in Bytes als Int voran.
 *
 * Arguments in:     Layerdata* ld              Zeiger auf Daten des Frames
 *                   int        gobnr           Nr. des GOBs, dessen MB-Indizes
 *                                              ermittelt werden sollen                   
 * Arguments in/out: -
 *
 * Arguments out:    
 *
 * Return values:    int        1: Fehler aufgetreten, 0: sonst
 *
 * Example:          -
 *
 * Side effects:     -
 *
 * Description:      -
 *
 * See also:         -
 *
 * Modified:         -
 *
 *****************************************************************************/
int findH263MBindices(H263Global *h263Data, LayerData *ld, MVField *mvfield,
                      int gobnr, int offset)
/***********************************************************CommentEnd********/
{
    InitStreamParsingH263(h263Data->bs);
    H263parseGOB(h263Data, ld->mbind, ld->mbquant, mvfield, offset);
        
    printf("\n\tSPLITTING H.263-GOB.\n");
    return 0;
}

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- get_h263motionvectors -- Holt Bewegungsvektoren fuer Mode B
 *
 * Author:           Markus Sebeck
 *
 * Created:          16-Apr-98
 *
 * Purpose:          
 *                   
 *
 * Arguments in:     Layerdata* ld              Zeiger auf Daten des Frames
 *                   int        gobnr           Nr. des GOBs, dessen MB-Indizes
 *                                              ermittelt werden sollen                   
 * Arguments in/out: -
 *
 * Arguments out:    
 *
 * Return values:    int        1: Fehler aufgetreten, 0: sonst
 *
 * Example:          -
 *
 * Side effects:     -
 *
 * Description:      -
 *
 * See also:         -
 *
 * Modified:         -
 *
 *****************************************************************************/
int get_h263motionvectors(h263rtpheader_B *h263rhb, int gobnr)
/***********************************************************CommentEnd********/
{
    printf("get_h263motionvectors not yet implemented");

    h263rhb->hmv1	= 0;
    h263rhb->vmv1	= 0;
    return 0;
}



/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- split_and_pack_h263frame --    
 *
 * Author:           Markus Sebeck
 *
 * Created:          16-Apr-98
 *
 * Purpose:          Schreibt ein RTP-Paket in ein File und stellt jeweils
 *                   die Gesamtlaenge in Bytes als Int voran.
 *
 * Arguments in:     Layerdata* ld              Zeiger auf Daten des Frames
 *                   int        gobnr           Nr. des GOBs, dessen MB-Indizes
 *                                              ermittelt werden sollen                   
 * Arguments in/out: -
 *
 * Arguments out:    
 *
 * Return values:    int        1: Fehler aufgetreten, 0: sonst
 *
 * Example:          -
 *
 * Side effects:     -
 *
 * Description:      -
 *
 * See also:         -
 *
 * Modified:         -
 *
 *****************************************************************************/
int split_and_pack_h263frame(
        H263Global *h263Data,
        /*!!
	unsigned char *bs_in,		/ bitstream [in] /
	u_int bitcount,			/ bitstream length in bits [in] /
	u_int gobs_per_frame,		/ gobs per frame [in] /
	u_int mbs_per_gob,		/ mbs per gob [in] /
	int *mbind,			/ macroblock indices [in] /
	int *mbquant,			/ quantifiers [in] /
        */
	MVField *mvfield,		/* motion vectors [in] */
	/*!! u_int ts_,			/ timestamp [in] /
	/ int headersize,			/ headerlength [in] /
	h263_rtp_packet	**packets	/ rtp packets [out] */

	RtpData *rtpdata,               /* [in] aktuelle RTP-Headerdaten */
	LayerData *ld,                  /* [in] MB-/GOB-Grenzen... */
	FILE* protocol
)
/***********************************************************CommentEnd********/
{
	/* Original-Variablen; werden am Schluss geloescht */
  /*!!
	h263streamheader	*h263sh = (h263streamheader*)ld->stream;
	int			i,sendmodeb,plen,lastgobind,lastsentbit,curind;
	int			lastind,psize=headersize-HDRSIZE_B,nrofrtps=0;

	*packets = NULL;lastsentbit=0;curind=0;sendmodeb=0;
	*/

	/* meine Variablen */
	char*                   packet;                 /* Bitstream fuer ein RTP-Paket */
	char*                   datastart;
	int			i,
				sendmodeb,
	                        databyteNum,            /* Anzahl Daten-Bytes im Paket (zuvor plen)*/
	                        packetlen,              /* Gesamtlaenge des Pakets (in Bytes) */ /*!!NEU*/
				lastgobind,		/* letzter MB-Index, der gerade noch
							   ins naechste Paket passt */
	                        prevgobnr,              /* GOB-Nr. des 1. GOBs, der noch nicht
							   (ganz) uebertragen ist */
	                        lastsentbit;            /* Index d. zuletzt gesendeten Bits */
	int			curbit,sentbytes=0,lastind;
	int                     maxdatasize,            /* max. Anzahl Daten-Bytes im Paket (zuvor psize)*/
	                        headersize,
                                mvf_size;

	h263streamheader	*h263sh = (h263streamheader*)ld->stream;
	RtpHeader		*rh;

	lastsentbit=0;sendmodeb=0;curbit=0; 		/* Initialisierungen */

	/*!!!!!!! evtl. (ld->mbind)[i] statt ld->mbind[i]   (Prioritaeten)
         * ebenso fuer mbquant und mvfield */

        /* fuer evtl. Berechnung v. MB-Indizes -> PicHeader dekodieren NEU*/
        h263Data->bs->ByteBuffer = ld->stream;
        InitStreamParsingH263(h263Data->bs);
        getheader(h263Data);

	while (lastsentbit<ld->bitlen) {
	  /*!!h263_rtp_packet	*curpacket;*/

		/* Bitstream fuer Paket allozieren */
		packet = (unsigned char*) malloc(MAX_PACKETSIZE * sizeof(char));
		rh = (RtpHeader*) packet;

		/* RTP-Header initialisieren */
		rh->rh_flags = 0;
		rh->rh_flags |= RTP_VERSION << 14; /*!! evtl mit htons */
		rh->rh_flags |= H263_PAYLOAD;      /*!! evtl mit htons */
		/*
		rh->rh_flags.v = RTP_VERSION;
		rh->rh_flags.p = 0;
		rh->rh_flags.x = 0;
		rh->rh_flags.cc = 0;	       
		rh->rh_flags.m = 0;                  / to be corrected /
		rh->rh_flags.pt = H263_PAYLOAD;
		*/
		rh->rh_seqno = ++rtpdata->sequencenr; 
		rh->rh_ts = rtpdata->timestamp;
		rh->rh_ssrc = rtpdata->ssrc;

		lastgobind = 0;

		/* Look for next GOB that fits whole into an RTP packet 
		 * The last+1 block is the complete bitstreamlength.
		 */
		maxdatasize = MAX_PACKETSIZE - sizeof(RtpHeader) - HDRSIZE_A; /*!! evtl Fallunterscheidung A/B ?*/
#if 0
		for (i=0;i<=ld->gobs_per_frame;i++)
			if (ld->mbind[i*ld->mbs_per_gob]<lastsentbit-8+(maxdatasize<<3))
				lastgobind = ld->mbind[i*ld->mbs_per_gob];
#else
		for (i=0;(i<=ld->gobs_per_frame) && (ld->mbind[i*ld->mbs_per_gob]<lastsentbit-8+(maxdatasize<<3));i++)
                    lastgobind = ld->mbind[i*ld->mbs_per_gob];
#endif
		prevgobnr = i-1;    /*!!! Ueberpruefen! evtl. prevgobnr = i-1 (wenn der 1. GOB nicht ganz 
				     reinpasst, ist prevgobnr=0 */
		/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
		/*!! prevgobnr evtl. nochmal bestimmen, falls lastgobind<=lastsentbit, mit anderem maxdatasize
		  (fuer Mode B) */

		if (lastgobind<=lastsentbit) {
			/* Next GOB doesn't fit */
			lastgobind = 0;
		}
		/* allocate one more RTP packet */
		/*!!nrofrtps++;*/
		/*!!
		if (*packets)
			*packets=(h263_rtp_packet*)realloc(*packets,sizeof(*packets[0])*nrofrtps);
		else
			*packets=(h263_rtp_packet*)malloc(sizeof(*packets[0])*nrofrtps);
		curpacket = (*packets)+(nrofrtps-1);
		*/

		/* Wir senden das naechste Paket im Mode B, wenn:
		 * - Das letzte im Mode B gesendet wurde und nicht an einer GOB
		 *   Grenze endete.
		 * - Der aktuelle GOB nicht vollstaendig in ein Paket passt.
		 */
		if (sendmodeb || !lastgobind) {
			/* RTP/H.263 header ,Mode B (64bit) */
		  	/*!!
			h263rtpheader_B	 *h263rhb = &(curpacket->header.h263b);
			curpacket->headersize	= HDRSIZE_B;*/
			h263rtpheader_B  *h263rhb = (h263rtpheader_B*) (packet + sizeof(RtpHeader));
			headersize  = sizeof(RtpHeader) + HDRSIZE_B;
			datastart   = (unsigned char*) (packet + headersize);
			maxdatasize = MAX_PACKETSIZE - headersize;

			/* fill in header stuff */
			h263rhb->ftype		= 1;	/* mode b */
			h263rhb->pbframes	= 0;	/* no pb frames */
			h263rhb->srcformat	= h263sh->srcformat;
			h263rhb->picture_coding_type	= h263sh->picture_coding_type;
			h263rhb->unrestricted_motion_vector= h263sh->unrestricted_motion_vector;
			h263rhb->syntax_based_arithmetic= h263sh->syntax_based_arithmetic;
			h263rhb->advanced_prediction	= h263sh->advanced_prediction;
			h263rhb->reserved	= 0;
			h263rhb->quant		= 0;
			h263rhb->hmv2		= 0;
			h263rhb->vmv2		= 0;
			h263rhb->gobn		= ld->gobs_per_frame-1;
			if (sendmodeb) { 
				/* Motion vectors/mba are only relevant
				 * if the packet before was modeB too */
				h263rhb->mba	= lastind % ld->mbs_per_gob;
				if (mvfield == NULL)
				{
				     get_h263motionvectors(h263rhb, prevgobnr);
				}
				else
				{
				     h263rhb->hmv1	= mvfield->mx[lastind];
				     h263rhb->vmv1	= mvfield->my[lastind];
				}
				h263rhb->quant	= ld->mbquant[lastind];
				/* look if we can split at a GOB */
				lastgobind = -1;
				for (i=0;i<=ld->gobs_per_frame;i++)
					if (ld->mbind[i*ld->mbs_per_gob]<lastsentbit-8+(maxdatasize<<3))
						lastgobind = ld->mbind[i*ld->mbs_per_gob];
				if (lastgobind>lastsentbit) {
					/* got (at least) one GOB. */
					sendmodeb = 0;
				} else {
					/* no GOB end in this block(again) 
					 * look for maximum number of fitting
					 * macroblocks */
					lastgobind = -1;
					for (i=lastind;(i<=ld->mbs_per_gob*ld->gobs_per_frame) && (ld->mbind[i]<lastsentbit-8+(maxdatasize<<3));i++)
						lastgobind = ld->mbind[i];
					if (lastgobind<=lastsentbit) {
						fprintf(stderr,"macroblock length of %d (exceed packetbitlength %d)!\n",ld->mbind[i]-lastsentbit,maxdatasize*8);
						assert(lastgobind>lastsentbit);
					}
					sendmodeb = 1;
					lastind = i;
				}
			} else {
				/* the packet before was NOT modeB (lastgobind==0) */
				h263rhb->mba	= 0;
				h263rhb->quant	= 0;
				h263rhb->hmv1	= 0;
				h263rhb->vmv1	= 0;
				if (!ld->mb_flag)
                                {
                                    /* allocate memory for mbquant and mvfield */
                                    if (ld->mbquant == NULL)
                                        ld->mbquant = (int*) malloc((ld->gobs_per_frame*ld->mbs_per_gob + 1)*sizeof(int));
                                    if (mvfield == NULL)
                                    {
                                        mvfield = (MVField*) malloc(sizeof(MVField));
                                        mvfield->w = h263Data->coded_picture_width / MACROBLOCK_SIZE;
                                        mvfield->h = h263Data->coded_picture_height / MACROBLOCK_SIZE;
                                        mvf_size = mvfield->w * mvfield->h * sizeof(short);
                                        mvfield->mode = (short *)malloc(mvf_size);
                                        mvfield->mx = (short *)malloc(mvf_size);
                                        mvfield->my = (short *)malloc(mvf_size);
                                    }
                                            
                                    /* IMPORTANT: set ByteBuffer-Ptr to sync of current gob */
                                    h263Data->bs->ByteBuffer = ld->stream+(lastsentbit>>3);
				    findH263MBindices(h263Data, ld, mvfield, prevgobnr, lastsentbit);
                                }
#if 1
                                for (	i=prevgobnr*ld->mbs_per_gob;
#else                                
                                for (	i=0;
#endif                                        
					(i<=ld->mbs_per_gob*ld->gobs_per_frame) &&
					(ld->mbind[i]<lastsentbit-8+(maxdatasize<<3)) ;
					i++
				)
					lastgobind = ld->mbind[i];
				lastind		= i;
				sendmodeb	= 1;
			}

			h263rhb->sbit		= lastsentbit&7;
			h263rhb->ebit		= 7-((lastgobind-1) &7);
			databyteNum = ((lastgobind+7)>>3)-(lastsentbit>>3);

			assert(databyteNum>0);
			assert(databyteNum<=maxdatasize);
			assert(lastsentbit!=lastgobind);

			/* Daten hinter den Extraheader kopieren */
			memcpy(datastart,ld->stream+(lastsentbit>>3),databyteNum); /*!!Fehler*/
			/*!!curpacket->datasize	= databyteNum;
			curpacket->data		= ld->stream+(lastsentbit>>3);*/
			lastsentbit 		= lastgobind;

			/*!!NEU*/
			packetlen               = headersize + databyteNum;
			sentbytes		+= packetlen;

			if (lastgobind >= ld->bitlen)
			    rh->rh_flags |= RTP_M; /*!! evtl. htons(RTP_M); */   /*Frameende im Paket */
			/*rh->rh_flags.m = 1;                  / Frameende im Paket */

		} else {
			/* RTP/H.263 header ,Mode A (32bit) */
		        /*!!
			h263rtpheader_A	 *h263rh = &(curpacket->header.h263a);
			curpacket->headersize	= HDRSIZE_A;*/

			h263rtpheader_A  *h263rha = (h263rtpheader_A*) (packet + sizeof(RtpHeader));
			headersize = sizeof(RtpHeader) + HDRSIZE_A;
			datastart = (char*) (packet + headersize);
			maxdatasize = MAX_PACKETSIZE - headersize;

			/* fill in header stuff */
			h263rha->ftype		= 0;		/*only mode a*/
			h263rha->pbframes	= 0;		/*no pb frames*/
			h263rha->srcformat	= h263sh->srcformat;
			h263rha->picture_coding_type	= h263sh->picture_coding_type;
			h263rha->unrestricted_motion_vector= h263sh->unrestricted_motion_vector;
			h263rha->syntax_based_arithmetic	= h263sh->syntax_based_arithmetic;
			h263rha->advanced_prediction	= h263sh->advanced_prediction;
			h263rha->reserved	= 0;
			h263rha->dbq		= h263sh->dbq;
			h263rha->trb		= h263sh->trb;
			h263rha->tr		= h263sh->tr;
			h263rha->sbit		= lastsentbit&7;
			h263rha->ebit		= 7-((lastgobind-1) &7);

			databyteNum = ((lastgobind+7)>>3)-(lastsentbit>>3);

			assert(databyteNum>0);
			assert(lastgobind>lastsentbit);
			assert(databyteNum<=maxdatasize);

			/* Daten hinter den Extraheader kopieren */
			memcpy(datastart,ld->stream+(lastsentbit>>3),databyteNum); /*!!Fehler*/
			/*!!curpacket->data		= ld->stream+(lastsentbit>>3);
			curpacket->datasize	= databyteNum; */
			lastsentbit		= lastgobind;
			sendmodeb = 0;

			/*!!NEU*/
			packetlen               = headersize + databyteNum;
			sentbytes		+= packetlen;

			if (lastgobind >= ld->bitlen)
			    rh->rh_flags |= RTP_M; /*!! evtl. htons(RTP_M); */   /*Frameende im Paket */
			/*rh->rh_flags.m = 1;                  / Frameende im Paket */
		}

		/*!!NEU*/
		/* Paket verschicken/speichern */
		fprintf(protocol, "%5d databytes and %2d headerbytes in packet %d.\n",databyteNum, headersize, rtpdata->sequencenr);
		if (ld->outfilePtr == NULL)
		{
		    printf("\nFunction 'sendpacket' not yet available.");
		    /* sendpacket(packet, packetlen); */
		}
		else
		{
		    writepacket(ld->outfilePtr, packet, packetlen);
		}
		free(packet);		/* gesendetes Paket aus Puffer loeschen */
		
	}

        /* free memory for mvfield and mbquant if just allocated */
        if (!ld->mb_flag)
        {
            if (ld->mbquant)
            {
                free(ld->mbquant);
                ld->mbquant = NULL;
            }
            if (mvfield)
            {            
                free(mvfield->mode);
                free(mvfield->mx);
                free(mvfield->my);
                free(mvfield);
                mvfield = NULL;
            }
        }
        
	/*return nrofrtps;*/
	return sentbytes;
}
