#include "layer_ref.h"


/* *************************************************************************/
/* *************************************************************************/
int InitLayerReferences(int *method, Global *these, int nl, int lastDecLayer)
{
  /* assert(lastDecLayer<maxlayers_); */
  if (!these[nl].pyra)
    return 0;
  if ((lastDecLayer >= 0) && (!these[lastDecLayer].h263))
    return 0;

  /*  */
  if (lastDecLayer >= 0 && !these[nl].pyra->first) {
    switch (method[lastDecLayer]) {
    case H263:
      if (these[lastDecLayer].h263->first)
	return 0;
      MV2MVField(these[lastDecLayer].h263->MV,
		 these[lastDecLayer].h263->modemap,
		 these[lastDecLayer].h263->coded_picture_width / 16,
		 these[lastDecLayer].h263->trd, 
		 these[nl].pyra->mvf,
		 these[nl].pyra->trd);
      break;
    case PYRA:
      if (these[lastDecLayer].pyra->first)
	return 0;
      SampleUpMVField(these[lastDecLayer].pyra->mvf,
		      these[lastDecLayer].pyra->trd, 
		      these[nl].pyra->mvf,
		      these[nl].pyra->trd);
      break;
    default: assert(0);
    }
  }

  if (lastDecLayer < 0)
    lastDecLayer = nl + 1;
  if (!these[lastDecLayer].h263)
    return 0;


  switch (method[lastDecLayer]) {
  case H263:
    if (!these[lastDecLayer].h263->newframe[0])
      return 0;
    these[nl].pyra->SpatRefPic->w = these[lastDecLayer].h263->coded_picture_width;
    these[nl].pyra->SpatRefPic->h = these[lastDecLayer].h263->coded_picture_height;
    these[nl].pyra->SpatRefPic->ws = these[lastDecLayer].h263->coded_picture_width;
    these[nl].pyra->SpatRefPic->hs = these[lastDecLayer].h263->coded_picture_height;
    these[nl].pyra->SpatRefPic->y = these[lastDecLayer].h263->newframe[0];
    these[nl].pyra->SpatRefPic->u = these[lastDecLayer].h263->newframe[1];
    these[nl].pyra->SpatRefPic->v = these[lastDecLayer].h263->newframe[2];
    break;
  case PYRA:
    if (!these[lastDecLayer].pyra->DecPic)
      return 0;
    LinkPicture(these[lastDecLayer].pyra->DecPic, these[nl].pyra->SpatRefPic);
    break;
  default:
    /* happens, when we are right into the middle of a decoding
       run. */
    return 0;
  }
  return 1;
}
