#include "main.h"

/***************** Funktionen ************************************************
  show_options
  main
*****************************************************************************/


/***************** Anmerkung ************************************************/


/*****************************************************************************/
void show_options()
/*****************************************************************************/
{
    printf("\n\nOPTIONS:\n\t-h \n\t\t show README file \n\t-i <input files prefix>");
    printf("\n\t-o <output files prefix> ");
    printf("\n\t-l<number of layers> \n\t\tspecify number of layers (e.g. -l3)"); 
    printf("\n\t-d <indices of layers> \n\t\tspecify indices of layers in uprising order (e.g. -d 0 1 3)");
    printf("\n\t\t default: 0 1 2 ...(number of layers -1)");
    printf("\n\t-xi <input files extension>  ");
    printf("\n\t-xo <output files extension> ");
    printf("\n\t-pi <input files path>  \n\t\t (e.g. ~/myhome/indir/)");
    printf("\n\t-po <output files path> \n\t\t (e.g. ~/myhome/outdir/)");
    printf("\n\nFor example the command ");
    printf("\n\trtppacker -l2 -d 0 2 -i foreman.     -pi ~/source/ -xi .hpy");
    printf("\n\t                     -o foreman.rtp. -po ~/output/ -xo .xyz ");
    printf("\n\n\treads the files");
    printf("\n\t~/source/foreman.0.hpy");
    printf("\n\t~/source/foreman.2.hpy");
    printf("\n\tand generates the output files");
    printf("\n\t~/output/foreman.rtp.0.xyz");
    printf("\n\t~/output/foreman.rtp.2.xyz");
    printf("\n\tand a protocol file");
    printf("\n\t~/output/protocol \n\n");
    exit(0);
}


/*****************************************************************************/
void main(int argc, char* argv[])
/*****************************************************************************/
{
    int i, j;
    int help, error = 0;
    int outputmode, layernum;

    int curl;                       /* Index des aktuellen Layers (current layer) */
    char inputFilesPrefix[MAX_FILENAME_LEN+1],  inpath[MAX_PATHNAME_LEN+1];
    char outputFilesPrefix[MAX_FILENAME_LEN+1], outpath[MAX_PATHNAME_LEN+1];
    char infileExt[10], outfileExt[10];
    char *infiles[MAX_LAYERS], *outfiles[MAX_LAYERS];

    int layerind[MAX_LAYERS];       /* Indizes der vorhandenen Layer */
    int optionflags[] = {0,0,0,0};
    FILE *fptr;


    /***************** Kommandozeilenargumente verarbeiten *************/
    if(argc == 1)
    {   
        show_options();
    }
    else
    {
        for ( i=1 ; i<argc ; i++ )
	{
	    if ( argv[i][0]=='-' ) 
	    {
	        switch ( argv[i][1] ) 
		{
		case 'h' :  /* show options */
		  show_options();

		case 'i' :  /* prefix for input filenames */ 				  
		
		  optionflags[0] = 1;
		  i++;
		  if ( (i>=argc) || (argv[i][0]=='-') ) 
		  {
		    fprintf(stderr,"Error in %s: specify input filename!\n", argv[0]);
		    exit(1);
		  }

		  strcpy(inputFilesPrefix,argv[i]);
		  if(strlen(inputFilesPrefix) > (MAX_FILENAME_LEN))
		  {
		      printf("Inputfile prefix is too long (limit: %d characters).\n",MAX_FILENAME_LEN);
		      error = 1;
		  }		  
		  break;
		
		case 'o' :  /* prefix for output filenames */
	
		  optionflags[1] = 1;
		  i++;
		  if ( (i>=argc) || (argv[i][0]=='-') ) 
		  {
		    fprintf(stderr,"Error in %s: specify input filename!\n", argv[0]);
		    exit(1);
		  }

		  strcpy(outputFilesPrefix,argv[i]);
		  if(strlen(outputFilesPrefix) > (MAX_FILENAME_LEN))
		  {
		      printf("Outputfile prefix is too long (limit: %d characters).\n",MAX_FILENAME_LEN);
		      error = 1;
		  }		  
		  break;
		
		case 'l':    /* number of layers */

		  optionflags[2] = 1;
		  layernum = atoi(&argv[i][2]);
		  if ((layernum < 1) || (layernum > MAX_LAYERS))
		  {
		      fprintf(stderr,"Error in %s: number of layers must be element of {1;%d}!\n", argv[0],MAX_LAYERS);
		      exit(1);
		  }
		  break;

		case 'd':    /* indices of layers */

		  optionflags[3] = 1;
		  /* while (++i < argc) */
		  for (j=0;++i<argc;j++) /* i ist richtig, kein Schreibfehler */
		  {
		      help = j;
		      if (argv[i][0]=='-') 
		      {
			  if ( j == 0 )
			  {
			      fprintf(stderr,"Error in %s: specify at least one layerindex!\n", argv[0]);
			      exit(1);
			  }
			  else
			  {
			      i--;
			      break;    /* break for-loop */
			  }
		      }
		      layerind[j] = atoi(argv[i]);
		      if ( (layerind[j]<0) || (layerind[j]>=MAX_LAYERS) ) 
		      {
		          fprintf(stderr,"Error in %s: wrong layer index '%d'!\n", argv[0], layerind[j]);
			  exit(1);
		      }
		  }
		  break;

		case 'x' :   /* Extension for filenames */

		  switch (argv[i][2])
		  {
		  case 'i':     /* input filenames */

		    i++;
		    if ( (i>=argc) || (argv[i][0]=='-') ) 
		    {
		        fprintf(stderr,"Error in %s: specify input filename extension!\n", argv[0]);
			exit(1);
		    }
		    sprintf(infileExt, "%s", argv[i]);  
		    break;

		  case 'o':     /* output filenames */

		    i++;
		    if ( (i>=argc) || (argv[i][0]=='-') ) 
		    {
		        fprintf(stderr,"Error in %s: specify output filename extension!\n", argv[0]);
			exit(1);
		    }
		    sprintf(outfileExt, "%s", argv[i]);  
		    break;
		  
		  default  : 

		    fprintf(stderr,"Wrong command line argument: %s! \n", argv[i]);
		    /* exit(1);*/
		    break;
		  }
		  break;
		
		case 'p' :   /* path names */

		  switch (argv[i][2])
		  {
		  case 'i':     /* path for input files */

		    i++;
		    if ( (i>=argc) || (argv[i][0]=='-') ) 
		    {
		        fprintf(stderr,"Error in %s: specify path name for input files!\n", argv[0]);
			exit(1);
		    }
		    sprintf(inpath, "%s", argv[i]);  
		    break;

		  case 'o':     /* path for output files */

		    i++;
		    if ( (i>=argc) || (argv[i][0]=='-') ) 
		    {
		        fprintf(stderr,"Error in %s: specify path name for output files!\n", argv[0]);
			exit(1);
		    }
		    sprintf(outpath, "%s", argv[i]);  
		    break;
		  
		  default  : 

		    fprintf(stderr,"Wrong command line argument: %s! \n", argv[i]);
		    exit(1);
		    break;
		  }
		  break;
		
		default  : 

		  fprintf(stderr,"Wrong command line argument: %s! \n\n", argv[i]);
		  show_options();
		  break;		   		  
		}
	    }
        }
    }

    /*************** check options and draw conclusions ****************/
    if (error) exit(2);

    /* if both layerindices and layernum were specified, check for equality, 
     * if only layerindices were specified set layernum */
    if (optionflags[3])
    {
        if (optionflags[2])
	{
	    if (layernum != help)
	    {
	        fprintf(stderr,"Error in %s: number of layer indices and number of layers specified are different!\n", argv[0]);
		exit(3);
	    }
	}
	else
	{
	    layernum = help;
	}
    }

    /* check if layerindices were specified in uprising order */
    if (optionflags[3])
    {
        for (i=0;i<(layernum-1);i++)
	{
	    if (layerind[i] >= layerind[i+1])
	    {
	        fprintf(stderr,"Error in %s: layer indices must be specified in uprising order!\n", argv[0]);
		exit(3);
	    }	
	}     
    }

    /* if no layerindices were specified, take default values */
    if (optionflags[2] && !optionflags[3])
    {
        for (i=0;i<layernum;i++)
	    layerind[i] = i;
    }

    /* generate complete filenames and check existence of input files*/
    for (i=0;i<layernum;i++)
    {
        curl = layerind[i];

	/* generate complete filenames */
	infiles[curl]  = (char*) malloc((strlen(inpath)  + strlen(inputFilesPrefix)  + 10) * sizeof(char));
	outfiles[curl] = (char*) malloc((strlen(outpath) + strlen(outputFilesPrefix) + 10) * sizeof(char));
	sprintf(infiles[curl],  "%s%s%d%s", inpath,  inputFilesPrefix,  curl, infileExt);
	sprintf(outfiles[curl], "%s%s%d%s", outpath, outputFilesPrefix, curl, outfileExt);

	/* printf("Layer %d  Inputfile: %s.\n", curl, infiles[curl]);
	printf("Layer %d Outputfile: %s.\n", curl, outfiles[curl]); */

	/* check existence of input files*/
	if ( (fptr = fopen(infiles[curl], "rb")) == NULL ) 
	{
	    fprintf(stderr,"Error in %s: can't open %s for reading.\n", argv[0], infiles[curl]);
	    error = 1;
	}
	else
	{	  
	    fclose(fptr);
	}
    }
    if (error) exit(4);
    printf("Evaluation of command line arguments successfully completed.\n\n");
    printf("Starting packetization process...\n\n");

    /*********************** Start packetization ***********************/
    rtp_packetize(layernum, layerind, infiles, outfiles, outpath, outputmode);
    return;

}

