/* #include "rtppack.h" */
#include <stdlib.h>
#include <assert.h>
#include <bitOut.h>

#include "rtp_defs.h"
#include "pyra.h"
#include "sendpacket.h"
#include "pyrapack.h"


/***************** Funktionen ************************************************
  getbits
  findPyraMBindices
  split_and_pack_pyraframe

*****************************************************************************/


/***************** Anmerkung ************************************************/



/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- getbits --     schneidet aus einem Bitstrom Teilstuecke heraus
 *
 * Author:           Markus Sebeck
 *
 * Created:          14-Apr-98
 *
 * Purpose:          kleine Hilfsfunktion, die aus einem Bitstrom Teilstuecke 
 *                   von maximal 32 Bit Laenge ausschneiden kann
 *
 * Arguments in:     Picture    *origPict       original image
 *                                              (possibly downsampled)
 *
 * Arguments in/out: -
 *
 * Arguments out:    unsigned char     *bs             Coded bitstream.
 *                                              Enough memory must have been
 *                                              allocated for 'bs->b'.
 *                                              'bitioX'-Routines are used,
 *                                              i.e. the buffersize is not
 *                                              checked.
 *
 * Return values:    int        number of bits used.
 *
 * Example:          -
 *
 * Side effects:     -
 *
 * Description:      -
 *
 * See also:         CodePyraLayerQ, EncodeH263
 *
 * Modified:         -
 *
 *****************************************************************************/
/*unsigned long int getbits(unsigned char *bs,unsigned int bitstart,unsigned int nrofbits) */
/*unsigned int getbits(unsigned char *bs,unsigned int bitstart,unsigned int nrofbits)*/
/*static */
unsigned int getbits(unsigned char *bs, unsigned int bitstart, unsigned int nrofbits)
/***********************************************************CommentEnd********/
{
	int	byte = bitstart>>3;
	unsigned long	xx,mask;

	/* mask out upper bits */
	static const unsigned long int masks[33] = {
	        0x00000000,
		0x80000000, 0xc0000000, 0xe0000000, 0xf0000000,
		0xf8000000, 0xfc000000, 0xfe000000, 0xff000000, 
		0xff800000, 0xffc00000, 0xffe00000, 0xfff00000,
		0xfff80000, 0xfffc0000, 0xfffe0000, 0xffff0000,
		0xffff8000, 0xffffc000, 0xffffe000, 0xfffff000, 
		0xfffff800, 0xfffffc00, 0xfffffe00, 0xffffff00,
		0xffffff80, 0xffffffc0, 0xffffffe0, 0xfffffff0,
		0xfffffff8, 0xfffffffc, 0xfffffffe, 0xffffffff};
	mask = masks[nrofbits] >> (bitstart & 7);

	/* get whole long */
	xx = ( (bs[byte]<<24)|(bs[byte+1]<<16) ) | ( (bs[byte+2]<<8)|(bs[byte+3]) );

	/* gesuchte Bits werden rechtsbuendig im unsigned long zurueckgegeben */
	return  (xx & mask) >> (32-nrofbits-(bitstart&7));
}

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- findMBindices --    
 *
 * Author:           Markus Sebeck
 *
 * Created:          16-Apr-98
 *
 * Purpose:          Schreibt ein RTP-Paket in ein File und stellt jeweils
 *                   die Gesamtlaenge in Bytes als Int voran.
 *
 * Arguments in:     Layerdata* ld              Zeiger auf Daten des Frames
 *                   int        gobnr           Nr. des GOBs, dessen MB-Indizes
 *                                              ermittelt werden sollen                   
 * Arguments in/out: -
 *
 * Arguments out:    
 *
 * Return values:    int        1: Fehler aufgetreten, 0: sonst
 *
 * Example:          -
 *
 * Side effects:     -
 *
 * Description:      -
 *
 * See also:         -
 *
 * Modified:         -
 *
 *****************************************************************************/
int findPyraMBindices(PyraGlobal *pyraData, LayerData *ld,
                      int gobnr, int offset)
/***********************************************************CommentEnd********/
{
    InitStreamParsingPyra(pyraData->bs);
    PyraParseGOB(pyraData, ld->mbind, ld->mbquant, offset);
        
    printf("\n\tSPLITTING PYRA-GOB.\n");
    return 0;
}




/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- split_and_pack_pyraframe --     
 *
 * Author:           Markus Sebeck
 *
 * Created:          14-Apr-98
 *
 * Purpose:          Liest Pyra-Daten aus den einzelnen Bitstreamfiles ein und
 *                   gibt diese in der entsprechenden Reihenfolge zur Packetierung
 *                   weiter.
 *
 * Arguments in:     int        layernum        Anzahl der Layer
 *                   char*      filesIn         
 *                   int        outfileNum      Anzahl der Outputfiles, in die 
 *                                              geschrieben werden soll (entweder
 *                                              gleich 1 oder gleich layernum)
 * Arguments in/out: -
 *
 * Arguments out:    -
 *
 * Return values:    int        number of bytes sent.
 *
 * Example:          -
 *
 * Side effects:     -
 *
 * Description:      -
 *
 * See also:         -
 *
 * Modified:         -
 *
 *****************************************************************************/
int split_and_pack_pyraframe(
        PyraGlobal *pyraData,   /*  */
	const int layernr,	/* [in] nummer des aktuellen layers */
	const int layernum,     /* [in] anzahl der layer */
	const unsigned int lmask,	/* [in] aktuelle layermask */
	const int layerfreq,    /* [in] Frequenz des Layers, MM:pl->freq  */
	RtpData *rtpdata,       /* [in] aktuelle RTP-Headerdaten */
	LayerData *ld,          /* [in] MB-/GOB-Grenzen */
	FILE* protocol
)
/***********************************************************CommentEnd********/
{  
	unsigned char*          packet;                 /* Bitstream fuer ein RTP-Paket */
	unsigned char*          datastart;
	int                     maxdatasize;            /* max. Anzahl Daten-Bytes im Paket (zuvor psize)*/


	RtpHeader		*rh;
	PyraLayerRtpHeader	*prh;
	PyraStreamHeader	psh;
	int			i,j,
				sendmodeb,
	                        databyteNum,            /* Anzahl Daten-Bytes im Paket (zuvor plen)*/
	                        packetlen,              /* Gesamtlaenge des Pakets (in Bytes) */ /*!!NEU*/
				lastgobind,		/* letzter MB-Index, der gerade noch
							   ins naechste Paket passt */
	                        prevgobnr,              /* GOB-Nr. des 1. GOBs, der noch nicht
							   (ganz) uebertragen ist */
	                        lastsentbit;            /* Index d. zuletzt gesendeten Bits */
	int			curbit,sentbytes=0,lastind;
	unsigned char           *pp;       /*!!MOD0306*/
	unsigned long int       firstlong; /*!!MOD0306*/

	/* Initialisierungen */
	lastsentbit=0;sendmodeb=0;curbit=0;
	maxdatasize = MAX_PACKETSIZE - sizeof(RtpHeader) - sizeof(PyraLayerRtpHeader);

        /* fuer evtl. Berechnung v. MB-Indizes -> PicHeader dekodieren NEU*/
        pyraData->bs->ByteBuffer = ld->stream;
        InitStreamParsingPyra(pyraData->bs);
        PyraDecodeHeader(pyraData);

	/* Irgendwie kann man nicht psh = (pyrastreamheader*)ld->stream machen...*/
	/*
	psh.syncword	= getbits(ld->stream,curbit,24);curbit+=24;
	psh.gobnr	= getbits(ld->stream,curbit,5);curbit+=5;
	psh.tr		= getbits(ld->stream,curbit,8);curbit+=8;
	psh.srcformat	= getbits(ld->stream,curbit,3);curbit+=3;
	psh.picture_coding_type = getbits(ld->stream,curbit,1);curbit++;
	psh.scaltype	= getbits(ld->stream,curbit,2);curbit+=2;
	psh.q		= getbits(ld->stream,curbit,5);curbit+=5;
	*/
	psh.srcformat	= getbits(ld->stream,37,3);
	assert(psh.srcformat);

	while (lastsentbit<ld->bitlen) {
		/* Bitstream fuer Paket allozieren */
		packet = (unsigned char*) malloc(MAX_PACKETSIZE * sizeof(char));
		rh = (RtpHeader*) packet;
		prh = (PyraLayerRtpHeader*) (packet + sizeof(RtpHeader));
		datastart = (unsigned char*) (packet + sizeof(RtpHeader) + sizeof(PyraLayerRtpHeader));

		/* RTP-Header initialisieren */
		rh->rh_flags = 0;
		rh->rh_flags |= RTP_VERSION << 14; /*!! evtl mit htons */
		rh->rh_flags |= PYRA_PAYLOAD; /*!! evtl mit htons */
		/*
		rh->rh_flags.v = RTP_VERSION;
		rh->rh_flags.p = 0;
		rh->rh_flags.x = 0;
		rh->rh_flags.cc = 0;	       
		rh->rh_flags.m = 0;                  / to be corrected /
		rh->rh_flags.pt = PYRA_PAYLOAD;
*/
		rh->rh_seqno = ++rtpdata->sequencenr; 
		rh->rh_ts = rtpdata->timestamp;
		rh->rh_ssrc = rtpdata->ssrc;

		/* PyraLayerRtpHeader initialisieren */
		prh->layernr 	= layernr;
		prh->maxlayers 	= layernum-1;
		prh->srcformat	= psh.srcformat;
		prh->tempdist	= layerfreq;

		/* nachschauen, welcher denn nun baselayer ist,
		 * und falls wir es sind, flag setzen */
		prh->isbaselayer = 0;
		for (j=32;j--;)
		{
		    if ((1<<j) & lmask)
		    {
		        if (j==layernr)
			    prh->isbaselayer = 1;
			break;
		    }
		}
		/* spatial distance berechnen aus der mask */
		for (j=layernr;j--;)
		    if ((1<<j) & lmask)
		        break;
		if (j==-1)
		    prh->spatialdist = 0;
		else
		    prh->spatialdist = layernr-j;


		/* Letzten GOB bitindex suchen, der gerade noch so in einen
		 * block passt */
		lastgobind = 0;
		for (i=0;(i<=ld->gobs_per_frame) && (ld->mbind[i*ld->mbs_per_gob]<lastsentbit-8+(maxdatasize<<3));i++)
			lastgobind = ld->mbind[i*ld->mbs_per_gob];
		prevgobnr = i-1;    /*!!! Ueberpruefen! evtl. prevgobnr = i-1 (wenn der 1. GOB nicht ganz 
				     reinpasst, ist prevgobnr=0 */
		if (lastgobind<=lastsentbit) 
		{
			/* nichts gefunden? */
			lastgobind = 0;
		}
		/* Wenn der letzte Block ein Mode B Block (ohne GOB Ende) war, 
		 * oder der naechste GOB nicht in ein RTP Paket passt, muessen
		 * wir einen Mode B Block senden */
		if (sendmodeb || !lastgobind) {
			/* nochmal den naechsten GOB suchen, der passt */
			for (i=0;(i<=ld->gobs_per_frame) && (ld->mbind[i*ld->mbs_per_gob]<lastsentbit-8+(maxdatasize<<3));i++)
			        lastgobind = ld->mbind[i*ld->mbs_per_gob];
			/* war der vorherige block ein Mode B Block? */
			if (sendmodeb) {
				/* nachsehen, ob wir fuer diesen Mode B block
				 * an einem GOB Ende aufhoeren koennen, oder
				 * ob wir noch einen Mode B Block brauchen
				 */
				lastgobind = -1;
				for (i=0;(i<=ld->gobs_per_frame) && (ld->mbind[i*ld->mbs_per_gob]<lastsentbit-8+(maxdatasize<<3));i++)
					lastgobind = ld->mbind[i*ld->mbs_per_gob];

				if (lastgobind>lastsentbit) {
					/* wir haben ein GOB Ende,
					 * der naechste Block kann wieder ein
					 * Mode A Block werden */
					lastind = -100000;
					sendmodeb = 0;
				} else {
					/* wir haben kein GOB Ende ->
					 * Wir sehen nach, bis zu welchem
					 * Macroblock wir splitten koennen */
					lastgobind = -1;
					for (i=lastind;(i<=ld->mbs_per_gob*ld->gobs_per_frame) &&
                                                 (ld->mbind[i]<lastsentbit-8+(maxdatasize<<3));i++)
					    lastgobind = ld->mbind[i];
					/* es _MUSS_ einer zu finden sein */
					assert(lastgobind>lastsentbit);
					sendmodeb = 1;
					lastind = i;
				}
			} else {
				/* nein, wir muessen einen Macroblock suchen,
				 * der noch gerade so reinpasst */
                                printf("\n\tSPLITTING PYRA-GOB.\n");
				lastgobind = -1;
				if (!ld->mb_flag)
                                {
                                    /* IMPORTANT: set ByteBuffer-Ptr to sync of current gob */
                                    pyraData->bs->ByteBuffer = ld->stream+(lastsentbit>>3);
				    findPyraMBindices(pyraData, ld, prevgobnr, lastsentbit); /*!!!!! Funktion noch schreiben !!!*/
				}
#if 1
                                for (i=prevgobnr*ld->mbs_per_gob;(i<=ld->mbs_per_gob*ld->gobs_per_frame) &&
#else                                         
                                for (i=0;(i<=ld->mbs_per_gob*ld->gobs_per_frame) &&
#endif                                         
                                         (ld->mbind[i]<lastsentbit-8+(maxdatasize<<3));i++)
					lastgobind = ld->mbind[i];
				assert(lastgobind != 0xdeadbeef);
				/* es _MUSS_ einer zu finden sein */
				assert(lastgobind>lastsentbit);
				lastind = i;
				sendmodeb = 1;
			}
			
			/* Mode B Flag setzen */
			prh->modeb	= 1;

			/* Bit Magic */
			prh->sbit	= lastsentbit&7;
			prh->ebit	= 7-((lastgobind-1) &7);
			databyteNum = ((lastgobind+7)>>3)-(lastsentbit>>3);

			/* einige sachen, die nicht passieren sollten */
			assert(databyteNum>0);
			if(databyteNum>maxdatasize) {
			        fprintf(stderr,"argh, databyteNum %d>maxdatasize %d, (lastgobind %d, 
lastsentbit %d)\n",databyteNum,maxdatasize,lastgobind,lastsentbit);
				assert(0);
			}

			/* Daten hinter den Extraheader kopieren */
			/*!!printf("Time: %d, datafrom: %d, datato: %d, bytes: %d.\n", rtpdata->timestamp, ld->stream+(lastsentbit>>3), datastart, databyteNum);*/
			memcpy(datastart,ld->stream+(lastsentbit>>3),databyteNum); /*!!Fehler*/

			assert(lastsentbit!=lastgobind);
			lastsentbit 		= lastgobind;
			/* sentbytes		+= sizeof(rtphdr)+sizeof(pyralayerrtpheader)+databyteNum; */
			packetlen               = sizeof(RtpHeader)+sizeof(PyraLayerRtpHeader)+databyteNum;
			sentbytes		+= packetlen;

			if (lastgobind >= ld->bitlen)
			    rh->rh_flags |= RTP_M; /*!! evtl. htons(RTP_M); */   /*Frameende im Paket */
			/*!!rh->rh_flags.m = 1;                  /Frameende im Paket */

		} else {
			/* mindestens ein GOB vollstaendig, also Mode A */

			/* Mode B Flag zu Null */
		        prh->modeb	        = 0;

			/* bitmagic */
			prh->sbit		= lastsentbit&7;
			prh->ebit		= 7-((lastgobind-1) &7);
			databyteNum = ((lastgobind+7)>>3)-(lastsentbit>>3);

			/* einige sachen, die nicht passieren sollten */
			assert(databyteNum>0);
			assert(lastgobind>lastsentbit);
			assert(databyteNum<=maxdatasize);

			pp = ld->stream+(lastsentbit>>3);                     /*!!MOD0306*/
			firstlong = (pp[0]<<24)+(pp[1]<<16)+(pp[2]<<8)+pp[3]; /*!!MOD0306*/
			assert((firstlong & 0xffffff00) == 0x00000100);       /*!!MOD0306*/

			/* Daten hinter den Extraheader kopieren */
			/*!!printf("Time: %d, datafrom: %d, datato: %d, bytes: %d.\n", rtpdata->timestamp, ld->stream+(lastsentbit>>3), datastart, databyteNum);*/
			memcpy(datastart,ld->stream+(lastsentbit>>3),databyteNum); /*!!Fehler*/

			lastsentbit		= lastgobind;
			/* sentbytes		+= sizeof(rtphdr)+sizeof(pyralayerrtpheader)+databyteNum; */
			packetlen               = sizeof(RtpHeader)+sizeof(PyraLayerRtpHeader)+databyteNum;
			sentbytes		+= packetlen;

			if (lastgobind >= ld->bitlen)    /* >=, da lastgobind an Bytegrenze */
			    rh->rh_flags |= RTP_M; /*!! evtl. htons(RTP_M); */   /*Frameende im Paket */
			/*rh->rh_flags.m = 1;                / Frameende im Paket */

			sendmodeb = 0;
		}

		/* Paket verschicken/speichern */
		fprintf(protocol, "%5d databytes and %2d headerbytes in packet %d.\n",databyteNum, sizeof(RtpHeader)+sizeof(PyraLayerRtpHeader), rtpdata->sequencenr);
		if (ld->outfilePtr == NULL)
		{
		    printf("\nFunction 'sendpacket' not yet available.");
		    /* sendpacket(packet, packetlen); */
		}
		else
		{
		    writepacket(ld->outfilePtr, packet, packetlen);
		}
		/*FreeBitstr(&packet);		/ gesendetes Paket aus Puffer loeschen */
		free(packet);		/* gesendetes Paket aus Puffer loeschen */
	}
	return sentbytes;
}

/*
int split_and_pack_pyraframe(
	const int layernr,	/ [in] nummer des aktuellen layers /
	const int layernum,     / [in] anzahl der layer /
	unsigned char bs_in,		/ [in] bitstream /
	unsigned int bitcount,		/ [in] Anzahl an bits in diesem /
	unsigned int gobs_per_frame,	/ [in] gobs per frame /
	unsigned int mbs_per_gob,	/ [in] macrobloecke per gob /
	RtpData rtpdata,       / [in] aktuelle RTP-Headerdaten /
	unsigned int lmask,		/ [in] aktuelle layermask /
	LayerData ld,     / [in] MB-/GOB-Grenzen /
	int layerfreq,          / [in] Frequenz des Layers (MM: pl->freq) /
	int maxpacketsize       / [in] maximale Paketgroesse [Bytes] /
)
*/
